/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.ap.util.DateUtils;

public class AcctAgeGroup
implements Serializable {
    private static final long serialVersionUID = -6532015739747326977L;
    public static final String ACCTAGERPT_SETTING_KEY = "ap_acctagesetting";
    private String name;
    private Integer beginDay;
    private Integer endDay;
    private String remark;
    private Date compareDate;

    public AcctAgeGroup() {
    }

    public AcctAgeGroup(String name, Integer beginDay, Integer endDay) {
        this(name, beginDay, endDay, null);
    }

    public AcctAgeGroup(String name, Integer beginDay, Integer endDay, Date compareDate) {
        this.name = name;
        this.beginDay = beginDay;
        this.endDay = endDay;
        this.compareDate = compareDate;
    }

    public String getAmountFieldName() {
        if (this.beginDay == null) {
            return "groupamount";
        }
        return "groupamount" + this.beginDay;
    }

    public boolean match(Date date) {
        if (date == null) {
            return this.beginDay == null;
        }
        int diffDays = DateUtils.getDiffDaysIgnoreTime(date, this.compareDate);
        if (this.beginDay != null && this.endDay != null) {
            return diffDays >= this.beginDay && diffDays <= this.endDay;
        }
        if (this.beginDay == null) {
            return diffDays <= this.endDay;
        }
        if (this.endDay == null) {
            return diffDays >= this.beginDay;
        }
        return false;
    }

    public static List<AcctAgeGroup> getGroups() {
        String settingJson = UserConfigServiceHelper.getSetting((long)AcctAgeGroup.getCurrentUserID(), (String)ACCTAGERPT_SETTING_KEY);
        if (settingJson != null && !settingJson.trim().isEmpty()) {
            try {
                return SerializationUtils.fromJsonStringToList((String)settingJson, AcctAgeGroup.class);
            }
            catch (Exception e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u89e3\u6790\u7528\u6237\u914d\u7f6e\u5931\u8d25\u3002", (String)"AcctAgeGroup_0", (String)"fi-ap-common", (Object[])new Object[0]));
            }
        }
        return AcctAgeGroup.getDefaultGroups();
    }

    public static boolean saveGroupSetting(List<AcctAgeGroup> groups) {
        String jsonString = SerializationUtils.toJsonString(groups);
        return UserConfigServiceHelper.setSetting((long)AcctAgeGroup.getCurrentUserID(), (String)ACCTAGERPT_SETTING_KEY, (String)jsonString);
    }

    public static List<AcctAgeGroup> getDefaultGroups() {
        ArrayList<AcctAgeGroup> groups = new ArrayList<AcctAgeGroup>();
        groups.add(new AcctAgeGroup(ResManager.loadKDString((String)"0\uff5e30\u5929", (String)"AcctAgeGroup_1", (String)"fi-ap-common", (Object[])new Object[0]), 0, 30));
        groups.add(new AcctAgeGroup(ResManager.loadKDString((String)"31\uff5e60\u5929", (String)"AcctAgeGroup_2", (String)"fi-ap-common", (Object[])new Object[0]), 31, 60));
        groups.add(new AcctAgeGroup(ResManager.loadKDString((String)"61\uff5e90\u5929", (String)"AcctAgeGroup_3", (String)"fi-ap-common", (Object[])new Object[0]), 61, 90));
        groups.add(new AcctAgeGroup(ResManager.loadKDString((String)"90\u5929\u4ee5\u4e0a", (String)"AcctAgeGroup_4", (String)"fi-ap-common", (Object[])new Object[0]), 91, null));
        return groups;
    }

    private static long getCurrentUserID() {
        return 0L;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getBeginDay() {
        return this.beginDay;
    }

    public void setBeginDay(Integer beginDay) {
        this.beginDay = beginDay;
    }

    public Integer getEndDay() {
        return this.endDay;
    }

    public void setEndDay(Integer endDay) {
        this.endDay = endDay;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getCompareDate() {
        return this.compareDate;
    }

    public void setCompareDate(Date compareDate) {
        this.compareDate = compareDate;
    }
}

