/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.vo;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.ap.enums.EnumDirection;

public class MatchBillChain
implements Serializable {
    private static final long serialVersionUID = 3207403266420969603L;
    public static final MatchChain mainChain = MatchBillChain.NewChain().setBillEntity("ap_invoice").setEntryEntity("detailentry").setEntryIdentifyPrefix("").setPlugin("kd.fi.ap.business.invoicematch.ApInvoiceMatchBillLoader");
    private String activeMatchTab;
    private Map<String, MatchChain> chainMap;
    private LinkedList<MatchChain> chains = new LinkedList();

    public static MatchChain NewChain() {
        return new MatchChain();
    }

    public void addChain(MatchChain ... chainArr) {
        for (MatchChain chain : chainArr) {
            if (this.chains.size() == 0) {
                this.chains.add(chain);
                continue;
            }
            MatchChain last = this.chains.getLast();
            last.setNext(chain);
            chain.setPrev(last);
            this.chains.add(chain);
        }
    }

    public MatchChain getChain(String billEntity) {
        if (billEntity.equals(mainChain.getBillEntity())) {
            return mainChain;
        }
        MatchChain chain = null;
        Optional<MatchChain> first = this.chains.stream().filter(c -> c.getBillEntity().equals(billEntity)).findFirst();
        if (first.isPresent()) {
            chain = first.get();
        } else if (!mainChain.getBillEntity().equals(billEntity)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5339\u914d\u94fe\u4fe1\u606f\u914d\u7f6e\u9519\u8bef...", (String)"MatchBillChain_0", (String)"fi-ap-common", (Object[])new Object[0]));
        }
        return chain;
    }

    public boolean contains(String billEntity) {
        Optional<MatchChain> first = this.chains.stream().filter(c -> c.getBillEntity().equals(billEntity)).findFirst();
        return first.isPresent();
    }

    public MatchChain getSibling(String billEntity, EnumDirection direction) {
        MatchChain sibling = null;
        Optional<MatchChain> first = this.chains.stream().filter(chain -> chain.getBillEntity().equals(billEntity)).findFirst();
        if (first.isPresent()) {
            sibling = direction == EnumDirection.DOWN ? first.get().getNext() : first.get().getPrev();
        }
        return sibling != null && !sibling.isHide() ? sibling : null;
    }

    public MatchChain getSiblingWithOutHide(String billEntity, EnumDirection direction) {
        MatchChain sibling = null;
        Optional<MatchChain> first = this.chains.stream().filter(chain -> chain.getBillEntity().equals(billEntity)).findFirst();
        if (first.isPresent()) {
            sibling = direction == EnumDirection.DOWN ? first.get().getNext() : first.get().getPrev();
        }
        return sibling;
    }

    public LinkedList<MatchChain> getChains() {
        return this.chains;
    }

    public void setChains(LinkedList<MatchChain> chains) {
        this.chains = chains;
    }

    public String getActiveMatchTab() {
        return this.activeMatchTab;
    }

    public void setActiveMatchTab(String activeMatchTab) {
        this.activeMatchTab = activeMatchTab;
    }

    public Map<String, MatchChain> getChainMap() {
        return this.chainMap;
    }

    public void setChainMap(Map<String, MatchChain> chainMap) {
        this.chainMap = chainMap;
    }

    public static class MatchChain
    implements Serializable {
        private static final long serialVersionUID = 103101893671585019L;
        private String billEntity;
        private String entryEntity;
        private MatchChain next;
        private MatchChain prev;
        private String f7Identify;
        private String entryIdentifyPrefix;
        private String plugin;
        private boolean hide;
        private String prevRelType;
        private String nextRelType;
        private String qtyKey;
        private String amtKey;

        public String getBillEntity() {
            return this.billEntity;
        }

        public MatchChain setBillEntity(String billEntity) {
            this.billEntity = billEntity;
            return this;
        }

        public String getEntryEntity() {
            return this.entryEntity;
        }

        public MatchChain setEntryEntity(String entryEntity) {
            this.entryEntity = entryEntity;
            return this;
        }

        public String getF7Identify() {
            return this.f7Identify;
        }

        public String getEntryIdentify() {
            return this.entryIdentifyPrefix.concat("entry");
        }

        public String getToolbarIdentify() {
            return this.entryIdentifyPrefix.concat("toolbar");
        }

        public String getTabIdentify() {
            return this.entryIdentifyPrefix.concat("tab");
        }

        public String getMatchQtyKey() {
            return this.entryIdentifyPrefix.concat("matchqty");
        }

        public String getMatchAmtKey() {
            return this.entryIdentifyPrefix.concat("matchamt");
        }

        public String getUnMatchQtyKey() {
            return this.entryIdentifyPrefix.concat("unmatchqty");
        }

        public String getUnMatchAmtKey() {
            return this.entryIdentifyPrefix.concat("unmatchamt");
        }

        public String getMatchKey(String matchType) {
            return matchType.equals("AMT") ? this.getMatchAmtKey() : this.getMatchQtyKey();
        }

        public String getUnMatchKey(String matchType) {
            return matchType.equals("AMT") ? this.getUnMatchAmtKey() : this.getUnMatchQtyKey();
        }

        public String getIdIdentify() {
            return this.entryIdentifyPrefix.concat("entryid");
        }

        public String getBillIdIdentify() {
            return this.entryIdentifyPrefix.concat("id");
        }

        public String getAddEntryIdentify() {
            return this.entryIdentifyPrefix.concat("addrow");
        }

        public String getDelEntryIdentify() {
            return this.entryIdentifyPrefix.concat("delrow");
        }

        public String getPriceAndTaxKey() {
            return this.entryIdentifyPrefix.concat("priceandtax");
        }

        public String getAmountAndTaxKey() {
            return this.entryIdentifyPrefix.concat("amountandtax");
        }

        public String getQuantityKey() {
            return this.entryIdentifyPrefix.concat("qty");
        }

        public MatchChain setF7Identify(String f7Identify) {
            this.f7Identify = f7Identify;
            return this;
        }

        public String getEntryIdentifyPrefix() {
            return this.entryIdentifyPrefix;
        }

        public MatchChain setEntryIdentifyPrefix(String entryIdentifyPrefix) {
            this.entryIdentifyPrefix = entryIdentifyPrefix;
            return this;
        }

        public String getPlugin() {
            return this.plugin;
        }

        public MatchChain setPlugin(String plugin) {
            this.plugin = plugin;
            return this;
        }

        public boolean isHide() {
            return this.hide;
        }

        public MatchChain setHide(boolean hide) {
            this.hide = hide;
            return this;
        }

        public String getPrevRelType() {
            return this.prevRelType;
        }

        public MatchChain setPrevRelType(String prevRelType) {
            this.prevRelType = prevRelType;
            return this;
        }

        public String getNextRelType() {
            return this.nextRelType;
        }

        public MatchChain setNextRelType(String nextRelType) {
            this.nextRelType = nextRelType;
            return this;
        }

        public String getQtyKey() {
            return this.qtyKey;
        }

        public MatchChain setQtyKey(String qtyKey) {
            this.qtyKey = qtyKey;
            return this;
        }

        public String getAmtKey() {
            return this.amtKey;
        }

        public MatchChain setAmtKey(String amtKey) {
            this.amtKey = amtKey;
            return this;
        }

        public MatchChain getNext() {
            return this.next;
        }

        public void setNext(MatchChain next) {
            this.next = next;
        }

        public MatchChain getPrev() {
            return this.prev;
        }

        public void setPrev(MatchChain prev) {
            this.prev = prev;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatchChain that = (MatchChain)o;
            return Objects.equals(this.billEntity, that.billEntity) && Objects.equals(this.entryEntity, that.entryEntity) && Objects.equals(this.entryIdentifyPrefix, that.entryIdentifyPrefix) && Objects.equals(this.plugin, that.plugin);
        }

        public int hashCode() {
            return Objects.hash(this.billEntity, this.entryEntity, this.entryIdentifyPrefix, this.plugin);
        }
    }
}

