/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.util.DateUtils;
import kd.fi.ap.validator.AntiCloseAccountValidator;

public class AntiCloseAccountOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject closeAccountInfo : e.getDataEntities()) {
            this.doAntiCloseAccount(closeAccountInfo);
        }
    }

    private void doAntiCloseAccount(DynamicObject closeAccountInfo) {
        Date antiCloseDate = this.getAntiCloseDate();
        closeAccountInfo.set("currentdate", (Object)DateUtils.getNextDay((Date)antiCloseDate, (int)1));
        closeAccountInfo.set("entryentity", null);
        SaveServiceHelper.save((IDataEntityType)closeAccountInfo.getDataEntityType(), (Object[])new DynamicObject[]{closeAccountInfo});
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        AntiCloseAccountValidator v = new AntiCloseAccountValidator();
        v.setAntiCloseDate(this.getAntiCloseDate());
        v.setEntityKey("ap_closeaccount");
        e.addValidator((AbstractValidator)v);
    }

    private Date getAntiCloseDate() {
        String closeDateString = this.getOption().getVariableValue("anticlosedate");
        Date anticloseDate = null;
        try {
            anticloseDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(closeDateString);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        return anticloseDate;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(this.getSelectors());
    }

    private List<String> getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("org");
        selectors.add("startdate");
        selectors.add("curperiod");
        selectors.add("currentdate");
        selectors.add("isfinishinit");
        selectors.add("failedmessage");
        return selectors;
    }
}

