/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class ApBusBillAuditForCostBillOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ApBusBillAuditForCostBillOp.class);

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] busBills = e.getDataEntities();
        this.pushCostEstimateBills(busBills);
    }

    private void pushCostEstimateBills(DynamicObject[] busBills) {
        logger.info("ApBusBillAuditForCostBillOp pushCostEstimateBills begin.");
        LinkedList<DynamicObject> sentBills = new LinkedList<DynamicObject>();
        HashSet<Object> expenseItemIds = new HashSet<Object>();
        for (DynamicObject busBill : busBills) {
            DynamicObject dynamicObject = busBill.getDynamicObject("billtype");
            if (!"ap_busbill_purfee_BT_S".equals(dynamicObject.getString("number")) || busBill.getBoolean("isadjust")) continue;
            sentBills.add(busBill);
            DynamicObjectCollection entry = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                Object expenseItem = row.getDynamicObject("e_expenseitem").getPkValue();
                expenseItemIds.add(expenseItem);
            }
        }
        logger.info("ApBusBillAuditForCostBillOp pushCostEstimateBills expenseItemIds size :" + expenseItemIds.size());
        if (expenseItemIds.isEmpty()) {
            return;
        }
        HashSet<Long> calRelatedexpenseItemIds = new HashSet<Long>();
        QFilter[] filters = new QFilter[]{new QFilter("expenseitem", "in", expenseItemIds)};
        Map relatedBillTypes = BusinessDataServiceHelper.loadFromCache((String)"er_expenseitembill", (String)"billtype,expenseitem", (QFilter[])filters);
        for (Map.Entry entry : relatedBillTypes.entrySet()) {
            DynamicObject relatedBillType = (DynamicObject)entry.getValue();
            if (!"cal_costrecord_subentity".equals(relatedBillType.getDynamicObject("billtype").getString("number"))) continue;
            calRelatedexpenseItemIds.add(relatedBillType.getLong("expenseitem.id"));
        }
        logger.info("ApBusBillAuditForCostBillOp pushCostEstimateBills calRelatedexpenseItemIds size :" + calRelatedexpenseItemIds.size());
        if (calRelatedexpenseItemIds.isEmpty()) {
            return;
        }
        Iterator iterator = sentBills.iterator();
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            boolean isNeeded = false;
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                Object expenseItem = row.getDynamicObject("e_expenseitem").getPkValue();
                if (!calRelatedexpenseItemIds.contains(expenseItem)) continue;
                isNeeded = true;
                break;
            }
            if (isNeeded) continue;
            iterator.remove();
        }
        if (!sentBills.isEmpty()) {
            logger.info("ApBusBillAuditForCostBillOp pushCostEstimateBills execute CalBizService doService .");
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("entrykey", "entry");
            hashMap.put("boptruleid", "716391545338728448");
            DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalBizService", (String)"doService", (Object[])new Object[]{"COSTESTIMATECREATE", hashMap, sentBills.toArray(new DynamicObject[0])});
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("billtype");
        lst.add("isadjust");
        lst.add("e_expenseitem");
    }
}

