/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.validator.ApBusAuditValidator;
import kd.fi.ap.validator.BusPaymentSecurityAuditValidator;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.validator.PeriodAuditOrUnauditValidator;

public class ApBusBillAuditOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(ApBusBillAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("bookdate");
        fieldKeys.add("bizdate");
        fieldKeys.add("biztype");
        fieldKeys.add("writeoffbusiness");
        fieldKeys.add("srcfinbillid");
        fieldKeys.add("isperiod");
        fieldKeys.add("isadjust");
        fieldKeys.add("isrevaluation");
        fieldKeys.add("revaluasrcbusbillid");
        fieldKeys.add("revaluasrcbusbillno");
        fieldKeys.add("entry.seq");
        fieldKeys.add("entry.e_quantity");
        fieldKeys.add("isselfwoff");
        fieldKeys.add("hadrevaluation");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("e_prepaid");
        fieldKeys.add("entry.e_baseunitqty");
        fieldKeys.add("entry.e_corebilltype");
        fieldKeys.add("entry.corebillid");
        fieldKeys.add("entry.corebillentryid");
        fieldKeys.add("entry.e_corebillentryseq");
        fieldKeys.add("entry.e_pricetaxtotal");
        fieldKeys.add("entry.seq");
        fieldKeys.add("asstact");
        fieldKeys.add("currency");
        fieldKeys.add("e_costdiffamount");
        fieldKeys.add("e_srcentryid");
        fieldKeys.add("intercostamt");
        fieldKeys.add("entry.e_unitprice");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PeriodAuditOrUnauditValidator());
        e.addValidator((AbstractValidator)new ApBusAuditValidator());
        e.addValidator((AbstractValidator)new BusPaymentSecurityAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] busBills = e.getDataEntities();
        this.setBookDate(busBills);
        this.setBookDate4WoffBill(busBills);
        this.revaluaSrcWoff(busBills);
        this.updateRevalBusWoffFlag(busBills);
        this.invokeCalService(busBills);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] apBusBills = e.getDataEntities();
        this.preParBillsToAr(apBusBills);
        this.setCostDiffAmount(apBusBills);
    }

    private void setBookDate(DynamicObject[] busBills) {
        List hadRevSrcBusId = Arrays.stream(busBills).filter(v -> v.getBoolean("isrevaluation")).filter(v -> v.getBoolean("isadjust")).map(v -> Long.valueOf(v.getString("sourcebillid"))).collect(Collectors.toList());
        if (hadRevSrcBusId.size() == 0) {
            BookDateHelper.setBookDate((DynamicObject[])busBills, (boolean)false);
            return;
        }
        DynamicObjectCollection hadRevSrcBusBills = QueryServiceHelper.query((String)"ap_busbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("isadjust", "=", (Object)Boolean.FALSE), new QFilter("hadrevaluation", "=", (Object)Boolean.TRUE), new QFilter("id", "in", hadRevSrcBusId)});
        List hadRevBusId = hadRevSrcBusBills.stream().map(v -> String.valueOf(v.getLong("id"))).collect(Collectors.toList());
        ArrayList<DynamicObject> needSetBookDates = new ArrayList<DynamicObject>(2);
        for (DynamicObject busBill : busBills) {
            String srcId = busBill.getString("sourcebillid");
            if (hadRevBusId.contains(srcId)) continue;
            needSetBookDates.add(busBill);
        }
        if (needSetBookDates.size() == 0) {
            return;
        }
        BookDateHelper.setBookDate((DynamicObject[])((DynamicObject[])needSetBookDates.stream().toArray(DynamicObject[]::new)), (boolean)false);
    }

    private void invokeCalService(DynamicObject[] busBills) {
        Set needInvokeCalBillIds = Arrays.stream(busBills).filter(busbill -> busbill.getBoolean("isrevaluation")).map(busbill -> busbill.getLong("id")).collect(Collectors.toSet());
        if (needInvokeCalBillIds.size() > 0) {
            CommonParam param = new CommonParam();
            param.put((Object)"actionName", (Object)"REESTIMATE");
            param.put((Object)"params", null);
            param.put((Object)"bizBillIds", needInvokeCalBillIds);
            param.put((Object)"entityName", (Object)"ap_busbill");
            ECServiceHelper.beginAndRegister((String)"ap_bus_audit", (String)"ap_revaluation_invokecal", (String)"fi", (String)"cal", (String)"CalBizServiceIdECService", (Param)param, (String)"");
        }
    }

    private void revaluaSrcWoff(DynamicObject[] busBills) {
        ArrayList<Long> needWoffBillIds = new ArrayList<Long>(busBills.length);
        ArrayList<DynamicObject> revalBills = new ArrayList<DynamicObject>(busBills.length);
        for (DynamicObject busBill : busBills) {
            boolean isRevalua = busBill.getBoolean("isrevaluation");
            boolean isadjust = busBill.getBoolean("isadjust");
            if (!isRevalua || isadjust) continue;
            Long srcBusBillId = busBill.getLong("revaluasrcbusbillid");
            needWoffBillIds.add(srcBusBillId);
            revalBills.add(busBill);
        }
        if (needWoffBillIds.size() > 0) {
            List woffBills = null;
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("isselfwoff", "true");
            paramMap.put("woffmode", "reval");
            Map resultMap = BOTPHelper.push4Result((String)"ap_busbill", (String)"ap_busbill", (String)"1482635299170322432", needWoffBillIds, paramMap);
            Object convertResult = resultMap.get("convertResult");
            if (convertResult != null) {
                ConvertOperationResult result = (ConvertOperationResult)convertResult;
                ErrorCode ec = new ErrorCode("botp", String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u4ed8\u91cd\u4f30\u51b2\u56de\u5931\u8d25\uff1a%s", (String)"ApBusBillAuditOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), result.getMessage()));
                throw new KDBizException(ec, new Object[0]);
            }
            woffBills = (List)resultMap.get("trgBills");
            this.setTargetBillsNo(woffBills);
            this.setTargetBillsBookDate(revalBills, woffBills);
            this.doOperation("ap_busbill", woffBills);
        }
    }

    private void setTargetBillsBookDate(List<DynamicObject> revalBills, List<DynamicObject> woffBills) {
        for (DynamicObject woffBill : woffBills) {
            Long srcBusId = Long.valueOf(woffBill.getString("sourcebillid"));
            for (DynamicObject revalBill : revalBills) {
                Long revalSrcBusBillId = revalBill.getLong("revaluasrcbusbillid");
                if (!srcBusId.equals(revalSrcBusBillId)) continue;
                woffBill.set("bookdate", (Object)revalBill.getDate("bookdate"));
                woffBill.set("bizdate", (Object)revalBill.getDate("bookdate"));
            }
        }
    }

    private void setTargetBillsNo(List<DynamicObject> trgBills) {
        Map<String, List<DynamicObject>> orgPkGroup = trgBills.stream().collect(Collectors.groupingBy(bill -> bill.getDynamicObject("org").getPkValue().toString()));
        orgPkGroup.entrySet().forEach(entry -> {
            List targetBills = (List)entry.getValue();
            String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)"ap_busbill", (DynamicObject)((DynamicObject)targetBills.get(0)), (String)((String)entry.getKey()), (int)targetBills.size());
            int i = 0;
            for (DynamicObject trgBusBill : targetBills) {
                trgBusBill.set("billno", (Object)numbers[i]);
                trgBusBill.set("isselfwoff", (Object)Boolean.TRUE);
                ++i;
            }
        });
    }

    private void doOperation(String entityName, List<DynamicObject> woffBills) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("iswoff", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])woffBills.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)result);
    }

    private void setBookDate4WoffBill(DynamicObject[] busBills) {
        HashSet<Long> finBillIds = new HashSet<Long>(busBills.length);
        ArrayList<DynamicObject> writeOffBus = new ArrayList<DynamicObject>(busBills.length);
        HashMap<Long, Date> finBookDates = new HashMap<Long, Date>(busBills.length);
        for (DynamicObject busBill : busBills) {
            Long srcfinbillid;
            boolean isWriteOff = busBill.getBoolean("writeoffbusiness");
            if (!isWriteOff || (srcfinbillid = Long.valueOf(busBill.getLong("srcfinbillid"))) == null || srcfinbillid == 0L) continue;
            finBillIds.add(srcfinbillid);
            writeOffBus.add(busBill);
        }
        if (finBillIds.size() == 0) {
            return;
        }
        DynamicObjectCollection finApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,bookdate", (QFilter[])new QFilter[]{new QFilter("id", "in", finBillIds)});
        for (DynamicObject finBill : finApBills) {
            finBookDates.put(finBill.getLong("id"), finBill.getDate("bookdate"));
        }
        if (finBookDates.size() == 0) {
            return;
        }
        for (DynamicObject busBill : writeOffBus) {
            Long srcfinbillid = busBill.getLong("srcfinbillid");
            Date bookDate = (Date)finBookDates.get(srcfinbillid);
            if (bookDate == null) continue;
            busBill.set("bookdate", (Object)bookDate);
        }
    }

    private void updateRevalBusWoffFlag(DynamicObject[] busBills) {
        for (DynamicObject bill : busBills) {
            boolean isReval = bill.getBoolean("isrevaluation");
            boolean isAdjust = bill.getBoolean("isadjust");
            if (!isReval || !isAdjust) continue;
            bill.set("isselfwoff", (Object)Boolean.FALSE);
        }
    }

    private void preParBillsToAr(DynamicObject[] apBusBills) {
        HashSet<Long> pushArSet = new HashSet<Long>(8);
        for (DynamicObject apBill : apBusBills) {
            String billTypeNum = apBill.getString("billtype.number");
            boolean isadjust = apBill.getBoolean("isadjust");
            DynamicObjectCollection apEntrys = apBill.getDynamicObjectCollection("entry");
            Set isPrepaidSet = apEntrys.stream().filter(t -> t.getBoolean("e_prepaid")).collect(Collectors.toSet());
            if (!"ap_busbill_purfee_BT_S".equals(billTypeNum) && !"ap_busbill_salefee_BT_S".equals(billTypeNum) || isPrepaidSet.size() <= 0 || isadjust) continue;
            pushArSet.add(apBill.getLong("id"));
        }
        if (pushArSet.size() > 0) {
            CommonParam commonParam = new CommonParam();
            commonParam.put((Object)"prePaidPks", pushArSet);
            commonParam.put((Object)"entityKey", (Object)"ap_busbill");
            ECServiceHelper.beginAndRegisterWithBusInfo((String)"ap_coordination_push", (String)"busprepaid_push", (String)"fi", (String)"ap", (String)"CoordAndPrepaidECService", (Param)commonParam, (String)"", new ArrayList(pushArSet));
        }
    }

    private void setCostDiffAmount(DynamicObject[] entities) {
        Object sourceRowIdsMap;
        Iterator iterator;
        Object entry;
        DynamicObject[] busBills;
        ArrayList<Long> busBillIds = new ArrayList<Long>(64);
        for (DynamicObject entity : entities) {
            if (!entity.getBoolean("isadjust")) continue;
            busBillIds.add(entity.getLong("id"));
        }
        logger.info("ApBusBillAuditOp setCostDiffAmount busBillIds size is : " + busBillIds.size());
        if (busBillIds.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> adjustBusBills = new ArrayList<DynamicObject>(64);
        ArrayList<DynamicObject> writeOffBusBills = new ArrayList<DynamicObject>(64);
        ArrayList<DynamicObject> revaluateAdjustBills = new ArrayList<DynamicObject>(64);
        String selectors = "e_costdiffamount,sourcebillid,e_srcentryid,intercostamt,srcfinbillid,isadjust,writeoffbusiness,isrevaluation,isselfwoff,corebillid,corebillentryid";
        for (DynamicObject busBill : busBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", busBillIds)})) {
            boolean isAdjust = busBill.getBoolean("isadjust");
            if (isAdjust && busBill.getBoolean("writeoffbusiness")) {
                writeOffBusBills.add(busBill);
                continue;
            }
            if (isAdjust && !busBill.getBoolean("isselfwoff") && busBill.getLong("srcfinbillid") != 0L) {
                adjustBusBills.add(busBill);
                continue;
            }
            if (!isAdjust || !busBill.getBoolean("isrevaluation")) continue;
            revaluateAdjustBills.add(busBill);
        }
        logger.info("ApBusBillAuditOp setCostDiffAmount adjustBusBills size is : " + adjustBusBills.size() + ";writeOffBusBills size is : " + writeOffBusBills.size() + ";revaluateAdjustBills size is : " + revaluateAdjustBills.size());
        ArrayList<DynamicObject> needSaveBusBills = new ArrayList<DynamicObject>(64);
        if (!writeOffBusBills.isEmpty()) {
            List srcAdjustBillIds = writeOffBusBills.stream().map(bill -> bill.getLong("sourcebillid")).collect(Collectors.toList());
            DataSet srcAdjustBillDataSet = QueryServiceHelper.queryDataSet((String)"querySrcAdjust", (String)"ap_busbill", (String)"entry.id entryId,entry.e_costdiffamount e_costdiffamount", (QFilter[])new QFilter[]{new QFilter("id", "in", srcAdjustBillIds)}, (String)"");
            HashMap<Long, BigDecimal> srcAdjustCostDiffMap = new HashMap<Long, BigDecimal>(64);
            for (Row srcAdjustRow : srcAdjustBillDataSet) {
                srcAdjustCostDiffMap.put(srcAdjustRow.getLong("entryId"), srcAdjustRow.getBigDecimal("e_costdiffamount"));
            }
            for (DynamicObject writeOffBusBill : writeOffBusBills) {
                entry = writeOffBusBill.getDynamicObjectCollection("entry");
                iterator = entry.iterator();
                while (iterator.hasNext()) {
                    DynamicObject busRow = (DynamicObject)iterator.next();
                    BigDecimal srcCostDiffAmt = (BigDecimal)srcAdjustCostDiffMap.get(busRow.getLong("e_srcentryid"));
                    if (srcCostDiffAmt == null) continue;
                    busRow.set("e_costdiffamount", (Object)srcCostDiffAmt.negate());
                }
            }
            needSaveBusBills.addAll(writeOffBusBills);
        }
        if (!revaluateAdjustBills.isEmpty()) {
            HashSet<Long> revaluateAdjustBillIds = new HashSet<Long>(64);
            ArrayList<Long> revaluateAdjustRowIds = new ArrayList<Long>(64);
            ArrayList<Long> blueBusBillIds = new ArrayList<Long>(64);
            for (DynamicObject revaluateAdjustBill : revaluateAdjustBills) {
                revaluateAdjustBillIds.add(revaluateAdjustBill.getLong("id"));
                entry = revaluateAdjustBill.getDynamicObjectCollection("entry");
                iterator = entry.iterator();
                while (iterator.hasNext()) {
                    DynamicObject revaluateAdjustRow = (DynamicObject)iterator.next();
                    revaluateAdjustRowIds.add(revaluateAdjustRow.getLong("id"));
                }
                blueBusBillIds.add(revaluateAdjustBill.getLong("sourcebillid"));
            }
            DataSet revaluateBillDataSet = QueryServiceHelper.queryDataSet((String)"queryrevaluatebill", (String)"ap_busbill", (String)"id,entry.e_srcentryid e_srcentryid,entry.intercostamt intercostamt", (QFilter[])new QFilter[]{new QFilter("revaluasrcbusbillid", "in", blueBusBillIds)}, (String)"");
            HashMap<Long, BigDecimal> revaluateInterCostAmtMap = new HashMap<Long, BigDecimal>(64);
            for (Object revaluateRow : revaluateBillDataSet) {
                revaluateInterCostAmtMap.put(revaluateRow.getLong("e_srcentryid"), revaluateRow.getBigDecimal("intercostamt"));
            }
            sourceRowIdsMap = BOTPNewHelper.loadNearSourceRowIds((String)"ap_busbill", (String)"entry", (Long[])revaluateAdjustBillIds.toArray(new Long[0]), (Long[])revaluateAdjustRowIds.toArray(new Long[0]), (String)"im_purinbill");
            for (DynamicObject revaluateAdjustBill : revaluateAdjustBills) {
                Iterator entry2 = revaluateAdjustBill.getDynamicObjectCollection("entry");
                Iterator iterator2 = entry2.iterator();
                while (iterator2.hasNext()) {
                    DynamicObject revaluateAdjustRow = (DynamicObject)iterator2.next();
                    Long purEntryId = (Long)sourceRowIdsMap.get(revaluateAdjustRow.getLong("id"));
                    BigDecimal revaluateInterCostAmt = (BigDecimal)revaluateInterCostAmtMap.get(purEntryId);
                    if (revaluateInterCostAmt == null) continue;
                    revaluateAdjustRow.set("e_costdiffamount", (Object)revaluateInterCostAmt.add(revaluateAdjustRow.getBigDecimal("intercostamt")));
                }
            }
            needSaveBusBills.addAll(revaluateAdjustBills);
        }
        if (!adjustBusBills.isEmpty()) {
            List finApBillIds = adjustBusBills.stream().map(bill -> bill.getLong("srcfinbillid")).collect(Collectors.toList());
            DynamicObject[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,detailentry.e_sourcebillentryid,detailentry.intercostamt,detailentry.e_costdiffamount,detailentry.corebillid,detailentry.corebillentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)});
            Map finApBillMap = Arrays.stream(finApBills).collect(Collectors.toMap(bill -> bill.getLong("id"), Function.identity()));
            HashSet<Long> adjustBillIds = new HashSet<Long>(32);
            HashSet<Long> adjustRowIds = new HashSet<Long>(32);
            for (DynamicObject adjustBusBill : adjustBusBills) {
                adjustBillIds.add(adjustBusBill.getLong("id"));
                DynamicObjectCollection entry3 = adjustBusBill.getDynamicObjectCollection("entry");
                for (DynamicObject row : entry3) {
                    adjustRowIds.add(row.getLong("id"));
                }
            }
            sourceRowIdsMap = BOTPNewHelper.loadNearSourceRowIds((String)"ap_busbill", (String)"entry", (Long[])adjustBillIds.toArray(new Long[0]), (Long[])adjustRowIds.toArray(new Long[0]), (String)"im_purinbill");
            for (DynamicObject adjustBusBill : adjustBusBills) {
                DynamicObject finApBill = (DynamicObject)finApBillMap.get(adjustBusBill.getLong("srcfinbillid"));
                if (finApBill == null) continue;
                HashMap<Long, DynamicObject> finApRowMap = new HashMap<Long, DynamicObject>(32);
                HashMap<Long, DynamicObject> finApCoreRowMap = new HashMap<Long, DynamicObject>(32);
                DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject detailRow : detailEntry) {
                    long coreBillEntryId;
                    String eSourceBillEntryId = detailRow.getString("e_sourcebillentryid");
                    if (!ObjectUtils.isEmpty((Object)eSourceBillEntryId)) {
                        finApRowMap.put(Long.parseLong(eSourceBillEntryId), detailRow);
                    }
                    if ((coreBillEntryId = detailRow.getLong("corebillentryid")) == 0L) continue;
                    finApCoreRowMap.put(coreBillEntryId, detailRow);
                }
                DynamicObjectCollection entry4 = adjustBusBill.getDynamicObjectCollection("entry");
                for (DynamicObject busRow : entry4) {
                    long blueBusRowId = busRow.getLong("e_srcentryid");
                    DynamicObject finApRow = (DynamicObject)finApRowMap.get(blueBusRowId);
                    if (finApRow == null && (finApRow = (DynamicObject)finApRowMap.get(sourceRowIdsMap.get(busRow.getLong("id")))) == null) {
                        finApRow = (DynamicObject)finApCoreRowMap.get(busRow.getLong("corebillentryid"));
                    }
                    if (finApRow == null) continue;
                    BigDecimal costDiffAmount = finApRow.getBigDecimal("intercostamt").add(busRow.getBigDecimal("intercostamt"));
                    busRow.set("e_costdiffamount", (Object)costDiffAmount);
                    finApRow.set("e_costdiffamount", (Object)costDiffAmount);
                }
            }
            SaveServiceHelper.save((DynamicObject[])finApBills);
            needSaveBusBills.addAll(adjustBusBills);
        }
        logger.info("ApBusBillAuditOp setCostDiffAmount needSaveBusBills size is : " + needSaveBusBills.size());
        if (!needSaveBusBills.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])needSaveBusBills.toArray(new DynamicObject[0]));
        }
    }
}

