/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.business.invoicematch.helper.MatchSchemeConverter;
import kd.fi.ap.business.invoicematch.match.AbstractInvMatchService;
import kd.fi.ap.business.invoicematch.match.InvMatchServiceFactory;
import kd.fi.ap.vo.MatchSchemeVO;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;

public class ApMatchSchemeExecuteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("org");
        lst.add("number");
        lst.add("name");
        lst.add("useorg");
        lst.add("createorg");
        lst.add("ctrlstrategy");
        lst.add("remark");
        lst.add("ismultiple");
        lst.add("taxtolerance");
        lst.add("amttolerance");
        lst.add("pricetaxtolerance");
        lst.add("applicability");
        lst.add("applicability_tag");
        lst.add("matchfield");
        lst.add("isforce");
        lst.add("ispreset");
        lst.add("mappingfield");
        lst.add("matchrule");
        lst.add("matchtype");
        lst.add("pricetolerance");
        lst.add("matchmode");
        lst.add("timeorder");
        lst.add("biztype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] schemes = e.getDataEntities();
        HashSet<String> invStatusSet = new HashSet<String>(4);
        invStatusSet.add("1");
        invStatusSet.add("2");
        invStatusSet.add("3");
        invStatusSet.add("4");
        for (DynamicObject scheme : schemes) {
            String matchrule = scheme.getString("matchrule");
            AbstractInvMatchService service = InvMatchServiceFactory.getInvMatchService((String)matchrule);
            String applicability = scheme.getString("applicability_tag");
            QFilter filter = new QFilter("org", "=", scheme.get("org.id"));
            filter.and(new QFilter("ismatched", "=", (Object)Boolean.FALSE));
            filter.and(new QFilter("billstatus", "=", (Object)"C"));
            filter.and(new QFilter("unrelatedamt", "!=", (Object)BigDecimal.ZERO));
            filter.and(new QFilter("entry.material", "!=", (Object)0L));
            filter.and(new QFilter("invoicestatus", "not in", invStatusSet));
            if (!ObjectUtils.isEmpty((Object)applicability)) {
                filter.and(this.getFilter(applicability, "ap_invoice"));
            }
            String timeorder = scheme.getString("timeorder");
            DynamicObject[] invColl = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,billno,org,asstacttype,asstact,currency,invoicetype", (QFilter[])filter.toArray(), (String)("issuedate " + timeorder));
            MatchSchemeVO matchSchemeVO = MatchSchemeConverter.convertMatchSchemeToVO((DynamicObject)scheme);
            for (DynamicObject invBill : invColl) {
                ArrayList<Object> invPks = new ArrayList<Object>(1);
                invPks.add(invBill.get("id"));
                List matchResults = service.mainDataInit(invPks, matchSchemeVO);
                service.loadMatchBill(matchResults, matchSchemeVO);
                List matchBillList = MatchSchemeConverter.convertVO2Dyn((List)matchResults);
                if (matchBillList.isEmpty()) {
                    OpLogServiceHelper.addLog((String)"AutoMatchInvoice", (Object)matchResults, (DynamicObject[])new DynamicObject[]{invBill}, (boolean)false);
                    continue;
                }
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_matchinvoice", (DynamicObject[])matchBillList.toArray(new DynamicObject[matchBillList.size()]), null);
                OperationHelper.assertResult((OperationResult)saveResult);
            }
        }
    }

    private QFilter getFilter(String condition, String number) {
        CRCondition formula = (CRCondition)SerializationUtils.fromJsonString((String)condition, CRCondition.class);
        FilterCondition filterCondition = formula.getFilterCondition();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
        FilterBuilder filterBuilder = new FilterBuilder(dataEntityType, filterCondition, true);
        filterBuilder.buildFilter(false);
        return filterBuilder.getQFilter();
    }
}

