/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.AsstactInfoImportHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;

public class ApplyPaySaveOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(ApplyPaySaveOp.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private final String[] filedKeys = new String[]{"applyamount", "appseleamount", "approvalamount", "aprseleamount"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        logger.info("ApplyPaySaveOp.onAddValidators start");
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
        logger.info("ApplyPaySaveOp.onAddValidators end");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        logger.info("ApplyPaySaveOp.beforeExecuteOperationTransaction start");
        DynamicObject[] datas = e.getDataEntities();
        String billSrctype = datas[0].getString("billsrctype");
        if (BillSrcTypeEnum.IMPORT.getValue().equals(billSrctype)) {
            AsstactInfoImportHelper.setAsstactInfo4PayApply((DynamicObject[])datas);
        }
        logger.info("ApplyPaySaveOp.beforeExecuteOperationTransaction end");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("ApplyPaySaveOp.beginOperationTransaction appendHeadAmt start");
        this.appendHeadAmt(entities);
        logger.info("ApplyPaySaveOp.beginOperationTransaction appendHeadAmt end");
        ArApDataRepairHelper.repairPayApplyDatas((DynamicObject[])entities);
        logger.info("ApplyPaySaveOp.beginOperationTransaction end");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("applyamount");
        lst.add("approvalamount");
        lst.add("paystatus");
        lst.add("billstatus");
        lst.add("e_paidamt");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("e_applyamount");
        lst.add("e_approvedseleamt");
        lst.add("settleorg");
        lst.add("entry_lk_sbillid");
        lst.add("entry.e_asstact");
        lst.add("entry.e_assacct");
        lst.add("entry.e_bebank");
        lst.add("entry.e_settlementtype");
        lst.add("entry.e_asstacttype");
        lst.add("billsrctype");
        lst.add("exchangerate");
        lst.add("applyamount");
        lst.add("appseleamount");
        lst.add("aprseleamount");
        lst.add("e_appseleamount");
        lst.add("e_approvedamt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendHeadAmt(DynamicObject[] datas) {
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        if ("true".equals(isAppend)) {
            try {
                lock.lock();
                for (DynamicObject data : datas) {
                    String amtJson = (String)ConfigCache.get((String)"appendentryrows", (String)data.getString("id"), String.class);
                    Map<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>(16);
                    if (amtJson != null) {
                        amtMap = (Map)SerializationUtils.fromJsonString((String)amtJson, Map.class);
                        for (String filedKey : this.filedKeys) {
                            data.set(filedKey, (Object)data.getBigDecimal(filedKey).add(amtMap.getOrDefault(filedKey, BigDecimal.ZERO)));
                        }
                    }
                    this.buildAmtMap(amtMap, data);
                    ConfigCache.put((String)"appendentryrows", (String)data.getString("id"), (Object)SerializationUtils.toJsonString(amtMap));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void buildAmtMap(Map<String, BigDecimal> amtMap, DynamicObject data) {
        for (String filedKey : this.filedKeys) {
            amtMap.put(filedKey, data.getBigDecimal(filedKey));
        }
    }
}

