/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.ap.validator.ApplyPaySubmit4RedRowValidator;
import kd.fi.ap.validator.ApplyPaySubmitAmountValidator;
import kd.fi.ap.validator.PayApplyInvoiceValidator;
import kd.fi.ap.validator.PayApplySrcTypeValidator;
import kd.fi.ap.validator.SupplierPayHoldValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.opplugin.MustInputValidator;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.PayApplyExcessValidator;

public class ApplyPaySubmitOp
extends ArapBaseOp {
    private static final int rowCountOneBatch = 2000;
    private static final Log logger = LogFactory.getLog(ApplyPaySubmitOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        logger.info("ApplyPaySubmitOp.onAddValidators start");
        if (SystemParameterHelper.isForceValidateAmt()) {
            e.addValidator((AbstractValidator)new ApplyPaySubmitAmountValidator());
        }
        e.addValidator((AbstractValidator)new ApplyPaySubmit4RedRowValidator());
        e.addValidator((AbstractValidator)new SupplierPayHoldValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
        e.addValidator((AbstractValidator)new MustInputValidator());
        e.addValidator((AbstractValidator)new PayApplyExcessValidator());
        e.addValidator((AbstractValidator)new PayApplyInvoiceValidator());
        e.addValidator((AbstractValidator)new PayApplySrcTypeValidator());
        logger.info("ApplyPaySubmitOp.onAddValidators end");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] datas;
        super.beforeExecuteOperationTransaction(e);
        logger.info("ApplyPaySubmitOp.beforeExecuteOperationTransaction start");
        for (DynamicObject data : datas = e.getDataEntities()) {
            if (!StringUtils.isEmpty((String)data.getString("billsrctype")) || !StringUtils.isNotEmpty((String)data.getString("sourcebilltype"))) continue;
            data.set("billsrctype", (Object)BillSrcTypeEnum.AUTO.getValue());
        }
        logger.info("ApplyPaySubmitOp.beforeExecuteOperationTransaction end");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        logger.info("ApplyPaySubmitOp.beginOperationTransaction start");
        Object[] entities = e.getDataEntities();
        ArApDataRepairHelper.repairPayApplyDatas((DynamicObject[])entities);
        try (TraceSpan span = Tracer.create((String)"paymentsecurity", (String)"beginOperationTransaction");){
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0079", null, (Object[])entities);
        }
        logger.info("ApplyPaySubmitOp.beginOperationTransaction end");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        logger.info("ApplyPaySubmitOp.afterExecuteOperationTransaction start");
        this.removeCache(e.getDataEntities());
        logger.info("ApplyPaySubmitOp.afterExecuteOperationTransaction end");
    }

    private void removeCache(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (2000 >= dataEntity.getDynamicObjectCollection("entry").size()) continue;
            ConfigCache.remove((String)"appendentryrows", (String)dataEntity.getString("id"));
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("applyamount");
        lst.add("approvalamount");
        lst.add("paystatus");
        lst.add("billstatus");
        lst.add("e_paidamt");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("e_applyamount");
        lst.add("e_approvedseleamt");
        lst.add("imageno");
        lst.add("applyorg");
        lst.add("creator");
        lst.add("modifier");
        lst.add("createtime");
        lst.add("modifytime");
        lst.add("settleorg");
        lst.add("e_expaydate");
        lst.add("appseleamount");
        lst.add("aprseleamount");
        lst.add("e_payamount");
        lst.add("e_appseleamount");
        lst.add("e_approvedamt");
        lst.add("entry.seq");
        lst.add("entry_lk");
        lst.add("e_corebilltype");
        lst.add("e_corebillno");
        lst.add("e_corebillid");
        lst.add("e_corebillentryid");
        lst.add("e_corebillentryseq");
        lst.add("billsrctype");
        lst.add("e_costcenter");
        lst.add("exchangerate");
        lst.add("paycurrency");
        lst.add("settlecurrency");
        lst.add("exratetable");
        lst.add("e_asstacttype");
        lst.add("e_asstact");
        lst.add("entry_lk_sbillid");
        lst.add("entry_lk_sid");
        lst.add("entry.e_paymenttype");
        lst.add("inventry.i_srctype");
        lst.add("inventry.invid");
        lst.add("inventry.i_serialno");
        lst.add("entry.e_paymenttype");
        lst.add("entry.e_asstacttype");
        lst.add("entry.e_approvedseleamt");
        lst.add("entry.e_asstact");
        lst.add("isprepayinvoice");
        lst.add("sourcebilltype");
        lst.add("aprseleamount");
        lst.add("billstatus");
        lst.add("settleorg");
        lst.add("settlecurrency");
        lst.add("billtype");
        lst.add("i_asstactname");
        lst.add("inventry.seq");
        if (SystemParameterHelper.isForceValidateAmt()) {
            lst.addAll(ApplyPaySubmitAmountValidator.getRequiredFields());
        }
    }
}

