/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.ap.validator.ApplyPayUnAuditValidator;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.validator.PayBillStatusValidator;

public class ApplyPayUnAuditOp
extends ArapBaseOp {
    private static final Log log = LogFactory.getLog(ApplyPayUnAuditOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        log.info("ApplyPayUnAuditOp.onAddValidators start");
        ApplyPayUnAuditValidator v = new ApplyPayUnAuditValidator();
        e.addValidator((AbstractValidator)v);
        PayBillStatusValidator payBillStatusValidator = new PayBillStatusValidator();
        e.addValidator((AbstractValidator)payBillStatusValidator);
        log.info("ApplyPayUnAuditOp.onAddValidators end");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] entities;
        super.afterExecuteOperationTransaction(e);
        log.info("ApplyPayUnAuditOp.afterExecuteOperationTransaction start");
        for (DynamicObject appBill : entities = e.getDataEntities()) {
            try {
                this.deleteBillToPurPayApply(appBill);
            }
            catch (Exception exc) {
                log.info(exc.getMessage());
            }
        }
        log.info("ApplyPayUnAuditOp.afterExecuteOperationTransaction end");
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("applyamount");
        lst.add("appseleamount");
        lst.add("approvalamount");
        lst.add("aprseleamount");
        lst.add("paystatus");
        lst.add("billstatus");
        lst.add("e_paidamt");
        lst.add("sourcebillid");
        lst.add("sourcebilltype");
        lst.add("e_approvedamt");
        lst.add("e_applyamount");
        lst.add("e_approvedseleamt");
        lst.add("e_appseleamount");
        lst.add("settleorg");
        lst.add("billsrctype");
        lst.add("billno");
    }

    private void deleteBillToPurPayApply(DynamicObject payApply) {
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)payApply.getDataEntityType().getName(), (Long[])new Long[]{payApply.getLong("id")});
        if (targetBills.size() == 0) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>(64);
        HashSet idSet = (HashSet)targetBills.get("pur_payapply");
        if (ObjectUtils.isEmpty((Object)idSet)) {
            return;
        }
        ArrayList ids = new ArrayList(idSet);
        param.put("ids", ids);
        param.put("entityName", "pur_payapply");
        DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"unAuditAndDeleteBill", (Object[])new Object[]{param});
    }
}

