/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;

public class ApplyRecInfoChangeOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("e_paidamt");
        lst.add("lockedamt");
        lst.add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                HashSet<Long> applyIds = new HashSet<Long>(dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    applyIds.add(dynamicObject.getLong("id"));
                }
                Map applyTarMap = BOTPHelper.findDirtTargetBillIds((String)"ap_payapply", (Long[])applyIds.toArray(new Long[0]), (String)"cas_paybill", (String)"cas_paybill");
                Map applyChangeMap = BOTPHelper.findDirtTargetBillIds((String)"ap_payapply", (Long[])applyIds.toArray(new Long[0]), (String)"ap_payapplychange", (String)"ap_payapplychange");
                HashSet allTarBillIds = new HashSet(10);
                if (applyTarMap != null) {
                    for (Map.Entry entry : applyTarMap.entrySet()) {
                        allTarBillIds.addAll((Collection)entry.getValue());
                    }
                }
                DynamicObjectCollection casColls = QueryServiceHelper.query((String)"cas_paybill", (String)"id,sourcebilltype,sourcebillid,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", allTarBillIds)});
                HashMap<Long, String> hashMap = new HashMap<Long, String>(8);
                for (Object casBill : casColls) {
                    String string = casBill.getString("billstatus");
                    Long casId = casBill.getLong("id");
                    hashMap.put(casId, string);
                }
                HashSet changeTarBillIds = new HashSet(10);
                if (applyChangeMap != null) {
                    for (Map.Entry entry : applyChangeMap.entrySet()) {
                        changeTarBillIds.addAll((Collection)entry.getValue());
                    }
                }
                DynamicObjectCollection applyChangeBills = QueryServiceHelper.query((String)"ap_payapplychange", (String)"id,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", changeTarBillIds)});
                Map<Long, String> map = applyChangeBills.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e.getString("billstatus")));
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    Set tarChangeIdSet;
                    String status;
                    Set tarCasIdSet;
                    DynamicObject applyPayBill = dataEntity.getDataEntity();
                    boolean isChange = false;
                    String billStatus = applyPayBill.getString("billstatus");
                    Long applyId = applyPayBill.getLong("id");
                    DynamicObjectCollection entryColls = (DynamicObjectCollection)applyPayBill.get("entry");
                    for (DynamicObject entry : entryColls) {
                        BigDecimal lockAmt = entry.getBigDecimal("lockedamt");
                        BigDecimal payAmt = entry.getBigDecimal("e_paidamt");
                        if (lockAmt.compareTo(BigDecimal.ZERO) != 0 || payAmt.compareTo(BigDecimal.ZERO) != 0 || !"C".equals(billStatus) && !"E".equals(billStatus)) continue;
                        isChange = true;
                        break;
                    }
                    if (applyTarMap != null && applyTarMap.size() > 0 && isChange && (tarCasIdSet = (Set)applyTarMap.get(applyId)) != null) {
                        for (Long casId : tarCasIdSet) {
                            status = (String)hashMap.get(casId);
                            if (!"A".equals(status) && !"B".equals(status) && !"C".equals(status) && !"E".equals(status) && !"J".equals(status)) continue;
                            isChange = false;
                            break;
                        }
                    }
                    if (applyChangeMap != null && applyChangeMap.size() > 0 && isChange && (tarChangeIdSet = (Set)applyChangeMap.get(applyId)) != null) {
                        for (Long changeId : tarChangeIdSet) {
                            status = map.get(changeId);
                            if ("C".equals(status) || "E".equals(status)) continue;
                            isChange = false;
                            break;
                        }
                    }
                    if (isChange) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355\u5df2\u5ba1\u6838\u4e14\u4e0b\u6e38\u4e0d\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u5355\u65f6\uff0c\u76f8\u540c\u6536\u6b3e\u4f9b\u5e94\u5546\u3001\u5f80\u6765\u8d26\u6237\u4e0e\u5f80\u6765\u94f6\u884c\u7684\u5df2\u4ed8\u91d1\u989d\u5408\u8ba1\u4e0e\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u5747\u4e3a0\u7684\u6570\u636e\u624d\u5141\u8bb8\u8fdb\u884c\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u3002", (String)"ApplyRecInfoChangeOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), new Object[0]));
                }
            }
        });
    }
}

