/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.validator.BusPaymentSecurityAuditValidator;
import kd.fi.arapcommon.opplugin.ArapBaseOp;

public class BusApBillDeleteOp
extends ArapBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("isrevaluation");
        lst.add("hadrevaluation");
        lst.add("revaluasrcbusbillid");
        lst.add("isadjust");
        lst.add("billno");
        lst.add("biztype");
        lst.add("payproperty.isbasedonamt");
        lst.add("org");
        lst.add("asstact");
        lst.add("currency");
        lst.add("entry.e_corebilltype");
        lst.add("entry.corebillid");
        lst.add("entry.corebillentryid");
        lst.add("entry.e_corebillentryseq");
        lst.add("entry.e_pricetaxtotal");
        lst.add("entry.e_baseunitqty");
        lst.add("entry.seq");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BusPaymentSecurityAuditValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> needInvokeCalBillIds = new HashSet<Long>(2);
        HashMap<Long, DynamicObject> srcBusBillMap = new HashMap<Long, DynamicObject>(8);
        ArrayList<DynamicObject> needSaveBills = new ArrayList<DynamicObject>(8);
        HashSet<Long> revaluaSrcbusBillIds = new HashSet<Long>(8);
        for (DynamicObject bill : dataEntities) {
            boolean isRevaluaTion = bill.getBoolean("isrevaluation");
            if (!isRevaluaTion) continue;
            Long revaluaSrcbusBillId = bill.getLong("revaluasrcbusbillid");
            revaluaSrcbusBillIds.add(revaluaSrcbusBillId);
        }
        if (!revaluaSrcbusBillIds.isEmpty()) {
            DynamicObject[] srcBusBills;
            DynamicObject[] dynamicObjectArray = srcBusBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"id,hadrevaluation", (QFilter[])new QFilter[]{new QFilter("id", "in", revaluaSrcbusBillIds)});
            int n = dynamicObjectArray.length;
            for (int bill = 0; bill < n; ++bill) {
                DynamicObject srcBusBill = dynamicObjectArray[bill];
                srcBusBillMap.put(srcBusBill.getLong("id"), srcBusBill);
            }
        }
        for (DynamicObject bill : dataEntities) {
            Long revaluaSrcbusBillId;
            DynamicObject srcBusBill;
            boolean isRevaluaTion = bill.getBoolean("isrevaluation");
            boolean isAdjust = bill.getBoolean("isadjust");
            if (!isRevaluaTion) continue;
            if (isAdjust) {
                needInvokeCalBillIds.add(bill.getLong("id"));
            }
            if ((srcBusBill = (DynamicObject)srcBusBillMap.get(revaluaSrcbusBillId = Long.valueOf(bill.getLong("revaluasrcbusbillid")))) == null) continue;
            srcBusBill.set("hadrevaluation", (Object)Boolean.FALSE);
            needSaveBills.add(srcBusBill);
        }
        if (!needSaveBills.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])needSaveBills.toArray(new DynamicObject[0]));
        }
        if (needInvokeCalBillIds.size() > 0) {
            try (TXHandle tx = TX.requiresNew((String)"invokeCal");){
                try {
                    DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCostAdjustDeleteService", (String)"deleteCostAdjust", (Object[])new Object[]{needInvokeCalBillIds});
                }
                catch (Exception ex) {
                    tx.markRollback();
                    throw ex;
                }
            }
        }
    }
}

