/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.util.DateUtils;
import kd.fi.ap.validator.CloseAccountValidator;

public class CloseAccountOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject info : e.getDataEntities()) {
            this.doCloseAccount(info);
        }
    }

    private void doCloseAccount(DynamicObject info) {
        Date closeDate = DateUtils.getDataFormat((Date)this.getCloseDate(), (boolean)true);
        info.set("currentdate", (Object)DateUtils.getNextDay((Date)closeDate, (int)1));
        info.set("entryentity", null);
        SaveServiceHelper.save((IDataEntityType)info.getDataEntityType(), (Object[])new DynamicObject[]{info});
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        CloseAccountValidator v = new CloseAccountValidator();
        v.setCloseDate(this.getCloseDate());
        v.setEntityKey("ap_closeaccount");
        e.addValidator((AbstractValidator)v);
    }

    private Date getCloseDate() {
        String closeDateString = this.getOption().getVariableValue("closedate");
        Date closeDate = null;
        try {
            closeDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(closeDateString);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
        return closeDate;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(this.getSelectors());
    }

    private List<String> getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("org");
        selectors.add("currentdate");
        selectors.add("isfinishinit");
        selectors.add("failedmessage");
        selectors.add("billtype");
        selectors.add("count");
        selectors.add("status");
        selectors.add("duedate");
        return selectors;
    }
}

