/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.util.DateUtils;
import kd.fi.arapcommon.helper.CloseAccountHelper;

public class CloseAccountSchemaOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CloseAccountSchemaOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<Long> allList = new ArrayList<Long>(10);
        for (DynamicObject info : e.getDataEntities()) {
            Long orgId = info.getLong("org.id");
            allList.add(orgId);
        }
        if (allList.size() > 0) {
            DynamicObject[] infos;
            logger.info("\u5173\u8d26\u7684\u7ec4\u7ec7\u4e3a\uff1a" + allList);
            for (DynamicObject info : infos = BusinessDataServiceHelper.load((String)"ap_closeaccount", (String)String.join((CharSequence)",", this.getSelectors()), (QFilter[])new QFilter[]{new QFilter("org.id", "in", allList)})) {
                DynamicObject org = info.getDynamicObject("org");
                if (!info.getBoolean("isfinishinit")) continue;
                Date date = this.getCloseDate(info);
                Date currentDate = info.getDate("currentdate");
                Date closeDate = DateUtils.getDataFormat((Date)date, (boolean)true);
                List allValidateInfos = CloseAccountHelper.getAllValidateInfos((boolean)false, (long)((Long)org.getPkValue()), (Date)closeDate, (Date)currentDate);
                if (!allValidateInfos.isEmpty()) {
                    CloseAccountHelper.bindFailedInfoToEntityEntry((DynamicObject)info, (List)allValidateInfos);
                    continue;
                }
                this.doCloseAccount(info, closeDate);
            }
            SaveServiceHelper.save((DynamicObject[])infos);
        }
    }

    private void doCloseAccount(DynamicObject info, Date closeDate) {
        info.set("currentdate", (Object)DateUtils.getNextDay((Date)closeDate, (int)1));
        info.set("entryentity", null);
    }

    private Date getCloseDate(DynamicObject info) {
        Date maxCurrentDate = this.getExtremeDate(new DynamicObject[]{info}, "currentdate", true);
        Date defaultCloseDate = kd.fi.arapcommon.util.DateUtils.getMaxMonthDate((Date)maxCurrentDate);
        return defaultCloseDate;
    }

    private Date getExtremeDate(DynamicObject[] closeAccountInfos, String dateName, boolean getMax) {
        Date aimDate = null;
        for (DynamicObject info : closeAccountInfos) {
            Date date = info.getDate(dateName);
            if (date == null) continue;
            if (aimDate != null) {
                if (getMax) {
                    aimDate = aimDate.after(date) ? aimDate : date;
                    continue;
                }
                aimDate = aimDate.before(date) ? aimDate : date;
                continue;
            }
            aimDate = date;
        }
        return aimDate;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(this.getSelectors());
    }

    private List<String> getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("org");
        selectors.add("currentdate");
        selectors.add("isfinishinit");
        selectors.add("failedmessage");
        selectors.add("billtype");
        selectors.add("count");
        selectors.add("status");
        selectors.add("duedate");
        return selectors;
    }
}

