/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.business.invoice.assign.IAssignInvoiceService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.validator.AdjustDiffValidator;
import kd.fi.ap.validator.AssginInvoiceValidator;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinApBillAssignOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(FinApBillAssignOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AssginInvoiceValidator());
        if (!this.isAutoAssign()) {
            e.addValidator((AbstractValidator)new AdjustDiffValidator());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        logger.info("FinApBillAssignOp endOperationTransaction begin");
        boolean isAutoAssign = this.isAutoAssign();
        List finApBillIds = Arrays.stream(e.getDataEntities()).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        Map variableMap = this.operateOption.getVariables();
        String invPksJson = (String)variableMap.get("invPks");
        ArrayList invPks = new ArrayList(32);
        if (!isAutoAssign) {
            invPks.addAll((Collection)JSONObject.parseObject((String)invPksJson, List.class));
        }
        AssignInvoiceParam assignInvoiceParam = new AssignInvoiceParam();
        String appId = (String)this.getOption().getVariables().get("appnumber");
        String operateKey = String.valueOf(this.operateMeta.get("key"));
        assignInvoiceParam.setBillIds(finApBillIds).setInvoiceIds(invPks).setAutoAssign(isAutoAssign).setAppId(appId).setOperateKey(operateKey);
        IAssignInvoiceService assignInvoiceService = (IAssignInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPASSIGNINVOICE.getValue());
        assignInvoiceService.assign(assignInvoiceParam);
        logger.info("FinApBillAssignOp endOperationTransaction end");
    }

    private boolean isAutoAssign() {
        String invPksJson = this.operateOption.getVariableValue("invPks", " ");
        return EmptyUtils.isEmpty((Object)invPksJson);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        Set properties = PlanSplitSchemeServiceHelper.getNeedProperties((boolean)false);
        lst.addAll(properties);
        Set invoiceAdjustSelectors = InvoiceHelper.getInvoiceAdjustSelectors();
        lst.addAll(invoiceAdjustSelectors);
    }
}

