/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.FinPlanRowService;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanRow;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.business.invoice.articulate.IInvoiceArticulateService;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.enums.InvoiceSrcTypeEnum;
import kd.fi.ap.helper.FinApBillHelper;
import kd.fi.ap.helper.FinapPremHelper;
import kd.fi.ap.mservice.ApExpenseCostService;
import kd.fi.ap.mservice.SettleServiceFactory;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.ap.mservice.writtenoffverify.ApWrittenOffVerifyService;
import kd.fi.ap.validator.FinApBillCodeRuleValidator;
import kd.fi.ap.validator.FinApBillImportValidator;
import kd.fi.ap.validator.FinApSubmitPremiumValidator;
import kd.fi.ap.validator.FinPaymentSecurityAuditValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.APSettleStatusEnum;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.ApFarmTaxAmtHelper;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApProcessParamsHelper;
import kd.fi.arapcommon.helper.ArApRecOrPayBillHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.AsstactInfoImportHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.WriteOffUnSettleService;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;
import kd.fi.arapcommon.service.concurrency.ConcuCtrlBizEnum;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.ValidOperationServiceHelper;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.writeback.helper.PremiumWBFinBillServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.validator.BillPriceValidator;
import kd.fi.arapcommon.validator.FarmTaxValidator;
import kd.fi.arapcommon.validator.SupplierandMaterial4VmiValidator;
import kd.fi.arapcommon.validator.WriteOffBillValidator;
import kd.fi.arapcommon.vo.RedVerifyRecordParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class FinApBillSaveOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(FinApBillSaveOp.class);
    private final List<Long> writeOffBillPks = new ArrayList<Long>(1);
    private static final ReentrantLock lock = new ReentrantLock();
    private final String[] filedKeys = new String[]{"pricetaxtotal", "pricetaxtotalbase", "amount", "amountbase", "tax", "uninvoicedamt", "unverifyamount", "unsettleamount", "unsettleamountbase", "adjustamount", "adjustlocalamt"};

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        if (!"true".equals(isAppend)) {
            e.addValidator((AbstractValidator)new FinApBillImportValidator());
        }
        e.addValidator((AbstractValidator)new SupplierandMaterial4VmiValidator());
        e.addValidator((AbstractValidator)new FinApBillCodeRuleValidator());
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new WriteOffBillValidator(this.writeOffBillPks));
        e.addValidator((AbstractValidator)new FinApSubmitPremiumValidator());
        e.addValidator((AbstractValidator)new FarmTaxValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
        e.addValidator((AbstractValidator)new FinPaymentSecurityAuditValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction start");
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction sortPlanDueDate start");
        ArApHelper.sortPlanDueDate((DynamicObject[])entities);
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction sortPlanDueDate end");
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction setBookDate start");
        BookDateHelper.billSavesetBookDate((DynamicObject[])entities, (boolean)false);
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction setBookDate end");
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction removeEmptyPreEntry start");
        ArApRecOrPayBillHelper.removeEmptyPreEntry((DynamicObject[])entities);
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction removeEmptyPreEntry end");
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction sortPreEntryByDate start");
        ArApRecOrPayBillHelper.sortPreEntryByDate((DynamicObject[])entities);
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction sortPreEntryByDate end");
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction setFinDecuAmt start");
        ApFarmTaxAmtHelper.setFinDecuAmt((DynamicObject[])entities);
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction setFinDecuAmt end");
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction putUnallocatedAmt start");
        this.putUnallocatedAmt(entities);
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction putUnallocatedAmt end");
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction setAsstactInfoForImport start");
        this.setAsstactInfoForImport(entities);
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction setAsstactInfoForImport end");
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction splitPlanEntryForImport start");
        this.splitPlanEntryForImport(entities);
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction splitPlanEntryForImport end");
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction setImptSuppliers start");
        this.setImptSuppliers(entities);
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction setImptSuppliers end");
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction removeSubEntry start");
        this.removeSubEntry(entities);
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction removeSubEntry end");
        logger.info("FinApBillSaveOp.beforeExecuteOperationTransaction end");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinApBillSaveOp.beginOperationTransaction start");
        logger.info("FinApBillSaveOp.beginOperationTransaction appendAmt start");
        this.appendAmt(entities);
        logger.info("FinApBillSaveOp.beginOperationTransaction appendAmt end");
        logger.info("FinApBillSaveOp.beginOperationTransaction writeOffBillSetAuditStatus start");
        this.writeOffBillSetAuditStatus(entities);
        logger.info("FinApBillSaveOp.beginOperationTransaction writeOffBillSetAuditStatus end");
        logger.info("FinApBillSaveOp.beginOperationTransaction repairFinApBillDatas start");
        ArApDataRepairHelper.repairFinApBillDatas((DynamicObject[])entities);
        logger.info("FinApBillSaveOp.beginOperationTransaction repairFinApBillDatas end");
        logger.info("FinApBillSaveOp.beginOperationTransaction premiumSaveDispose start");
        DynamicObject[] premiumBills = (DynamicObject[])Stream.of(entities).filter(entity -> entity.getBoolean("ispremium") && !entity.getBoolean("iswrittenoff")).toArray(DynamicObject[]::new);
        this.premiumSaveDispose(premiumBills);
        logger.info("FinApBillSaveOp.beginOperationTransaction premiumSaveDispose end");
        logger.info("FinApBillSaveOp.beginOperationTransaction end");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinApBillSaveOp.endOperationTransaction start");
        for (DynamicObject bill2 : entities) {
            if (!ObjectUtils.isEmpty((Object)bill2.getString("billno")) || !bill2.getBoolean("istanspay") && !bill2.getBoolean("ispremium")) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u672a\u6309\u8981\u6c42\u586b\u5199\u201c\u5355\u636e\u7f16\u53f7\u201d\u4e14\u672a\u627e\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillSaveOp_5", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        logger.info("FinApBillSaveOp.endOperationTransaction expense start");
        ApExpenseCostService exService = new ApExpenseCostService();
        Map expenseFiledMap = exService.ExpenseIdsByBotp(e.getDataEntities());
        if (expenseFiledMap != null && expenseFiledMap.size() > 0) {
            this.saveExpenseFiled(e.getDataEntities(), expenseFiledMap);
        }
        logger.info("FinApBillSaveOp.endOperationTransaction expense end");
        List<DynamicObject> writeOffBills = Stream.of(entities).filter(entity -> entity.getBoolean("iswrittenoff")).collect(Collectors.toList());
        writeOffBills = writeOffBills.stream().filter(bill -> !this.writeOffBillPks.contains(bill.getLong("id"))).collect(Collectors.toList());
        if (writeOffBills.size() == 0) {
            return;
        }
        logger.info("FinApBillSaveOp.endOperationTransaction addWriteOffCtrl start");
        this.addWriteOffCtrl(writeOffBills);
        logger.info("FinApBillSaveOp.endOperationTransaction addWriteOffCtrl end");
        logger.info("FinApBillSaveOp.endOperationTransaction settle start");
        this.executeSettle(writeOffBills);
        logger.info("FinApBillSaveOp.endOperationTransaction settle end");
        logger.info("FinApBillSaveOp.endOperationTransaction updateSettleStatusZeroBills start");
        this.updateSettleStatusZeroBills(writeOffBills);
        logger.info("FinApBillSaveOp.endOperationTransaction updateSettleStatusZeroBills start");
        logger.info("FinApBillSaveOp.endOperationTransaction writebackbus start");
        BusWoffHelper.finWriteOffWriteBackBusForSave((boolean)false, writeOffBills);
        logger.info("FinApBillSaveOp.endOperationTransaction writebackbus end");
        logger.info("FinApBillSaveOp.endOperationTransaction writeBackSrcBillWrittenStatus start");
        this.writeBackSrcBillWrittenStatus(writeOffBills);
        logger.info("FinApBillSaveOp.endOperationTransaction writeBackSrcBillWrittenStatus start");
        logger.info("FinApBillSaveOp.endOperationTransaction invalidBill start");
        this.invalidBill(writeOffBills.toArray(new DynamicObject[0]));
        logger.info("FinApBillSaveOp.endOperationTransaction invalidBill end");
        logger.info("FinApBillSaveOp.endOperationTransaction writeBackScmcBill start");
        ArApProcessParamsHelper.writeBackScmcBill((DynamicObject[])writeOffBills.toArray(new DynamicObject[0]), (boolean)true);
        logger.info("FinApBillSaveOp.endOperationTransaction writeBackScmcBill end");
        logger.info("FinApBillSaveOp.endOperationTransaction delInvEntrys start");
        this.delInvEntrys(writeOffBills.toArray(new DynamicObject[0]));
        logger.info("FinApBillSaveOp.endOperationTransaction delInvEntrys end");
        logger.info("FinApBillSaveOp.endOperationTransaction verify start");
        this.executeVerify(writeOffBills);
        logger.info("FinApBillSaveOp.endOperationTransaction verify end");
        logger.info("FinApBillSaveOp.endOperationTransaction end");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        logger.info("FinApBillSaveOp.afterExecuteOperationTransaction start");
        logger.info("FinApBillSaveOp.afterExecuteOperationTransaction recordTaxLog start");
        TaxHelper.recordTaxLog((DynamicObject[])datas, (boolean)false);
        logger.info("FinApBillSaveOp.afterExecuteOperationTransaction recordTaxLog end");
        DynamicObject[] writeOffBills = (DynamicObject[])Stream.of(datas).filter(data -> !this.writeOffBillPks.contains(data.getLong("id"))).toArray(DynamicObject[]::new);
        logger.info("FinApBillSaveOp.afterExecuteOperationTransaction executeWriteOffBillSubmitAndAudit start");
        this.executeWriteOffBillSubmitAndAudit(writeOffBills);
        logger.info("FinApBillSaveOp.afterExecuteOperationTransaction executeWriteOffBillSubmitAndAudit end");
        logger.info("FinApBillSaveOp.afterExecuteOperationTransaction end");
    }

    private void addWriteOffCtrl(List<DynamicObject> writeOffBills) {
        DynamicObject[] srcBills;
        HashSet<Long> srcBillIds = new HashSet<Long>(writeOffBills.size());
        for (DynamicObject writeOffBill : writeOffBills) {
            srcBillIds.add(writeOffBill.getLong("sourcebillid"));
        }
        ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_finapbill", (String)ConcuCtrlBizEnum.WRITEOFF.getValue(), srcBillIds, (boolean)false);
        for (DynamicObject srcBill : srcBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)})) {
            if (!srcBill.getBoolean("hadwrittenoff")) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u5355\u5df2\u7ecf\u88ab\u51b2\u9500\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillSaveOp_3", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }

    private void premiumSaveDispose(DynamicObject[] finBills) {
        List<DynamicObject> noSavedPremiumBills = this.getNoSavedPremiumBills(finBills);
        if (noSavedPremiumBills.isEmpty()) {
            return;
        }
        ArrayList<Long> premiumSourceBillIds = new ArrayList<Long>(noSavedPremiumBills.size());
        for (DynamicObject bill : noSavedPremiumBills) {
            premiumSourceBillIds.add(bill.getLong("sourcebillid"));
        }
        QFilter[] sourceBillFilters = new QFilter[]{new QFilter("id", "in", premiumSourceBillIds)};
        List selectors = FinApBillHandleHelper.getLockWBSelector();
        selectors.add("creator");
        selectors.add("billno");
        DynamicObject[] sourceFinBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", selectors), (QFilter[])sourceBillFilters);
        HashMap<Object, DynamicObject> sourceFinBillsMap = new HashMap<Object, DynamicObject>(sourceFinBills.length);
        for (DynamicObject finBill : sourceFinBills) {
            sourceFinBillsMap.put(finBill.getPkValue(), finBill);
        }
        for (DynamicObject premiumBill : noSavedPremiumBills) {
            Long sourceBillId = premiumBill.getLong("sourcebillid");
            DynamicObject sourceFinBill = (DynamicObject)sourceFinBillsMap.get(sourceBillId);
            Object srcCreator = sourceFinBill.get("creator");
            premiumBill.set("creator", srcCreator);
            premiumBill.set("modifier", srcCreator);
            PremiumWBFinBillServiceHelper.saveWriteBack((DynamicObject)sourceFinBill, (DynamicObject)premiumBill);
            String billno = sourceFinBill.getString("billno");
            DynamicObjectCollection entryCol = sourceFinBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject entryInfo : entryCol) {
                BigDecimal price = entryInfo.getBigDecimal("e_pricetaxtotal");
                BigDecimal lockedAmt = entryInfo.getBigDecimal("lockedamt");
                if ((price.compareTo(BigDecimal.ZERO) <= 0 || lockedAmt.compareTo(price) <= 0) && (price.compareTo(BigDecimal.ZERO) >= 0 || lockedAmt.compareTo(price) >= 0)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u5e94\u4ed8\u5355\u8d28\u4fdd\u91d1\u91d1\u989d\u8d85\u8fc7\u5355\u636e\u7684\u672a\u9501\u5b9a\u91d1\u989d\uff0c\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5355\u636e\u4fe1\u606f\u3002", (String)"FinApBillSaveOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billno));
            }
        }
        SaveServiceHelper.save((DynamicObject[])sourceFinBills);
    }

    private List<DynamicObject> getNoSavedPremiumBills(DynamicObject[] finBills) {
        ArrayList<Object> premiumBillIds = new ArrayList<Object>(1);
        ArrayList<DynamicObject> premiumBills = new ArrayList<DynamicObject>(1);
        for (DynamicObject bill2 : finBills) {
            if (!bill2.getBoolean("ispremium")) continue;
            premiumBills.add(bill2);
            Object pkValue = bill2.getPkValue();
            if (EmptyUtils.isEmpty((Object)pkValue)) continue;
            premiumBillIds.add(pkValue);
        }
        if (!premiumBillIds.isEmpty()) {
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", premiumBillIds)};
            DynamicObjectCollection savedPremiumBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id", (QFilter[])filters);
            Set savedPremiumBillIds = savedPremiumBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toSet());
            Iterator iterator = premiumBills.iterator();
            while (iterator.hasNext()) {
                DynamicObject premiumBill = (DynamicObject)iterator.next();
                Long billId = premiumBill.getLong("id");
                if (!savedPremiumBillIds.contains(billId)) continue;
                iterator.remove();
            }
        }
        return premiumBills;
    }

    private void executeSettle(List<DynamicObject> writeOffBills) {
        AbstractSettleTemplate service = SettleServiceFactory.getService((String)SettleRelationEnum.APWRITEOFF.getValue());
        JournalService journalService = new JournalService();
        for (DynamicObject writeOffBill : writeOffBills) {
            long srcBillID = writeOffBill.getLong("sourcebillid");
            Date bookDate = writeOffBill.getDate("bookdate");
            try {
                WriteOffUnSettleService unSettleService = new WriteOffUnSettleService(Long.valueOf(srcBillID), bookDate, false);
                unSettleService.unSettle();
            }
            catch (KDBizException e1) {
                String message = e1.getMessage();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u7ea2\u51b2\u5931\u8d25\uff1a%s", (String)"FinApBillSaveOp_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), message));
            }
            DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)srcBillID, (String)"ap_finapbill");
            DynamicObject[] mainRows = new DynamicObject[]{srcBill};
            DynamicObject[] asstRows = new DynamicObject[]{writeOffBill};
            SettleSchemeVO scheme = new SettleSchemeVO();
            int settleParam = ArApHelper.getApSettleParam((Object)srcBill.getLong("org.id"));
            if (settleParam == 1) {
                scheme.setOnlyByBotp(true);
            }
            service.settle(mainRows, asstRows, scheme, SettleTypeEnum.AUTO.getValue());
            journalService.pushAndSaveJournals(new DynamicObject[]{writeOffBill});
            List finPrems = FinapPremHelper.gettargetFinPrem((DynamicObject)srcBill);
            if (finPrems == null || finPrems.size() <= 0) continue;
            for (DynamicObject finPrem : finPrems) {
                DynamicObject[] writeFin = BOTPHelper.push((String)"ap_finapbill", (String)"ap_finapbill", (String)"520819751337865216", (DynamicObject)finPrem, (String)ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u51b2\u9500\u5931\u8d25\u3002", (String)"FinApBillSaveOp_2", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                if (writeFin.length <= 0) continue;
                OperationResult saveReault = OperationServiceHelper.executeOperate((String)"save", (String)"ap_finapbill", (DynamicObject[])writeFin, (OperateOption)OperateOption.create());
                OperationHelper.assertResult((OperationResult)saveReault);
            }
        }
    }

    private void executeVerify(List<DynamicObject> writeOffBills) {
        ApWrittenOffVerifyService verifyService = new ApWrittenOffVerifyService();
        for (DynamicObject writeOffBill : writeOffBills) {
            String billEntityKey = writeOffBill.getDataEntityType().getName();
            long srcBillID = writeOffBill.getLong("sourcebillid");
            String billType = writeOffBill.getString("billtypeid.number");
            if (VerifyServiceHelper.getExcludeBillTypeNum().contains(billType)) continue;
            RedVerifyRecordParam redVerifyRecordParam = new RedVerifyRecordParam();
            redVerifyRecordParam.setRemark(writeOffBill.getString("remark"));
            redVerifyRecordParam.setBillId(writeOffBill.getLong("id"));
            ArrayList<Long> orgIds = new ArrayList<Long>(1);
            orgIds.add(writeOffBill.getLong("org.id"));
            redVerifyRecordParam.setOrgIds(orgIds);
            redVerifyRecordParam.setSourcebillId(srcBillID);
            redVerifyRecordParam.setBookDate(writeOffBill.getDate("bookdate"));
            redVerifyRecordParam.setBizDate(writeOffBill.getDate("bizdate"));
            List<Long> verifyRecordIds = this.getVerifyRecordIds(srcBillID);
            if (verifyRecordIds.size() > 0) {
                this.newVerify(redVerifyRecordParam, verifyRecordIds);
                continue;
            }
            verifyService.finGenerateRedVerifyRecord(redVerifyRecordParam, billEntityKey);
            verifyService.finWrittenOffVerify(redVerifyRecordParam, billEntityKey, false);
        }
    }

    private void writeBackSrcBillWrittenStatus(List<DynamicObject> writeOffBills) {
        HashSet<Long> hadWrittenOffBillIds = new HashSet<Long>(writeOffBills.size());
        for (DynamicObject writeOffBill : writeOffBills) {
            hadWrittenOffBillIds.add(writeOffBill.getLong("sourcebillid"));
        }
        if (EmptyUtils.isNotEmpty(hadWrittenOffBillIds)) {
            DynamicObject[] hadWrittenOffBills;
            for (DynamicObject hadWrittenOffBill : hadWrittenOffBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", hadWrittenOffBillIds)})) {
                hadWrittenOffBill.set("hadwrittenoff", (Object)Boolean.TRUE);
            }
            SaveServiceHelper.save((DynamicObject[])hadWrittenOffBills);
        }
    }

    private void writeOffBillSetAuditStatus(DynamicObject[] entities) {
        Long curUserPk = RequestContext.get().getCurrUserId();
        DynamicObject curUser = BusinessDataServiceHelper.loadSingleFromCache((Object)curUserPk, (String)"bos_user");
        Date curDate = new Date();
        for (DynamicObject bill : entities) {
            if (!bill.getBoolean("iswrittenoff")) continue;
            bill.set("billstatus", (Object)"C");
            bill.set("auditor", (Object)curUser);
            bill.set("auditdate", (Object)curDate);
        }
    }

    private void newVerify(RedVerifyRecordParam redVerifyRecordParam, List<Long> verifyRecordIds) {
        HashMap<String, Object> schemaMap = new HashMap<String, Object>(2);
        schemaMap.put("recordType", "cal_purwfrecord");
        schemaMap.put("recordPk", verifyRecordIds);
        schemaMap.put("caBillType", "ap_finapbill");
        schemaMap.put("bookDate", redVerifyRecordParam.getBookDate());
        schemaMap.put("bizDate", redVerifyRecordParam.getBizDate());
        schemaMap.put("remark", redVerifyRecordParam.getRemark());
        HashMap<Long, Long> caBillIdMapping = new HashMap<Long, Long>(2);
        caBillIdMapping.put(redVerifyRecordParam.getSourcebillId(), redVerifyRecordParam.getBillId());
        schemaMap.put("caBillIdMapping", caBillIdMapping);
        long uniqueKey = DB.genGlobalLongId();
        schemaMap.put("uniquekey", uniqueKey);
        CommonParam param = new CommonParam();
        param.put((Object)"schemamap", schemaMap);
        ECServiceHelper.beginAndRegister((String)"ap_writtenoff", (String)"", (String)"mpscmm", (String)"mscommon", (String)"ChargeAgainstRecordImpl", (Param)param, (String)"");
    }

    private void appendAmt(DynamicObject[] datas) {
        if (this.isAppendEntryRows()) {
            for (DynamicObject data : datas) {
                if (!data.getBoolean("iswrittenoff")) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u51b2\u9500\u7684\u8f6c\u6362\u89c4\u5219\u4e0d\u5141\u8bb8\u6253\u5f00\u201c\u4e0b\u63a8\u81ea\u52a8\u4fdd\u5b58\u201d\u6309\u94ae\u3002\u5982\u679c\u6e90\u5355\u7269\u6599\u884c\u5206\u5f55\u7684\u5927\u5c0f\u8d85\u8fc7\u5e73\u53f0\u9650\u5236\u768420000\u884c\u5206\u5f55\u8bf7\u53c2\u8003\u793e\u533a\u6587\u6863\uff0c\u91c7\u7528\u540e\u53f0\u51b2\u9500\u7684\u65b9\u5f0f\u5904\u7406:https://vip.kingdee.com/knowledge/specialDetail/223800781941044992?category=433217318319929600&id=464213782940848384&productLineId=2", (String)"FinApBillSaveOp_4", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean isAppendEntryRows() {
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        return "true".equals(isAppend);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void appendHeadAmt(DynamicObject[] datas) {
        try {
            lock.lock();
            for (DynamicObject data : datas) {
                String amtJson = (String)ConfigCache.get((String)"appendentryrows", (String)data.getString("id"), String.class);
                Map<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>(16);
                if (amtJson != null) {
                    amtMap = (Map)SerializationUtils.fromJsonString((String)amtJson, Map.class);
                    for (String filedKey : this.filedKeys) {
                        data.set(filedKey, (Object)data.getBigDecimal(filedKey).add(amtMap.getOrDefault(filedKey, BigDecimal.ZERO)));
                    }
                }
                this.buildAmtMap(amtMap, data);
                ConfigCache.put((String)"appendentryrows", (String)data.getString("id"), (Object)SerializationUtils.toJsonString(amtMap));
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Deprecated
    private void appendPlanAmt(DynamicObject[] datas) {
        String selector = "settlementtype,basecurrency,currency,exchangerate,paycond,pricetaxtotal,duedate,termsdate,pricetaxtotalbase,planentity.seq,planentity.planpricetax,planentity.unplanlockamt,planentity.unplansettleamt,planentity.planpricetaxloc,planentity.unplansettlelocamt,planentity.planduedate,planentity.plansettletype,planentity.e_freezestate";
        List ids = Stream.of(datas).map(data -> data.getLong("id")).collect(Collectors.toList());
        DynamicObject[] dbFinApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (dbFinApBills.length == 0) {
            return;
        }
        HashMap<Long, DynamicObject> dbFinApMap = new HashMap<Long, DynamicObject>(dbFinApBills.length);
        for (DynamicObject dbFinApBill : dbFinApBills) {
            dbFinApMap.put(dbFinApBill.getLong("id"), dbFinApBill);
        }
        FinPlanRowService planRowService = new FinPlanRowService();
        for (DynamicObject finApBill : datas) {
            Date planMaxDuedate = null;
            int baseprecision = finApBill.getInt("basecurrency.amtprecision");
            int amtprecision = finApBill.getInt("currency.amtprecision");
            Date termsDate = finApBill.getDate("termsdate");
            if (termsDate == null) {
                termsDate = planRowService.getTermsDate(finApBill);
                finApBill.set("termsdate", (Object)termsDate);
            }
            List planRows = planRowService.calculatePlanRows(finApBill, termsDate);
            DynamicObject settlementType = finApBill.getDynamicObject("settlementtype");
            BigDecimal amt = BigDecimal.ZERO;
            BigDecimal amtLoc = BigDecimal.ZERO;
            BigDecimal rate = finApBill.getBigDecimal("exchangerate");
            DynamicObjectCollection planEntryDatas = finApBill.getDynamicObjectCollection("planentity");
            DynamicObjectCollection dbPlanEntryDatas = ((DynamicObject)dbFinApMap.get(finApBill.getLong("id"))).getDynamicObjectCollection("planentity");
            planEntryDatas.clear();
            for (int i = 0; i < planRows.size(); ++i) {
                DynamicObject planEntry = new DynamicObject(planEntryDatas.getDynamicObjectType());
                PlanRow planRow = (PlanRow)planRows.get(i);
                DynamicObject dbPlanRow = (DynamicObject)dbPlanEntryDatas.get(i);
                Date palnDuedate = planRow.getDueDate();
                BigDecimal planAmt = planRow.getPlanAmt().setScale(amtprecision, RoundingMode.HALF_UP);
                BigDecimal planAmtLoc = planAmt.multiply(rate).setScale(baseprecision, RoundingMode.HALF_UP);
                amt = amt.add(planAmt.setScale(amtprecision, RoundingMode.HALF_UP));
                amtLoc = amtLoc.add(planAmtLoc.setScale(baseprecision, RoundingMode.HALF_UP));
                if (i == planRows.size() - 1) {
                    BigDecimal priceLoc;
                    BigDecimal price;
                    BigDecimal pricetaxtotal = finApBill.getBigDecimal("pricetaxtotal");
                    BigDecimal pricetaxtotalbase = finApBill.getBigDecimal("pricetaxtotalbase");
                    if (amt.compareTo(pricetaxtotal) > 0) {
                        price = amt.subtract(pricetaxtotal);
                        planAmt = planAmt.subtract(price);
                    } else if (amt.compareTo(pricetaxtotal) < 0) {
                        price = pricetaxtotal.subtract(amt);
                        planAmt = planAmt.add(price);
                    }
                    if (amtLoc.compareTo(pricetaxtotalbase) > 0) {
                        priceLoc = amtLoc.subtract(pricetaxtotalbase);
                        planAmtLoc = planAmtLoc.subtract(priceLoc);
                    } else if (amtLoc.compareTo(pricetaxtotalbase) < 0) {
                        priceLoc = pricetaxtotalbase.subtract(amtLoc);
                        planAmtLoc = planAmtLoc.add(priceLoc);
                    }
                }
                planEntry.set("id", (Object)dbPlanRow.getLong("id"));
                planEntry.set("seq", (Object)(i + 1));
                planEntry.set("planpricetax", (Object)planAmt);
                planEntry.set("unplanlockamt", (Object)planAmt);
                planEntry.set("unplansettleamt", (Object)planAmt);
                planEntry.set("planpricetaxloc", (Object)planAmtLoc);
                planEntry.set("unplansettlelocamt", (Object)planAmtLoc);
                planEntry.set("planduedate", (Object)palnDuedate);
                planEntry.set("plansettletype", (Object)settlementType);
                planEntry.set("e_freezestate", (Object)"unfreeze");
                if (planMaxDuedate == null) {
                    planMaxDuedate = palnDuedate;
                } else if (palnDuedate != null) {
                    planMaxDuedate = palnDuedate.after(planMaxDuedate) ? palnDuedate : planMaxDuedate;
                }
                planEntryDatas.add((Object)planEntry);
            }
            if (finApBill.getDate("duedate") == null && planMaxDuedate != null) {
                finApBill.set("duedate", planMaxDuedate);
            }
            dbPlanEntryDatas.clear();
        }
        SaveServiceHelper.save((DynamicObject[])dbFinApBills);
    }

    private void buildAmtMap(Map<String, BigDecimal> amtMap, DynamicObject data) {
        for (String filedKey : this.filedKeys) {
            amtMap.put(filedKey, data.getBigDecimal(filedKey));
        }
    }

    private List<Long> getVerifyRecordIds(Long id) {
        ArrayList<Long> verifyRecordIds = new ArrayList<Long>(2);
        QFilter asstFilter = new QFilter("entry.e_billid", "in", (Object)id);
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)"ap_finapbill", (Object[])new Long[]{id}, (boolean)false);
        asstFilter.and(commonFilter);
        DataSet recordAssts = QueryServiceHelper.queryDataSet((String)"queryVR4Asst", (String)"ap_verifyrecord", (String)"id,writeofftypeid", (QFilter[])new QFilter[]{asstFilter}, null);
        for (Row record : recordAssts) {
            Long writeoffTypeId = record.getLong("writeofftypeid");
            if (writeoffTypeId == null || writeoffTypeId == 0L) continue;
            verifyRecordIds.add(record.getLong("id"));
        }
        return verifyRecordIds;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        HashSet<String> props = new HashSet<String>(50);
        props.add("iswrittenoff");
        props.add("hadwrittenoff");
        props.add("sourcebillid");
        props.add("sourcebilltype");
        props.add("isadjust");
        props.add("istanspay");
        props.add("pricetaxtotal");
        props.add("payproperty");
        props.add("ispremium");
        props.add("billno");
        props.add("bookdate");
        props.add("quotation");
        props.add("asstacttype");
        props.add("biztype");
        props.add("material");
        props.add("billsrctype");
        props.add("org");
        props.add("configuredcode");
        props.add("bizdate");
        props.add("asstact");
        props.add("billtypeid");
        props.add("detailentry.corebillid");
        props.add("detailentry.corebillentryid");
        props.add("detailentry.corebilltype");
        props.add("detailentry.e_baseunitqty");
        props.add("detailentry.e_pricetaxtotal");
        props.add("detailentry.e_conbillentity");
        props.add("detailentry.e_conbillid");
        props.add("detailentry.e_conbillentryid");
        props.add("detailentry.lockedamt");
        props.add("detailentry.unlockamt");
        props.add("detailentry.quantity");
        props.add("detailentry.e_verifybaseqty");
        props.add("detailentry.verifyquantity");
        props.add("detailentry.unverifyquantity");
        props.add("planentity.planduedate");
        props.add("preentry.y_billid");
        props.add("preentry.y_date");
        props.add("remark");
        props.add("detailentry.material");
        props.add("detailentry.measureunit");
        props.add("detailentry.e_unitconvertrate");
        props.add("detailentry.configuredcode");
        props.add("isperiod");
        props.add("isincludetax");
        props.add("detailentry.discountmode");
        props.add("detailentry.discountrate");
        props.add("detailentry.pricetax");
        props.add("detailentry.price");
        props.add("duedate");
        props.add("planentity.planpricetax");
        props.add("planentity.planlockedamt");
        props.add("planentity.unplanlockamt");
        props.add("planentity.plansettledamt");
        props.add("planentity.unplansettleamt");
        props.add("e_amountbase");
        props.add("basecurrency");
        props.add("istaxdeduction");
        props.add("e_pricetaxtotalbase");
        props.add("curdeductibleamt");
        props.add("intercostamt");
        props.add("e_unallocatedamt");
        props.add("deductiblerate");
        props.add("payeebanknum");
        props.add("bebank");
        props.add("settlementtype");
        props.add("e_farmproducts");
        props.add("splitscheme");
        props.add("e_taxlocalamt");
        props.add("taxrate");
        props.add("detailentry.ispresent");
        props.add("invoicebiztype");
        props.add("relationpay");
        props.add("e_taxdiffamt");
        props.add("e_amountdiffamt");
        props.add("e_pricetaxdiffamt");
        props.add("unsettleamt");
        props.add("settledamt");
        props.add("settleamount");
        props.add("unsettleamount");
        props.add("amountbase");
        props.add("taxlocamt");
        props.add("pricetaxtotalbase");
        props.add("unsettleamountbase");
        props.add("adjustlocalamt");
        props.add("tax");
        props.add("amount");
        props.add("adjustamount");
        props.add("e_tax");
        props.add("discountamount");
        props.add("discountlocalamt");
        props.add("e_amount");
        props.add("unsettleamtbase");
        props.add("e_adjustamount");
        props.add("e_adjustlocalamt");
        props.add("planpricetaxloc");
        props.add("unplansettlelocamt");
        props.add("unverifyamount");
        props.add("p_sourcebillid");
        props.add("p_sourcebillentryid");
        props.add("settleversion");
        props.add("preentry.seq");
        props.add("haspaperticket");
        props.add("planentity.plancorebillid");
        props.add("planentity.p_splitdimensionid");
        props.add("planentity.seq");
        props.add("paycond");
        props.add("entry.e_splitdimensionid");
        props.addAll(FinApBillHandleHelper.getSelector());
        props.addAll(PlanSplitSchemeServiceHelper.getNeedProperties((boolean)false));
        fieldKeys.addAll(props);
    }

    private void executeWriteOffBillSubmitAndAudit(DynamicObject[] entities) {
        ArrayList<Long> writeOffBillIds = new ArrayList<Long>(16);
        for (DynamicObject entity : entities) {
            boolean isWriteOff = entity.getBoolean("iswrittenoff");
            if (!isWriteOff) continue;
            writeOffBillIds.add(entity.getLong("id"));
        }
        if (EmptyUtils.isEmpty(writeOffBillIds)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"nochecksubmit", (String)"ap_finapbill", (Object[])writeOffBillIds.toArray(new Object[0]), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)submitResult);
        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"nocheckaudit", (String)"ap_finapbill", (Object[])writeOffBillIds.toArray(new Object[0]), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)auditResult);
        Boolean isSuccess = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)this.billEntityType.getName(), (String)"nocheckaudit", writeOffBillIds, (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.INSERTWRITE);
        logger.info("Voucher Insert White List result: " + isSuccess);
    }

    private void invalidBill(DynamicObject[] dataEntities) {
        Object[] pkIds = Arrays.stream(dataEntities).filter(entity -> entity.getBoolean("iswrittenoff")).map(entity -> Long.valueOf(entity.getString("sourcebillid"))).toArray();
        if (EmptyUtils.isEmpty((Object)pkIds)) {
            return;
        }
        ValidOperationServiceHelper.invalid((String)"ap_finapbill", (Object[])pkIds);
    }

    private void removeSubEntry(DynamicObject[] entities) {
        Map paramMap = this.getOption().getVariables();
        String isAppend = (String)paramMap.get("bos_save_appendentryrows");
        if ("true".equals(isAppend)) {
            for (DynamicObject data : entities) {
                DynamicObjectCollection entryList = data.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entryList) {
                    Optional<IDataEntityProperty> findFirst = entry.getDataEntityType().getProperties().stream().filter(p -> "subentryentity".equals(p.getName())).findFirst();
                    if (!findFirst.isPresent()) continue;
                    entry.getDynamicObjectCollection("subentryentity").clear();
                }
            }
        }
    }

    private void setImptSuppliers(DynamicObject[] entities) {
        List sipplierBills = Arrays.stream(entities).filter(s -> ("1".equals(s.getString("billsrctype")) || "3".equals(s.getString("billsrctype"))) && "bd_supplier".equals(s.getString("asstacttype"))).collect(Collectors.toList());
        if (sipplierBills.size() > 0) {
            FinApBillHelper.setImptsuppliers(sipplierBills, (String)"detailentry");
        }
    }

    private void splitPlanEntryForImport(DynamicObject[] entities) {
        String billSrctype = entities[0].getString("billsrctype");
        if (BillSrcTypeEnum.IMPORT.getValue().equals(billSrctype) && this.isSplitPlanEntry()) {
            this.splitPlanEntry(entities);
        }
    }

    private void setAsstactInfoForImport(DynamicObject[] entities) {
        String billSrctype = entities[0].getString("billsrctype");
        if (BillSrcTypeEnum.IMPORT.getValue().equals(billSrctype)) {
            AsstactInfoImportHelper.setAsstactInfo4ApBill((DynamicObject[])entities);
        }
    }

    private void splitPlanEntry(DynamicObject[] datas) {
        ArrayList<DynamicObject> needSplitDatas = new ArrayList<DynamicObject>(8);
        ArrayList<Long> splitSchemeIds = new ArrayList<Long>(8);
        ArrayList<DynamicObject> needMatchSplitDatas = new ArrayList<DynamicObject>(8);
        for (DynamicObject data : datas) {
            if ("C".equals(data.getString("billstatus"))) continue;
            if (data.getDynamicObject("splitscheme") != null) {
                splitSchemeIds.add(data.getDynamicObject("splitscheme").getLong("id"));
                needSplitDatas.add(data);
                continue;
            }
            needMatchSplitDatas.add(data);
        }
        DynamicObject[] schemes = PlanSplitSchemeServiceHelper.getSchemesBySchemeIds((String)this.billEntityType.getName(), splitSchemeIds);
        HashMap<Long, DynamicObject> schemeMap = new HashMap<Long, DynamicObject>(schemes.length);
        for (DynamicObject scheme : schemes) {
            schemeMap.put(scheme.getLong("id"), scheme);
        }
        for (DynamicObject needSplitData : needSplitDatas) {
            PlanSplitAndBuilder.splitAndBuild((DynamicObject)needSplitData, (DynamicObject)((DynamicObject)schemeMap.get(needSplitData.getDynamicObject("splitscheme").getLong("id"))));
        }
        PlanSplitAndBuilder.splitAndBuildByApi((DynamicObject[])needMatchSplitDatas.toArray(new DynamicObject[0]));
    }

    private boolean isSplitPlanEntry() {
        String isSplitPlanEntry = StdConfig.get((String)"isSplitPlanEntry");
        return isSplitPlanEntry == null || "true".equals(isSplitPlanEntry);
    }

    private void delInvEntrys(DynamicObject[] writeOffBills) {
        ArrayList<Long> srcBillSet = new ArrayList<Long>(8);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        for (DynamicObject offBill : writeOffBills) {
            srcBillSet.add(offBill.getLong("sourcebillid"));
            orgIds.add(offBill.getLong("org.id"));
        }
        HashMap<Long, Set> bill4InvoiceMap = new HashMap<Long, Set>(16);
        DynamicObjectCollection srcFinApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,inventry.invid,inventry.i_srctype", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillSet)});
        for (Object srcFinApBill : srcFinApBills) {
            long billId = srcFinApBill.getLong("id");
            Set deleteInvoiceIds = bill4InvoiceMap.getOrDefault(billId, new HashSet(8));
            if (!InvoiceSrcTypeEnum.BYINVOICE.getValue().equals(srcFinApBill.getString("inventry.i_srctype"))) {
                deleteInvoiceIds.add(srcFinApBill.getLong("inventry.invid"));
            }
            bill4InvoiceMap.put(billId, deleteInvoiceIds);
        }
        DynamicObjectCollection premiumFinApBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,inventry.invid,inventry.i_srctype", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", srcBillSet).and("ispremium", "=", (Object)Boolean.TRUE)});
        for (DynamicObject premiumFinApBill : premiumFinApBills) {
            long billId = premiumFinApBill.getLong("id");
            Set deleteInvoiceIds = bill4InvoiceMap.getOrDefault(billId, new HashSet(8));
            if (!InvoiceSrcTypeEnum.BYINVOICE.getValue().equals(premiumFinApBill.getString("inventry.i_srctype"))) {
                deleteInvoiceIds.add(premiumFinApBill.getLong("inventry.invid"));
            }
            bill4InvoiceMap.put(billId, deleteInvoiceIds);
        }
        if (bill4InvoiceMap.isEmpty()) {
            return;
        }
        HashSet<Long> canDeleteRowIds = new HashSet<Long>(16);
        HashSet allInvoiceIds = new HashSet(8);
        bill4InvoiceMap.forEach((key, value) -> allInvoiceIds.addAll(value));
        QFilter filter = new QFilter("id", "in", allInvoiceIds);
        DynamicObjectCollection invoices = QueryServiceHelper.query((String)"ap_invoice", (String)"id,invoicestatus", (QFilter[])new QFilter[]{filter});
        for (DynamicObject invoice : invoices) {
            String invoiceStatus = invoice.getString("invoicestatus");
            if (!"0".equals(invoiceStatus) && !"".equals(invoiceStatus)) continue;
            canDeleteRowIds.add(invoice.getLong("id"));
        }
        Iterator iterator = bill4InvoiceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            Set deleteInvIds = (Set)next.getValue();
            deleteInvIds.removeIf(invId -> !canDeleteRowIds.contains(invId));
            if (!deleteInvIds.isEmpty()) continue;
            iterator.remove();
        }
        logger.info("FinApBillSaveOp delInvEntrys bill4InvoiceMap is : " + bill4InvoiceMap);
        if (!bill4InvoiceMap.isEmpty()) {
            InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
            deleteParam.setBill4InvoiceMap(bill4InvoiceMap).setBillClose(true).setOperateKey(String.valueOf(this.operateMeta.get("key"))).setAppId((String)this.getOption().getVariables().get("appnumber"));
            IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.FINAPDELETEINVROW.getValue());
            deleteService.deleteInvoiceRow(deleteParam);
        }
        srcBillSet.removeIf(bill4InvoiceMap::containsKey);
        if (!srcBillSet.isEmpty()) {
            QFilter filter1 = new QFilter("org", "in", orgIds);
            filter1.and("writeofftypeid", "=", (Object)1893666267970144256L);
            DataSet recordAsMainDataSet = QueryServiceHelper.queryDataSet((String)"query_match_record", (String)"ap_matchrecord_verify", (String)"id", (QFilter[])new QFilter[]{filter1, new QFilter("entry.billid", "in", srcBillSet)}, (String)"");
            DataSet recordAsAssDataSet = QueryServiceHelper.queryDataSet((String)"query_match_record", (String)"ap_matchrecord_verify", (String)"id", (QFilter[])new QFilter[]{filter1, new QFilter("entry.assbillid", "in", srcBillSet)}, (String)"");
            DataSet recordDataSet = recordAsMainDataSet.union(recordAsAssDataSet).distinct();
            ArrayList<Long> recordIds = new ArrayList<Long>(8);
            for (Row row : recordDataSet) {
                recordIds.add(row.getLong("id"));
            }
            logger.info("FinApBillSaveOp delInvEntrys recordIds is : " + recordIds);
            if (!recordIds.isEmpty()) {
                IInvoiceArticulateService articulateService = (IInvoiceArticulateService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.INVOICEARTICULATEFINAP.getValue());
                articulateService.unArticulate(recordIds);
            }
        }
    }

    private void putUnallocatedAmt(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (!dataEntity.getBoolean("iswrittenoff")) continue;
            DynamicObjectCollection detailentries = dataEntity.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : detailentries) {
                BigDecimal interCostAmt = entry.getBigDecimal("intercostamt");
                if (BigDecimal.ZERO.compareTo(interCostAmt) == 0) {
                    entry.set("e_unallocatedamt", (Object)entry.getBigDecimal("e_amountbase"));
                    continue;
                }
                entry.set("e_unallocatedamt", (Object)interCostAmt);
            }
        }
    }

    private void saveExpenseFiled(DynamicObject[] entities, Map<Long, String> expenseFiledMap) {
        DynamicObject[] apBills;
        Set billIdSet = Arrays.stream(entities).map(t -> t.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject apBill : apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"detailentry.e_expensebillids_tag,detailentry.material", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)})) {
            DynamicObjectCollection entrys = apBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entrys) {
                entry.set("e_expensebillids_tag", (Object)expenseFiledMap.get(entry.getLong("id")));
            }
        }
        SaveServiceHelper.save((DynamicObject[])apBills);
    }

    private void updateSettleStatusZeroBills(List<DynamicObject> writeOffBills) {
        DynamicObject[] noSettleBills;
        HashMap<Long, Integer> orgMap = new HashMap<Long, Integer>(4);
        List writeOffBillIds = writeOffBills.stream().map(temp -> temp.getLong("id")).collect(Collectors.toList());
        for (DynamicObject bill : noSettleBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"org,pricetaxtotal,settleversion,settlestatus,e_pricetaxtotal,planpricetax,planpricetaxloc,unplanlockamt,planlockedamt,unplansettleamt,plansettledamt,unplansettlelocamt,plansettledlocamt", (QFilter[])new QFilter[]{new QFilter("id", "in", writeOffBillIds), new QFilter("settlestatus", "=", (Object)"unsettle")})) {
            if (!this.checkAmt4Settled(bill, orgMap)) continue;
            bill.set("settlestatus", (Object)APSettleStatusEnum.SETTLED.getValue());
            DynamicObjectCollection planEntries = bill.getDynamicObjectCollection("planentity");
            for (DynamicObject planEntry : planEntries) {
                BigDecimal planPricetax = planEntry.getBigDecimal("planpricetax");
                BigDecimal planPricetaxLoc = planEntry.getBigDecimal("planpricetaxloc");
                planEntry.set("unplanlockamt", (Object)BigDecimal.ZERO);
                planEntry.set("planlockedamt", (Object)planPricetax);
                planEntry.set("unplansettleamt", (Object)BigDecimal.ZERO);
                planEntry.set("plansettledamt", (Object)planPricetax);
                planEntry.set("unplansettlelocamt", (Object)BigDecimal.ZERO);
                planEntry.set("plansettledlocamt", (Object)planPricetaxLoc);
            }
        }
        SaveServiceHelper.save((DynamicObject[])noSettleBills);
    }

    private boolean checkAmt4Settled(DynamicObject entity, Map<Long, Integer> orgMap) {
        boolean isSettled;
        block4: {
            block5: {
                if (BigDecimal.ZERO.compareTo(entity.getBigDecimal("pricetaxtotal")) != 0) {
                    return false;
                }
                isSettled = true;
                Long orgPk = entity.getDynamicObject("org").getLong("id");
                Integer param = orgMap.get(orgPk);
                if (ObjectUtils.isEmpty((Object)param)) {
                    param = ArApHelper.getApSettleParam((Object)orgPk);
                    orgMap.put(orgPk, param);
                }
                if (1 != param) break block5;
                DynamicObjectCollection entries = entity.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entries) {
                    if (BigDecimal.ZERO.compareTo(entry.getBigDecimal("e_pricetaxtotal")) == 0) continue;
                    isSettled = false;
                    break block4;
                }
                break block4;
            }
            boolean isOldVersion = SettleVersionServiceHelper.isOldVersion((DynamicObject)entity);
            if (isOldVersion) break block4;
            DynamicObjectCollection planEntries = entity.getDynamicObjectCollection("planentity");
            for (DynamicObject planEntry : planEntries) {
                if (BigDecimal.ZERO.compareTo(planEntry.getBigDecimal("planpricetax")) == 0) continue;
                isSettled = false;
            }
        }
        return isSettled;
    }
}

