/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.fi.ap.mservice.ApExpenseCostService;
import kd.fi.ap.mservice.ApPaySettleService;
import kd.fi.ap.mservice.api.service.ApSettleRecordService;
import kd.fi.ap.mservice.helper.SettleServiceHelper;
import kd.fi.ap.validator.BillToleranceValidator;
import kd.fi.ap.validator.FinApAdjustValidator;
import kd.fi.ap.validator.FinApBillSubmitAmountValidator;
import kd.fi.ap.validator.FinApBillSubmitValidator;
import kd.fi.ap.validator.FinApConBillValidator;
import kd.fi.ap.validator.FinApSubmitPremiumValidator;
import kd.fi.ap.validator.FinPaymentSecuritySubmitCtrlService;
import kd.fi.ap.validator.SupplierPayHoldValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.business.price.FXPriceLocalCalculator;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.helper.ApFarmTaxAmtHelper;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApRecOrPayBillHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.helper.TaxHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.opplugin.BillAppStatusValidator;
import kd.fi.arapcommon.opplugin.FinBillCheckAmtValidator;
import kd.fi.arapcommon.opplugin.FinBillPreInfoValidator;
import kd.fi.arapcommon.opplugin.MustInputValidator;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.service.helper.TxSettleServiceHelper;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;
import kd.fi.arapcommon.service.plan.split.entity.DimensionMapping;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitMappingServiceHelper;
import kd.fi.arapcommon.service.plan.split.helper.PlanSplitSchemeServiceHelper;
import kd.fi.arapcommon.service.writeback.helper.FinApExitPremiumWBServiceHelper;
import kd.fi.arapcommon.util.AllocationUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.BillPriceValidator;
import kd.fi.arapcommon.validator.FarmTaxValidator;
import kd.fi.arapcommon.validator.MtoValidator;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class FinApBillSubmitOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(FinApBillSubmitOp.class);
    private static final int rowCountOneBatch = 2000;

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FinApBillSubmitValidator());
        e.addValidator((AbstractValidator)new BillAppStatusValidator());
        e.addValidator((AbstractValidator)new MustInputValidator());
        e.addValidator((AbstractValidator)new FinBillCheckAmtValidator(false));
        e.addValidator((AbstractValidator)new FinApSubmitPremiumValidator());
        if (SystemParameterHelper.isForceValidateAmt()) {
            e.getValidators().add(new FinApBillSubmitAmountValidator());
        }
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new MtoValidator());
        e.addValidator((AbstractValidator)new FinApAdjustValidator());
        e.addValidator((AbstractValidator)new FarmTaxValidator());
        e.addValidator((AbstractValidator)new FinBillPreInfoValidator(false));
        e.addValidator((AbstractValidator)new SupplierPayHoldValidator());
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        ArApHelper.sortPlanDueDate((DynamicObject[])datas);
        ArApRecOrPayBillHelper.removeEmptyPreEntry((DynamicObject[])datas);
        ArApRecOrPayBillHelper.sortPreEntryByDate((DynamicObject[])datas);
        BookDateHelper.setBookDate((DynamicObject[])datas, (boolean)false);
        this.setAdjustType(datas);
        for (DynamicObject data : datas) {
            if (StringUtils.isEmpty((String)data.getString("billsrctype")) && StringUtils.isNotEmpty((String)data.getString("sourcebilltype"))) {
                data.set("billsrctype", (Object)BillSrcTypeEnum.AUTO.getValue());
            }
            String asstactType = data.getString("asstacttype");
            DynamicObject recAsstact = data.getDynamicObject("receivingsupplierid");
            if (recAsstact != null || !"bd_supplier".equals(asstactType)) continue;
            DynamicObject asstact = data.getDynamicObject("asstact");
            data.set("receivingsupplierid", (Object)asstact);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        logger.info("FinApBillSubmitOp.beginOperationTransaction start");
        this.repairFinApData(dataEntities);
        AllocationUtils.calculateAndSetAllocDifference((DynamicObject[])dataEntities);
        ArApRecOrPayBillHelper.updateHistoryPreEntrySettleAmt((DynamicObject[])dataEntities);
        this.coordinateFromFinAr(dataEntities);
        ApFarmTaxAmtHelper.setFinDecuAmt((DynamicObject[])dataEntities);
        this.putUnallocatedAmt(dataEntities);
        logger.info("FinApBillSubmitOp.beginOperationTransaction end");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        logger.info("FinApBillSubmitOp.endOperationTransaction start");
        this.submitAutoSettle(dataEntities);
        this.updateInvoiceTexDeduction(dataEntities);
        BillToleranceValidator.finApTaxValidator(dataEntities);
        BillToleranceValidator.busQtyAndAmtValidator(dataEntities);
        ApExpenseCostService exService = new ApExpenseCostService();
        Map expenseFiledMap = exService.ExpenseIdsByBotp(e.getDataEntities());
        if (expenseFiledMap != null && expenseFiledMap.size() > 0) {
            this.saveExpenseFiled(e.getDataEntities(), expenseFiledMap);
        }
        BillToleranceValidator.coreBillPriceValidator(dataEntities);
        try (TraceSpan span = Tracer.create((String)"paymentsecurity", (String)"beginOperationTransaction");){
            FinPaymentSecuritySubmitCtrlService service = new FinPaymentSecuritySubmitCtrlService();
            service.execute(dataEntities);
        }
        FinApConBillValidator validator = new FinApConBillValidator();
        validator.validate(dataEntities);
        logger.info("FinApBillSubmitOp.endOperationTransaction end");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        TaxHelper.recordTaxLog((DynamicObject[])e.getDataEntities(), (boolean)false);
        this.removeCache(e.getDataEntities());
    }

    private void putUnallocatedAmt(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection detailentries = dataEntity.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : detailentries) {
                BigDecimal interCostAmt = entry.getBigDecimal("intercostamt");
                if (BigDecimal.ZERO.compareTo(interCostAmt) == 0) {
                    entry.set("e_unallocatedamt", (Object)entry.getBigDecimal("e_amountbase"));
                    continue;
                }
                entry.set("e_unallocatedamt", (Object)interCostAmt);
            }
        }
    }

    private void repairFinApData(DynamicObject[] dataEntities) {
        logger.info("FinApBillSubmitOp.repairFinApData start");
        ArApHelper.baseUnitQtyCorrection((DynamicObject[])dataEntities, (String)"ap_finapbill");
        ArApDataRepairHelper.repairFinApBillDatas((DynamicObject[])dataEntities);
        this.locAmountFieldCorrection(dataEntities);
        this.compensateSrcBillIdField(dataEntities);
        logger.info("FinApBillSubmitOp.repairFinApData end");
    }

    private void compensateSrcBillIdField(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (ObjectUtils.isEmpty((Object)dataEntity.getString("sourcebilltype"))) continue;
            DynamicObjectCollection detailEntry = dataEntity.getDynamicObjectCollection("detailentry");
            for (DynamicObject detail : detailEntry) {
                try {
                    detail.set("e_srcbillid", (Object)Long.parseLong(detail.getString("e_sourcebillid")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    detail.set("e_srcbillentryid", (Object)Long.parseLong(detail.getString("e_sourcebillentryid")));
                }
                catch (Exception exception) {}
            }
        }
    }

    private void setAdjustType(DynamicObject[] datas) {
        for (DynamicObject data : datas) {
            BigDecimal priceTaxToTAL = data.getBigDecimal("pricetaxtotal");
            DynamicObject billtye = data.getDynamicObject("billtypeid");
            String adjusttype = data.getString("adjusttype");
            if (!"ApFin_borr_BT_S".equals(billtye.getString("number")) || !StringUtils.isEmpty((String)adjusttype)) continue;
            if (priceTaxToTAL.compareTo(BigDecimal.ZERO) > 0) {
                data.set("adjusttype", (Object)"overdue");
                continue;
            }
            if (priceTaxToTAL.compareTo(BigDecimal.ZERO) < 0) {
                data.set("adjusttype", (Object)"buckle");
                continue;
            }
            data.set("adjusttype", (Object)"adjustinv");
        }
    }

    private void coordinateFromFinAr(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> coordinateFinAps = new ArrayList<DynamicObject>(2);
        HashSet<Long> srcFinArIds = new HashSet<Long>(2);
        for (DynamicObject finBill : dataEntities) {
            String srcType = finBill.getString("sourcebilltype");
            boolean isCoordinate = finBill.getBoolean("relationpay");
            if (!isCoordinate || !"ar_finarbill".equals(srcType)) continue;
            DynamicObjectCollection entrys = finBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entrys) {
                long sourceBillId = entry.getLong("e_srcbillid");
                if (sourceBillId == 0L) continue;
                srcFinArIds.add(sourceBillId);
            }
            coordinateFinAps.add(finBill);
        }
        if (srcFinArIds.isEmpty()) {
            return;
        }
        DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,amount,localamt,tax,taxlocamt,recamount,reclocalamt,entry.id,entry.e_amount,entry.e_localamt,entry.e_tax,entry.e_taxlocalamt,entry.e_recamount,entry.e_reclocalamt", (QFilter[])new QFilter[]{new QFilter("id", "in", srcFinArIds)});
        Map<Long, List<DynamicObject>> srcFinArMap = finArBills.stream().collect(Collectors.groupingBy(v -> v.getLong("id")));
        for (DynamicObject finBill : coordinateFinAps) {
            Long sourceBillId = finBill.getLong("sourcebillid");
            List<DynamicObject> finArBillList = srcFinArMap.get(sourceBillId);
            if (finArBillList == null) continue;
            DynamicObjectCollection entrys = finBill.getDynamicObjectCollection("detailentry");
            BigDecimal exchangeRate = finBill.getBigDecimal("exchangerate");
            String quotation = finBill.getString("quotation");
            int localCurrencyPrecison = finBill.getInt("basecurrency.amtprecision");
            BigDecimal localAmt = BigDecimal.ZERO;
            BigDecimal taxLocAmt = BigDecimal.ZERO;
            BigDecimal priceTaxtotalBase = BigDecimal.ZERO;
            BigDecimal amtSum = BigDecimal.ZERO;
            BigDecimal taxSum = BigDecimal.ZERO;
            BigDecimal pricetaxtotalSum = BigDecimal.ZERO;
            boolean isTax = finBill.getBoolean("isincludetax");
            for (DynamicObject entry : entrys) {
                Long srcEntryId = Long.valueOf(entry.getString("e_sourcebillentryid"));
                for (DynamicObject finArEntry : finArBills) {
                    Long entryId = finArEntry.getLong("entry.id");
                    if (!srcEntryId.equals(entryId)) continue;
                    BigDecimal e_amount = finArEntry.getBigDecimal("entry.e_amount");
                    BigDecimal e_tax = finArEntry.getBigDecimal("entry.e_tax");
                    BigDecimal e_pricetaxtotal = finArEntry.getBigDecimal("entry.e_recamount");
                    entry.set("e_amount", (Object)e_amount);
                    amtSum = amtSum.add(e_amount);
                    entry.set("e_tax", (Object)e_tax);
                    taxSum = taxSum.add(e_tax);
                    entry.set("e_pricetaxtotal", (Object)e_pricetaxtotal);
                    pricetaxtotalSum = pricetaxtotalSum.add(e_pricetaxtotal);
                    entry.set("unsettleamt", (Object)e_pricetaxtotal);
                    entry.set("e_unverifyamount", (Object)e_amount);
                    entry.set("unlockamt", (Object)e_pricetaxtotal);
                    BigDecimal discountamount = entry.getBigDecimal("discountamount");
                    BigDecimal eAdjustamount = entry.getBigDecimal("e_adjustamount");
                    FXPriceLocalCalculator calculator = new FXPriceLocalCalculator(isTax, e_tax, e_amount, discountamount, exchangeRate, localCurrencyPrecison, eAdjustamount, quotation);
                    calculator.calculate();
                    entry.set("e_amountbase", (Object)calculator.getAmountLocal());
                    entry.set("e_taxlocalamt", (Object)calculator.getTaxLocal());
                    entry.set("e_pricetaxtotalbase", (Object)calculator.getPriceTaxTotalLocal());
                    entry.set("unsettleamtbase", (Object)calculator.getPriceTaxTotalLocal());
                    localAmt = localAmt.add(calculator.getAmountLocal());
                    taxLocAmt = taxLocAmt.add(calculator.getTaxLocal());
                    priceTaxtotalBase = priceTaxtotalBase.add(calculator.getPriceTaxTotalLocal());
                }
            }
            finBill.set("amountbase", (Object)localAmt);
            finBill.set("taxlocamt", (Object)taxLocAmt);
            finBill.set("pricetaxtotalbase", (Object)priceTaxtotalBase);
            finBill.set("unsettleamountbase", (Object)priceTaxtotalBase);
            finBill.set("amount", (Object)amtSum);
            finBill.set("tax", (Object)taxSum);
            finBill.set("pricetaxtotal", (Object)pricetaxtotalSum);
            finBill.set("unsettleamount", (Object)pricetaxtotalSum);
            finBill.set("unverifyamount", (Object)amtSum);
            boolean isexpensealloc = finBill.getBoolean("isexpensealloc");
            if (!isexpensealloc) continue;
            boolean allocatebyper = finBill.getBoolean("allocatebyper");
            if (allocatebyper) {
                AllocationUtils.executeCalculation((BigDecimal)finArBillList.get(0).getBigDecimal("amount"), (BigDecimal)finArBillList.get(0).getBigDecimal("localamt"), (DynamicObject)finBill);
                continue;
            }
            AllocationUtils.executeCalculation((BigDecimal)finArBillList.get(0).getBigDecimal("recamount"), (BigDecimal)finArBillList.get(0).getBigDecimal("reclocalamt"), (DynamicObject)finBill);
        }
        PlanSplitAndBuilder.splitAndBuild((DynamicObject[])coordinateFinAps.toArray(new DynamicObject[0]));
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        HashSet<String> props = new HashSet<String>(50);
        props.add("e_srcbillentryid");
        props.add("e_srcbillid");
        props.add("billtypeid");
        props.add("sourcebilltype");
        props.add("sourcebillid");
        props.add("pricetaxtotal");
        props.add("isvoucher");
        props.add("detailentry.material");
        props.add("detailentry.measureunit");
        props.add("detailentry.expenseitem");
        props.add("detailentry.e_pricetaxtotal");
        props.add("planentity.planduedate");
        props.add("planentity.seq");
        props.add("planentity.planpricetax");
        props.add("bizdate");
        props.add("biztype");
        props.add("isperiod");
        props.add("duedate");
        props.add("imageno");
        props.add("creator");
        props.add("modifier");
        props.add("createtime");
        props.add("modifytime");
        props.add("isexpensealloc");
        props.add("iswholealloc");
        props.add("a_allocationper");
        props.add("a_allocationamt");
        props.add("a_localamt");
        props.add("allocationentry");
        props.add("allocatebyper");
        props.add("amount");
        props.add("basecurrency");
        props.add("currency");
        props.add("detailentry");
        props.add("billsrctype");
        props.add("isincludetax");
        props.add("price");
        props.add("actprice");
        props.add("pricetax");
        props.add("quantity");
        props.add("e_tax");
        props.add("e_amount");
        props.add("discountamount");
        props.add("ispresent");
        props.add("relationpay");
        props.add("asstacttype");
        props.add("asstact");
        props.add("amountbase");
        props.add("exratetable");
        props.add("e_costcenter");
        props.add("e_taxdiffamt");
        props.add("e_amountdiffamt");
        props.add("e_pricetaxdiffamt");
        props.add("e_pricetaxbase");
        props.add("e_unverifyamount");
        props.add("e_uninvoicedamt");
        props.add("e_invoicedamt");
        props.add("e_unallocatedamt");
        props.add("unverifyamount");
        props.add("uninvoicedamt");
        props.add("unlockamt");
        props.add("i_tax");
        props.add("i_amount");
        props.add("i_pricetaxtotal");
        props.add("unplanlockamt");
        props.add("e_sourcebillid");
        props.add("settlementtype");
        props.add("planentity.plansettletype");
        props.add("planentity.e_freezestate");
        props.add("preentry.seq");
        props.add("y_billid");
        props.add("y_settleamt");
        props.add("y_billtype");
        props.add("y_amount");
        props.add("y_billno");
        props.add("y_date");
        props.add("y_billentryid");
        props.add("quotation");
        props.add("isadjust");
        props.add("e_unverifybaseqty");
        if (SystemParameterHelper.isForceValidateAmt()) {
            List<String> requiredFields = FinApBillSubmitAmountValidator.getRequiredFields();
            props.addAll(requiredFields);
        }
        props.add("payproperty");
        props.add("linetype");
        props.add("bookdate");
        props.add("ispremium");
        props.add("premiumamt");
        props.add("billno");
        props.add("detailentry.seq");
        props.add("adjusttype");
        props.add("configuredcode");
        props.add("tracknumber");
        props.add("corebillno");
        props.add("corebillid");
        props.add("corebillentryseq");
        props.add("corebillentryid");
        props.add("iswrittenoff");
        props.add("e_amountbase");
        props.add("basecurrency");
        props.add("istaxdeduction");
        props.add("e_pricetaxtotalbase");
        props.add("taxlocamt");
        props.add("tax");
        props.add("pricetaxtotalbase");
        props.add("unsettleamountbase");
        props.add("unsettleamount");
        props.add("adjustlocalamt");
        props.add("adjustamount");
        props.add("e_taxlocalamt");
        props.add("discountlocalamt");
        props.add("unsettleamtbase");
        props.add("unsettleamt");
        props.add("e_adjustlocalamt");
        props.add("e_adjustamount");
        props.add("planpricetaxloc");
        props.add("unplansettlelocamt");
        props.add("unplansettleamt");
        props.add("e_unitconvertrate");
        props.add("e_baseunitqty");
        props.add("e_baseunit");
        props.add("quantity");
        props.add("e_measureunit");
        props.add("curdeductibleamt");
        props.add("intercostamt");
        props.add("deductiblerate");
        props.add("istanspay");
        props.add("e_farmproducts");
        props.add("paycond");
        props.add("project");
        props.add("e_contract");
        props.add("splitscheme");
        props.add("planmaterial");
        props.add("planexpenseitem");
        props.add("plancorebillno");
        props.add("planproject");
        props.add("plancontract");
        props.add("plancostcenter");
        props.add("receivingsupplierid");
        props.add("exchangerate");
        props.add("taxrate");
        props.add("invoicebiztype");
        props.add("relationpay");
        props.add("e_sourcebillentryid");
        props.add("e_splitdimensionid");
        props.add("p_payrate");
        props.add("p_splitdimensionid");
        fieldKeys.add("lockedamt");
        fieldKeys.add("settledamt");
        fieldKeys.add("settleamount");
        fieldKeys.add("verifyquantity");
        fieldKeys.add("e_verifybaseqty");
        fieldKeys.add("verifyamount");
        fieldKeys.add("unverifyquantity");
        fieldKeys.add("planlockedamt");
        fieldKeys.add("unplanlockamt");
        fieldKeys.add("plansettledamt");
        fieldKeys.add("unplansettleamt");
        fieldKeys.add("org");
        fieldKeys.add("iswrittenoff");
        fieldKeys.add("e_expensebillids");
        fieldKeys.add("e_expensebillids_tag");
        fieldKeys.add("inventry.invid");
        fieldKeys.add("corebilltype");
        fieldKeys.add("isincludetax");
        fieldKeys.add("discountmode");
        fieldKeys.add("discountrate");
        fieldKeys.add("e_conbillid");
        List dimensionMappings = PlanSplitMappingServiceHelper.getDimensionMappings((boolean)false);
        for (DimensionMapping dimensionMapping : dimensionMappings) {
            props.add(dimensionMapping.getDetailEntryKey());
            props.add(dimensionMapping.getPlanEntryKey());
        }
        props.addAll(PlanSplitSchemeServiceHelper.getNeedProperties((boolean)false));
        props.addAll(FinApBillHandleHelper.getSelector());
        fieldKeys.addAll(props);
    }

    private void locAmountFieldCorrection(DynamicObject[] entities) {
        for (DynamicObject bill : entities) {
            BigDecimal rate = bill.getBigDecimal("exchangerate");
            if (rate.compareTo(BigDecimal.ONE) != 0) continue;
            bill.set("amountbase", (Object)bill.getBigDecimal("amount"));
            bill.set("taxlocamt", (Object)bill.getBigDecimal("tax"));
            bill.set("pricetaxtotalbase", (Object)bill.getBigDecimal("pricetaxtotal"));
            bill.set("unsettleamountbase", (Object)bill.getBigDecimal("unsettleamount"));
            bill.set("adjustlocalamt", (Object)bill.getBigDecimal("adjustamount"));
            for (DynamicObject entry : bill.getDynamicObjectCollection("detailentry")) {
                entry.set("e_taxlocalamt", (Object)entry.getBigDecimal("e_tax"));
                entry.set("discountlocalamt", (Object)entry.getBigDecimal("discountamount"));
                entry.set("e_amountbase", (Object)entry.getBigDecimal("e_amount"));
                entry.set("e_pricetaxtotalbase", (Object)entry.getBigDecimal("e_pricetaxtotal"));
                entry.set("unsettleamtbase", (Object)entry.getBigDecimal("unsettleamt"));
                entry.set("e_adjustlocalamt", (Object)entry.getBigDecimal("e_adjustamount"));
            }
            for (DynamicObject entry : bill.getDynamicObjectCollection("planentity")) {
                entry.set("planpricetaxloc", (Object)entry.getBigDecimal("planpricetax"));
                entry.set("unplansettlelocamt", (Object)entry.getBigDecimal("unplansettleamt"));
            }
        }
    }

    private void removeCache(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (2000 >= dataEntity.getDynamicObjectCollection("detailentry").size()) continue;
            ConfigCache.remove((String)"appendentryrows", (String)dataEntity.getString("id"));
        }
    }

    private void submitAutoSettle(DynamicObject[] dataEntities) {
        Map<Long, List<DynamicObject>> dataMap = Arrays.stream(dataEntities).collect(Collectors.groupingBy(data -> data.getLong("org.id")));
        ArrayList<DynamicObject> submitSettleDatas = null;
        for (Map.Entry<Long, List<DynamicObject>> entry : dataMap.entrySet()) {
            long orgId = entry.getKey();
            boolean submitSettle = SystemParameterHelper.getAPBooleanParam((long)orgId, (String)"ap_016");
            if (!submitSettle) continue;
            List<DynamicObject> value = entry.getValue();
            if (submitSettleDatas == null) {
                submitSettleDatas = new ArrayList<DynamicObject>(value.size());
            }
            submitSettleDatas.addAll(value);
        }
        if (submitSettleDatas != null && !submitSettleDatas.isEmpty()) {
            String settleModel;
            BigDecimal disposeAmount;
            ArrayList<Long> existHasPremiumBillIds;
            ArrayList<DynamicObject> needSettleBillList = new ArrayList<DynamicObject>(submitSettleDatas.size());
            ArrayList<DynamicObject> settleByPreEntryBillList = new ArrayList<DynamicObject>(submitSettleDatas.size());
            ArrayList<DynamicObject> settleByCoreBillBillList = new ArrayList<DynamicObject>(submitSettleDatas.size());
            ArrayList<DynamicObject> settleByConbillnumberBillList = new ArrayList<DynamicObject>(submitSettleDatas.size());
            List orgIds = submitSettleDatas.stream().map(bill -> bill.getLong("org.id")).distinct().collect(Collectors.toList());
            Map appParametersMap = SystemParameterHelper.batchGetAppParameters((Boolean)Boolean.FALSE, orgIds, (String[])new String[]{"ap_019", "ap_003"});
            for (DynamicObject dynamicObject : submitSettleDatas) {
                long l = dynamicObject.getLong("org.id");
                Map orgParametersMap = (Map)appParametersMap.get(l);
                boolean isPeriod = dynamicObject.getBoolean("isperiod");
                DynamicObjectCollection preEntries = dynamicObject.getDynamicObjectCollection("preentry");
                boolean isNeedSettle = false;
                if (!ObjectUtils.isEmpty((Object)preEntries)) {
                    settleByPreEntryBillList.add(dynamicObject);
                    isNeedSettle = true;
                }
                DynamicObjectCollection detailEntries = dynamicObject.getDynamicObjectCollection("detailentry");
                for (DynamicObject detailEntry : detailEntries) {
                    String corebillno = detailEntry.getString("corebillno");
                    if (!StringUtils.isNotEmpty((String)corebillno) || isPeriod || orgParametersMap == null || !((Boolean)orgParametersMap.get("ap_019")).booleanValue()) continue;
                    settleByCoreBillBillList.add(dynamicObject);
                    isNeedSettle = true;
                    break;
                }
                for (DynamicObject detailEntry : detailEntries) {
                    String conbillnumber = detailEntry.getString("e_conbillnumber");
                    if (!StringUtils.isNotEmpty((String)conbillnumber) || isPeriod || orgParametersMap == null || !((Boolean)orgParametersMap.get("ap_019")).booleanValue()) continue;
                    settleByConbillnumberBillList.add(dynamicObject);
                    isNeedSettle = true;
                    break;
                }
                if (!isNeedSettle) continue;
                needSettleBillList.add(dynamicObject);
            }
            if (!needSettleBillList.isEmpty()) {
                existHasPremiumBillIds = new ArrayList<Long>(8);
                for (DynamicObject dynamicObject : needSettleBillList) {
                    BigDecimal disposeAmount2 = dynamicObject.getBigDecimal("premiumamt");
                    if (disposeAmount2.compareTo(BigDecimal.ZERO) == 0) continue;
                    existHasPremiumBillIds.add(dynamicObject.getLong("id"));
                }
                if (existHasPremiumBillIds.size() > 0) {
                    DynamicObject[] dynamicObjectArray;
                    for (DynamicObject finApBill : dynamicObjectArray = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", FinApBillHandleHelper.getLockWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", existHasPremiumBillIds)})) {
                        disposeAmount = finApBill.getBigDecimal("premiumamt");
                        FinApExitPremiumWBServiceHelper.occupy((DynamicObject)finApBill, (BigDecimal)disposeAmount);
                    }
                    SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
                }
            }
            if (!settleByPreEntryBillList.isEmpty()) {
                this.doSettleByPreEntry(settleByPreEntryBillList);
            }
            if (!settleByCoreBillBillList.isEmpty()) {
                HashMap<String, List> needCoreSettleByModelMap = new HashMap<String, List>(8);
                for (DynamicObject dynamicObject : settleByCoreBillBillList) {
                    long orgId = dynamicObject.getLong("org.id");
                    Map orgParametersMap = (Map)appParametersMap.get(orgId);
                    if (ObjectUtils.isEmpty((Object)orgParametersMap)) continue;
                    settleModel = (String)orgParametersMap.get("ap_003");
                    List tempFinApBills = needCoreSettleByModelMap.getOrDefault(settleModel, new ArrayList(64));
                    tempFinApBills.add(dynamicObject);
                    needCoreSettleByModelMap.put(settleModel, tempFinApBills);
                }
                Map map = SettleServiceHelper.getPaidBillIdsByCoreBill(settleByCoreBillBillList, (Map)appParametersMap);
                Map map2 = SettleServiceHelper.getPayBillIdsByCoreBill(settleByCoreBillBillList, (Map)appParametersMap);
                ApSettleRecordService apSettleRecordService = new ApSettleRecordService();
                for (Map.Entry entrySet : needCoreSettleByModelMap.entrySet()) {
                    SettleParam settleParam;
                    settleModel = (String)entrySet.getKey();
                    List finApBills = (List)entrySet.getValue();
                    Set apBillIds = finApBills.stream().map(apBill -> apBill.getLong("id")).collect(Collectors.toSet());
                    Set paidBillIds = (Set)map.get(settleModel);
                    Set payBillIds = (Set)map2.get(settleModel);
                    if (!ObjectUtils.isEmpty((Object)paidBillIds)) {
                        settleParam = new SettleParam();
                        settleParam.setMainBillIds(apBillIds).setAsstBillIds(paidBillIds).setAsstEntity("ap_paidbill").setOnlyByCoreBill(true);
                        apSettleRecordService.apPaySettle(settleParam);
                    }
                    if (ObjectUtils.isEmpty((Object)payBillIds)) continue;
                    CommonSettleServiceHelper.settleAddMutexCtrlInTX((Set)payBillIds, (String)"cas_paybill", (boolean)true);
                    TxSettleServiceHelper.validatePayBillIsExistUnfinishedTx(payBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                    settleParam = new SettleParam();
                    settleParam.setMainBillIds(apBillIds).setAsstBillIds(payBillIds).setOnlyByCoreBill(true);
                    apSettleRecordService.apPaySettle(settleParam);
                }
            }
            if (!settleByConbillnumberBillList.isEmpty()) {
                HashMap<String, List> needSettleByModelMap = new HashMap<String, List>(8);
                for (DynamicObject dynamicObject : settleByConbillnumberBillList) {
                    long orgId = dynamicObject.getLong("org.id");
                    Map orgParametersMap = (Map)appParametersMap.get(orgId);
                    if (ObjectUtils.isEmpty((Object)orgParametersMap)) continue;
                    settleModel = (String)orgParametersMap.get("ap_003");
                    List tempFinApBills = needSettleByModelMap.getOrDefault(settleModel, new ArrayList(64));
                    tempFinApBills.add(dynamicObject);
                    needSettleByModelMap.put(settleModel, tempFinApBills);
                }
                Map map = SettleServiceHelper.getPayBillIdsByConBill(settleByConbillnumberBillList, (Map)appParametersMap);
                ApSettleRecordService apSettleRecordService = new ApSettleRecordService();
                for (Map.Entry entrySet : needSettleByModelMap.entrySet()) {
                    String settleModel2 = (String)entrySet.getKey();
                    List finApBills = (List)entrySet.getValue();
                    Set apBillIds = finApBills.stream().map(apBill -> apBill.getLong("id")).collect(Collectors.toSet());
                    Set payBillIds = (Set)map.get(settleModel2);
                    if (ObjectUtils.isEmpty((Object)payBillIds)) continue;
                    CommonSettleServiceHelper.settleAddMutexCtrlInTX((Set)payBillIds, (String)"cas_paybill", (boolean)true);
                    TxSettleServiceHelper.validatePayBillIsExistUnfinishedTx(payBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                    SettleParam settleParam = new SettleParam();
                    settleParam.setMainBillIds(apBillIds).setAsstBillIds(payBillIds).setOnlyByConBill(true).setMainOp(true);
                    apSettleRecordService.apPaySettle(settleParam);
                }
            }
            if (!needSettleBillList.isEmpty()) {
                existHasPremiumBillIds = new ArrayList(8);
                for (DynamicObject dynamicObject : needSettleBillList) {
                    BigDecimal disposeAmount3 = dynamicObject.getBigDecimal("premiumamt");
                    if (disposeAmount3.compareTo(BigDecimal.ZERO) == 0) continue;
                    existHasPremiumBillIds.add(dynamicObject.getLong("id"));
                }
                if (existHasPremiumBillIds.size() > 0) {
                    DynamicObject[] dynamicObjectArray;
                    for (DynamicObject finApBill : dynamicObjectArray = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", FinApBillHandleHelper.getLockWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", existHasPremiumBillIds)})) {
                        disposeAmount = finApBill.getBigDecimal("premiumamt");
                        FinApExitPremiumWBServiceHelper.release((DynamicObject)finApBill, (BigDecimal)disposeAmount);
                    }
                    SaveServiceHelper.save((DynamicObject[])dynamicObjectArray);
                }
            }
        }
    }

    private void doSettleByPreEntry(List<DynamicObject> settleByPreEntryBillList) {
        Object[] paidArr;
        HashMap<String, HashSet<Long>> preInfoMap = new HashMap<String, HashSet<Long>>(settleByPreEntryBillList.size());
        for (DynamicObject bill : settleByPreEntryBillList) {
            DynamicObjectCollection preEntry = bill.getDynamicObjectCollection("preentry");
            for (DynamicObject row : preEntry) {
                long preBillId = row.getLong("y_billid");
                String preBillType = row.getString("y_billtype");
                BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                HashSet<Long> ids = (HashSet<Long>)preInfoMap.get(preBillType);
                if (ids == null) {
                    ids = new HashSet<Long>(2);
                }
                ids.add(preBillId);
                preInfoMap.put(preBillType, ids);
            }
        }
        HashMap<Long, Map<Long, BigDecimal>> asstUnsettleAmtMap = new HashMap<Long, Map<Long, BigDecimal>>(2);
        HashMap<Long, Map<Long, BigDecimal>> asstOrgAmtMap = new HashMap<Long, Map<Long, BigDecimal>>(2);
        Set payIds = (Set)preInfoMap.get("cas_paybill");
        Set paidIds = (Set)preInfoMap.get("ap_paidbill");
        Object[] payArr = this.payValidateBeforeSettle(payIds, asstUnsettleAmtMap, asstOrgAmtMap, settleByPreEntryBillList);
        Object[] payMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])payArr, (Object[])(paidArr = this.paidValidateBeforeSettle(paidIds, asstUnsettleAmtMap, asstOrgAmtMap, settleByPreEntryBillList)));
        if (ObjectUtils.isEmpty((Object[])payMergeArr)) {
            return;
        }
        List tempVOs = PayBillHandleHelper.getAsstListVO((DynamicObject[])payMergeArr);
        Map<Long, List<BillSettleVO>> entryIdVOMap = tempVOs.stream().collect(Collectors.groupingBy(BillSettleVO::getEntryId));
        if (!ObjectUtils.isEmpty(asstUnsettleAmtMap)) {
            Map<Long, List<DynamicObject>> collect = settleByPreEntryBillList.stream().collect(Collectors.groupingBy(finBill -> finBill.getLong("org.id")));
            Map orgSettleEntry = ArApHelper.batchGetApSettleParam(collect.keySet());
            for (Map.Entry<Long, List<DynamicObject>> entry : collect.entrySet()) {
                DynamicObject[] mainArr;
                Long orgId = entry.getKey();
                int settleEntry = (Integer)orgSettleEntry.get(orgId);
                SettleSchemeVO scheme = new SettleSchemeVO();
                scheme.setSettle(true);
                scheme.setSettleEntryParam(settleEntry);
                scheme.setMatchServiceClass("kd.fi.arapcommon.service.match.PreEntrySettleMatchService");
                ArrayList<BillSettleVO> asstListVO = new ArrayList<BillSettleVO>(1);
                for (DynamicObject finBill2 : settleByPreEntryBillList) {
                    BigDecimal canSettleAmt;
                    long asstId;
                    long id = finBill2.getLong("id");
                    String mainBillno = finBill2.getString("billno");
                    int rowIndex = 1;
                    boolean isMergeRows = ((DynamicObject)finBill2.getDynamicObjectCollection("preentry").get(0)).getLong("y_billentryid") != 0L ? Boolean.TRUE : Boolean.FALSE;
                    if (isMergeRows) {
                        for (DynamicObject row : finBill2.getDynamicObjectCollection("preentry")) {
                            asstId = row.getLong("y_billid");
                            long asstEntryId = row.getLong("y_billentryid");
                            String asstBillno = row.getString("y_billno");
                            BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                            if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                            canSettleAmt = (BigDecimal)((Map)asstUnsettleAmtMap.get(asstId)).get(asstEntryId);
                            if (canSettleAmt.abs().compareTo(settleAmt.abs()) < 0) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u7b2c%2$s\u884c\u5173\u8054\u7684\u9884\u4ed8\u6b3e\u5355%3$s\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApBillSubmitOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), mainBillno, rowIndex, asstBillno));
                            }
                            BillSettleVO tempVO = entryIdVOMap.get(asstEntryId).get(0);
                            BillSettleVO billSettleVO = (BillSettleVO)tempVO.clone();
                            billSettleVO.setEntryUnSettleAmt(settleAmt);
                            HashMap<String, Long> resultExtMap = new HashMap<String, Long>(1);
                            resultExtMap.put("billId", id);
                            resultExtMap.putAll(tempVO.getExtFields());
                            billSettleVO.setExtFields(resultExtMap);
                            asstListVO.add(billSettleVO);
                            ++rowIndex;
                            canSettleAmt = canSettleAmt.subtract(settleAmt);
                            ((Map)asstUnsettleAmtMap.get(asstId)).put(asstEntryId, canSettleAmt);
                            Map orgIdAmtMap = (Map)asstOrgAmtMap.get(asstId);
                            BigDecimal billCanSettleAmt = (BigDecimal)orgIdAmtMap.get(orgId);
                            orgIdAmtMap.put(orgId, billCanSettleAmt.subtract(settleAmt));
                            asstOrgAmtMap.put(asstId, orgIdAmtMap);
                        }
                        continue;
                    }
                    for (DynamicObject row : finBill2.getDynamicObjectCollection("preentry")) {
                        asstId = row.getLong("y_billid");
                        String asstBillno = row.getString("y_billno");
                        BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                        if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        Map entryIdAmtMap = (Map)asstUnsettleAmtMap.get(asstId);
                        Map orgIdAmtMap = (Map)asstOrgAmtMap.get(asstId);
                        canSettleAmt = (BigDecimal)orgIdAmtMap.get(orgId);
                        if (canSettleAmt.abs().compareTo(settleAmt.abs()) < 0) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u7b2c%2$s\u884c\u5173\u8054\u7684\u9884\u4ed8\u6b3e\u5355%3$s\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApBillSubmitOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), mainBillno, rowIndex, asstBillno));
                        }
                        for (Map.Entry entry2 : entryIdAmtMap.entrySet()) {
                            HashMap<String, Long> resultExtMap;
                            BillSettleVO newVO;
                            BigDecimal entryCanSettleAmt;
                            if (settleAmt.compareTo(BigDecimal.ZERO) == 0) break;
                            long entryId = (Long)entry2.getKey();
                            BillSettleVO tempVO = entryIdVOMap.get(entryId).get(0);
                            long entryOrgId = tempVO.getOrgId();
                            if (entryOrgId != orgId || (entryCanSettleAmt = (BigDecimal)entry2.getValue()).compareTo(BigDecimal.ZERO) == 0) continue;
                            if (settleAmt.abs().compareTo(entryCanSettleAmt.abs()) <= 0) {
                                newVO = (BillSettleVO)tempVO.clone();
                                newVO.setEntryUnSettleAmt(settleAmt);
                                resultExtMap = new HashMap<String, Long>(1);
                                resultExtMap.put("billId", id);
                                resultExtMap.putAll(tempVO.getExtFields());
                                newVO.setExtFields(resultExtMap);
                                asstListVO.add(newVO);
                                ++rowIndex;
                                orgIdAmtMap.put(orgId, canSettleAmt.subtract(settleAmt));
                                entryCanSettleAmt = entryCanSettleAmt.subtract(settleAmt);
                                settleAmt = BigDecimal.ZERO;
                                entry2.setValue(entryCanSettleAmt);
                                continue;
                            }
                            newVO = (BillSettleVO)tempVO.clone();
                            newVO.setEntryUnSettleAmt(entryCanSettleAmt);
                            resultExtMap = new HashMap(1);
                            resultExtMap.put("billId", id);
                            resultExtMap.putAll(tempVO.getExtFields());
                            newVO.setExtFields(resultExtMap);
                            asstListVO.add(newVO);
                            ++rowIndex;
                            orgIdAmtMap.put(orgId, BigDecimal.ZERO);
                            settleAmt = settleAmt.subtract((BigDecimal)entry2.getValue());
                            entry2.setValue(BigDecimal.ZERO);
                        }
                        asstOrgAmtMap.put(asstId, orgIdAmtMap);
                    }
                }
                if (ObjectUtils.isEmpty(asstListVO)) continue;
                Set mainBillIds = entry.getValue().stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
                for (DynamicObject obj : mainArr = FinApBillHandleHelper.load((QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)})) {
                    DynamicObjectCollection detailEntry = obj.getDynamicObjectCollection("detailentry");
                    for (DynamicObject row : detailEntry) {
                        row.set("settledamt", row.get("lockedamt"));
                        row.set("unsettleamt", row.get("unlockamt"));
                    }
                    DynamicObjectCollection planEntry = obj.getDynamicObjectCollection("planentity");
                    for (DynamicObject row : planEntry) {
                        row.set("plansettledamt", row.get("planlockedamt"));
                        row.set("unplansettleamt", row.get("unplanlockamt"));
                    }
                }
                List mainListVO = FinApBillHandleHelper.getMainListVO((DynamicObject[])mainArr, (SettleSchemeVO)scheme);
                for (BillSettleVO settleVO : mainListVO) {
                    Map extFields = settleVO.getExtFields();
                    extFields.put("billId", settleVO.getId());
                    settleVO.setExtFields(extFields);
                }
                ApPaySettleService service = new ApPaySettleService();
                service.settleByVO(mainListVO, asstListVO, scheme, SettleTypeEnum.AUTO.getValue());
            }
        }
    }

    private DynamicObject[] payValidateBeforeSettle(Set<Long> payIds, Map<Long, Map<Long, BigDecimal>> asstUnsettleAmtMap, Map<Long, Map<Long, BigDecimal>> asstOrgAmtMap, List<DynamicObject> settleByPreEntryBillList) {
        if (ObjectUtils.isEmpty(payIds)) {
            return null;
        }
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(payIds, (String)"cas_paybill", (boolean)true);
        TxSettleServiceHelper.validatePayBillIsExistUnfinishedTx(payIds.stream().map(String::valueOf).collect(Collectors.toList()));
        Object[] assts = PayBillHandleHelper.loadPay((QFilter[])new QFilter[]{new QFilter("id", "in", payIds)});
        HashSet<Long> asstIds = new HashSet<Long>(payIds.size());
        for (Object asst : assts) {
            long id = asst.getLong("id");
            HashMap<Long, BigDecimal> orgUnSettleAmtMap = new HashMap<Long, BigDecimal>(2);
            DynamicObjectCollection entry = asst.getDynamicObjectCollection("entry");
            LinkedHashMap<Long, BigDecimal> entryIdAmtMap = new LinkedHashMap<Long, BigDecimal>(1);
            for (DynamicObject row : entry) {
                DynamicObject paymentType = row.getDynamicObject("e_paymenttype");
                long entryOrgId = row.getLong("settleorg.id");
                if (ObjectUtils.isEmpty((Object)paymentType) || !paymentType.getBoolean("ispartpayment") || !"202".equals(paymentType.getString("biztype"))) continue;
                long entryId = row.getLong("id");
                BigDecimal unSettleAmt = row.getBigDecimal("e_unsettledamt");
                if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                entryIdAmtMap.put(entryId, unSettleAmt);
                BigDecimal orgUnSettleAmt = (BigDecimal)orgUnSettleAmtMap.get(entryOrgId);
                if (orgUnSettleAmt == null) {
                    orgUnSettleAmt = BigDecimal.ZERO;
                }
                orgUnSettleAmt = orgUnSettleAmt.add(unSettleAmt);
                orgUnSettleAmtMap.put(entryOrgId, orgUnSettleAmt);
            }
            asstUnsettleAmtMap.put(id, entryIdAmtMap);
            asstOrgAmtMap.put(id, orgUnSettleAmtMap);
            asstIds.add(id);
        }
        if (ObjectUtils.isEmpty((Object[])assts) || payIds.size() != assts.length) {
            for (DynamicObject finBill : settleByPreEntryBillList) {
                DynamicObjectCollection preEntry = finBill.getDynamicObjectCollection("preentry");
                for (DynamicObject row : preEntry) {
                    long preBillId = row.getLong("y_billid");
                    String preBillType = row.getString("y_billtype");
                    if (asstIds.contains(preBillId) || !"cas_paybill".equals(preBillType)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u6ca1\u6709\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u9884\u4ed8\u6b3e\u5355%2$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillSubmitOp_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), finBill.getString("billno"), row.getString("y_billno")));
                }
            }
        }
        return assts;
    }

    private DynamicObject[] paidValidateBeforeSettle(Set<Long> paidIds, Map<Long, Map<Long, BigDecimal>> asstUnsettleAmtMap, Map<Long, Map<Long, BigDecimal>> asstOrgAmtMap, List<DynamicObject> settleByPreEntryBillList) {
        if (ObjectUtils.isEmpty(paidIds)) {
            return null;
        }
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(paidIds, (String)"ap_paidbill", (boolean)true);
        Object[] assts = PayBillHandleHelper.loadPaid((QFilter[])new QFilter[]{new QFilter("id", "in", paidIds)});
        HashSet<Long> asstIds = new HashSet<Long>(paidIds.size());
        for (Object asst : assts) {
            long id = asst.getLong("id");
            DynamicObjectCollection entry = asst.getDynamicObjectCollection("entry");
            LinkedHashMap<Long, BigDecimal> entryIdAmtMap = new LinkedHashMap<Long, BigDecimal>(1);
            HashMap<Long, BigDecimal> orgUnSettleAmtMap = new HashMap<Long, BigDecimal>(2);
            BigDecimal orgUnSettleAmt = BigDecimal.ZERO;
            for (DynamicObject row : entry) {
                long entryId = row.getLong("id");
                BigDecimal unSettleAmt = row.getBigDecimal("e_unsettledamt");
                if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                entryIdAmtMap.put(entryId, unSettleAmt);
                orgUnSettleAmt = orgUnSettleAmt.add(unSettleAmt);
            }
            orgUnSettleAmtMap.put(asst.getLong("org.id"), orgUnSettleAmt);
            asstOrgAmtMap.put(id, orgUnSettleAmtMap);
            asstUnsettleAmtMap.put(id, entryIdAmtMap);
            asstIds.add(id);
        }
        if (ObjectUtils.isEmpty((Object[])assts) || paidIds.size() != assts.length) {
            for (DynamicObject finBill : settleByPreEntryBillList) {
                DynamicObjectCollection preEntry = finBill.getDynamicObjectCollection("preentry");
                for (DynamicObject row : preEntry) {
                    long preBillId = row.getLong("y_billid");
                    String preBillType = row.getString("y_billtype");
                    if (asstIds.contains(preBillId) || !"ap_paidbill".equals(preBillType)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u6ca1\u6709\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u9884\u4ed8\u6b3e\u5355%2$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillSubmitOp_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), finBill.getString("billno"), row.getString("y_billno")));
                }
            }
        }
        return assts;
    }

    private void updateInvoiceTexDeduction(DynamicObject[] entities) {
        List finApBillIds = Arrays.stream(entities).filter(bill -> !bill.getDynamicObjectCollection("inventry").isEmpty()).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        if (finApBillIds.isEmpty()) {
            return;
        }
        DynamicObject[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"billtypeid,istaxdeduction,inventry.invid,inventry.i_istaxdeduction,inventry.i_serialno", (QFilter[])new QFilter[]{new QFilter("id", "in", finApBillIds)});
        ArrayList<Long> invoiceIds = new ArrayList<Long>(64);
        for (DynamicObject finApBill : entities) {
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                long invid = invRow.getLong("invid");
                if (invid == 0L) continue;
                invoiceIds.add(invid);
            }
        }
        if (invoiceIds.isEmpty()) {
            return;
        }
        DynamicObject[] invoiceBills = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,istaxdeduction,serialno,invoiceno,invoicecode", (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        Map<Long, DynamicObject> invoiceMap = Arrays.stream(invoiceBills).collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        ArrayList<DynamicObject> needUpdateInvoices = new ArrayList<DynamicObject>(64);
        String ignoreTypes = StdConfig.get((String)"ignore.billTypes");
        for (DynamicObject finApBill : finApBills) {
            String billTypeNum = finApBill.getString("billtypeid.number");
            if (ignoreTypes != null && ignoreTypes.contains(billTypeNum)) continue;
            boolean isTaxDeduction = finApBill.getBoolean("istaxdeduction");
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                DynamicObject invoice = invoiceMap.get(invRow.getLong("invid"));
                if (invoice == null || isTaxDeduction == invoice.getBoolean("istaxdeduction")) continue;
                invoice.set("istaxdeduction", (Object)isTaxDeduction);
                needUpdateInvoices.add(invoice);
                invRow.set("i_istaxdeduction", (Object)isTaxDeduction);
            }
        }
        if (!needUpdateInvoices.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])needUpdateInvoices.toArray(new DynamicObject[0]));
            SaveServiceHelper.update((DynamicObject[])finApBills);
            this.updateTaxDeduction(needUpdateInvoices.toArray(new DynamicObject[0]));
        }
    }

    private void updateTaxDeduction(DynamicObject[] invoices) {
        if (ObjectUtils.isEmpty((Object[])invoices)) {
            return;
        }
        ArrayList<Object> invoiceIds = new ArrayList<Object>(64);
        ArrayList<String> invNoAndCodes = new ArrayList<String>(64);
        for (DynamicObject invoice : invoices) {
            if (ObjectUtils.isEmpty((Object)invoice.getString("serialno"))) continue;
            invoiceIds.add(invoice.getPkValue());
            invNoAndCodes.add(invoice.getString("invoiceno") + "_" + invoice.getString("invoicecode"));
        }
        logger.info("updateTaxDeduction updateTaxDeduction invoiceIds : " + invoiceIds);
        if (ObjectUtils.isEmpty(invoiceIds)) {
            return;
        }
        CommonParam param = new CommonParam();
        param.put((Object)"invoiceIds", invoiceIds);
        param.put((Object)"uniquekey", (Object)DB.genGlobalLongId());
        param.put((Object)"invNoAndCodes", invNoAndCodes);
        param.put((Object)"operate", (Object)"finapsubmit");
        ECServiceHelper.beginAndRegisterWithBusInfo((String)"ap_updatetaxdeduction", null, (String)"fi", (String)"ap", (String)"ApUpdateTaxDeductionECService", (Param)param, (String)"", invoiceIds);
    }

    private void saveExpenseFiled(DynamicObject[] entities, Map<Long, String> expenseFiledMap) {
        DynamicObject[] apBills;
        Set billIdSet = Arrays.stream(entities).map(t -> t.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject apBill : apBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"detailentry.e_expensebillids_tag,detailentry.material", (QFilter[])new QFilter[]{new QFilter("id", "in", billIdSet)})) {
            DynamicObjectCollection entrys = apBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject entry : entrys) {
                entry.set("e_expensebillids_tag", (Object)expenseFiledMap.get(entry.getLong("id")));
            }
        }
        SaveServiceHelper.save((DynamicObject[])apBills);
    }
}

