/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.arapcommon.enums.FreezeStateEnum;

public class FinApFreezeOp
extends AbstractOperationServicePlugIn {
    private Map<Long, Integer> ap003Cache = new HashMap<Long, Integer>();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List selecter = e.getFieldKeys();
        selecter.add("org");
        selecter.add("detailentry");
        selecter.add("e_pricetaxtotal");
        selecter.add("lockedamt");
        selecter.add("planentity");
        selecter.add("planpricetax");
        selecter.add("billstatus");
        selecter.add("freezestate");
        selecter.add("planlockedamt");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                long orgId = 0L;
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject info = dataEntity.getDataEntity();
                    long tempOrgId = (Long)info.getDynamicObject("org").getPkValue();
                    if (orgId == 0L) {
                        orgId = tempOrgId;
                    }
                    if (FinApFreezeOp.this.getAp003(orgId) == 1) {
                        DynamicObjectCollection detailentrys = info.getDynamicObjectCollection("detailentry");
                        BigDecimal e_pricetaxtotal = BigDecimal.ZERO;
                        BigDecimal lockedamt = BigDecimal.ZERO;
                        for (DynamicObject detailentry : detailentrys) {
                            e_pricetaxtotal = e_pricetaxtotal.add(detailentry.getBigDecimal("e_pricetaxtotal"));
                            lockedamt = lockedamt.add(detailentry.getBigDecimal("lockedamt"));
                        }
                        if (e_pricetaxtotal.subtract(lockedamt).compareTo(BigDecimal.ZERO) == 0) {
                            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u660e\u7ec6\u4f4d\u7f6e\u7684\u201c\u672a\u9501\u5b9a\u91d1\u989d\u201d\u4e0d\u4e3a0\u7684\u6570\u636e\u624d\u53ef\u4ee5\u51bb\u7ed3\u3002", (String)"FinApFreezeOp_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                        }
                    } else {
                        DynamicObjectCollection planentitys = info.getDynamicObjectCollection("planentity");
                        BigDecimal planpricetax = BigDecimal.ZERO;
                        BigDecimal unplanlockamt = BigDecimal.ZERO;
                        for (DynamicObject planentity : planentitys) {
                            planpricetax = planpricetax.add(planentity.getBigDecimal("planpricetax"));
                            unplanlockamt = unplanlockamt.add(planentity.getBigDecimal("planlockedamt"));
                        }
                        if (planpricetax.subtract(unplanlockamt).compareTo(BigDecimal.ZERO) == 0) {
                            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u201c\u672a\u9501\u5b9a\u91d1\u989d\u201d\u4e0d\u4e3a0\u7684\u6570\u636e\u624d\u53ef\u4ee5\u51bb\u7ed3\u3002", (String)"FinApFreezeOp_2", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                        }
                    }
                    if (!info.getString("billstatus").equals("C")) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u53ef\u4ee5\u51bb\u7ed3\u3002", (String)"FinApFreezeOp_3", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    }
                    if (!info.getString("freezestate").equals(FreezeStateEnum.ALLFREEZE.getValue())) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u51bb\u7ed3\u72b6\u6001\u4e3a\u201c\u672a\u51bb\u7ed3\u201d\u6216\u201c\u90e8\u5206\u51bb\u7ed3\u201d\u7684\u6570\u636e\u624d\u80fd\u8fdb\u884c\u51bb\u7ed3\u3002", (String)"FinApFreezeOp_4", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private int getAp003(Long orgId) {
        Integer target = this.ap003Cache.get(orgId);
        if (target != null) {
            return target;
        }
        int ap003 = SystemParameterHelper.getParameterInteger((long)orgId, (String)"ap_003");
        this.ap003Cache.put(orgId, ap003);
        return ap003;
    }
}

