/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.mservice.ApAdjustAutoSettleService;
import kd.fi.ap.mservice.ApPaySettleService;
import kd.fi.ap.mservice.IAutoVerifyService;
import kd.fi.ap.mservice.PremAutoSettleService;
import kd.fi.ap.mservice.TranspayAutoSettleService;
import kd.fi.ap.mservice.api.service.ApSettleRecordService;
import kd.fi.ap.mservice.helper.SettleServiceHelper;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.ap.mservice.verify.ApOminAutoVerifyService;
import kd.fi.ap.mservice.verify.ApPurAutoVerifyService;
import kd.fi.ap.mservice.verify.ApPurRecedAutoVerifyService;
import kd.fi.ap.validator.FinApTaxToleranceValidator;
import kd.fi.ap.validator.FinApToBusEntryQtyAndAmtToleranceValidator;
import kd.fi.ap.validator.FinPaymentSecurityAuditValidator;
import kd.fi.ap.validator.FinanceApBillAuditValidator;
import kd.fi.ap.validator.SupplierPayHoldValidator;
import kd.fi.arapcommon.enums.APSettleStatusEnum;
import kd.fi.arapcommon.enums.APVerifyStatusEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.enums.SettleTypeEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.factory.FinBillFactory;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApProcessParamsHelper;
import kd.fi.arapcommon.helper.ArApRecOrPayBillHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.opplugin.AsyncSupportiveOp;
import kd.fi.arapcommon.opplugin.FinBillPreInfoValidator;
import kd.fi.arapcommon.service.bus.ApWoffService;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.fin.FinCoordinationService;
import kd.fi.arapcommon.service.freeze.FinApAuditFreezeService;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.CommonVerifyServiceHelper;
import kd.fi.arapcommon.service.helper.FinApBillHandleHelper;
import kd.fi.arapcommon.service.helper.PayBillHandleHelper;
import kd.fi.arapcommon.service.helper.PremiumConvertServiceHelper;
import kd.fi.arapcommon.service.helper.SettleRecordOpHelper;
import kd.fi.arapcommon.service.helper.TxSettleServiceHelper;
import kd.fi.arapcommon.service.plan.split.PlanSplitService;
import kd.fi.arapcommon.service.plan.split.entity.DetailGroupData;
import kd.fi.arapcommon.service.plan.split.entity.PlanRowData;
import kd.fi.arapcommon.service.settle.SettleVersionServiceHelper;
import kd.fi.arapcommon.service.writeback.helper.FinApExitPremiumWBServiceHelper;
import kd.fi.arapcommon.util.StringUtils;
import kd.fi.arapcommon.validator.PeriodAuditOrUnauditValidator;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleParam;
import kd.fi.arapcommon.vo.SettleSchemeVO;

public class FinanceApBillAuditOp
extends AsyncSupportiveOp {
    private static final Log logger = LogFactory.getLog(FinanceApBillAuditOp.class);
    @Deprecated
    private final Map<Long, Boolean> checkAutoSettleMap = new HashMap<Long, Boolean>();

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PeriodAuditOrUnauditValidator());
        e.addValidator((AbstractValidator)new FinanceApBillAuditValidator());
        e.addValidator((AbstractValidator)new FinBillPreInfoValidator(false));
        e.addValidator((AbstractValidator)new SupplierPayHoldValidator());
        e.addValidator((AbstractValidator)new FinPaymentSecurityAuditValidator());
        e.addValidator((AbstractValidator)new FinApTaxToleranceValidator());
        e.addValidator((AbstractValidator)new FinApToBusEntryQtyAndAmtToleranceValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] finBills = e.getDataEntities();
        super.beforeExecuteOperationTransaction(e);
        logger.info("FinanceApBillAuditOp.beginOperationTransaction clearExpenseFileds start");
        this.clearExpenseFileds(finBills);
        logger.info("FinanceApBillAuditOp.beginOperationTransaction clearExpenseFileds end");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] finBills = e.getDataEntities();
        logger.info("FinanceApBillAuditOp.beginOperationTransaction start");
        logger.info("FinanceApBillAuditOp.beginOperationTransaction setbookdate start");
        BookDateHelper.setBookDate((DynamicObject[])finBills, (boolean)false);
        logger.info("FinanceApBillAuditOp.beginOperationTransaction setbookdate end");
        logger.info("FinanceApBillAuditOp.beginOperationTransaction updateHistoryPreEntrySettleAmt start");
        ArApRecOrPayBillHelper.updateHistoryPreEntrySettleAmt((DynamicObject[])finBills);
        logger.info("FinanceApBillAuditOp.beginOperationTransaction updateHistoryPreEntrySettleAmt end");
        logger.info("FinanceApBillAuditOp.beginOperationTransaction updateUnitCoefficient start");
        this.updateUnitCoefficient(finBills);
        logger.info("FinanceApBillAuditOp.beginOperationTransaction updateUnitCoefficient end");
        logger.info("FinanceApBillAuditOp.beginOperationTransaction setSrcIdAndEntryIdForAdjustBill start");
        this.setSrcIdAndEntryIdForAdjustBill(finBills);
        logger.info("FinanceApBillAuditOp.beginOperationTransaction setSrcIdAndEntryIdForAdjustBill end");
        logger.info("FinanceApBillAuditOp.beginOperationTransaction end");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinanceApBillAuditOp.endOperationTransaction start");
        logger.info("FinanceApBillAuditOp.endOperationTransaction settle start");
        this.autoSettle(entities);
        logger.info("FinanceApBillAuditOp.endOperationTransaction settle end");
        logger.info("FinanceApBillAuditOp.endOperationTransaction writeScmcBill start");
        ArApProcessParamsHelper.writeBackScmcBill((DynamicObject[])entities, (boolean)true);
        logger.info("FinanceApBillAuditOp.endOperationTransaction writeScmcBill end");
        logger.info("FinanceApBillAuditOp.endOperationTransaction autoPushPrem start");
        this.autoPushPremium(entities);
        logger.info("FinanceApBillAuditOp.endOperationTransaction autoPushPrem end");
        logger.info("FinanceApBillAuditOp.endOperationTransaction coordination start");
        FinCoordinationService coordinationService = FinBillFactory.getCoordinationService((boolean)false);
        coordinationService.kdtxCoordination(entities);
        logger.info("FinanceApBillAuditOp.endOperationTransaction coordination end");
        logger.info("FinanceApBillAuditOp.endOperationTransaction woff start");
        this.autoWoff(entities);
        logger.info("FinanceApBillAuditOp.endOperationTransaction woff end");
        logger.info("FinanceApBillAuditOp.endOperationTransaction autoVerify start");
        this.autoVerify(entities);
        logger.info("FinanceApBillAuditOp.endOperationTransaction autoVerify end");
        logger.info("FinanceApBillAuditOp.endOperationTransaction pushToArBills start");
        this.pushToArBills(entities);
        logger.info("FinanceApBillAuditOp.endOperationTransaction pushToArBills end");
        logger.info("FinanceApBillAuditOp.endOperationTransaction freeze start");
        Set apBillIds = Arrays.stream(entities).map(v -> v.getLong("id")).collect(Collectors.toSet());
        FinApAuditFreezeService service = new FinApAuditFreezeService();
        service.freeze(apBillIds, true);
        logger.info("FinanceApBillAuditOp.endOperationTransaction freeze end");
        logger.info("FinanceApBillAuditOp.endOperationTransaction end");
    }

    private void autoWoff(DynamicObject[] entities) {
        try {
            Boolean woffServiceV2 = BusWoffHelper.woffServiceV2();
            logger.info("audit.woff.woffServiceV2:" + woffServiceV2);
            if (woffServiceV2.booleanValue()) {
                ApWoffService woffService = new ApWoffService();
                Set srcBusIds = woffService.initWoffDetailInfo(entities);
                if (ObjectUtils.isEmpty((Object)srcBusIds)) {
                    return;
                }
                ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_busbill", (String)"woff", (Set)srcBusIds);
                woffService.genWoffBill();
            } else {
                BusWoffHelper.doBusWoffFromFinAp((DynamicObject[])entities);
            }
        }
        catch (KDBizException e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6682\u4f30\u5e94\u4ed8\u6574\u5355\u51b2\u56de\u5931\u8d25\uff1a%s", (String)"FinanceApBillAuditOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), e.getMessage()));
        }
    }

    private void autoPushPremium(DynamicObject[] entities) {
        List sourceBillIds = Arrays.stream(entities).map(v -> v.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", sourceBillIds), new QFilter("ispremium", "=", (Object)Boolean.TRUE)});
        HashSet<Long> hasPremBillIds = new HashSet<Long>();
        for (DynamicObject[] coll : colls) {
            hasPremBillIds.add(coll.getLong("sourcebillid"));
        }
        HashMap<Long, DynamicObject> canPushPremBillsMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject data : entities) {
            boolean isPremium = data.getBoolean("ispremium");
            BigDecimal premiumAmt = data.getBigDecimal("premiumamt");
            if (premiumAmt.compareTo(BigDecimal.ZERO) == 0 || isPremium || hasPremBillIds.contains(data.getLong("id"))) continue;
            canPushPremBillsMap.put(data.getLong("id"), data);
        }
        if (!ObjectUtils.isEmpty(canPushPremBillsMap)) {
            try {
                PremiumConvertServiceHelper.pushAndSave(canPushPremBillsMap, (String)"ap_finapbill");
            }
            catch (KDBizException e) {
                String message = e.getMessage();
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u8d28\u4fdd\u91d1\u4e0b\u63a8\u5931\u8d25\uff1a%s", (String)"FinanceApBillAuditOp_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), message));
            }
        }
    }

    private void setSrcIdAndEntryIdForAdjustBill(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> adjustBills = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject billType = dataEntity.getDynamicObject("billtypeid");
            String sourceBillType = dataEntity.getString("sourcebilltype");
            if (!"ApFin_borr_BT_S".equals(billType.getString("number")) || !"ap_finapbill".equals(sourceBillType)) continue;
            adjustBills.add(dataEntity);
        }
        if (adjustBills.size() == 0) {
            return;
        }
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashSet<Long> srcIds = new HashSet<Long>(1);
        for (DynamicObject adjustBill : adjustBills) {
            orgIds.add(adjustBill.getLong("org.id"));
            DynamicObject[] detailEntries = adjustBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject detailEntry : detailEntries) {
                srcIds.add(detailEntry.getLong("e_sourcebillid"));
            }
        }
        DynamicObject[] srcFinBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,org,pricetaxtotal,unplanlockamt,planlockedamt,settleversion,e_splitdimensionid,p_splitdimensionid", (QFilter[])new QFilter[]{new QFilter("id", "in", srcIds)});
        HashMap<Long, DynamicObject> srcFinBillMap = new HashMap<Long, DynamicObject>(srcFinBills.length);
        for (DynamicObject srcFinBill : srcFinBills) {
            srcFinBillMap.put(srcFinBill.getLong("id"), srcFinBill);
        }
        if (srcFinBills.length == 0) {
            return;
        }
        Map settleParamMap = ArApHelper.batchGetApSettleParam(orgIds);
        Iterator iterator = adjustBills.iterator();
        while (iterator.hasNext()) {
            DynamicObject adjustBill = (DynamicObject)iterator.next();
            long orgId = adjustBill.getLong("org.id");
            DynamicObjectCollection detailEntries = adjustBill.getDynamicObjectCollection("detailentry");
            long sourceBillId = ((DynamicObject)detailEntries.get(0)).getLong("e_sourcebillid");
            if ((Integer)settleParamMap.get(orgId) == 2 && !SettleVersionServiceHelper.isOldVersion((DynamicObject)((DynamicObject)srcFinBillMap.get(sourceBillId)))) continue;
            iterator.remove();
        }
        if (adjustBills.size() == 0) {
            return;
        }
        Iterator iterator0 = adjustBills.iterator();
        while (iterator0.hasNext()) {
            DynamicObject adjustBill = (DynamicObject)iterator0.next();
            DynamicObjectCollection detailEntries = adjustBill.getDynamicObjectCollection("detailentry");
            long srcBilllId = ((DynamicObject)detailEntries.get(0)).getLong("e_sourcebillid");
            DynamicObject sourceBill = (DynamicObject)srcFinBillMap.get(srcBilllId);
            BigDecimal adjustPriceTaxTotal = adjustBill.getBigDecimal("pricetaxtotal");
            if (sourceBill == null || adjustPriceTaxTotal.compareTo(BigDecimal.ZERO) > 0) {
                iterator0.remove();
                continue;
            }
            BigDecimal sourcePriceTaxTotal = sourceBill.getBigDecimal("pricetaxtotal");
            DynamicObjectCollection sourcePlanEntries = sourceBill.getDynamicObjectCollection("planentity");
            BigDecimal planLockedAmt = BigDecimal.ZERO;
            for (DynamicObject planEntry : sourcePlanEntries) {
                planLockedAmt = planLockedAmt.add(planEntry.getBigDecimal("planlockedamt"));
            }
            if (adjustPriceTaxTotal.abs().add(planLockedAmt).compareTo(sourcePriceTaxTotal) <= 0) continue;
            iterator0.remove();
        }
        if (adjustBills.size() == 0) {
            return;
        }
        HashMap<Long, Integer> srcEntryIdToDimensionId = new HashMap<Long, Integer>(8);
        for (DynamicObject srcFinBill : srcFinBills) {
            DynamicObjectCollection detailEntries = srcFinBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject detailEntry : detailEntries) {
                srcEntryIdToDimensionId.put(detailEntry.getLong("id"), detailEntry.getInt("e_splitdimensionid"));
            }
        }
        for (DynamicObject adjustBill : adjustBills) {
            DynamicObjectCollection detailEntries = adjustBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject detailEntry : detailEntries) {
                long srcEntryId = detailEntry.getLong("e_sourcebillentryid");
                detailEntry.set("e_splitdimensionid", srcEntryIdToDimensionId.get(srcEntryId));
            }
        }
        this.splitPlanEntryBySrcIdAndDimensionId(adjustBills);
        this.setAdjustBillPlanEntrySrcIdAndEntryId(adjustBills, srcFinBillMap);
        this.reSetSplitDimensionId(adjustBills);
    }

    private void splitPlanEntryBySrcIdAndDimensionId(List<DynamicObject> adjustBills) {
        HashMap<String, String> dimensionMappings = new HashMap<String, String>(2);
        ArrayList<String> dimensions = new ArrayList<String>(2);
        dimensionMappings.put("e_sourcebillid", "p_sourcebillid");
        dimensionMappings.put("e_splitdimensionid", "p_splitdimensionid");
        dimensions.add("e_sourcebillid");
        dimensions.add("e_splitdimensionid");
        for (DynamicObject adjustBill : adjustBills) {
            PlanSplitService splitService = new PlanSplitService(adjustBill, dimensions);
            List planRowDatas = splitService.execute();
            DynamicObjectCollection planEntries = adjustBill.getDynamicObjectCollection("planentity");
            planEntries.clear();
            DynamicObject settlementType = adjustBill.getDynamicObject("settlementtype");
            for (int i = 0; i < planRowDatas.size(); ++i) {
                PlanRowData planRowData = (PlanRowData)planRowDatas.get(i);
                DetailGroupData groupData = planRowData.getGroupData();
                Map dimensionMap = groupData.getDimensionMap();
                DynamicObject planEntry = new DynamicObject(planEntries.getDynamicObjectType());
                planEntry.set("seq", (Object)(i + 1));
                for (Map.Entry dimensionMapping : dimensionMappings.entrySet()) {
                    String detailKey = (String)dimensionMapping.getKey();
                    String planKey = (String)dimensionMapping.getValue();
                    Object dimensionValue = dimensionMap.get(detailKey);
                    planEntry.set(planKey, dimensionValue);
                }
                BigDecimal priceTaxTotal = groupData.getPriceTaxTotal();
                planEntry.set("planpricetax", (Object)priceTaxTotal);
                planEntry.set("unplanlockamt", (Object)priceTaxTotal);
                planEntry.set("unplansettleamt", (Object)priceTaxTotal);
                BigDecimal priceTaxTotalLocal = groupData.getPriceTaxTotalLocal();
                planEntry.set("planpricetaxloc", (Object)priceTaxTotalLocal);
                planEntry.set("unplansettlelocamt", (Object)priceTaxTotalLocal);
                planEntry.set("planduedate", (Object)planRowData.getDueDate());
                planEntry.set("plansettletype", (Object)settlementType);
                planEntry.set("e_freezestate", (Object)"unfreeze");
                planEntry.set("p_payrate", (Object)planRowData.getRate());
                planEntries.add((Object)planEntry);
            }
        }
    }

    private void setAdjustBillPlanEntrySrcIdAndEntryId(List<DynamicObject> adjustBills, Map<Long, DynamicObject> srcFinBillMap) {
        for (DynamicObject adjustBill : adjustBills) {
            int basePrecision = adjustBill.getInt("basecurrency.amtprecision");
            String quotation = adjustBill.getString("quotation");
            BigDecimal exchange = adjustBill.getBigDecimal("exchangerate");
            DynamicObjectCollection adjustPlanEntries = adjustBill.getDynamicObjectCollection("planentity");
            ArrayList<DynamicObject> newPlanEntries = new ArrayList<DynamicObject>(1);
            int seqCount = 0;
            CloneUtils clone = new CloneUtils(true, true);
            block1: for (DynamicObject adjustPlanEntry : adjustPlanEntries) {
                BigDecimal planEntryPriceTaxTotal = adjustPlanEntry.getBigDecimal("planpricetax");
                if (planEntryPriceTaxTotal.compareTo(BigDecimal.ZERO) == 0) continue;
                BigDecimal planEntryPriceTaxLocalTotal = adjustPlanEntry.getBigDecimal("planpricetaxloc");
                BigDecimal planPayRate = adjustPlanEntry.getBigDecimal("p_payrate");
                BigDecimal remainAmt = planEntryPriceTaxTotal;
                BigDecimal remainLocalAmt = BigDecimal.ZERO;
                BigDecimal remainRate = BigDecimal.ZERO;
                long srcBillId = adjustPlanEntry.getLong("p_sourcebillid");
                DynamicObject sourceBill = srcFinBillMap.get(srcBillId);
                DynamicObjectCollection sourcePlanEntries = sourceBill.getDynamicObjectCollection("planentity");
                BigDecimal amtDirection = new BigDecimal(planEntryPriceTaxTotal.signum());
                for (DynamicObject sourcePlanEntry : sourcePlanEntries) {
                    int transferPlanSplitDimensionId;
                    int srcPlanSplitDimensionId = sourcePlanEntry.getInt("p_splitdimensionid");
                    if (srcPlanSplitDimensionId != (transferPlanSplitDimensionId = adjustPlanEntry.getInt("p_splitdimensionid"))) continue;
                    BigDecimal planUnLockAmt = sourcePlanEntry.getBigDecimal("unplanlockamt");
                    BigDecimal sourceUnLockAmtDirection = new BigDecimal(planUnLockAmt.signum());
                    if (planUnLockAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                    DynamicObject planEntry = (DynamicObject)clone.clone((IDataEntityBase)adjustPlanEntry);
                    BigDecimal curEntryAmt = amtDirection.multiply(remainAmt.abs().compareTo(planUnLockAmt.abs()) > 0 ? planUnLockAmt.abs() : remainAmt.abs());
                    BigDecimal curEntryLocalAmt = this.getLocalAmt(curEntryAmt, quotation, exchange, basePrecision);
                    planEntry.set("seq", (Object)(++seqCount));
                    planEntry.set("planpricetax", (Object)curEntryAmt);
                    planEntry.set("planpricetaxloc", (Object)curEntryLocalAmt);
                    planEntry.set("unplansettleamt", (Object)curEntryAmt);
                    planEntry.set("unplansettlelocamt", (Object)curEntryLocalAmt);
                    planEntry.set("unplanlockamt", (Object)curEntryAmt);
                    planEntry.set("planduedate", adjustPlanEntry.get("planduedate"));
                    planEntry.set("plansettletype", adjustBill.get("settlementtype"));
                    planEntry.set("e_freezestate", (Object)"unfreeze");
                    BigDecimal payRate = curEntryAmt.divide(planEntryPriceTaxTotal, 2, RoundingMode.DOWN).multiply(planPayRate).setScale(2, RoundingMode.DOWN);
                    planEntry.set("p_payrate", (Object)payRate);
                    planEntry.set("p_sourcebillid", (Object)srcBillId);
                    planEntry.set("p_sourcebillentryid", (Object)sourcePlanEntry.getLong("id"));
                    if (curEntryAmt.signum() != 0) {
                        newPlanEntries.add(planEntry);
                    }
                    remainAmt = remainAmt.subtract(curEntryAmt);
                    sourcePlanEntry.set("unplanlockamt", (Object)planUnLockAmt.subtract(curEntryAmt.abs().multiply(sourceUnLockAmtDirection)));
                    if (remainAmt.compareTo(BigDecimal.ZERO) == 0) {
                        curEntryLocalAmt = planEntryPriceTaxLocalTotal.subtract(remainLocalAmt);
                        planEntry.set("planpricetaxloc", (Object)curEntryLocalAmt);
                        planEntry.set("unplansettlelocamt", (Object)curEntryLocalAmt);
                        planEntry.set("p_payrate", (Object)planPayRate.subtract(remainRate));
                        continue block1;
                    }
                    remainLocalAmt = remainLocalAmt.add(curEntryLocalAmt);
                    remainRate = remainRate.add(payRate);
                }
            }
            adjustPlanEntries.clear();
            adjustPlanEntries.addAll(newPlanEntries);
        }
    }

    private void reSetSplitDimensionId(List<DynamicObject> adjustBills) {
        for (DynamicObject adjustBill : adjustBills) {
            String key;
            long srcBillId;
            DynamicObjectCollection detailEntries = adjustBill.getDynamicObjectCollection("detailentry");
            DynamicObjectCollection planEntries = adjustBill.getDynamicObjectCollection("planentity");
            int splitDimensionIdIndex = 0;
            HashMap<String, Integer> planSrcIdToSplitDimensionId = new HashMap<String, Integer>(8);
            for (DynamicObject planEntry : planEntries) {
                srcBillId = planEntry.getLong("p_sourcebillid");
                int planSplitDimensionId = planEntry.getInt("p_splitdimensionid");
                key = srcBillId + "_" + planSplitDimensionId;
                Integer newSplitDimensionId = (Integer)planSrcIdToSplitDimensionId.get(key);
                if (newSplitDimensionId == null) {
                    planSrcIdToSplitDimensionId.put(key, splitDimensionIdIndex);
                    planEntry.set("p_splitdimensionid", (Object)splitDimensionIdIndex);
                    ++splitDimensionIdIndex;
                    continue;
                }
                planEntry.set("p_splitdimensionid", (Object)newSplitDimensionId);
            }
            for (DynamicObject detailEntry : detailEntries) {
                srcBillId = detailEntry.getLong("e_sourcebillid");
                int detailOldSplitDimensionId = detailEntry.getInt("e_splitdimensionid");
                key = srcBillId + "_" + detailOldSplitDimensionId;
                detailEntry.set("e_splitdimensionid", planSrcIdToSplitDimensionId.get(key));
            }
        }
    }

    private BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchange, int precision) {
        if ("1".equals(quotation)) {
            return amount.divide(exchange, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchange).setScale(precision, RoundingMode.HALF_UP);
    }

    private boolean checkAmt4Settled(DynamicObject entity, Map<Long, Integer> orgMap) {
        boolean isSettled;
        block4: {
            block5: {
                if (BigDecimal.ZERO.compareTo(entity.getBigDecimal("pricetaxtotal")) != 0) {
                    return false;
                }
                isSettled = true;
                Long orgPk = entity.getDynamicObject("org").getLong("id");
                Integer param = orgMap.get(orgPk);
                if (ObjectUtils.isEmpty((Object)param)) {
                    param = ArApHelper.getApSettleParam((Object)orgPk);
                    orgMap.put(orgPk, param);
                }
                if (1 != param) break block5;
                DynamicObjectCollection entries = entity.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entries) {
                    if (BigDecimal.ZERO.compareTo(entry.getBigDecimal("e_pricetaxtotal")) == 0) continue;
                    isSettled = false;
                    break block4;
                }
                break block4;
            }
            boolean isOldVersion = SettleVersionServiceHelper.isOldVersion((DynamicObject)entity);
            if (isOldVersion) break block4;
            DynamicObjectCollection planEntries = entity.getDynamicObjectCollection("planentity");
            for (DynamicObject planEntry : planEntries) {
                if (BigDecimal.ZERO.compareTo(planEntry.getBigDecimal("planpricetax")) == 0) continue;
                isSettled = false;
            }
        }
        return isSettled;
    }

    protected void asyncExecute(DynamicObject bill, String customParams) {
    }

    protected void autoVerify(DynamicObject[] entities) {
        Set entrySet;
        HashSet entryIdSet;
        HashSet<Long> apBillPks = new HashSet<Long>(entities.length);
        HashSet<Long> apBillPksHasSour = new HashSet<Long>(entities.length);
        HashSet<Long> apBillPksPurSour = new HashSet<Long>(entities.length);
        HashSet<Long> apBillPksOminSour = new HashSet<Long>(entities.length);
        Set verifyBillTypeNum = VerifyServiceHelper.getVerifyBillTypeNum();
        Set excludeBillTypeNum = VerifyServiceHelper.getExcludeBillTypeNum();
        String omInbillkey = VerifyServiceHelper.getOmInBillKey();
        List finApBills = CommonVerifyServiceHelper.filterVerifyEntity((DynamicObject[])entities);
        Map<Long, DynamicObject> fiVerifyBillMap = finApBills.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        HashMap idAndEntrySetMap = new HashMap(8);
        for (Object entity : finApBills) {
            String sourceBillType;
            String billTypeNum = entity.getString("billtypeid.number");
            String verifyStatus = entity.getString("verifystatus");
            String biztype = entity.getString("biztype.number");
            boolean bl = entity.getBoolean("ispremium");
            boolean istansPay = entity.getBoolean("istanspay");
            Long billId = entity.getLong("id");
            DynamicObjectCollection dynamicObjectCollection = entity.getDynamicObjectCollection("detailentry");
            HashSet<Long> entryIdSet2 = new HashSet<Long>(dynamicObjectCollection.size());
            for (DynamicObject entry : dynamicObjectCollection) {
                entryIdSet2.add(entry.getLong("id"));
            }
            idAndEntrySetMap.put(billId, entryIdSet2);
            if (bl || istansPay || "ApFin_product_BT_S".equals(billTypeNum) && ("604".equals(biztype) || "6041".equals(biztype)) || excludeBillTypeNum.contains(billTypeNum) || APVerifyStatusEnum.VERIFIED.getValue().equals(verifyStatus)) continue;
            if (verifyBillTypeNum.contains(billTypeNum)) {
                apBillPks.add(billId);
            }
            if (!StringUtils.isEmpty((String)(sourceBillType = entity.getString("sourcebilltype")))) {
                apBillPksHasSour.add(billId);
            }
            if ("im_purinbill".equals(sourceBillType)) {
                apBillPksPurSour.add(billId);
            }
            if (!omInbillkey.equals(sourceBillType)) continue;
            apBillPksOminSour.add(billId);
        }
        logger.info("apautoverify:apBillPksHasSour-" + apBillPksHasSour);
        if (apBillPksHasSour.size() > 0) {
            this.directSourPurVerify(apBillPksPurSour, entities);
            apBillPks.removeAll(apBillPksPurSour);
            apBillPksHasSour.removeAll(apBillPksPurSour);
            this.directSourOminVerify(apBillPksOminSour, entities, omInbillkey);
            apBillPks.removeAll(apBillPksOminSour);
            apBillPksHasSour.removeAll(apBillPksOminSour);
            if (apBillPksHasSour.size() > 0) {
                entryIdSet = new HashSet(8);
                for (Long apBill : apBillPksHasSour) {
                    entryIdSet.addAll((Collection)idAndEntrySetMap.get(apBill));
                }
                Map purinSrcMap = BOTPHelper.loadNearUpBillIds((String)"ap_finapbill", (String)"detailentry", (Long[])apBillPksHasSour.toArray(new Long[0]), (Long[])entryIdSet.toArray(new Long[0]), (String)"im_purinbill");
                HashSet indirectSrcPurIds = new HashSet(16);
                HashSet<Long> logisticBillIds = new HashSet<Long>(16);
                for (Map.Entry entry : purinSrcMap.entrySet()) {
                    indirectSrcPurIds.addAll((Collection)entry.getValue());
                }
                if (indirectSrcPurIds.size() > 0) {
                    DynamicObjectCollection logisticBills = QueryServiceHelper.query((String)"im_purinbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", indirectSrcPurIds), new QFilter("billentry.logisticsbill", "=", (Object)Boolean.TRUE)});
                    for (DynamicObject purBill : logisticBills) {
                        logisticBillIds.add(purBill.getLong("id"));
                    }
                }
                if (purinSrcMap.size() > 0) {
                    logger.info("apautoverify:purinSrcMap-" + purinSrcMap);
                    HashSet<Long> apBillIds = new HashSet<Long>(purinSrcMap.size());
                    HashSet<Long> hashSet = new HashSet<Long>(apBillIds.size());
                    Set entrySet2 = purinSrcMap.entrySet();
                    for (Map.Entry entry : entrySet2) {
                        boolean partVerify = true;
                        List purBillIds = (List)entry.getValue();
                        for (Long purId : purBillIds) {
                            if (!logisticBillIds.contains(purId)) continue;
                            partVerify = false;
                            break;
                        }
                        if (!partVerify) continue;
                        apBillIds.add((Long)entry.getKey());
                        hashSet.addAll((Collection)entry.getValue());
                    }
                    SettleSchemeVO scheme = new SettleSchemeVO();
                    scheme.setOnlyByBotp(true);
                    ApPurAutoVerifyService apPurAutoVerifyService = new ApPurAutoVerifyService("im_purinbill", hashSet);
                    this.doAutoVerify("im_purinbill", hashSet, apBillIds, scheme, (IAutoVerifyService)apPurAutoVerifyService);
                    ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0031", null, (Object[])new Object[]{"ap_finapbill", apBillIds});
                    apBillPks.removeAll(apBillIds);
                    apBillPksHasSour.removeAll(apBillIds);
                }
            }
            if (apBillPksHasSour.size() > 0) {
                entryIdSet = new HashSet(8);
                for (Long apBill : apBillPksHasSour) {
                    entryIdSet.addAll((Collection)idAndEntrySetMap.get(apBill));
                }
                Map ominSrcMap = BOTPHelper.loadNearUpBillIds((String)"ap_finapbill", (String)"detailentry", (Long[])apBillPksHasSour.toArray(new Long[0]), (Long[])entryIdSet.toArray(new Long[0]), (String)omInbillkey);
                if (ominSrcMap.size() > 0) {
                    HashSet<Long> apBillIds = new HashSet<Long>(ominSrcMap.size());
                    HashSet<Long> ominBillIds = new HashSet<Long>(8);
                    entrySet = ominSrcMap.entrySet();
                    for (Map.Entry entry : entrySet) {
                        apBillIds.add((Long)entry.getKey());
                        ominBillIds.addAll((Collection)entry.getValue());
                    }
                    SettleSchemeVO settleSchemeVO = new SettleSchemeVO();
                    settleSchemeVO.setOnlyByBotp(true);
                    ApOminAutoVerifyService verifyService = new ApOminAutoVerifyService(omInbillkey, ominBillIds);
                    this.doAutoVerify(omInbillkey, ominBillIds, apBillIds, settleSchemeVO, (IAutoVerifyService)verifyService);
                    apBillPks.removeAll(apBillIds);
                    apBillPksHasSour.removeAll(apBillIds);
                }
            }
        }
        if (apBillPks.size() > 0) {
            ArrayList<DynamicObject> purCoreVerifyBills = new ArrayList<DynamicObject>(apBillPks.size());
            for (DynamicObject entity : entities) {
                long l = entity.getLong("id");
                if (!apBillPks.contains(l)) continue;
                purCoreVerifyBills.add(entity);
            }
            Set purInBillIds = VerifyServiceHelper.getMainBillIdsByCoreBill((String)"im_purinbill", (DynamicObject[])purCoreVerifyBills.toArray(new DynamicObject[0]));
            if (purInBillIds != null && purInBillIds.size() > 0) {
                SettleSchemeVO scheme = new SettleSchemeVO();
                scheme.setOnlyByCoreBill(true);
                ApPurAutoVerifyService verifyService = new ApPurAutoVerifyService("im_purinbill", purInBillIds);
                this.doAutoVerify("im_purinbill", purInBillIds, apBillPks, scheme, (IAutoVerifyService)verifyService);
                DataSet apBills = QueryServiceHelper.queryDataSet((String)"verifyresult", (String)"ap_finapbill", (String)"id,verifystatus", (QFilter[])new QFilter[]{new QFilter("id", "in", apBillPks)}, null);
                for (Row row : apBills) {
                    String verifyStatus = row.getString("verifystatus");
                    if (APVerifyStatusEnum.UNVERIFY.getValue().equals(verifyStatus)) continue;
                    apBillPks.remove(row.getLong("id"));
                    apBillPksHasSour.remove(row.getLong("id"));
                }
            }
        }
        if (apBillPks.size() > 0 && "im_mdc_ominbill".equals(omInbillkey)) {
            Object omInBillIds;
            ArrayList<DynamicObject> ominCoreVerifyBills = new ArrayList<DynamicObject>(apBillPks.size());
            for (DynamicObject entity : entities) {
                long l = entity.getLong("id");
                DynamicObject entry = (DynamicObject)entity.getDynamicObjectCollection("detailentry").get(0);
                if (!apBillPks.contains(l) || !"pm_om_purorderbill".equals(entry.getString("corebilltype"))) continue;
                ominCoreVerifyBills.add(entity);
            }
            if (ominCoreVerifyBills.size() > 0 && (omInBillIds = VerifyServiceHelper.getMainBillIdsByCoreBill((String)omInbillkey, (DynamicObject[])ominCoreVerifyBills.toArray(new DynamicObject[0]))) != null && omInBillIds.size() > 0) {
                SettleSchemeVO scheme = new SettleSchemeVO();
                scheme.setOnlyByCoreBill(true);
                ApOminAutoVerifyService verifyService = new ApOminAutoVerifyService(omInbillkey, (Set)omInBillIds);
                this.doAutoVerify(omInbillkey, (Set<Long>)omInBillIds, apBillPks, scheme, (IAutoVerifyService)verifyService);
            }
        }
        if (apBillPksHasSour.size() > 0) {
            entryIdSet = new HashSet(8);
            for (Long apBill : apBillPksHasSour) {
                entryIdSet.addAll((Collection)idAndEntrySetMap.get(apBill));
            }
            Map purrecSrcMap = BOTPHelper.loadNearUpBillIds((String)"ap_finapbill", (String)"detailentry", (Long[])apBillPksHasSour.toArray(new Long[0]), (Long[])entryIdSet.toArray(new Long[0]), (String)"im_purreceivebill");
            if (purrecSrcMap != null && purrecSrcMap.size() > 0) {
                HashSet<Long> apBillIds = new HashSet<Long>(purrecSrcMap.size());
                HashSet<Long> purrecBillIds = new HashSet<Long>(8);
                entrySet = purrecSrcMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    apBillIds.add((Long)entry.getKey());
                    purrecBillIds.addAll((Collection)entry.getValue());
                }
                HashSet hashSet = new HashSet(8);
                for (Long apBill : apBillIds) {
                    hashSet.addAll((Collection)idAndEntrySetMap.get(apBill));
                }
                Map purrectrgMap = BOTPHelper.loadNearUpBillIds((String)"ap_finapbill", (String)"detailentry", (Long[])apBillIds.toArray(new Long[0]), (Long[])hashSet.toArray(new Long[0]), (String)"im_ospurinbill");
                HashSet hadSrcOsPurBillIds = new HashSet(16);
                for (Map.Entry entry : purrectrgMap.entrySet()) {
                    hadSrcOsPurBillIds.add(entry.getKey());
                }
                Iterator iterator = apBillIds.iterator();
                while (iterator.hasNext()) {
                    if (!hadSrcOsPurBillIds.contains(iterator.next())) continue;
                    iterator.remove();
                }
                SettleSchemeVO scheme = new SettleSchemeVO();
                scheme.setOnlyByBotp(true);
                ApPurRecedAutoVerifyService verifyService = new ApPurRecedAutoVerifyService("im_purreceivebill", purrecBillIds);
                this.doAutoVerify("im_purreceivebill", purrecBillIds, apBillIds, scheme, (IAutoVerifyService)verifyService);
                ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0031", null, (Object[])new Object[]{"ap_finapbill", apBillIds});
                apBillPks.removeAll(apBillIds);
                apBillPksHasSour.removeAll(apBillIds);
            }
        }
        ArrayList<DynamicObject> apOmBills = new ArrayList<DynamicObject>(2);
        for (DynamicObject bill : entities) {
            Long l = bill.getLong("id");
            if (fiVerifyBillMap.get(l) != null) continue;
            apOmBills.add(bill);
        }
        this.apOminVerify(apOmBills.toArray(new DynamicObject[0]));
    }

    private void apOminVerify(DynamicObject[] entities) {
        if (entities.length == 0) {
            return;
        }
        String omInbillkey = VerifyServiceHelper.getOmInBillKey();
        Set verifyBillTypeNum = VerifyServiceHelper.getVerifyBillTypeNum();
        Set excludeBillTypeNum = VerifyServiceHelper.getExcludeBillTypeNum();
        HashSet<Long> apBillPks = new HashSet<Long>(entities.length);
        HashSet<Long> apBillPksHasSour = new HashSet<Long>(entities.length);
        HashSet<Long> apBillPksOminSour = new HashSet<Long>(entities.length);
        List finBills = "im_mdc_ominbill".equals(omInbillkey) ? Arrays.stream(entities).collect(Collectors.toList()) : CommonVerifyServiceHelper.filterVerifyEntity((DynamicObject[])entities);
        for (DynamicObject[] entity : finBills) {
            String sourceBillType;
            String billTypeNum = entity.getString("billtypeid.number");
            String verifyStatus = entity.getString("verifystatus");
            String biztype = entity.getString("biztype.number");
            if ("ApFin_product_BT_S".equals(billTypeNum) && ("604".equals(biztype) || "6041".equals(biztype)) || excludeBillTypeNum.contains(billTypeNum) || APVerifyStatusEnum.VERIFIED.getValue().equals(verifyStatus)) continue;
            if (verifyBillTypeNum.contains(billTypeNum)) {
                apBillPks.add(entity.getLong("id"));
            }
            if (!StringUtils.isEmpty((String)(sourceBillType = entity.getString("sourcebilltype")))) {
                apBillPksHasSour.add(entity.getLong("id"));
            }
            if (!omInbillkey.equals(sourceBillType)) continue;
            apBillPksOminSour.add(entity.getLong("id"));
        }
        if (apBillPksOminSour.size() > 0) {
            this.directSourOminVerify(apBillPksOminSour, entities, omInbillkey);
            apBillPks.removeAll(apBillPksOminSour);
            apBillPksHasSour.removeAll(apBillPksOminSour);
        }
        if (apBillPksHasSour.size() > 0) {
            HashSet<Long> entryIdSet = new HashSet<Long>(8);
            for (DynamicObject entity : entities) {
                long billId = entity.getLong("id");
                if (!apBillPksHasSour.contains(billId)) continue;
                DynamicObjectCollection entryColl = entity.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entryColl) {
                    entryIdSet.add(entry.getLong("id"));
                }
            }
            Map ominSrcMap = BOTPHelper.loadNearUpBillIds((String)"ap_finapbill", (String)"detailentry", (Long[])apBillPksHasSour.toArray(new Long[0]), (Long[])entryIdSet.toArray(new Long[0]), (String)omInbillkey);
            if (ominSrcMap.size() > 0) {
                HashSet<Long> apBillIds = new HashSet<Long>(ominSrcMap.size());
                HashSet<Long> ominBillIds = new HashSet<Long>(ominSrcMap.size());
                Set entrySet = ominSrcMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    apBillIds.add((Long)entry.getKey());
                    ominBillIds.addAll((Collection)entry.getValue());
                }
                SettleSchemeVO scheme = new SettleSchemeVO();
                scheme.setOnlyByBotp(true);
                ApOminAutoVerifyService verifyService = new ApOminAutoVerifyService(omInbillkey, ominBillIds);
                this.doAutoVerify(omInbillkey, ominBillIds, apBillIds, scheme, (IAutoVerifyService)verifyService);
                apBillPks.removeAll(apBillIds);
            }
        }
        if (apBillPks.size() > 0) {
            logger.info("\u5269\u4f59\u7684\u5355\u636e\u7f16\u53f7\u4e3a\uff1a" + apBillPks);
            if ("im_mdc_ominbill".equals(omInbillkey)) {
                Set omInBillIds;
                ArrayList<DynamicObject> ominCoreVerifyBills = new ArrayList<DynamicObject>(apBillPks.size());
                for (DynamicObject entity : finBills) {
                    long pk = entity.getLong("id");
                    DynamicObject entry = (DynamicObject)entity.getDynamicObjectCollection("detailentry").get(0);
                    if (!apBillPks.contains(pk) || !"pm_om_purorderbill".equals(entry.getString("corebilltype"))) continue;
                    ominCoreVerifyBills.add(entity);
                }
                if (ominCoreVerifyBills.size() > 0 && (omInBillIds = VerifyServiceHelper.getMainBillIdsByCoreBill((String)omInbillkey, (DynamicObject[])ominCoreVerifyBills.toArray(new DynamicObject[0]))) != null && omInBillIds.size() > 0) {
                    logger.info("\u59d4\u5916\u6838\u5fc3\u5355\u636e\u53f7\u6838\u9500\u59d4\u5916\u5355\u636eid\u4e3a\uff1a" + omInBillIds);
                    SettleSchemeVO scheme = new SettleSchemeVO();
                    scheme.setOnlyByCoreBill(true);
                    ApOminAutoVerifyService verifyService = new ApOminAutoVerifyService(omInbillkey, omInBillIds);
                    this.doAutoVerify(omInbillkey, omInBillIds, apBillPks, scheme, (IAutoVerifyService)verifyService);
                }
            }
        }
    }

    private void autoSettle(DynamicObject[] entities) {
        List needSettleBills;
        Set submitSettleFinIds;
        DynamicObject[] submitSettleFinBills;
        List settledBills;
        ArrayList<DynamicObject> needApPaySettleBills = new ArrayList<DynamicObject>(entities.length);
        ArrayList<DynamicObject> needApAdjustSettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needApTransPaySettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needApPremSettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needUpdateSettleStatusZeroBills = new ArrayList<DynamicObject>(entities.length);
        HashMap<Long, Integer> orgMap = new HashMap<Long, Integer>(4);
        for (DynamicObject entity2 : entities) {
            if (this.checkAmt4Settled(entity2, orgMap)) {
                needUpdateSettleStatusZeroBills.add(entity2);
                continue;
            }
            if (!entity2.getBoolean("isadjust")) {
                needApPaySettleBills.add(entity2);
            }
            if (entity2.getBoolean("isadjust")) {
                needApAdjustSettleBills.add(entity2);
            }
            if (entity2.getBoolean("istanspay")) {
                needApTransPaySettleBills.add(entity2);
            }
            if (!entity2.getBoolean("ispremium")) continue;
            needApPremSettleBills.add(entity2);
        }
        if (!needUpdateSettleStatusZeroBills.isEmpty()) {
            DynamicObject[] needSaveZeroBills;
            List zeroApBillIds = needUpdateSettleStatusZeroBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList());
            for (DynamicObject zeroBill : needSaveZeroBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"settlestatus,planpricetax,planpricetaxloc,unplanlockamt,planlockedamt,unplansettleamt,plansettledamt,unplansettlelocamt,plansettledlocamt", (QFilter[])new QFilter[]{new QFilter("id", "in", zeroApBillIds)})) {
                zeroBill.set("settlestatus", (Object)APSettleStatusEnum.SETTLED.getValue());
                DynamicObjectCollection planEntries = zeroBill.getDynamicObjectCollection("planentity");
                for (Object planEntry : planEntries) {
                    BigDecimal planPricetax = planEntry.getBigDecimal("planpricetax");
                    BigDecimal bigDecimal = planEntry.getBigDecimal("planpricetaxloc");
                    planEntry.set("unplanlockamt", (Object)BigDecimal.ZERO);
                    planEntry.set("planlockedamt", (Object)planPricetax);
                    planEntry.set("unplansettleamt", (Object)BigDecimal.ZERO);
                    planEntry.set("plansettledamt", (Object)planPricetax);
                    planEntry.set("unplansettlelocamt", (Object)BigDecimal.ZERO);
                    planEntry.set("plansettledlocamt", (Object)bigDecimal);
                }
            }
            SaveServiceHelper.save((DynamicObject[])needSaveZeroBills);
        }
        if (!needApAdjustSettleBills.isEmpty()) {
            HashSet<Long> sourceBillIds = new HashSet<Long>(8);
            for (DynamicObject adjustBill : needApAdjustSettleBills) {
                String sourceBilltype = adjustBill.getString("sourcebilltype");
                if (!"ap_finapbill".equals(sourceBilltype)) continue;
                sourceBillIds.add(adjustBill.getLong("sourcebillid"));
            }
            DynamicObject[] sourceBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"pricetaxtotal,lockedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", sourceBillIds)});
            Map sourceBillMap = Arrays.stream(sourceBills).collect(Collectors.toMap(bill -> bill.getLong("id"), Function.identity()));
            ApAdjustAutoSettleService apAdjustAutoSettleService = new ApAdjustAutoSettleService();
            for (DynamicObject adjustBill : needApAdjustSettleBills) {
                String sourceBilltype = adjustBill.getString("sourcebilltype");
                if (!"ap_finapbill".equals(sourceBilltype)) continue;
                long sourcebillid = adjustBill.getLong("sourcebillid");
                HashSet<Long> needAddCtrlIds = new HashSet<Long>(1);
                needAddCtrlIds.add(sourcebillid);
                CommonSettleServiceHelper.settleAddMutexCtrlInTX(needAddCtrlIds, (String)"ap_finapbill", (boolean)false);
                DynamicObject dynamicObject = (DynamicObject)sourceBillMap.get(sourcebillid);
                BigDecimal sourcebillAmout = dynamicObject.getBigDecimal("pricetaxtotal");
                DynamicObjectCollection detailentrys = dynamicObject.getDynamicObjectCollection("detailentry");
                BigDecimal lockedamt = BigDecimal.ZERO;
                for (DynamicObject detailentry : detailentrys) {
                    lockedamt = lockedamt.add(detailentry.getBigDecimal("lockedamt"));
                }
                BigDecimal adjustAmout = adjustBill.getBigDecimal("pricetaxtotal").abs();
                if (sourcebillAmout.compareTo(lockedamt.add(adjustAmout)) < 0) continue;
                apAdjustAutoSettleService.autoSettle(adjustBill, false);
            }
        }
        if (!needApTransPaySettleBills.isEmpty()) {
            TranspayAutoSettleService transpayAutoSettleService = new TranspayAutoSettleService();
            for (DynamicObject transferBill : needApTransPaySettleBills) {
                transpayAutoSettleService.autoSettle(transferBill, false);
            }
        }
        if (!needApPremSettleBills.isEmpty()) {
            PremAutoSettleService premAutoSettleService = new PremAutoSettleService();
            premAutoSettleService.batchAutoSettle(needApPremSettleBills.toArray(new DynamicObject[0]), false);
        }
        if (!needApPaySettleBills.isEmpty() && (settledBills = Arrays.stream(submitSettleFinBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"settlestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", submitSettleFinIds = needApPaySettleBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toSet()))})).filter(bill -> !"unsettle".equals(bill.getString("settlestatus"))).collect(Collectors.toList())).size() > 0) {
            List entityIds = settledBills.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList());
            QFilter filter = new QFilter("settlerelation", "=", (Object)SettleRelationEnum.APPAYSETTLE.getValue());
            filter.and("mainbillid", "in", entityIds);
            filter.and("billstatus", "=", (Object)"B");
            List submitSettleRecordIds = QueryServiceHelper.queryPrimaryKeys((String)"ap_settlerecord", (QFilter[])filter.toArray(), (String)"", (int)-1);
            DynamicObject[] submitSettleRecords = BusinessDataServiceHelper.load((Object[])submitSettleRecordIds.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ap_settlerecord"));
            if (submitSettleRecords.length > 0) {
                SettleRecordOpHelper.sumbitStatusSettleRecordAudit(Arrays.asList(submitSettleRecords), (String)"ap_settlerecord");
            }
        }
        if (!needApPaySettleBills.isEmpty() && !(needSettleBills = needApPaySettleBills.stream().filter(bill -> "unsettle".equals(bill.getString("settlestatus"))).collect(Collectors.toList())).isEmpty()) {
            String settleModel;
            BigDecimal disposeAmount;
            DynamicObject[] existHasPremiumBills;
            ArrayList<Long> existHasPremiumBillIds;
            ApSettleRecordService apSettleRecordService = new ApSettleRecordService();
            ArrayList<Object> needSettleBillList = new ArrayList<Object>(needSettleBills.size());
            ArrayList<DynamicObject> settleByPreEntryBillList = new ArrayList<DynamicObject>(needSettleBills.size());
            ArrayList<Object> settleByCoreBillBillList = new ArrayList<Object>(needSettleBills.size());
            ArrayList<Object> settleByConbillnumberBillList = new ArrayList<Object>(needSettleBills.size());
            List orgIds = needSettleBills.stream().map(bill -> bill.getLong("org.id")).distinct().collect(Collectors.toList());
            Map appParametersMap = SystemParameterHelper.batchGetAppParameters((Boolean)Boolean.FALSE, orgIds, (String[])new String[]{"ap_019", "ap_003"});
            for (Object apPaySettleBill : needSettleBills) {
                long l = apPaySettleBill.getLong("org.id");
                Map orgParametersMap = (Map)appParametersMap.get(l);
                boolean isPeriod = apPaySettleBill.getBoolean("isperiod");
                DynamicObjectCollection preEntries = apPaySettleBill.getDynamicObjectCollection("preentry");
                boolean isNeedSettle = false;
                if (!ObjectUtils.isEmpty((Object)preEntries)) {
                    settleByPreEntryBillList.add((DynamicObject)apPaySettleBill);
                    isNeedSettle = true;
                }
                DynamicObjectCollection detailEntries = apPaySettleBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject detailEntry : detailEntries) {
                    String corebillno = detailEntry.getString("corebillno");
                    if (!StringUtils.isNotEmpty((String)corebillno) || isPeriod || orgParametersMap == null || !((Boolean)orgParametersMap.get("ap_019")).booleanValue()) continue;
                    settleByCoreBillBillList.add(apPaySettleBill);
                    isNeedSettle = true;
                    break;
                }
                for (DynamicObject detailEntry : detailEntries) {
                    String conbillnumber = detailEntry.getString("e_conbillnumber");
                    if (!StringUtils.isNotEmpty((String)conbillnumber) || isPeriod || orgParametersMap == null || !((Boolean)orgParametersMap.get("ap_019")).booleanValue()) continue;
                    settleByConbillnumberBillList.add(apPaySettleBill);
                    isNeedSettle = true;
                    break;
                }
                if (!isNeedSettle) continue;
                needSettleBillList.add(apPaySettleBill);
            }
            if (!needSettleBillList.isEmpty()) {
                existHasPremiumBillIds = new ArrayList<Long>(8);
                for (DynamicObject dynamicObject : needSettleBillList) {
                    BigDecimal disposeAmount2 = dynamicObject.getBigDecimal("premiumamt");
                    if (disposeAmount2.compareTo(BigDecimal.ZERO) == 0) continue;
                    existHasPremiumBillIds.add(dynamicObject.getLong("id"));
                }
                if (existHasPremiumBillIds.size() > 0) {
                    for (DynamicObject finApBill : existHasPremiumBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", FinApBillHandleHelper.getLockWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", existHasPremiumBillIds)})) {
                        disposeAmount = finApBill.getBigDecimal("premiumamt");
                        FinApExitPremiumWBServiceHelper.occupy((DynamicObject)finApBill, (BigDecimal)disposeAmount);
                    }
                    SaveServiceHelper.save((DynamicObject[])existHasPremiumBills);
                }
            }
            if (!settleByPreEntryBillList.isEmpty()) {
                this.doSettleByPreEntry(settleByPreEntryBillList);
            }
            if (!settleByCoreBillBillList.isEmpty()) {
                HashMap<String, List> needCoreSettleByModelMap = new HashMap<String, List>(8);
                existHasPremiumBills = settleByCoreBillBillList.iterator();
                while (existHasPremiumBills.hasNext()) {
                    DynamicObject dynamicObject = (DynamicObject)existHasPremiumBills.next();
                    long orgId = dynamicObject.getLong("org.id");
                    Map orgParametersMap = (Map)appParametersMap.get(orgId);
                    if (ObjectUtils.isEmpty((Object)orgParametersMap)) continue;
                    settleModel = (String)orgParametersMap.get("ap_003");
                    List tempFinApBills = needCoreSettleByModelMap.getOrDefault(settleModel, new ArrayList(64));
                    tempFinApBills.add(dynamicObject);
                    needCoreSettleByModelMap.put(settleModel, tempFinApBills);
                }
                Map paidBillIdsMap = SettleServiceHelper.getPaidBillIdsByCoreBill(settleByCoreBillBillList, (Map)appParametersMap);
                Map map = SettleServiceHelper.getPayBillIdsByCoreBill(settleByCoreBillBillList, (Map)appParametersMap);
                for (Map.Entry entrySet : needCoreSettleByModelMap.entrySet()) {
                    SettleParam settleParam;
                    String settleModel2 = (String)entrySet.getKey();
                    List finApBills = (List)entrySet.getValue();
                    Set apBillIds = finApBills.stream().map(apBill -> apBill.getLong("id")).collect(Collectors.toSet());
                    Set paidBillIds = (Set)paidBillIdsMap.get(settleModel2);
                    Set payBillIds = (Set)map.get(settleModel2);
                    if (!ObjectUtils.isEmpty((Object)paidBillIds)) {
                        settleParam = new SettleParam();
                        settleParam.setMainBillIds(apBillIds).setAsstBillIds(paidBillIds).setAsstEntity("ap_paidbill").setOnlyByCoreBill(true).setMainOp(true);
                        apSettleRecordService.apPaySettle(settleParam);
                    }
                    if (ObjectUtils.isEmpty((Object)payBillIds)) continue;
                    CommonSettleServiceHelper.settleAddMutexCtrlInTX((Set)payBillIds, (String)"cas_paybill", (boolean)true);
                    TxSettleServiceHelper.validatePayBillIsExistUnfinishedTx(payBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                    settleParam = new SettleParam();
                    settleParam.setMainBillIds(apBillIds).setAsstBillIds(payBillIds).setOnlyByCoreBill(true).setMainOp(true);
                    apSettleRecordService.apPaySettle(settleParam);
                }
            }
            if (!settleByConbillnumberBillList.isEmpty()) {
                HashMap<String, List> needSettleByModelMap = new HashMap<String, List>(8);
                for (DynamicObject dynamicObject : settleByConbillnumberBillList) {
                    long orgId = dynamicObject.getLong("org.id");
                    Map orgParametersMap = (Map)appParametersMap.get(orgId);
                    if (ObjectUtils.isEmpty((Object)orgParametersMap)) continue;
                    settleModel = (String)orgParametersMap.get("ap_003");
                    List tempFinApBills = needSettleByModelMap.getOrDefault(settleModel, new ArrayList(64));
                    tempFinApBills.add(dynamicObject);
                    needSettleByModelMap.put(settleModel, tempFinApBills);
                }
                Map payBillIdsMap = SettleServiceHelper.getPayBillIdsByConBill(settleByConbillnumberBillList, (Map)appParametersMap);
                for (Map.Entry entrySet : needSettleByModelMap.entrySet()) {
                    String settleModel3 = (String)entrySet.getKey();
                    List finApBills = (List)entrySet.getValue();
                    Set apBillIds = finApBills.stream().map(apBill -> apBill.getLong("id")).collect(Collectors.toSet());
                    Set payBillIds = (Set)payBillIdsMap.get(settleModel3);
                    if (ObjectUtils.isEmpty((Object)payBillIds)) continue;
                    CommonSettleServiceHelper.settleAddMutexCtrlInTX((Set)payBillIds, (String)"cas_paybill", (boolean)true);
                    TxSettleServiceHelper.validatePayBillIsExistUnfinishedTx(payBillIds.stream().map(String::valueOf).collect(Collectors.toList()));
                    SettleParam settleParam = new SettleParam();
                    settleParam.setMainBillIds(apBillIds).setAsstBillIds(payBillIds).setOnlyByConBill(true).setMainOp(true);
                    apSettleRecordService.apPaySettle(settleParam);
                }
            }
            if (!needSettleBillList.isEmpty()) {
                existHasPremiumBillIds = new ArrayList(8);
                for (DynamicObject dynamicObject : needSettleBillList) {
                    BigDecimal disposeAmount3 = dynamicObject.getBigDecimal("premiumamt");
                    if (disposeAmount3.compareTo(BigDecimal.ZERO) == 0) continue;
                    existHasPremiumBillIds.add(dynamicObject.getLong("id"));
                }
                if (existHasPremiumBillIds.size() > 0) {
                    for (DynamicObject finApBill : existHasPremiumBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)String.join((CharSequence)",", FinApBillHandleHelper.getLockWBSelector()), (QFilter[])new QFilter[]{new QFilter("id", "in", existHasPremiumBillIds)})) {
                        disposeAmount = finApBill.getBigDecimal("premiumamt");
                        FinApExitPremiumWBServiceHelper.release((DynamicObject)finApBill, (BigDecimal)disposeAmount);
                    }
                    SaveServiceHelper.save((DynamicObject[])existHasPremiumBills);
                }
            }
        }
    }

    @Deprecated
    private boolean isCheckAutoSettle(long orgId) {
        Boolean checkAutoSettle = this.checkAutoSettleMap.get(orgId);
        if (checkAutoSettle == null) {
            checkAutoSettle = (Boolean)SystemParameterHelper.getAPAppParameter((Long)orgId, (String)"hihn_finapbill_check");
            checkAutoSettle = checkAutoSettle == null ? Boolean.TRUE : checkAutoSettle;
            this.checkAutoSettleMap.put(orgId, checkAutoSettle);
        }
        return checkAutoSettle;
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        HashSet<String> lst = new HashSet<String>(50);
        lst.add("org");
        lst.add("billno");
        lst.add("bizdate");
        lst.add("duedate");
        lst.add("asstacttype");
        lst.add("asstactname");
        lst.add("billtypeid");
        lst.add("amount");
        lst.add("pricetaxtotal");
        lst.add("currency");
        lst.add("isadjust");
        lst.add("tax");
        lst.add("pricetax");
        lst.add("material");
        lst.add("unsettleamt");
        lst.add("settledamt");
        lst.add("corebillno");
        lst.add("corebillentryseq");
        lst.add("groupnumber");
        lst.add("groupseq");
        lst.add("payproperty");
        lst.add("payproperty.isbasedonamt");
        lst.add("asstact");
        lst.add("verifystatus");
        lst.add("settlestatus");
        lst.add("expenseitem");
        lst.add("measureunit");
        lst.add("e_unverifyamount");
        lst.add("verifyamount");
        lst.add("quantity");
        lst.add("unverifyquantity");
        lst.add("verifyquantity");
        lst.add("e_sourcebillentryid");
        lst.add("sourcebilltype");
        lst.add("sourcebillid");
        lst.add("istanspay");
        lst.add("iswrittenoff");
        lst.add("corebillid");
        lst.add("corebillentryid");
        lst.add("e_pricetaxtotal");
        lst.add("e_pricetaxtotalbase");
        lst.add("ispresent");
        lst.add("price");
        lst.add("actprice");
        lst.add("actpricetax");
        lst.add("exchangerate");
        lst.add("basecurrency");
        lst.add("paycond");
        lst.add("unsettleamount");
        lst.add("e_baseunit");
        lst.add("e_unitconvertrate");
        lst.add("e_baseunitqty");
        lst.add("e_prepayrate");
        lst.add("e_isallverify");
        lst.add("unlockamt");
        lst.add("lockedamt");
        lst.add("e_materialversion");
        lst.add("spectype");
        lst.add("e_assistantattr");
        lst.add("configuredcode");
        lst.add("tracknumber");
        lst.add("isperiod");
        lst.add("planduedate");
        lst.add("planpricetax");
        lst.add("plansettledamt");
        lst.add("unplansettleamt");
        lst.add("unplanlockamt");
        lst.add("planlockedamt");
        lst.add("e_amount");
        lst.add("e_amountbase");
        lst.add("e_tax");
        lst.add("e_sourcebillid");
        lst.add("ispremium");
        lst.add("premiumamt");
        lst.add("premiumrate");
        lst.add("corebilltype");
        lst.add("bookdate");
        lst.add("istaxdeduction");
        lst.add("preentry.seq");
        lst.add("y_billid");
        lst.add("y_billtype");
        lst.add("y_settleamt");
        lst.add("y_billno");
        lst.add("y_billentryid");
        lst.add("quotation");
        lst.add("e_conbillentity");
        lst.add("e_conbillid");
        lst.add("e_conbillentryid");
        lst.add("biztype");
        lst.add("receivingsupplierid");
        lst.add("inventry");
        lst.add("i_billno");
        lst.add("i_serialno");
        lst.add("invid");
        lst.add("e_prepaid");
        lst.add("detailentry.linetype");
        lst.add("iswrittenoff");
        lst.add("hadwrittenoff");
        lst.add("detailentry.seq");
        lst.add("detailentry.taxrate");
        lst.add("inventry.invid");
        lst.add("inventry.i_usedamt");
        lst.add("inventry.seq");
        lst.add("inventry.i_billno");
        lst.add("inventry.i_invoicetype");
        lst.add("inventry.i_invoicetypef7");
        lst.add("inventry.i_invoicecode");
        lst.add("inventry.i_currency");
        lst.add("inventry.i_invoiceno");
        lst.add("inventry.i_invoicedate");
        lst.add("inventry.i_pricetaxtotal");
        lst.add("inventry.i_taxrate");
        lst.add("inventry.i_tax");
        lst.add("inventry.i_srctype");
        lst.add("inventry.i_amount");
        lst.add("inventry.i_asstactname");
        lst.add("inventry.i_buyername");
        lst.add("inventry.i_istaxdeduction");
        lst.add("inventry.i_remark");
        lst.add("inventry.i_serialno");
        lst.add("inventry.i_issupplement");
        lst.add("inventry.i_invoicestatus");
        lst.add("detailentry.e_splitdimensionid");
        lst.add("settlementtype");
        lst.add("planentity.seq");
        lst.add("planentity.p_splitdimensionid");
        lst.add("planentity.planpricetaxloc");
        lst.add("planentity.unplansettlelocamt");
        lst.add("planentity.e_freezestate");
        lst.add("planentity.p_payrate");
        lst.addAll(FinApBillHandleHelper.getSelector());
        fieldKeys.addAll(lst);
    }

    private void directSourPurVerify(Set<Long> apBillPksPurSour, DynamicObject[] entities) {
        logger.info("apautoverify:apBillPksPurSour-" + apBillPksPurSour);
        if (apBillPksPurSour != null && apBillPksPurSour.size() > 0) {
            HashSet<Long> purInBillIds = new HashSet<Long>(apBillPksPurSour.size());
            for (DynamicObject entity : entities) {
                long pk = entity.getLong("id");
                if (!apBillPksPurSour.contains(pk)) continue;
                DynamicObjectCollection entries = entity.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entries) {
                    String sourcebillId = entry.getString("e_sourcebillid");
                    if (!StringUtils.isNotEmpty((String)sourcebillId)) continue;
                    purInBillIds.add(Long.parseLong(sourcebillId));
                }
            }
            SettleSchemeVO scheme = new SettleSchemeVO();
            scheme.setOnlyByBotp(true);
            ApPurAutoVerifyService verifyService = new ApPurAutoVerifyService("im_purinbill", purInBillIds);
            this.doAutoVerify("im_purinbill", purInBillIds, apBillPksPurSour, scheme, (IAutoVerifyService)verifyService);
            ExecCtrlHelper.execCustomizeCtrlService((String)"SZJK-PRE-0031", null, (Object[])new Object[]{"ap_finapbill", apBillPksPurSour});
        }
    }

    private void directSourOminVerify(Set<Long> apBillPksOminSour, DynamicObject[] entities, String entityKey) {
        logger.info("apautoverify:apBillPksOminSour-" + apBillPksOminSour);
        if (apBillPksOminSour != null && apBillPksOminSour.size() > 0) {
            HashSet<Long> omInBillIds = new HashSet<Long>(apBillPksOminSour.size());
            for (DynamicObject entity : entities) {
                long pk = entity.getLong("id");
                if (!apBillPksOminSour.contains(pk)) continue;
                DynamicObjectCollection entries = entity.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : entries) {
                    String sourcebillId = entry.getString("e_sourcebillid");
                    if (!StringUtils.isNotEmpty((String)sourcebillId)) continue;
                    omInBillIds.add(Long.parseLong(sourcebillId));
                }
            }
            SettleSchemeVO scheme = new SettleSchemeVO();
            scheme.setOnlyByBotp(true);
            ApOminAutoVerifyService verifyService = new ApOminAutoVerifyService(entityKey, omInBillIds);
            this.doAutoVerify(entityKey, omInBillIds, apBillPksOminSour, scheme, (IAutoVerifyService)verifyService);
        }
    }

    private void doAutoVerify(String mainEntity, Set<Long> mainIds, Set<Long> asstIds, SettleSchemeVO scheme, IAutoVerifyService verifyService) {
        CommonVerifyServiceHelper.verifyAddMutexCtrlInTX(mainIds, (String)mainEntity, asstIds, (String)"ap_finapbill", (boolean)true);
        verifyService.autoVerify(mainIds, asstIds, scheme);
    }

    private void doSettleByPreEntry(List<DynamicObject> settleByPreEntryBillList) {
        Object[] paidArr;
        HashMap<String, HashSet<Long>> preInfoMap = new HashMap<String, HashSet<Long>>(settleByPreEntryBillList.size());
        for (DynamicObject bill : settleByPreEntryBillList) {
            DynamicObjectCollection preEntry = bill.getDynamicObjectCollection("preentry");
            for (DynamicObject row : preEntry) {
                long preBillId = row.getLong("y_billid");
                String preBillType = row.getString("y_billtype");
                BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                HashSet<Long> ids = (HashSet<Long>)preInfoMap.get(preBillType);
                if (ids == null) {
                    ids = new HashSet<Long>(2);
                }
                ids.add(preBillId);
                preInfoMap.put(preBillType, ids);
            }
        }
        HashMap<Long, Map<Long, BigDecimal>> asstUnsettleAmtMap = new HashMap<Long, Map<Long, BigDecimal>>(2);
        HashMap<Long, Map<Long, BigDecimal>> asstOrgAmtMap = new HashMap<Long, Map<Long, BigDecimal>>(2);
        Set payIds = (Set)preInfoMap.get("cas_paybill");
        Set paidIds = (Set)preInfoMap.get("ap_paidbill");
        Object[] payArr = this.payValidateBeforeSettle(payIds, asstUnsettleAmtMap, asstOrgAmtMap, settleByPreEntryBillList);
        Object[] payMergeArr = (DynamicObject[])ArrayUtils.addAll((Object[])payArr, (Object[])(paidArr = this.paidValidateBeforeSettle(paidIds, asstUnsettleAmtMap, asstOrgAmtMap, settleByPreEntryBillList)));
        if (ObjectUtils.isEmpty((Object[])payMergeArr)) {
            return;
        }
        List tempVOs = PayBillHandleHelper.getAsstListVO((DynamicObject[])payMergeArr);
        Map<Long, List<BillSettleVO>> entryIdVOMap = tempVOs.stream().collect(Collectors.groupingBy(BillSettleVO::getEntryId));
        if (!ObjectUtils.isEmpty(asstUnsettleAmtMap)) {
            Map<Long, List<DynamicObject>> collect = settleByPreEntryBillList.stream().collect(Collectors.groupingBy(finBill -> finBill.getLong("org.id")));
            Map orgSettleEntry = ArApHelper.batchGetApSettleParam(collect.keySet());
            ApPaySettleService service = new ApPaySettleService();
            for (Map.Entry<Long, List<DynamicObject>> entry : collect.entrySet()) {
                DynamicObject[] mainArr;
                Long orgId = entry.getKey();
                int settleEntry = (Integer)orgSettleEntry.get(orgId);
                SettleSchemeVO scheme = new SettleSchemeVO();
                scheme.setSettle(true);
                scheme.setSettleEntryParam(settleEntry);
                scheme.setMatchServiceClass("kd.fi.arapcommon.service.match.PreEntrySettleMatchService");
                ArrayList<BillSettleVO> asstListVO = new ArrayList<BillSettleVO>(1);
                for (DynamicObject finBill2 : settleByPreEntryBillList) {
                    BigDecimal canSettleAmt;
                    long asstId;
                    long id = finBill2.getLong("id");
                    String mainBillno = finBill2.getString("billno");
                    int rowIndex = 1;
                    boolean isMergeRows = ((DynamicObject)finBill2.getDynamicObjectCollection("preentry").get(0)).getLong("y_billentryid") != 0L ? Boolean.TRUE : Boolean.FALSE;
                    if (isMergeRows) {
                        for (DynamicObject row : finBill2.getDynamicObjectCollection("preentry")) {
                            asstId = row.getLong("y_billid");
                            long asstEntryId = row.getLong("y_billentryid");
                            String asstBillno = row.getString("y_billno");
                            BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                            if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                            canSettleAmt = (BigDecimal)((Map)asstUnsettleAmtMap.get(asstId)).get(asstEntryId);
                            if (canSettleAmt.abs().compareTo(settleAmt.abs()) < 0) {
                                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u7b2c%2$s\u884c\u5173\u8054\u7684\u9884\u4ed8\u6b3e\u5355%3$s\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinanceApBillAuditOp_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), mainBillno, rowIndex, asstBillno));
                            }
                            BillSettleVO tempVO = entryIdVOMap.get(asstEntryId).get(0);
                            BillSettleVO billSettleVO = (BillSettleVO)tempVO.clone();
                            billSettleVO.setEntryUnSettleAmt(settleAmt);
                            HashMap<String, Long> resultExtMap = new HashMap<String, Long>(1);
                            resultExtMap.put("billId", id);
                            resultExtMap.putAll(tempVO.getExtFields());
                            billSettleVO.setExtFields(resultExtMap);
                            asstListVO.add(billSettleVO);
                            ++rowIndex;
                            canSettleAmt = canSettleAmt.subtract(settleAmt);
                            ((Map)asstUnsettleAmtMap.get(asstId)).put(asstEntryId, canSettleAmt);
                            Map orgIdAmtMap = (Map)asstOrgAmtMap.get(asstId);
                            BigDecimal billCanSettleAmt = (BigDecimal)orgIdAmtMap.get(orgId);
                            orgIdAmtMap.put(orgId, billCanSettleAmt.subtract(settleAmt));
                            asstOrgAmtMap.put(asstId, orgIdAmtMap);
                        }
                        continue;
                    }
                    for (DynamicObject row : finBill2.getDynamicObjectCollection("preentry")) {
                        asstId = row.getLong("y_billid");
                        String asstBillno = row.getString("y_billno");
                        BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                        if (settleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                        Map entryIdAmtMap = (Map)asstUnsettleAmtMap.get(asstId);
                        Map orgIdAmtMap = (Map)asstOrgAmtMap.get(asstId);
                        canSettleAmt = (BigDecimal)orgIdAmtMap.get(orgId);
                        if (canSettleAmt.abs().compareTo(settleAmt.abs()) < 0) {
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u7b2c%2$s\u884c\u5173\u8054\u7684\u9884\u4ed8\u6b3e\u5355%3$s\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinanceApBillAuditOp_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), mainBillno, rowIndex, asstBillno));
                        }
                        for (Map.Entry entry2 : entryIdAmtMap.entrySet()) {
                            HashMap<String, Long> resultExtMap;
                            BillSettleVO newVO;
                            BigDecimal entryCanSettleAmt;
                            if (settleAmt.compareTo(BigDecimal.ZERO) == 0) break;
                            long entryId = (Long)entry2.getKey();
                            BillSettleVO tempVO = entryIdVOMap.get(entryId).get(0);
                            long entryOrgId = tempVO.getOrgId();
                            if (entryOrgId != orgId || (entryCanSettleAmt = (BigDecimal)entry2.getValue()).compareTo(BigDecimal.ZERO) == 0) continue;
                            if (settleAmt.abs().compareTo(entryCanSettleAmt.abs()) <= 0) {
                                newVO = (BillSettleVO)tempVO.clone();
                                newVO.setEntryUnSettleAmt(settleAmt);
                                resultExtMap = new HashMap<String, Long>(1);
                                resultExtMap.put("billId", id);
                                resultExtMap.putAll(tempVO.getExtFields());
                                newVO.setExtFields(resultExtMap);
                                asstListVO.add(newVO);
                                ++rowIndex;
                                orgIdAmtMap.put(orgId, canSettleAmt.subtract(settleAmt));
                                entryCanSettleAmt = entryCanSettleAmt.subtract(settleAmt);
                                settleAmt = BigDecimal.ZERO;
                                entry2.setValue(entryCanSettleAmt);
                                continue;
                            }
                            newVO = (BillSettleVO)tempVO.clone();
                            newVO.setEntryUnSettleAmt(entryCanSettleAmt);
                            resultExtMap = new HashMap(1);
                            resultExtMap.put("billId", id);
                            resultExtMap.putAll(tempVO.getExtFields());
                            newVO.setExtFields(resultExtMap);
                            asstListVO.add(newVO);
                            ++rowIndex;
                            orgIdAmtMap.put(orgId, BigDecimal.ZERO);
                            settleAmt = settleAmt.subtract((BigDecimal)entry2.getValue());
                            entry2.setValue(BigDecimal.ZERO);
                        }
                        asstOrgAmtMap.put(asstId, orgIdAmtMap);
                    }
                }
                if (ObjectUtils.isEmpty(asstListVO)) continue;
                Set mainBillIds = entry.getValue().stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
                for (DynamicObject obj : mainArr = FinApBillHandleHelper.load((QFilter[])new QFilter[]{new QFilter("id", "in", mainBillIds)})) {
                    DynamicObjectCollection detailEntry = obj.getDynamicObjectCollection("detailentry");
                    for (DynamicObject row : detailEntry) {
                        row.set("settledamt", row.get("lockedamt"));
                        row.set("unsettleamt", row.get("unlockamt"));
                    }
                    DynamicObjectCollection planEntry = obj.getDynamicObjectCollection("planentity");
                    for (DynamicObject row : planEntry) {
                        row.set("plansettledamt", row.get("planlockedamt"));
                        row.set("unplansettleamt", row.get("unplanlockamt"));
                    }
                }
                List mainListVO = FinApBillHandleHelper.getMainListVO((DynamicObject[])mainArr, (SettleSchemeVO)scheme);
                for (BillSettleVO settleVO : mainListVO) {
                    Map extFields = settleVO.getExtFields();
                    extFields.put("billId", settleVO.getId());
                    settleVO.setExtFields(extFields);
                }
                service.settleByVO(mainListVO, asstListVO, scheme, SettleTypeEnum.AUTO.getValue());
            }
        }
    }

    private DynamicObject[] payValidateBeforeSettle(Set<Long> payIds, Map<Long, Map<Long, BigDecimal>> asstUnsettleAmtMap, Map<Long, Map<Long, BigDecimal>> asstOrgAmtMap, List<DynamicObject> settleByPreEntryBillList) {
        if (ObjectUtils.isEmpty(payIds)) {
            return null;
        }
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(payIds, (String)"cas_paybill", (boolean)true);
        TxSettleServiceHelper.validatePayBillIsExistUnfinishedTx(payIds.stream().map(String::valueOf).collect(Collectors.toList()));
        Object[] assts = PayBillHandleHelper.loadPay((QFilter[])new QFilter[]{new QFilter("id", "in", payIds)});
        HashSet<Long> asstIds = new HashSet<Long>(payIds.size());
        for (Object asst : assts) {
            long id = asst.getLong("id");
            HashMap<Long, BigDecimal> orgUnSettleAmtMap = new HashMap<Long, BigDecimal>(2);
            DynamicObjectCollection entry = asst.getDynamicObjectCollection("entry");
            LinkedHashMap<Long, BigDecimal> entryIdAmtMap = new LinkedHashMap<Long, BigDecimal>(1);
            for (DynamicObject row : entry) {
                DynamicObject paymentType = row.getDynamicObject("e_paymenttype");
                long entryOrgId = row.getLong("settleorg.id");
                if (ObjectUtils.isEmpty((Object)paymentType) || !paymentType.getBoolean("ispartpayment") || !"202".equals(paymentType.getString("biztype"))) continue;
                long entryId = row.getLong("id");
                BigDecimal unSettleAmt = row.getBigDecimal("e_unsettledamt");
                if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                entryIdAmtMap.put(entryId, unSettleAmt);
                BigDecimal orgUnSettleAmt = (BigDecimal)orgUnSettleAmtMap.get(entryOrgId);
                if (orgUnSettleAmt == null) {
                    orgUnSettleAmt = BigDecimal.ZERO;
                }
                orgUnSettleAmt = orgUnSettleAmt.add(unSettleAmt);
                orgUnSettleAmtMap.put(entryOrgId, orgUnSettleAmt);
            }
            asstUnsettleAmtMap.put(id, entryIdAmtMap);
            asstOrgAmtMap.put(id, orgUnSettleAmtMap);
            asstIds.add(id);
        }
        if (ObjectUtils.isEmpty((Object[])assts) || payIds.size() != assts.length) {
            for (DynamicObject finBill : settleByPreEntryBillList) {
                DynamicObjectCollection preEntry = finBill.getDynamicObjectCollection("preentry");
                for (DynamicObject row : preEntry) {
                    long preBillId = row.getLong("y_billid");
                    String preBillType = row.getString("y_billtype");
                    if (asstIds.contains(preBillId) || !"cas_paybill".equals(preBillType)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u6ca1\u6709\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u9884\u4ed8\u6b3e\u5355%2$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinanceApBillAuditOp_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), finBill.getString("billno"), row.getString("y_billno")));
                }
            }
        }
        return assts;
    }

    private DynamicObject[] paidValidateBeforeSettle(Set<Long> paidIds, Map<Long, Map<Long, BigDecimal>> asstUnsettleAmtMap, Map<Long, Map<Long, BigDecimal>> asstOrgAmtMap, List<DynamicObject> settleByPreEntryBillList) {
        if (ObjectUtils.isEmpty(paidIds)) {
            return null;
        }
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(paidIds, (String)"ap_paidbill", (boolean)true);
        Object[] assts = PayBillHandleHelper.loadPaid((QFilter[])new QFilter[]{new QFilter("id", "in", paidIds)});
        HashSet<Long> asstIds = new HashSet<Long>(paidIds.size());
        for (Object asst : assts) {
            long id = asst.getLong("id");
            DynamicObjectCollection entry = asst.getDynamicObjectCollection("entry");
            LinkedHashMap<Long, BigDecimal> entryIdAmtMap = new LinkedHashMap<Long, BigDecimal>(1);
            HashMap<Long, BigDecimal> orgUnSettleAmtMap = new HashMap<Long, BigDecimal>(2);
            BigDecimal orgUnSettleAmt = BigDecimal.ZERO;
            for (DynamicObject row : entry) {
                long entryId = row.getLong("id");
                BigDecimal unSettleAmt = row.getBigDecimal("e_unsettledamt");
                if (unSettleAmt.compareTo(BigDecimal.ZERO) == 0) continue;
                entryIdAmtMap.put(entryId, unSettleAmt);
                orgUnSettleAmt = orgUnSettleAmt.add(unSettleAmt);
            }
            orgUnSettleAmtMap.put(asst.getLong("org.id"), orgUnSettleAmt);
            asstOrgAmtMap.put(id, orgUnSettleAmtMap);
            asstUnsettleAmtMap.put(id, entryIdAmtMap);
            asstIds.add(id);
        }
        if (ObjectUtils.isEmpty((Object[])assts) || paidIds.size() != assts.length) {
            for (DynamicObject finBill : settleByPreEntryBillList) {
                DynamicObjectCollection preEntry = finBill.getDynamicObjectCollection("preentry");
                for (DynamicObject row : preEntry) {
                    long preBillId = row.getLong("y_billid");
                    String preBillType = row.getString("y_billtype");
                    if (asstIds.contains(preBillId) || !"ap_paidbill".equals(preBillType)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355%1$s\u6ca1\u6709\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u9884\u4ed8\u6b3e\u5355%2$s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinanceApBillAuditOp_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), finBill.getString("billno"), row.getString("y_billno")));
                }
            }
        }
        return assts;
    }

    private void processAsst(List<DynamicObject> asstArr, Map<Long, BigDecimal> preEntryCurrentAmt) {
        Set<Long> asstEntryIdSet = preEntryCurrentAmt.keySet();
        for (DynamicObject asstObj : asstArr) {
            DynamicObjectCollection entrys = asstObj.getDynamicObjectCollection("entry");
            for (int i = entrys.size() - 1; i >= 0; --i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                long entryId = entry.getLong("id");
                BigDecimal unSettleAmt = entry.getBigDecimal("e_unsettledamt");
                if (asstEntryIdSet.contains(entryId)) {
                    BigDecimal curSettleAmt = preEntryCurrentAmt.get(entryId);
                    int comparevalue = unSettleAmt.abs().compareTo(curSettleAmt.abs());
                    curSettleAmt = comparevalue >= 0 ? curSettleAmt : unSettleAmt;
                    entry.set("e_unsettledamt", (Object)curSettleAmt);
                    continue;
                }
                entrys.remove(i);
            }
        }
    }

    private void updateUnitCoefficient(DynamicObject[] finBills) {
        HashMap<String, BigDecimal> covertRateCacheMap = new HashMap<String, BigDecimal>(2);
        for (DynamicObject finBill : finBills) {
            DynamicObjectCollection details = finBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject detailRow : details) {
                BigDecimal covertRate;
                if (BigDecimal.ZERO.compareTo(detailRow.getBigDecimal("e_unitconvertrate")) != 0) continue;
                DynamicObject material = detailRow.getDynamicObject("material");
                DynamicObject measureUnit = detailRow.getDynamicObject("measureunit");
                if (!ObjectUtils.isEmpty((Object)material)) {
                    String key;
                    DynamicObject baseUnit = material.getDynamicObject("baseunit");
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    if ((covertRate = (BigDecimal)covertRateCacheMap.get(key = String.format("%s_%s_%s", material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id")))) == null) {
                        covertRate = InitConvertHelper.getUnitRateConv((Long)material.getLong("id"), (Long)measureUnit.getLong("id"), (Long)baseUnit.getLong("id"));
                        covertRate = covertRate == null ? BigDecimal.ONE : covertRate;
                        covertRateCacheMap.put(key, covertRate);
                    }
                } else {
                    covertRate = BigDecimal.ONE;
                }
                detailRow.set("e_unitconvertrate", (Object)covertRate);
            }
        }
    }

    private void pushToArBills(DynamicObject[] apBusBills) {
        HashSet<Long> pushArSet = new HashSet<Long>(8);
        for (DynamicObject apBill : apBusBills) {
            String billTypeNum = apBill.getString("billtypeid.number");
            boolean isWOff = apBill.getBoolean("hadwrittenoff");
            boolean isOff = apBill.getBoolean("iswrittenoff");
            DynamicObjectCollection apEntrys = apBill.getDynamicObjectCollection("detailentry");
            Set isPrepaidSet = apEntrys.stream().filter(t -> t.getBoolean("e_prepaid")).collect(Collectors.toSet());
            if (!"ApFin_purfee_BT_S".equals(billTypeNum) && !"ApFin_salefee_BT_S".equals(billTypeNum) && !"ApFin_borr_BT_S".equals(billTypeNum) || isPrepaidSet.size() <= 0 || isOff || isWOff) continue;
            pushArSet.add(apBill.getLong("id"));
        }
        if (pushArSet.size() > 0) {
            CommonParam commonParam = new CommonParam();
            commonParam.put((Object)"prePaidPks", pushArSet);
            commonParam.put((Object)"entityKey", (Object)"ap_finapbill");
            ECServiceHelper.beginAndRegisterWithBusInfo((String)"ap_coordination_push", (String)"prepaid_push", (String)"fi", (String)"ap", (String)"CoordAndPrepaidECService", (Param)commonParam, (String)"", new ArrayList(pushArSet));
        }
    }

    private void clearExpenseFileds(DynamicObject[] finBills) {
        if (finBills.length > 0) {
            HashSet srcIds = new HashSet(16);
            for (DynamicObject finBill : finBills) {
                DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
                for (DynamicObject entry : detailEntry) {
                    String expenseTag = entry.getString("e_expensebillids_tag");
                    if (!StringUtils.isNotEmpty((String)expenseTag)) continue;
                    Map expenseMap = (Map)JSON.parseObject((String)expenseTag, Map.class);
                    srcIds.addAll((Collection)expenseMap.get("id"));
                }
            }
            if (srcIds.size() > 0) {
                DynamicObjectCollection outBIlls;
                HashSet imIds = new HashSet(16);
                QFilter[] imIdFilters = new QFilter[]{new QFilter("id", "in", srcIds)};
                DynamicObjectCollection purBills = QueryServiceHelper.query((String)"im_purinbill", (String)"id", (QFilter[])imIdFilters);
                if (purBills.size() > 0) {
                    Set purIds = purBills.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
                    imIds.addAll(purIds);
                }
                if ((outBIlls = QueryServiceHelper.query((String)"im_saloutbill", (String)"id", (QFilter[])imIdFilters)).size() > 0) {
                    Set outIds = outBIlls.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
                    imIds.addAll(outIds);
                }
                for (DynamicObject finBill : finBills) {
                    DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
                    for (DynamicObject entry : detailEntry) {
                        Map expenseMap;
                        String expenseTag = entry.getString("e_expensebillids_tag");
                        if (!StringUtils.isNotEmpty((String)expenseTag) || imIds.containsAll((Collection)(expenseMap = (Map)JSON.parseObject((String)expenseTag, Map.class)).get("id"))) continue;
                        entry.set("e_expensebillids_tag", (Object)"");
                    }
                }
            }
        }
    }
}

