/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.fi.ap.helper.FinapPremHelper;
import kd.fi.ap.mservice.ApAdjustAutoSettleService;
import kd.fi.ap.mservice.ApPayAutoSettleService;
import kd.fi.ap.mservice.PremAutoSettleService;
import kd.fi.ap.mservice.SettleServiceFactory;
import kd.fi.ap.mservice.TranspayAutoSettleService;
import kd.fi.ap.mservice.helper.VerifyServiceHelper;
import kd.fi.ap.mservice.verify.ApPurAutoVerifyService;
import kd.fi.ap.mservice.verify.VerifyServiceFactory;
import kd.fi.ap.validator.FinApBillUnAuditPushValidator;
import kd.fi.ap.validator.FinApBillUnAuditSrcBusRevalValidator;
import kd.fi.ap.validator.FinApBillUnAuditValidator;
import kd.fi.ap.validator.WrittenOffBillUnAuditValidator;
import kd.fi.arapcommon.enums.APSettleStatusEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.ArApProcessParamsHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.AbstractVerifyTemplate;
import kd.fi.arapcommon.service.bus.ApWoffService;
import kd.fi.arapcommon.service.buswoff.BusBotpWoffFromFinap;
import kd.fi.arapcommon.service.buswoff.BusCoreBillWoffFromFinap;
import kd.fi.arapcommon.service.buswoff.BusGroupWoffFromFinap;
import kd.fi.arapcommon.service.buswoff.BusSameSourceWoffFromFinap;
import kd.fi.arapcommon.service.buswoff.BusWoffHelper;
import kd.fi.arapcommon.service.buswoff.BusWoffResult;
import kd.fi.arapcommon.service.concurrency.ConcuCtrlBizEnum;
import kd.fi.arapcommon.service.concurrency.ConcurrencyCtrlUtil;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.ValidOperationServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.validator.PayBillStatusValidator;
import kd.fi.arapcommon.validator.PeriodAuditOrUnauditValidator;
import kd.fi.arapcommon.validator.VerifyECUnFinishValidator;

public class FinanceApBillUnAuditOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(FinanceApBillUnAuditOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PeriodAuditOrUnauditValidator());
        e.addValidator((AbstractValidator)new FinApBillUnAuditValidator());
        e.addValidator((AbstractValidator)new FinApBillUnAuditPushValidator());
        e.addValidator((AbstractValidator)new PayBillStatusValidator());
        e.addValidator((AbstractValidator)new VerifyECUnFinishValidator());
        e.addValidator((AbstractValidator)new WrittenOffBillUnAuditValidator());
        e.addValidator((AbstractValidator)new FinApBillUnAuditSrcBusRevalValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction start");
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction writeoffbus start");
        try {
            BusWoffHelper.finWriteOffWriteBackBusForUnAudit((boolean)false, (DynamicObject[])e.getDataEntities());
        }
        catch (KDException e1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u51b2\u9500\u51b2\u56de\u5931\u8d25\uff1a%s", (String)"FinanceApBillUnAuditOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), e1.getMessage()));
        }
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction writeoffbus end");
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction executeUnWoff start");
        this.executeUnWoff(entities);
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction executeUnWoff end");
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction executeCoordintion start");
        this.executeCoordintion(entities);
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction executeCoordintion end");
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction deleteOtherFinArBill start");
        this.deleteOtherFinArBill(entities);
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction deleteOtherFinArBill end");
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction deletePremiumBill start");
        this.deletePremiumBill(entities);
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction deletePremiumBill end");
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction validBill start");
        this.validBill(entities);
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction validBill end");
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction writeBackScmcBill start");
        ArApProcessParamsHelper.writeBackScmcBill((DynamicObject[])entities, (boolean)false);
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction writeBackScmcBill end");
        logger.info("FinanceApBillUnAuditOp.beginOperationTransaction end");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        logger.info("FinanceApBillUnAuditOp.endOperationTransaction start");
        this.addWriteOffCtrl(entities);
        logger.info("FinanceApBillUnAuditOp.endOperationTransaction unsettle start");
        this.executeUnSettle(entities);
        logger.info("FinanceApBillUnAuditOp.endOperationTransaction unsettle end");
        logger.info("FinanceApBillUnAuditOp.endOperationTransaction unverify start");
        this.executeUnVerify(entities);
        logger.info("FinanceApBillUnAuditOp.endOperationTransaction unverify end");
        logger.info("FinanceApBillUnAuditOp.endOperationTransaction setCostDiffAmtToZero start");
        this.setCostDiffAmtToZero(entities);
        logger.info("FinanceApBillUnAuditOp.endOperationTransaction setCostDiffAmtToZero end");
        logger.info("FinanceApBillUnAuditOp.endOperationTransaction end");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        logger.info("FinanceApBillUnAuditOp.afterExecuteOperationTransaction start");
        DynamicObject[] finBills = e.getDataEntities();
        Map<Long, List<DynamicObject>> cashBillMap = Stream.of(finBills).filter(finBill -> "CASH".equals(finBill.getString("purmode"))).collect(Collectors.groupingBy(finBill -> finBill.getLong("org.id")));
        ArrayList cashFinBills = new ArrayList(finBills.length);
        for (Map.Entry<Long, List<DynamicObject>> entry : cashBillMap.entrySet()) {
            Long orgId = entry.getKey();
            if (!this.isAutoPushPayBill(orgId)) continue;
            cashFinBills.addAll(cashBillMap.get(orgId));
        }
        List<Long> cashFinBillIds = cashFinBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList());
        Map targetBills = BOTPHelper.findTargetBills((String)"ap_finapbill", (Long[])cashFinBillIds.toArray(new Long[0]));
        HashSet payBillIds = (HashSet)targetBills.get("cas_paybill");
        if (payBillIds == null || payBillIds.isEmpty()) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", (Object)payBillIds);
        DynamicObjectCollection autoPushPayBills = QueryServiceHelper.query((String)"cas_paybill", (String)"id,billstatus", (QFilter[])new QFilter[]{idFilter});
        Set<Long> autoPushPayBillIds = autoPushPayBills.stream().filter(payBill -> "A".equals(payBill.getString("billstatus"))).map(payBill -> payBill.getLong("id")).collect(Collectors.toSet());
        if (ObjectUtils.isEmpty(autoPushPayBillIds)) {
            return;
        }
        this.delCasPayBill(autoPushPayBillIds);
        logger.info("FinanceApBillUnAuditOp.afterExecuteOperationTransaction end");
    }

    private void addWriteOffCtrl(DynamicObject[] entities) {
        DynamicObject[] srcBills;
        Set billIds = Arrays.stream(entities).map(entity -> entity.getLong("id")).collect(Collectors.toSet());
        ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_finapbill", (String)ConcuCtrlBizEnum.WRITEOFF.getValue(), billIds, (boolean)false);
        for (DynamicObject srcBill : srcBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)})) {
            if (!srcBill.getBoolean("hadwrittenoff")) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u5355\u5df2\u7ecf\u88ab\u51b2\u9500\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillSaveOp_3", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }

    private void executeUnSettle(DynamicObject[] entities) {
        Set finBillIds = Arrays.stream(entities).map(entity -> entity.getLong("id")).collect(Collectors.toSet());
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(finBillIds, (String)this.billEntityType.getName(), (boolean)false);
        ArrayList<DynamicObject> needApWriteOffUnSettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needApAdjustUnSettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needApTransPayUnSettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needApPremUnSettleBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needApPayUnSettleBills = new ArrayList<DynamicObject>(1);
        for (DynamicObject entity2 : entities) {
            if (entity2.getBoolean("iswrittenoff")) {
                needApWriteOffUnSettleBills.add(entity2);
                continue;
            }
            if (entity2.getBoolean("ispremium")) {
                needApPremUnSettleBills.add(entity2);
                continue;
            }
            if (entity2.getBoolean("istanspay")) {
                needApTransPayUnSettleBills.add(entity2);
                continue;
            }
            if (entity2.getBoolean("isadjust")) {
                needApAdjustUnSettleBills.add(entity2);
                continue;
            }
            if (APSettleStatusEnum.UNSETTLE.getValue().equals(entity2.getString("settlestatus"))) continue;
            needApPayUnSettleBills.add(entity2);
        }
        if (needApPremUnSettleBills.size() > 0) {
            PremAutoSettleService premAutoSettleService = new PremAutoSettleService();
            premAutoSettleService.unAutoSettle(needApPremUnSettleBills.toArray(new DynamicObject[0]));
        }
        if (needApTransPayUnSettleBills.size() > 0) {
            TranspayAutoSettleService transpayAutoSettleService = new TranspayAutoSettleService();
            transpayAutoSettleService.unAutoSettle(needApTransPayUnSettleBills.toArray(new DynamicObject[0]));
        }
        if (needApAdjustUnSettleBills.size() > 0) {
            ApAdjustAutoSettleService apAdjustAutoSettleService = new ApAdjustAutoSettleService();
            apAdjustAutoSettleService.unAutoSettle(needApAdjustUnSettleBills.toArray(new DynamicObject[0]));
        }
        if (needApPayUnSettleBills.size() > 0) {
            DynamicObject[] needSaveZeroBills;
            ApPayAutoSettleService apPayAutoSettleService = new ApPayAutoSettleService();
            apPayAutoSettleService.unAutoSettle(needApPayUnSettleBills.toArray(new DynamicObject[0]));
            ArrayList<DynamicObject> zeroApBills = new ArrayList<DynamicObject>(1);
            for (DynamicObject apBill : needApPayUnSettleBills) {
                if (!APSettleStatusEnum.SETTLED.getValue().equals(apBill.getString("settlestatus")) || BigDecimal.ZERO.compareTo(apBill.getBigDecimal("pricetaxtotal")) != 0) continue;
                zeroApBills.add(apBill);
            }
            List zeroApBillIds = zeroApBills.stream().map(bill -> bill.getLong("id")).collect(Collectors.toList());
            for (DynamicObject zeroBill : needSaveZeroBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"settlestatus,planpricetax,planpricetaxloc,unplanlockamt,planlockedamt,unplansettleamt,plansettledamt,unplansettlelocamt,plansettledlocamt", (QFilter[])new QFilter[]{new QFilter("id", "in", zeroApBillIds)})) {
                zeroBill.set("settlestatus", (Object)APSettleStatusEnum.UNSETTLE.getValue());
                DynamicObjectCollection planEntries = zeroBill.getDynamicObjectCollection("planentity");
                for (DynamicObject planEntry : planEntries) {
                    BigDecimal planPricetax = planEntry.getBigDecimal("planpricetax");
                    BigDecimal planPricetaxLoc = planEntry.getBigDecimal("planpricetaxloc");
                    planEntry.set("unplanlockamt", (Object)planPricetax);
                    planEntry.set("planlockedamt", (Object)BigDecimal.ZERO);
                    planEntry.set("unplansettleamt", (Object)planPricetax);
                    planEntry.set("plansettledamt", (Object)BigDecimal.ZERO);
                    planEntry.set("unplansettlelocamt", (Object)planPricetaxLoc);
                    planEntry.set("plansettledlocamt", (Object)BigDecimal.ZERO);
                }
            }
            SaveServiceHelper.save((DynamicObject[])needSaveZeroBills);
        }
        if (needApWriteOffUnSettleBills.size() > 0) {
            ArrayList<Long> srcBillIds = new ArrayList<Long>(needApWriteOffUnSettleBills.size());
            for (DynamicObject writeOffBill : needApWriteOffUnSettleBills) {
                long billId = writeOffBill.getLong("id");
                long srcBillId = writeOffBill.getLong("sourcebillid");
                this.writeOff(srcBillId, billId);
                srcBillIds.add(srcBillId);
            }
            FinapPremHelper.writeOff(srcBillIds);
        }
    }

    private void setCostDiffAmtToZero(DynamicObject[] entities) {
        List billIds = Arrays.stream(entities).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", billIds);
        filter.and("detailentry.e_costdiffamount", "<>", (Object)0);
        Object[] finApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,e_costdiffamount", (QFilter[])new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object[])finApBills)) {
            return;
        }
        for (Object finApBill : finApBills) {
            DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
            for (DynamicObject detailRow : detailEntry) {
                detailRow.set("e_costdiffamount", (Object)BigDecimal.ZERO);
            }
        }
        SaveServiceHelper.save((DynamicObject[])finApBills);
    }

    private void executeUnVerify(DynamicObject[] entities) {
        ArrayList<DynamicObject> needUnVerifyWriteOffBills = new ArrayList<DynamicObject>(1);
        ArrayList<DynamicObject> needUnVerifyBills = new ArrayList<DynamicObject>(1);
        for (DynamicObject entity : entities) {
            if (entity.getBoolean("iswrittenoff")) {
                needUnVerifyWriteOffBills.add(entity);
                continue;
            }
            if ("10".equals(entity.getString("verifystatus"))) continue;
            needUnVerifyBills.add(entity);
        }
        if (needUnVerifyBills.size() > 0) {
            ApPurAutoVerifyService service = new ApPurAutoVerifyService();
            Object[] billIds = needUnVerifyBills.stream().map(bill -> bill.getLong("id")).toArray();
            service.unAutoVerify(billIds, false);
        }
        if (needUnVerifyWriteOffBills.size() > 0) {
            ArrayList<Long> writeOffIds = new ArrayList<Long>(needUnVerifyBills.size());
            ArrayList<Long> srcBillIds = new ArrayList<Long>(needUnVerifyBills.size());
            for (DynamicObject writeOffBill : needUnVerifyWriteOffBills) {
                writeOffIds.add(writeOffBill.getLong("id"));
                srcBillIds.add(writeOffBill.getLong("sourcebillid"));
            }
            DynamicObject[] verifyRecords = BusinessDataServiceHelper.load((String)"ap_verifyrecord", (String)this.getVerifyRecordSelects(), (QFilter[])new QFilter[]{new QFilter("billid", "in", srcBillIds), new QFilter("entry.e_billid", "in", writeOffIds)});
            Map verifyRecordMap = VerifyServiceHelper.classfyByRelation((DynamicObject[])verifyRecords);
            for (Map.Entry entry : verifyRecordMap.entrySet()) {
                AbstractVerifyTemplate verifyTemplate = VerifyServiceFactory.getService((String)((String)entry.getKey()));
                verifyTemplate.unVerify(((List)entry.getValue()).toArray(new DynamicObject[0]));
            }
            List mainBillIds = Stream.of(verifyRecords).map(verifyRecord -> verifyRecord.getLong("billid")).collect(Collectors.toList());
            List<Long> historyBillIds = srcBillIds.stream().filter(srcBillId -> !mainBillIds.contains(srcBillId)).collect(Collectors.toList());
            this.historyDataDispose(historyBillIds);
        }
    }

    private void executeCoordintion(DynamicObject[] entities) {
        ArrayList<Object> pks = new ArrayList<Object>(entities.length);
        for (DynamicObject entity : entities) {
            if (!EmptyUtils.isNotEmpty((Object)entity.getPkValue())) continue;
            pks.add(entity.getPkValue());
        }
        if (!pks.isEmpty()) {
            this.delCoordintionBill(pks);
        }
    }

    private void deleteOtherFinArBill(DynamicObject[] finBills) {
        Set pks = Arrays.stream(finBills).map(entity -> entity.getLong("id")).collect(Collectors.toSet());
        QFilter qf = new QFilter("sourcebilltype", "=", (Object)"ap_finapbill");
        qf.and(new QFilter("sourcebillid", "in", pks.stream().map(String::valueOf).collect(Collectors.toList())));
        qf.and(new QFilter("billtype.number", "=", (Object)"arfin_other_BT_S"));
        qf.and(new QFilter("billstatus", "=", (Object)"A"));
        DynamicObjectCollection finArColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{qf});
        if (!ObjectUtils.isEmpty((Object)finArColl)) {
            List finarPks = ArApHelper.getPks((Object)finArColl);
            OperateOption option = OperateOption.create();
            OperationServiceHelper.executeOperate((String)"delete", (String)"ar_finarbill", (Object[])finarPks.toArray(), (OperateOption)option);
        }
    }

    private void executeUnWoff(DynamicObject[] entities) {
        Boolean woffServiceV2 = BusWoffHelper.woffServiceV2();
        logger.info("audit.woff.woffServiceV2:" + woffServiceV2);
        if (woffServiceV2.booleanValue()) {
            ApWoffService woffService = new ApWoffService();
            Set srcBusIds = woffService.initUnWoffDetailInfo(entities);
            if (!ObjectUtils.isEmpty((Object)srcBusIds)) {
                ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_busbill", (String)"woff", (Set)srcBusIds);
            }
            woffService.delWoffBill(entities, srcBusIds);
        } else {
            HashMap<Long, DynamicObject> billMap = new HashMap<Long, DynamicObject>(2);
            for (DynamicObject entity : entities) {
                billMap.put(entity.getLong("id"), entity);
            }
            BusBotpWoffFromFinap busBotpWoff = new BusBotpWoffFromFinap();
            BusWoffResult result = busBotpWoff.busUnWoffBills(billMap.keySet());
            for (Iterator doneBillId : result.getFinBillIds()) {
                billMap.remove(doneBillId);
            }
            if (!ObjectUtils.isEmpty(billMap)) {
                BusSameSourceWoffFromFinap busSameSourceWoff = new BusSameSourceWoffFromFinap();
                result = busSameSourceWoff.busUnWoffBills(billMap.keySet());
                for (Long doneBillId : result.getFinBillIds()) {
                    billMap.remove(doneBillId);
                }
            }
            if (!ObjectUtils.isEmpty(billMap)) {
                BusGroupWoffFromFinap busGroupWoff = new BusGroupWoffFromFinap();
                result = busGroupWoff.busUnWoffBills(billMap.keySet());
                for (Long doneBillId : result.getFinBillIds()) {
                    billMap.remove(doneBillId);
                }
            }
            if (!ObjectUtils.isEmpty(billMap)) {
                BusCoreBillWoffFromFinap busCoreBillWoff = new BusCoreBillWoffFromFinap();
                result = busCoreBillWoff.busUnWoffBills(billMap.keySet());
                for (Long doneBillId : result.getFinBillIds()) {
                    billMap.remove(doneBillId);
                }
            }
            if (!ObjectUtils.isEmpty(billMap)) {
                ApWoffService woffService = new ApWoffService();
                DynamicObject[] historyEntities = billMap.values().toArray(new DynamicObject[0]);
                Set srcBusIds = woffService.initUnWoffDetailInfo(historyEntities);
                if (!ObjectUtils.isEmpty((Object)srcBusIds)) {
                    ConcurrencyCtrlUtil.addCtrlInTX((String)"ap_busbill", (String)"woff", (Set)srcBusIds);
                }
                woffService.delWoffBill(historyEntities, srcBusIds);
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        HashSet<String> props = new HashSet<String>(50);
        props.add("sourcebilltype");
        props.add("billtypeid");
        props.add("bizdate");
        props.add("verifystatus");
        props.add("detailentry");
        props.add("material");
        props.add("measureunit");
        props.add("corebillno");
        props.add("corebillentryseq");
        props.add("groupnumber");
        props.add("groupseq");
        props.add("iswrittenoff");
        props.add("hadwrittenoff");
        props.add("sourcebillid");
        props.add("settlestatus");
        props.add("istanspay");
        props.add("e_sourcebillid");
        props.add("e_sourcebillentryid");
        props.add("payproperty");
        props.add("payproperty.isbasedonamt");
        props.add("pricetaxtotal");
        props.add("ispremium");
        props.add("isadjust");
        props.add("isallocate");
        props.add("isperiod");
        props.add("detailentry.e_sourcebillid");
        props.add("detailentry.e_sourcebillentryid");
        props.add("detailentry.e_pricetaxtotal");
        props.add("detailentry.quantity");
        props.add("detailentry.e_isallverify");
        props.add("detailentry.corebillid");
        props.add("detailentry.corebillentryid");
        props.add("detailentry.e_amount");
        props.add("purmode");
        props.add("bookdate");
        props.add("writebackbill");
        props.add("corebilltype");
        props.add("e_conbillentity");
        props.add("e_conbillid");
        props.add("e_conbillentryid");
        props.add("e_baseunitqty");
        props.add("e_taxdiffamt");
        props.add("e_amountdiffamt");
        props.add("e_pricetaxdiffamt");
        props.add("e_tax");
        props.add("tax");
        props.add("amount");
        props.add("e_adjustamount");
        props.add("e_unverifyamount");
        props.add("e_uninvoicedamt");
        props.add("unsettleamt");
        props.add("unverifyamount");
        props.add("unsettleamount");
        props.add("uninvoicedamt");
        props.add("unlockamt");
        props.add("unplanlockamt");
        props.add("i_tax");
        props.add("i_amount");
        props.add("i_pricetaxtotal");
        props.add("e_taxlocalamt");
        props.add("e_amountbase");
        props.add("e_pricetaxtotalbase");
        props.add("splitscheme");
        props.add("planpricetax");
        props.add("unplansettleamt");
        props.add("taxlocamt");
        props.add("amountbase");
        props.add("pricetaxtotalbase");
        props.add("planpricetaxloc");
        props.add("unplansettlelocamt");
        props.add("basecurrency");
        props.add("quotation");
        props.add("exchangerate");
        props.add("settlementtype");
        props.add("unsettleamtbase");
        props.add("planentity.seq");
        props.add("planentity.plansettletype");
        props.add("planentity.e_freezestate");
        props.add("unsettleamountbase");
        props.add("lockedamt");
        props.add("billsrctype");
        props.add("detailentry.e_prepaid");
        props.add("detailentry.linetype");
        props.add("detailentry.expenseitem");
        fieldKeys.addAll(props);
    }

    private void validBill(DynamicObject[] dataEntities) {
        Object[] pkIds = Arrays.stream(dataEntities).filter(entity -> entity.getBoolean("iswrittenoff")).filter(entity -> !entity.getBoolean("writebackbill")).map(entity -> Long.valueOf(entity.getString("sourcebillid"))).toArray();
        if (EmptyUtils.isEmpty((Object)pkIds)) {
            return;
        }
        ValidOperationServiceHelper.valid((String)"ap_finapbill", (Object[])pkIds);
    }

    private void delCoordintionBill(List<Object> pks) {
        ThreadPools.executeOnceIncludeRequestContext((String)"delete.coordintion", () -> {
            QFilter qFilter = new QFilter("sourcebilltype", "=", (Object)"ap_finapbill");
            qFilter.and(new QFilter("sourcebillid", "in", pks.stream().map(String::valueOf).collect(Collectors.toList())));
            qFilter.and(new QFilter("relationpay", "=", (Object)true));
            DynamicObjectCollection finarColl = QueryServiceHelper.query((String)"ar_finarbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (!ObjectUtils.isEmpty((Object)finarColl)) {
                List finarPks = ArApHelper.getPks((Object)finarColl);
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", "false");
                OperationServiceHelper.executeOperate((String)"noprotocoldelete", (String)"ar_finarbill", (Object[])finarPks.toArray(), (OperateOption)option);
            }
        });
    }

    private void deletePremiumBill(DynamicObject[] entites) {
        Set pks = Arrays.stream(entites).map(entity -> entity.getLong("id")).collect(Collectors.toSet());
        QFilter qf = new QFilter("sourcebilltype", "=", (Object)"ap_finapbill");
        qf.and(new QFilter("sourcebillid", "in", pks));
        qf.and(new QFilter("ispremium", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection finapColl = QueryServiceHelper.query((String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{qf});
        if (!ObjectUtils.isEmpty((Object)finapColl)) {
            List finarPks = ArApHelper.getPks((Object)finapColl);
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", "false");
            OperationServiceHelper.executeOperate((String)"noprotocoldelete", (String)"ap_finapbill", (Object[])finarPks.toArray(), (OperateOption)option);
        }
    }

    private void writeOff(long mainBillID, long asstBillID) {
        DynamicObject[] sourceDys;
        AbstractSettleTemplate service = SettleServiceFactory.getService((String)SettleRelationEnum.APWRITEOFF.getValue());
        DynamicObject[] records = this.getSettleRecord(mainBillID);
        if (records != null && records.length > 0) {
            service.unSettle(records, false);
        }
        DynamicObject hadWrittenOffBill = BusinessDataServiceHelper.loadSingle((String)"ap_finapbill", (String)"id,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)mainBillID)});
        hadWrittenOffBill.set("hadwrittenoff", (Object)Boolean.FALSE);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{hadWrittenOffBill});
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"ap_finapbill", (Object[])new Object[]{asstBillID}, (OperateOption)option);
        OperationHelper.assertResult((OperationResult)result);
        Boolean isSuccess = DapBuildVoucherCommonUtil.executeWriteBillDBOperation((String)"ap_finapbill", (String)"delete", Collections.singletonList(asstBillID), (DapBuildVoucherCommonUtil.executeType)DapBuildVoucherCommonUtil.executeType.DELETEWRITE);
        logger.info("Voucher Delete White List result: " + isSuccess);
        QFilter filter = new QFilter("mainbillid", "=", (Object)mainBillID);
        filter.and(new QFilter("iswrittenoff", "=", (Object)Boolean.TRUE));
        filter.and(new QFilter("settlerelation", "=", (Object)"transwar"));
        records = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])new QFilter[]{filter});
        if (records != null && records.length > 0) {
            SettleServiceFactory.getService((String)"transwar").unSettle(records, true);
        }
        QFilter sourFilter = new QFilter("mainbillid", "=", (Object)mainBillID);
        sourFilter.and(new QFilter("settlerelation", "=", (Object)"transwar"));
        for (DynamicObject sourceDy : sourceDys = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])new QFilter[]{sourFilter})) {
            sourceDy.set("hadwrittenoff", (Object)0);
            DynamicObjectCollection col = sourceDy.getDynamicObjectCollection("entry");
            for (DynamicObject dynamicObject : col) {
                dynamicObject.set("e_hadwrittenoff", (Object)0);
            }
        }
        if (sourceDys.length > 0) {
            SaveServiceHelper.save((DynamicObject[])sourceDys);
        }
    }

    private DynamicObject[] getSettleRecord(long mainBillID) {
        QFilter filter = new QFilter("mainbillid", "=", (Object)mainBillID);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        return BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])new QFilter[]{filter});
    }

    private boolean isAutoPushPayBill(Long orgId) {
        return SystemParameterHelper.getAPBooleanParam((long)orgId, (String)"ap_017");
    }

    private void delCasPayBill(Set<Long> payBillIds) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        OperationResult operate = OperationServiceHelper.executeOperate((String)"delete", (String)"cas_paybill", (Object[])payBillIds.toArray(), (OperateOption)option);
        if (!operate.isSuccess()) {
            OperationHelper.assertResult((OperationResult)operate);
        }
    }

    private String getVerifyRecordSelects() {
        return "org,billid,billno,billtype,billentryid,qty,measureunit,verifyqty,verifybaseqty,payableamount,verifyamount,verifytype,verifyrelation,e_billtype,e_qty,e_measureunit,e_verifyqty,e_verifybaseqty,e_payableamount,e_verifyamount,e_billid,e_billno,e_billentryid,currency,e_currency,e_verifytaxamount,verifytaxamount,e_writtenoffremark,e_iswrittenoff,e_hadwrittenoff";
    }

    private void historyDataDispose(List<Long> historyBillIds) {
        String selects = "unverifyamount,amount,quantity,e_amount,verifyquantity,unverifyquantity,verifyamount,e_unverifyamount";
        Object[] bills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)selects, (QFilter[])new QFilter[]{new QFilter("id", "in", historyBillIds), new QFilter("unverifyamount", "=", (Object)BigDecimal.ZERO)});
        if (!ObjectUtils.isEmpty((Object[])bills)) {
            for (Object bill : bills) {
                bill.set("unverifyamount", (Object)bill.getBigDecimal("amount"));
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
                for (DynamicObject row : entry) {
                    row.set("verifyquantity", (Object)BigDecimal.ZERO);
                    row.set("verifyamount", (Object)BigDecimal.ZERO);
                    row.set("unverifyquantity", (Object)row.getBigDecimal("quantity"));
                    row.set("e_unverifyamount", (Object)row.getBigDecimal("e_amount"));
                }
            }
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }
}

