/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.ap.opplugin.ApBaseBillOp;
import kd.fi.ap.validator.InvoiceSrcCollectValidator;
import kd.fi.ap.validator.InvoiceToBusEntryAmtToleranceValidator;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;

public class InvoiceAuditOp
extends ApBaseBillOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String ruleId = InvoiceAuditOp.this.getBotpRuleId();
                HashMap<Long, Integer> paramMap = new HashMap<Long, Integer>(8);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    BigDecimal unrelatedamt;
                    boolean isRefFin;
                    DynamicObject info = dataEntity.getDataEntity();
                    long orgId = info.getLong("org.id");
                    int para = paramMap.computeIfAbsent(orgId, e -> SystemParameterHelper.getParameterNull((long)orgId, (String)"ap_001"));
                    BigDecimal pricetaxtotal = info.getBigDecimal("pricetaxtotal");
                    boolean bl = isRefFin = pricetaxtotal.compareTo(unrelatedamt = info.getBigDecimal("unrelatedamt")) != 0;
                    if (isRefFin && para != 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5173\u8054\u201c\u8d22\u52a1\u5e94\u4ed8\u5355\u201d\uff0c\u65e0\u6cd5\u7ee7\u7eed\u751f\u6210\u3002", (String)"InvoiceAuditOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    }
                    if (para == 0 || ruleId != null) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u81ea\u52a8\u4e0b\u63a8\u8d22\u52a1\u5e94\u4ed8\u5355\u5931\u8d25\u3002\u82e5\u65e0\u9700\u5ba1\u6838\u81ea\u52a8\u4e0b\u63a8\u5e94\u4ed8\uff0c\u8bf7\u524d\u5f80\u201c\u7cfb\u7edf\u53c2\u6570>\u5e94\u4ed8\u201d\u5173\u95ed\u53c2\u6570\u201c\u53d1\u7968\u8ba4\u5217\u201d\u3002", (String)"InvoiceAuditOp_2", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                }
            }
        });
        e.addValidator((AbstractValidator)new InvoiceSrcCollectValidator());
        e.addValidator((AbstractValidator)new InvoiceToBusEntryAmtToleranceValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] entities = e.getDataEntities();
        DynamicObject defaultSettleType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])new QFilter[]{new QFilter("isdefault", "=", (Object)Character.valueOf('1'))});
        for (DynamicObject invoice : entities) {
            DynamicObject[] objects;
            int para = SystemParameterHelper.getParameterNull((long)invoice.getLong("org.id"), (String)"ap_001");
            if (para == 0 || invoice.getBoolean("isreffin")) continue;
            for (DynamicObject data : objects = BOTPHelper.push((String)"ap_invoice", (String)"ap_finapbill", null, (DynamicObject)invoice, (String)ResManager.loadKDString((String)"\u6536\u7968\u5355\u4e0b\u63a8\u8d22\u52a1\u5e94\u4ed8\u5355\u5931\u8d25\u3002", (String)"InvoiceAuditOp_1", (String)"fi-ap-opplugin", (Object[])new Object[0]))) {
                DynamicObject settleType = data.getDynamicObject("settlementtype");
                if (settleType != null) continue;
                data.set("settlementtype", defaultSettleType == null ? null : defaultSettleType.getPkValue());
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("mutex_writeback", "false");
            option.setVariableValue("ishasright", "true");
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_finapbill", (DynamicObject[])objects, (OperateOption)option);
            OperationHelper.assertResult((OperationResult)saveResult);
        }
    }

    private String getBotpRuleId() {
        QFilter[] filter = new QFilter[]{new QFilter("sourceentitynumber", "=", (Object)"ap_invoice"), new QFilter("targetentitynumber", "=", (Object)"ap_finapbill"), new QFilter("enabled", "=", (Object)Character.valueOf('1'))};
        DynamicObject[] rules = BusinessDataServiceHelper.load((String)"botp_crlist", (String)"id,defrule", (QFilter[])filter);
        if (rules.length < 1) {
            return null;
        }
        if (rules.length > 1) {
            for (DynamicObject rule : rules) {
                if (!rule.getBoolean("defrule")) continue;
                return rule.getString("id");
            }
        }
        return rules[0].getString("id");
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("finbillno");
        e.getFieldKeys().add("pricetaxtotal");
        e.getFieldKeys().add("unrelatedamt");
        e.getFieldKeys().add("isreffin");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("businesssource");
        e.getFieldKeys().add("sourcebilltype");
    }
}

