/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.validator.InvoiceSrcCollectValidator;
import kd.fi.arapcommon.invcloud.CallCloudHelper;
import kd.fi.arapcommon.validator.UnFinishECValidator;

public class InvoiceDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(InvoiceDeleteOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InvoiceSrcCollectValidator());
        e.addValidator((AbstractValidator)new UnFinishECValidator(InvoiceHelper.getInvoiceECTxBiz()));
        boolean autoOp = this.getOption().containsVariable("isreffin");
        if (autoOp) {
            Iterator iterator = e.getValidators().iterator();
            while (iterator.hasNext()) {
                AbstractValidator validator = (AbstractValidator)iterator.next();
                Map validation = validator.getValidation();
                if (validation == null || !"FormValidate".equals(validation.get("ruleType")) || !"IsPush()".equals(validation.get("express")) || !((Boolean)validation.get("enabled")).booleanValue()) continue;
                iterator.remove();
                break;
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("org");
        list.add("billno");
        list.add("serialno");
        list.add("isreffin");
        list.add("businesssource");
        list.add("buyertin");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        logger.info("InvoiceDeleteOp endOperationTransaction begin");
        DynamicObject[] dataEntities = e.getDataEntities();
        List needReleaseInvIds = Arrays.stream(dataEntities).filter(inv -> !ObjectUtils.isEmpty((Object)inv.getString("serialno"))).map(inv -> inv.getLong("id")).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(needReleaseInvIds)) {
            CallCloudHelper.releaseInvoice(needReleaseInvIds);
        }
        logger.info("InvoiceDeleteOp endOperationTransaction end");
    }
}

