/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ap.piaozone.InvoiceCollectHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.ap.vo.MatchResultItem;
import kd.fi.arapcommon.business.price.IPriceCalculate;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.convert.InitConvertHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.UnitConvertHelper;
import kd.fi.arapcommon.service.plan.split.PlanSplitAndBuilder;
import kd.fi.arapcommon.util.EmptyUtils;

public class InvoiceMatchOp
extends AbstractOperationServicePlugIn {
    private final Map<Long, List<DynamicObject>> generateFinapBillMap = new HashMap<Long, List<DynamicObject>>(64);
    private DynamicObject[] invoices;

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("entry");
        list.add("invoiceid");
        list.add("subentry");
        list.add("billtype");
        list.add("invoiceentryid");
        list.add("price");
        list.add("stockbillid");
        list.add("stockentryid");
        list.add("curamt");
        list.add("curqty");
        list.add("curbaseqty");
        list.add("matchscheme");
        list.add("apbillid");
        list.add("apbillentryid");
        list.add("ismatched");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> apBills = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            this.queryInvoiceBills(dataEntity);
            apBills.addAll(this.generateFinApBill(dataEntity));
        }
        InvoiceHelper.updateFinTaxDeductionLogic((DynamicObject[])apBills.toArray(new DynamicObject[0]), (boolean)false);
        SaveServiceHelper.save((DynamicObject[])apBills.toArray(new DynamicObject[0]));
        this.setRecordApBillInfo(dataEntities);
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    private void queryInvoiceBills(DynamicObject dataEntity) {
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("entry");
        HashSet<Object> invoiceIdSet = new HashSet<Object>(1);
        for (DynamicObject entry : entryColl) {
            Object invoiceid = entry.get("invoiceid");
            invoiceIdSet.add(invoiceid);
        }
        QFilter[] filterArr = new QFilter("id", "in", invoiceIdSet).toArray();
        this.invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"id,pricetaxtotal,invoicestatus,tax,invoicetype,invoicetypef7,invoicecode,invoiceno,issuedate,asstactname,buyername,istaxdeduction,remark,billno,billstatus,serialno,currency,unmatchamt,isincludetax,modifier,modifytime,ismatched,quotation,entry.id,entry.e_unmatchqty,entry.quantity,entry.actpricetax,entry.e_unmatchamt,entry.taxrate,entry.taxrateid,entry.discountmode,entry.discountrate,entry.discountamt,entry.ispresent,entry.price,entry.e_pricetaxtotal,entry.measureunit", (QFilter[])filterArr);
    }

    private void setRecordApBillInfo(DynamicObject[] records) {
        for (DynamicObject record : records) {
            record.set("ismatched", (Object)Boolean.TRUE);
            DynamicObjectCollection matchEntries = record.getDynamicObjectCollection("entry");
            for (DynamicObject matchEntry : matchEntries) {
                List<DynamicObject> apBills = this.generateFinapBillMap.get(matchEntry.getLong("invoiceid"));
                if (!EmptyUtils.isNotEmpty(apBills)) continue;
                Map<String, DynamicObject> sourceEntryIdMap = apBills.stream().map(apBill -> apBill.getDynamicObjectCollection("detailentry")).flatMap(Collection::stream).collect(Collectors.toMap(entry -> entry.getString("e_sourcebillentryid"), entry -> entry));
                DynamicObjectCollection subentryColl = matchEntry.getDynamicObjectCollection("subentry");
                for (DynamicObject subentry : subentryColl) {
                    DynamicObject apBillEntry = sourceEntryIdMap.get(subentry.getString("stockentryid"));
                    if (apBillEntry == null) continue;
                    subentry.set("apbillid", ((DynamicObject)apBillEntry.getParent()).getPkValue());
                    subentry.set("apbillentryid", apBillEntry.getPkValue());
                }
            }
        }
    }

    private List<DynamicObject> generateFinApBill(DynamicObject dataEntity) {
        List<MatchResultItem> results = this.getResults(dataEntity);
        Map<Long, List<MatchResultItem>> group = results.stream().collect(Collectors.groupingBy(MatchResultItem::getInvPk));
        Map<Long, DynamicObject> invIdMap = Arrays.stream(this.invoices).collect(Collectors.toMap(inv -> inv.getLong("id"), inv -> inv));
        ArrayList<DynamicObject> finBills = new ArrayList<DynamicObject>(64);
        for (Map.Entry<Long, List<MatchResultItem>> keyVal : group.entrySet()) {
            List<MatchResultItem> items = keyVal.getValue();
            PushArgs args = this.getPushArgs(items);
            ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)args);
            boolean success = pushResult.isSuccess();
            if (!success) {
                throw new KDBizException(new ErrorCode("InvoiceMatchPushBotp", pushResult.getMessage()), new Object[]{pushResult.getBillReports()});
            }
            IRefrencedataProvider refDataProvider = BusinessDataServiceHelper::loadRefence;
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"ap_finapbill");
            List finApBills = pushResult.loadTargetDataObjects(refDataProvider, mainType);
            DynamicObject invoice = invIdMap.get(keyVal.getKey());
            this.reCalculateFinApBills(finApBills, items, dataEntity, invoice);
            int i = 0;
            BigDecimal finAmt = BigDecimal.ZERO;
            BigDecimal finTax = BigDecimal.ZERO;
            BigDecimal finAmtAndTax = BigDecimal.ZERO;
            BigDecimal invAmtAndTax = invoice.getBigDecimal("pricetaxtotal");
            BigDecimal invTax = invoice.getBigDecimal("tax");
            BigDecimal invAmt = invAmtAndTax.subtract(invTax);
            for (DynamicObject finbill : finApBills) {
                finAmt = finAmt.add(finbill.getBigDecimal("amount"));
                finTax = finTax.add(finbill.getBigDecimal("tax"));
                finAmtAndTax = finAmtAndTax.add(finbill.getBigDecimal("pricetaxtotal"));
                if (++i == finApBills.size()) {
                    BigDecimal diffAmtAndTax = finAmtAndTax.subtract(invAmtAndTax);
                    BigDecimal diffAmt = finAmt.subtract(invAmt);
                    BigDecimal diffTax = finTax.subtract(invTax);
                    DynamicObjectCollection entryColl = finbill.getDynamicObjectCollection("detailentry");
                    DynamicObject finalEntry = (DynamicObject)entryColl.get(entryColl.size() - 1);
                    if (diffAmtAndTax.signum() != 0) {
                        finbill.set("isfxpricetaxtotal", (Object)Boolean.TRUE);
                        finbill.set("pricetaxtotal", (Object)finbill.getBigDecimal("pricetaxtotal").subtract(diffAmtAndTax));
                        finbill.set("amount", (Object)finbill.getBigDecimal("amount").subtract(diffAmt));
                        finbill.set("tax", (Object)finbill.getBigDecimal("tax").subtract(diffTax));
                        finalEntry.set("e_pricetaxtotal", (Object)finalEntry.getBigDecimal("e_pricetaxtotal").subtract(diffAmtAndTax));
                        finalEntry.set("e_amount", (Object)finalEntry.getBigDecimal("e_amount").subtract(diffAmt));
                        finalEntry.set("e_tax", (Object)finalEntry.getBigDecimal("e_tax").subtract(diffTax));
                        finbill.set("uninvoicedamt", (Object)finbill.getBigDecimal("uninvoicedamt").subtract(diffAmtAndTax));
                        finbill.set("unverifyamount", (Object)finbill.getBigDecimal("unverifyamount").subtract(diffAmt));
                        finbill.set("unsettleamount", (Object)finbill.getBigDecimal("unsettleamount").subtract(diffAmtAndTax));
                        finalEntry.set("unlockamt", (Object)finalEntry.getBigDecimal("unlockamt").subtract(diffAmtAndTax));
                        finalEntry.set("unsettleamt", (Object)finalEntry.getBigDecimal("unsettleamt").subtract(diffAmtAndTax));
                        finalEntry.set("e_uninvoicedamt", (Object)finalEntry.getBigDecimal("e_uninvoicedamt").subtract(diffAmtAndTax));
                        finalEntry.set("e_unverifyamount", (Object)finalEntry.getBigDecimal("e_unverifyamount").subtract(diffAmt));
                    } else if (diffAmt.signum() != 0) {
                        finbill.set("isfx", (Object)Boolean.TRUE);
                        finbill.set("amount", (Object)finbill.getBigDecimal("amount").subtract(diffAmt));
                        finbill.set("tax", (Object)finbill.getBigDecimal("tax").subtract(diffTax));
                        finalEntry.set("e_amount", (Object)finalEntry.getBigDecimal("e_amount").subtract(diffAmt));
                        finalEntry.set("e_tax", (Object)finalEntry.getBigDecimal("e_tax").subtract(diffTax));
                        finbill.set("unverifyamount", (Object)finbill.getBigDecimal("unverifyamount").subtract(diffAmt));
                        finalEntry.set("e_unverifyamount", (Object)finalEntry.getBigDecimal("e_unverifyamount").subtract(diffAmt));
                    }
                }
                DynamicObjectCollection invEntrys = finbill.getDynamicObjectCollection("inventry");
                DynamicObject invEntry = new DynamicObject(invEntrys.getDynamicObjectType());
                invEntry.set("seq", (Object)1);
                invEntry.set("invid", invoice.getPkValue());
                invEntry.set("i_invoicetype", (Object)invoice.getString("invoicetype"));
                invEntry.set("i_invoicetypef7", invoice.get("invoicetypef7"));
                invEntry.set("i_invoicecode", (Object)invoice.getString("invoicecode"));
                invEntry.set("i_invoiceno", (Object)invoice.getString("invoiceno"));
                invEntry.set("i_invoicedate", (Object)invoice.getDate("issuedate"));
                invEntry.set("i_pricetaxtotal", (Object)invAmtAndTax);
                invEntry.set("i_taxrate", (Object)InvoiceCollectHelper.calculateTaxRate((DynamicObject)invoice));
                invEntry.set("i_tax", (Object)invTax);
                invEntry.set("i_amount", (Object)invAmt);
                invEntry.set("i_asstactname", (Object)invoice.getString("asstactname"));
                invEntry.set("i_buyername", (Object)invoice.getString("buyername"));
                invEntry.set("i_istaxdeduction", (Object)invoice.getBoolean("istaxdeduction"));
                invEntry.set("i_remark", (Object)invoice.getString("remark"));
                invEntry.set("i_srctype", (Object)"5");
                invEntry.set("i_billno", (Object)invoice.getString("billno"));
                invEntry.set("i_issupplement", (Object)("C".equals(invoice.getString("billstatus")) ? "1" : "0"));
                invEntry.set("i_serialno", (Object)invoice.getString("serialno"));
                invEntry.set("i_canuseamt", (Object)invAmtAndTax);
                invEntry.set("i_currency", invoice.get("currency"));
                invEntrys.add((Object)invEntry);
            }
            PlanSplitAndBuilder.splitAndBuild((DynamicObject[])finApBills.toArray(new DynamicObject[0]));
            finBills.addAll(finApBills);
            this.generateFinapBillMap.put(keyVal.getKey(), finApBills);
        }
        for (DynamicObject trgBill : finBills) {
            trgBill.set("isinvoicematch", (Object)Boolean.TRUE);
            trgBill.set("billsrctype", (Object)"2");
            if (!EmptyUtils.isEmpty((Object)trgBill.getString("billno"))) continue;
            String billno = CodeRuleServiceHelper.getNumber((String)"ap_finapbill", (DynamicObject)trgBill, (String)trgBill.getDynamicObject("org").getPkValue().toString());
            trgBill.set("billno", (Object)billno);
        }
        return finBills;
    }

    private PushArgs getPushArgs(List<MatchResultItem> items) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(64);
        for (MatchResultItem item : items) {
            ListSelectedRow row = new ListSelectedRow();
            row.setEntryPrimaryKeyValue(item.getEntryId());
            row.setEntryEntityKey(item.getBillEntity());
            row.setPrimaryKeyValue(item.getBillId());
            selectedRows.add(row);
        }
        PushArgs args = new PushArgs();
        args.setSourceEntityNumber(items.get(0).getBillEntity());
        args.setTargetEntityNumber("ap_finapbill");
        args.setSelectedRows(selectedRows);
        args.addCustomParam("bos_max_push_rows", ArApHelper.getMaxPushRows());
        return args;
    }

    private List<MatchResultItem> getResults(DynamicObject dataEntity) {
        ArrayList<MatchResultItem> results = new ArrayList<MatchResultItem>(64);
        DynamicObjectCollection entryColl = dataEntity.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entryColl) {
            DynamicObjectCollection subentryColl = entry.getDynamicObjectCollection("subentry");
            for (DynamicObject subEntry : subentryColl) {
                MatchResultItem item = new MatchResultItem();
                item.setInvPk(Long.valueOf(entry.getLong("invoiceid")));
                item.setInvEntryPk(Long.valueOf(entry.getLong("invoiceentryid")));
                item.setPrice(entry.getBigDecimal("price"));
                item.setBillEntity(dataEntity.getString("billtype"));
                item.setBillId((Object)subEntry.getLong("stockbillid"));
                item.setEntryId((Object)subEntry.getLong("stockentryid"));
                item.setMatchAmt(subEntry.getBigDecimal("curamt"));
                item.setMatchQty(subEntry.getBigDecimal("curqty"));
                item.setCurbaseqty(subEntry.getBigDecimal("curbaseqty"));
                item.setMatchType("QTY");
                results.add(item);
            }
        }
        return results;
    }

    private void updateInvoiceMatchStatus() {
        Date date = new Date();
        String uid = RequestContext.get().getUid();
        for (DynamicObject invoice : this.invoices) {
            DynamicObjectCollection invoiceEntryColl = invoice.getDynamicObjectCollection("entry");
            for (DynamicObject invoiceEntry : invoiceEntryColl) {
                invoiceEntry.set("e_unmatchamt", (Object)BigDecimal.ZERO);
                invoiceEntry.set("e_unmatchqty", (Object)BigDecimal.ZERO);
            }
            invoice.set("unmatchamt", (Object)BigDecimal.ZERO);
            invoice.set("modifier", (Object)uid);
            invoice.set("modifytime", (Object)date);
        }
        SaveServiceHelper.save((DynamicObject[])this.invoices);
    }

    private void reCalculateFinApBills(List<DynamicObject> finBills, List<MatchResultItem> recordItems, DynamicObject record, DynamicObject invoice) {
        Long invoiceId = invoice.getLong("id");
        HashMap<Object, MatchResultItem> recordItemMap = new HashMap<Object, MatchResultItem>(recordItems.size());
        for (MatchResultItem recordItem : recordItems) {
            if (!invoiceId.equals(recordItem.getInvPk())) continue;
            Object entryId = recordItem.getEntryId();
            MatchResultItem item = (MatchResultItem)recordItemMap.get(entryId);
            if (item != null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u4e1a\u52a1\u8981\u6c42\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u540e\u7eed\u64cd\u4f5c\u3002", (String)"InvoiceMatchOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            recordItemMap.put(entryId, recordItem);
        }
        HashMap<Long, DynamicObject> invoiceEntryMap = new HashMap<Long, DynamicObject>(this.invoices.length);
        invoiceEntryMap.putAll(invoice.getDynamicObjectCollection("entry").stream().collect(Collectors.toMap(entry -> entry.getLong("id"), entry -> entry)));
        DynamicObject matchScheme = record.getDynamicObject("matchscheme");
        String matchType = "QTY";
        String invMatch = "ENTRY";
        if (matchScheme != null) {
            matchType = matchScheme.getString("matchtype");
            invMatch = matchScheme.getString("matchmode");
        }
        BigDecimal payableAmount = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountbase = BigDecimal.ZERO;
        BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal unSettleAmount = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal unVerifyAmount = BigDecimal.ZERO;
        String quotation = this.invoices[0].getString("quotation");
        for (DynamicObject finBill : finBills) {
            BigDecimal exchangeRate = finBill.getBigDecimal("exchangerate");
            boolean isbasedonamt = matchType.equals("AMT");
            int precision = finBill.getInt("currency.amtprecision");
            DynamicObjectCollection detailEntry = finBill.getDynamicObjectCollection("detailentry");
            Iterator iterator = detailEntry.iterator();
            while (iterator.hasNext()) {
                DynamicObject finBillEntry = (DynamicObject)iterator.next();
                MatchResultItem item = (MatchResultItem)recordItemMap.get(finBillEntry.getLong("e_sourcebillentryid"));
                if (item == null) {
                    iterator.remove();
                    continue;
                }
                DynamicObject invoiceEntry = (DynamicObject)invoiceEntryMap.get(item.getInvEntryPk());
                BigDecimal matchBaseQty = item.getCurbaseqty();
                DynamicObject measureunit = invoiceEntry.getDynamicObject("measureunit");
                if (matchBaseQty == null) {
                    matchBaseQty = BigDecimal.ZERO;
                }
                BigDecimal covertRate = BigDecimal.ONE;
                DynamicObject material = finBillEntry.getDynamicObject("material");
                DynamicObject baseUnit = finBillEntry.getDynamicObject("e_baseunit");
                finBillEntry.set("measureunit", (Object)measureunit);
                if (!ObjectUtils.isEmpty((Object)material)) {
                    covertRate = InitConvertHelper.getUnitRateConv((Long)material.getLong("id"), (Long)measureunit.getLong("id"), (Long)baseUnit.getLong("id"));
                    covertRate = covertRate == null ? BigDecimal.ONE : covertRate;
                }
                finBillEntry.set("e_unitconvertrate", (Object)covertRate);
                finBillEntry.set("e_baseunitqty", (Object)matchBaseQty);
                BigDecimal unitQty = UnitConvertHelper.getUnitQty((BigDecimal)matchBaseQty, (BigDecimal)covertRate, (DynamicObject)measureunit);
                finBillEntry.set("quantity", (Object)unitQty);
                finBillEntry.set("unverifyquantity", (Object)unitQty);
                BigDecimal matchQty = unitQty;
                BigDecimal matchAmt = item.getMatchAmt();
                BigDecimal taxRate = invoiceEntry.getBigDecimal("taxrate");
                DynamicObject taxRateDyb = invoiceEntry.getDynamicObject("taxrateid");
                String discountMode = invoiceEntry.getString("discountmode");
                BigDecimal discountRate = invoiceEntry.getBigDecimal("discountrate");
                BigDecimal discountamt = invoiceEntry.getBigDecimal("discountamt");
                BigDecimal eAdjustamount = BigDecimal.ZERO;
                PriceLocalCalculator localCalculator = null;
                PriceTaxTotalCalculator calculator = null;
                BigDecimal unmatchQty = BigDecimal.ZERO;
                if (!isbasedonamt && "ENTRY".equals(invMatch)) {
                    BigDecimal price = invoiceEntry.getBigDecimal("price");
                    calculator = new UnitPriceCalculator(matchQty, price, taxRate, discountMode, discountRate, precision, eAdjustamount, discountamt);
                } else {
                    calculator = new PriceTaxTotalCalculator(matchQty, matchAmt, taxRate, discountMode, discountRate, precision, eAdjustamount, discountamt);
                }
                localCalculator = new PriceLocalCalculator((IPriceCalculate)calculator, exchangeRate, precision, quotation);
                localCalculator.calculate();
                BigDecimal e_amountbase = localCalculator.getAmountlocal();
                BigDecimal e_pricetaxtotalbase = localCalculator.getPricetaxtotallocal();
                BigDecimal e_pricetaxtotal = localCalculator.getPricetaxtotal();
                BigDecimal e_amount = localCalculator.getAmount();
                BigDecimal e_tax = localCalculator.getTax();
                amountbase = amountbase.add(e_amountbase);
                pricetaxtotalbase = pricetaxtotalbase.add(e_pricetaxtotalbase);
                payableAmount = payableAmount.add(e_pricetaxtotal);
                amount = amount.add(e_amount);
                tax = tax.add(e_tax);
                unVerifyAmount = unVerifyAmount.add(e_amount);
                unSettleAmount = unSettleAmount.add(e_pricetaxtotal);
                adjustamt = adjustamt.add(localCalculator.getAdjustamt());
                adjustamtlocal = adjustamtlocal.add(localCalculator.getAdjustamtlocal());
                finBillEntry.set("price", (Object)localCalculator.getUnitprice());
                finBillEntry.set("pricetax", (Object)localCalculator.getTaxunitprice());
                finBillEntry.set("actprice", (Object)localCalculator.getActunitprice());
                finBillEntry.set("actpricetax", (Object)localCalculator.getActtaxunitprice());
                finBillEntry.set("e_amount", (Object)e_amount);
                finBillEntry.set("e_amountbase", (Object)e_amountbase);
                finBillEntry.set("e_tax", (Object)e_tax);
                finBillEntry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
                finBillEntry.set("e_pricetaxtotal", (Object)e_pricetaxtotal);
                finBillEntry.set("unlockamt", (Object)localCalculator.getPricetaxtotal());
                finBillEntry.set("unsettleamt", (Object)localCalculator.getPricetaxtotal());
                finBillEntry.set("e_uninvoicedamt", (Object)localCalculator.getPricetaxtotal());
                finBillEntry.set("e_unverifyamount", (Object)e_amount);
                finBillEntry.set("e_pricetaxtotalbase", (Object)e_pricetaxtotalbase);
                finBillEntry.set("unsettleamtbase", (Object)e_pricetaxtotalbase);
                finBillEntry.set("e_adjustamount", (Object)localCalculator.getAdjustamt());
                finBillEntry.set("e_adjustlocalamt", (Object)localCalculator.getAdjustamt());
                finBillEntry.set("taxrateid", (Object)taxRateDyb);
                finBillEntry.set("discountmode", (Object)localCalculator.getDiscountmode());
                finBillEntry.set("discountrate", (Object)localCalculator.getDiscountrate());
                finBillEntry.set("discountamount", (Object)localCalculator.getDiscountamount());
                finBillEntry.set("discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                finBillEntry.set("ispresent", invoiceEntry.get("ispresent"));
            }
            finBill.set("pricetaxtotal", (Object)payableAmount);
            finBill.set("uninvoicedamt", (Object)payableAmount);
            finBill.set("pricetaxtotalbase", (Object)pricetaxtotalbase);
            finBill.set("amount", (Object)amount);
            finBill.set("amountbase", (Object)amountbase);
            finBill.set("tax", (Object)tax);
            finBill.set("taxlocamt", (Object)pricetaxtotalbase.subtract(amountbase));
            finBill.set("unverifyamount", (Object)unVerifyAmount);
            finBill.set("unsettleamount", (Object)unSettleAmount);
            finBill.set("unsettleamountbase", (Object)pricetaxtotalbase);
            finBill.set("adjustamount", (Object)adjustamt);
            finBill.set("adjustlocalamt", (Object)adjustamtlocal);
        }
    }
}

