/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.kdtx.common.CommonParam;
import kd.bos.kdtx.common.Param;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.validator.BillToleranceValidator;
import kd.fi.ap.validator.FinApInvoiceSubmitAmountValidator;
import kd.fi.ap.validator.InvoiceSrcCollectValidator;
import kd.fi.ap.validator.InvoiceSubmitValidator;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.helper.ArApDataRepairHelper;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.kdtx.ec.ECServiceHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BaseDataEnableValidator;
import kd.fi.arapcommon.opplugin.MustInputValidator;
import kd.fi.arapcommon.util.ErStdConfig;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.validator.BillPriceValidator;

public class InvoiceSubmitOp
extends ArapBaseOp {
    private static Log logger = LogFactory.getLog(InvoiceSubmitOp.class);
    private static final int rowCountOneBatch = 2000;

    public void onAddValidators(AddValidatorsEventArgs e) {
        InvoiceSubmitValidator v = new InvoiceSubmitValidator();
        v.setEntityKey("ap_invoice");
        e.addValidator((AbstractValidator)v);
        e.addValidator((AbstractValidator)new BillPriceValidator());
        e.addValidator((AbstractValidator)new InvoiceSrcCollectValidator());
        if (SystemParameterHelper.isForceValidateAmt()) {
            e.addValidator((AbstractValidator)new FinApInvoiceSubmitAmountValidator());
        }
        e.addValidator((AbstractValidator)new BaseDataEnableValidator());
        e.addValidator((AbstractValidator)new MustInputValidator());
        super.onAddValidators(e);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("buyer");
        list.add("asstact");
        list.add("invoicetype");
        list.add("pricetaxtotal");
        list.add("asstacttype");
        list.add("entry");
        list.add("material");
        list.add("quantity");
        list.add("measureunit");
        list.add("expenseitem");
        list.add("invoiceno");
        list.add("asstactname");
        list.add("expense");
        list.add("imageno");
        list.add("e_sourcebillid");
        list.add("e_sourcebillentryid");
        list.add("org");
        list.add("billno");
        list.add("creator");
        list.add("modifier");
        list.add("createtime");
        list.add("modifytime");
        list.add("ispresent");
        list.add("price");
        list.add("e_tax");
        list.add("e_amount");
        list.add("serialno");
        list.add("quantity");
        list.add("discountamt");
        list.add("e_pricetaxtotal");
        list.add("isreffin");
        list.add("sourcebillid");
        list.add("sourcebilltype");
        list.add("buyertin");
        list.add("corebillno");
        list.add("corebillid");
        list.add("corebillentryseq");
        list.add("corebillentryid");
        list.add("e_relatedamt");
        list.add("e_unrelatedamt");
        list.add("unrelatedamt");
        list.add("e_unmatchamt");
        list.add("unmatchamt");
        list.add("billstatus");
        list.add("basecurrency");
        list.add("e_amountbase");
        list.add("discountamt");
        list.add("discountlocalamt");
        list.add("e_pricetaxtotalbase");
        list.add("pricetaxtotalbase");
        list.add("amount");
        list.add("amountbase");
        list.add("exchangerate");
        list.add("entry.seq");
        list.add("e_relatedamt");
        list.add("currency");
        list.add("receivablessupp");
        list.add("exratetable");
        list.add("invoicetypef7");
        list.add("tax");
        list.add("businesssource");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        logger.info("InvoiceSubmitOp beginOperationTransaction begin .");
        DynamicObject[] invs = e.getDataEntities();
        ArApDataRepairHelper.repairApInvoiceDatas((DynamicObject[])invs);
        Map invoiceTypePKMap = InvoiceTypeHelper.getInvoiceTypePKMap();
        for (DynamicObject inv : invs) {
            Object invoicetype = inv.get("invoicetypef7");
            if (invoicetype == null || invoicetype.equals(0L)) {
                String invoicetypeStr = inv.getString("invoicetype");
                Long pk = invoiceTypePKMap.computeIfAbsent(InvoiceType.getTypeNo((String)invoicetypeStr), v -> 0L);
                inv.set("invoicetypef7", (Object)pk);
                continue;
            }
            if (!(invoicetype instanceof DynamicObject)) continue;
            String number = ((DynamicObject)invoicetype).getString("number");
            String value = InvoiceType.getValue((String)number);
            if (value == null) {
                value = number;
            }
            inv.set("invoicetype", (Object)value);
        }
        logger.info("InvoiceSubmitOp beginOperationTransaction end .");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        this.pullInvImage(dataEntities);
        BillToleranceValidator.busAmtValidator(dataEntities);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.removeCache(e.getDataEntities());
    }

    private void removeCache(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            if (2000 >= dataEntity.getDynamicObjectCollection("entry").size()) continue;
            ConfigCache.remove((String)"appendentryrows", (String)dataEntity.getString("id"));
        }
    }

    private void pullInvImage(DynamicObject[] dataEntities) {
        if ("false".equals(ErStdConfig.get((String)"invoicecloud.invoicecloudxh")) || "true".equals(StdConfig.get((String)"pullimagexh"))) {
            ArrayList<Object> invoiceIds = new ArrayList<Object>(64);
            ArrayList<String> invNoAndCodes = new ArrayList<String>(64);
            for (DynamicObject invoice : dataEntities) {
                if (ObjectUtils.isEmpty((Object)invoice.getString("serialno"))) continue;
                invoiceIds.add(invoice.getPkValue());
                invNoAndCodes.add(invoice.getString("invoiceno") + "_" + invoice.getString("invoicecode"));
            }
            logger.info("InvoiceSubmitOp pullInvImage invoiceIds : " + invoiceIds);
            if (ObjectUtils.isEmpty(invoiceIds)) {
                return;
            }
            CommonParam param = new CommonParam();
            param.put((Object)"invoiceIds", invoiceIds);
            param.put((Object)"finBillNo", this.getOption().getVariables().get("finBillno"));
            param.put((Object)"uniquekey", (Object)DB.genGlobalLongId());
            param.put((Object)"invNoAndCodes", invNoAndCodes);
            ECServiceHelper.beginAndRegisterWithBusInfo((String)"ap_pullinvimage", null, (String)"fi", (String)"ap", (String)"ApInvoicePullImageECService", (Param)param, (String)"", invoiceIds);
        }
    }
}

