/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.helper.SystemParameterHelper;
import kd.fi.ap.validator.InvoiceSrcCollectValidator;
import kd.fi.ap.validator.InvoiceUnauditValidator;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;

public class InvoiceUnauditOp
extends ArapBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        InvoiceUnauditValidator v = new InvoiceUnauditValidator();
        v.setEntityKey("ap_invoice");
        e.addValidator((AbstractValidator)v);
        e.addValidator((AbstractValidator)new InvoiceSrcCollectValidator());
        super.onAddValidators(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] entities = e.getDataEntities();
        this.deleteFinApBills(entities);
    }

    private void deleteFinApBills(DynamicObject[] entities) {
        HashMap<Long, Boolean> ap001Map = new HashMap<Long, Boolean>(8);
        HashSet<Long> invoiceIds = new HashSet<Long>(64);
        for (DynamicObject entity : entities) {
            long orgId = entity.getLong("org.id");
            Boolean ap001 = ap001Map.computeIfAbsent(orgId, t -> SystemParameterHelper.getParameterBoolean((long)orgId, (String)"ap_001"));
            if (!Boolean.TRUE.equals(ap001)) continue;
            invoiceIds.add(entity.getLong("id"));
        }
        if (invoiceIds.isEmpty()) {
            return;
        }
        QFilter qFilter = new QFilter("sourcebillid", "in", invoiceIds);
        List finApIds = QueryServiceHelper.queryPrimaryKeys((String)"ap_finapbill", (QFilter[])new QFilter[]{qFilter}, (String)"", (int)-1);
        if (ObjectUtils.isEmpty((Object)finApIds)) {
            return;
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("mutex_writeback", "false");
        option.setVariableValue("ishasright", "true");
        OperationResult result = OperationServiceHelper.executeOperate((String)"noprotocoldelete", (String)"ap_finapbill", (Object[])finApIds.toArray(), (OperateOption)option);
        OperationHelper.assertResult((OperationResult)result);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("finbillno");
        e.getFieldKeys().add("unrelatedamt");
        e.getFieldKeys().add("pricetaxtotal");
        e.getFieldKeys().add("isreffin");
        e.getFieldKeys().add("businesssource");
    }
}

