/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.business.invoice.assign.IAssignInvoiceService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.validator.PayApply4InvAntiValidator;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;

public class PayApply4InvAntiOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PayApply4InvAntiOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PayApply4InvAntiValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("PayApply4InvAntiOp endOperationTransaction begin .");
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> needAntiApplyIds = new HashSet<Long>(8);
        for (DynamicObject applyBill : dataEntities) {
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            if (invEntry.isEmpty()) continue;
            needAntiApplyIds.add(applyBill.getLong("id"));
        }
        logger.info("PayApply4InvAntiOp endOperationTransaction needAntiApplyIds is : " + needAntiApplyIds);
        if (!needAntiApplyIds.isEmpty()) {
            AssignInvoiceParam assignInvoiceParam = new AssignInvoiceParam();
            assignInvoiceParam.setAutoAssign(true).setBillIds(new ArrayList(needAntiApplyIds));
            IAssignInvoiceService assignInvoiceService = (IAssignInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.APPLYASSIGNINVOICE.getValue());
            assignInvoiceService.antiAssign(assignInvoiceParam);
        }
        logger.info("PayApply4InvAntiOp endOperationTransaction begin end.");
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List selectors = e.getFieldKeys();
        selectors.add("isprepayinvoice");
        selectors.add("settleorg");
        selectors.add("billno");
        selectors.add("entry.e_asstacttype");
        selectors.add("entry.e_asstact");
        selectors.add("inventry.i_serialno");
        selectors.add("inventry.invid");
        selectors.add("inventry.i_srctype");
    }
}

