/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.business.invoice.collect.ICollectInvoiceService;
import kd.fi.ap.validator.PayApplyDeleteInvEntryValidator;
import kd.fi.ap.vo.InvoiceCollectParam;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;

public class PayApply4InvCollOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PayApply4InvCollOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PayApplyDeleteInvEntryValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("PayApplyInvCollOp endOperationTransaction begin .");
        Object[] dataEntities = this.getNeedProcessPayApplyBills(e.getDataEntities());
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        logger.info("PayApplyInvCollOp endOperationTransaction begin collect.");
        String appId = (String)this.getOption().getVariables().get("appnumber");
        InvoiceCollectParam collectParam = new InvoiceCollectParam();
        collectParam.setAppId(appId);
        collectParam.setOperateKey(String.valueOf(this.operateMeta.get("key")));
        ICollectInvoiceService collectService = (ICollectInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.PAYAPPLYCOLLECT.getValue());
        collectService.collectInvoice(collectParam, (DynamicObject[])dataEntities);
        logger.info("PayApplyInvCollOp endOperationTransaction begin end.");
    }

    private DynamicObject[] getNeedProcessPayApplyBills(DynamicObject[] dataEntities) {
        ArrayList<Long> ApplyBillIds = new ArrayList<Long>(8);
        for (DynamicObject applyBill : dataEntities) {
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            if (invEntry.isEmpty()) continue;
            ApplyBillIds.add(applyBill.getLong("id"));
        }
        if (ObjectUtils.isEmpty(ApplyBillIds)) {
            return new DynamicObject[0];
        }
        return BusinessDataServiceHelper.load((String)"ap_payapply", (String)String.join((CharSequence)",", this.getSelectors()), (QFilter[])new QFilter[]{new QFilter("id", "in", ApplyBillIds)});
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List lst = e.getFieldKeys();
        lst.addAll(this.getSelectors());
    }

    private List<String> getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(256);
        selectors.add("isprepayinvoice");
        selectors.add("settleorg");
        selectors.add("billno");
        selectors.add("entry.e_asstacttype");
        selectors.add("entry.e_asstact");
        selectors.add("inventry.i_serialno");
        selectors.add("inventry.invid");
        selectors.add("inventry.i_srctype");
        return selectors;
    }
}

