/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.ap.business.invoice.delinv.IInvoiceEntryDeleteService;
import kd.fi.ap.business.pojo.InvEntryDeleteParam;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.ap.validator.PayApplyDeleteInvEntryValidator;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;

public class PayApply4InvDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(PayApply4InvDeleteOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PayApplyDeleteInvEntryValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        logger.info("PayApply4InvDeleteOp beginOperationTransaction begin .");
        DynamicObject[] dataEntities = e.getDataEntities();
        this.releaseInvoice(dataEntities);
        logger.info("PayApply4InvDeleteOp beginOperationTransaction end.");
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        logger.info("PayApply4InvDeleteOp endOperationTransaction begin .");
        HashSet<Long> orgIds = new HashSet<Long>(8);
        ArrayList<Long> billIds = new ArrayList<Long>(32);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            orgIds.add(dataEntity.getLong("settleorg.id"));
            billIds.add(dataEntity.getLong("id"));
        }
        ReplaceInvoiceHelper.deleteReplaceRecord((String)"ap_payapply", orgIds, billIds);
        logger.info("PayApply4InvDeleteOp endOperationTransaction end .");
    }

    private void releaseInvoice(DynamicObject[] dataEntities) {
        HashMap<Long, Set> apply4InvoiceMap = new HashMap<Long, Set>(8);
        for (DynamicObject applyBill : dataEntities) {
            Long applyId = applyBill.getLong("id");
            DynamicObjectCollection invEntry = applyBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                Set deleteInvoiceIds = apply4InvoiceMap.getOrDefault(applyId, new HashSet(8));
                deleteInvoiceIds.add(invRow.getLong("invid"));
                apply4InvoiceMap.put(applyId, deleteInvoiceIds);
            }
        }
        if (apply4InvoiceMap.isEmpty()) {
            return;
        }
        InvEntryDeleteParam deleteParam = new InvEntryDeleteParam();
        String appId = (String)this.getOption().getVariables().get("appnumber");
        String operateKey = String.valueOf(this.operateMeta.get("key"));
        deleteParam.setBill4InvoiceMap(apply4InvoiceMap).setSave(false).setOperateKey(operateKey).setAppId(appId);
        IInvoiceEntryDeleteService deleteService = (IInvoiceEntryDeleteService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.APPLYDELETEINVROW.getValue());
        deleteService.deleteInvoiceRow(deleteParam);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List selectors = e.getFieldKeys();
        selectors.add("isprepayinvoice");
        selectors.add("settleorg");
        selectors.add("billno");
        selectors.add("entry.e_asstacttype");
        selectors.add("entry.e_asstact");
        selectors.add("inventry.i_serialno");
        selectors.add("inventry.invid");
        selectors.add("inventry.i_srctype");
    }
}

