/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.ap.business.invoice.assign.IAssignInvoiceService;
import kd.fi.ap.business.pojo.AssignInvoiceParam;
import kd.fi.ap.validator.PayApplyAntiAssignValidator;
import kd.fi.ap.validator.PayApplyDeleteInvEntryValidator;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;

public class PayApplyAntiAssignOp
extends ArapBaseOp {
    protected static final Log logger = LogFactory.getLog(PayApplyAntiAssignOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PayApplyDeleteInvEntryValidator());
        e.addValidator((AbstractValidator)new PayApplyAntiAssignValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("PayApplyAntiAssignInvoiceOp endOperationTransaction begin");
        Map variableMap = this.getOption().getVariables();
        if (variableMap.containsKey("modeltypeforwf") && "bill".equals(variableMap.get("modeltypeforwf"))) {
            OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)"ap_payapply", (DynamicObject[])e.getDataEntities(), (OperateOption)OperateOption.create());
            OperationHelper.assertResult((OperationResult)saveResult);
        }
        List applyBillIds = Arrays.stream(e.getDataEntities()).map(apply -> apply.getLong("id")).collect(Collectors.toList());
        AssignInvoiceParam assignInvoiceParam = new AssignInvoiceParam();
        assignInvoiceParam.setBillIds(applyBillIds);
        IAssignInvoiceService assignInvoiceService = (IAssignInvoiceService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.APPLYASSIGNINVOICE.getValue());
        assignInvoiceService.antiAssign(assignInvoiceParam);
        logger.info("PayApplyAntiAssignInvoiceOp endOperationTransaction end");
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("inventry.invid");
        fieldKeys.add("inventry.i_serialno");
        fieldKeys.add("inventry.i_srctype");
        fieldKeys.add("billstatus");
    }
}

