/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.ap.validator.ReplaceInvoiceSubmitAndAuditValidator;
import kd.fi.arapcommon.opplugin.ArapBaseOp;

public class ReplaceInvoiceSubmitOp
extends ArapBaseOp {
    private static final Log logger = LogFactory.getLog(ReplaceInvoiceSubmitOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReplaceInvoiceSubmitAndAuditValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        logger.info("ReplaceInvoiceSubmitOp endOperationTransaction begin .");
        this.onTheWayValidate(e.getDataEntities());
        logger.info("ReplaceInvoiceSubmitOp endOperationTransaction end .");
    }

    private void onTheWayValidate(DynamicObject[] bills) {
        HashSet<Long> orgIds = new HashSet<Long>(8);
        HashSet<Long> finApBillIds = new HashSet<Long>(32);
        HashSet<Long> invoiceIds = new HashSet<Long>(32);
        HashSet<Long> applyIds = new HashSet<Long>(32);
        for (DynamicObject bill : bills) {
            Object oldInvRow2;
            orgIds.add(bill.getLong("org.id"));
            DynamicObjectCollection oldInvEntry = bill.getDynamicObjectCollection("oldinventry");
            for (Object oldInvRow2 : oldInvEntry) {
                long invoiceId = oldInvRow2.getLong("o_invid");
                long apBillId = oldInvRow2.getLong("o_apbillid");
                long applyId = oldInvRow2.getLong("o_applybillid");
                invoiceIds.add(invoiceId);
                if (apBillId != 0L) {
                    finApBillIds.add(apBillId);
                }
                if (applyId == 0L) continue;
                applyIds.add(applyId);
            }
            DynamicObjectCollection newInvEntry = bill.getDynamicObjectCollection("newinventry");
            oldInvRow2 = newInvEntry.iterator();
            while (oldInvRow2.hasNext()) {
                DynamicObject newInvRow = (DynamicObject)oldInvRow2.next();
                long invoiceId = newInvRow.getLong("n_invid");
                invoiceIds.add(invoiceId);
            }
        }
        Map onTheWayInvoiceIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_invoice", orgIds, new ArrayList(invoiceIds));
        Map onTheWayFinApIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_finapbill", orgIds, new ArrayList(finApBillIds));
        Map onTheWayApplyIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_payapply", orgIds, new ArrayList(applyIds));
        for (DynamicObject bill : bills) {
            long billId = bill.getLong("id");
            String billNo = bill.getString("billno");
            DynamicObjectCollection oldInvEntry = bill.getDynamicObjectCollection("oldinventry");
            for (DynamicObject oldInvRow : oldInvEntry) {
                Set onTheWayApply4ReplaceIds;
                Set onTheWayFinAp4ReplaceIds;
                long invoiceId = oldInvRow.getLong("o_invid");
                long apBillId = oldInvRow.getLong("o_apbillid");
                long applyId = oldInvRow.getLong("o_applybillid");
                Set onTheWayInvoice4ReplaceIds = (Set)onTheWayInvoiceIdsMap.get(invoiceId);
                if (!ObjectUtils.isEmpty((Object)onTheWayInvoice4ReplaceIds)) {
                    onTheWayInvoice4ReplaceIds.remove(billId);
                    if (!onTheWayInvoice4ReplaceIds.isEmpty()) {
                        this.throwErrorBizException(billNo, "ap_invoice", invoiceId);
                    }
                }
                if (apBillId != 0L && !ObjectUtils.isEmpty((Object)(onTheWayFinAp4ReplaceIds = (Set)onTheWayFinApIdsMap.get(apBillId)))) {
                    onTheWayFinAp4ReplaceIds.remove(billId);
                    if (!onTheWayFinAp4ReplaceIds.isEmpty()) {
                        this.throwErrorBizException(billNo, "ap_finapbill", apBillId);
                    }
                }
                if (applyId == 0L || ObjectUtils.isEmpty((Object)(onTheWayApply4ReplaceIds = (Set)onTheWayApplyIdsMap.get(apBillId)))) continue;
                onTheWayApply4ReplaceIds.remove(billId);
                if (onTheWayApply4ReplaceIds.isEmpty()) continue;
                this.throwErrorBizException(billNo, "ap_payapply", applyId);
            }
            DynamicObjectCollection newInvEntry = bill.getDynamicObjectCollection("newinventry");
            for (DynamicObject newInvRow : newInvEntry) {
                long invoiceId = newInvRow.getLong("n_invid");
                Set onTheWayInvoice4ReplaceIds = (Set)onTheWayInvoiceIdsMap.get(invoiceId);
                if (ObjectUtils.isEmpty((Object)onTheWayInvoice4ReplaceIds)) continue;
                onTheWayInvoice4ReplaceIds.remove(billId);
                if (onTheWayInvoice4ReplaceIds.isEmpty()) continue;
                this.throwErrorBizException(billNo, "ap_invoice", invoiceId);
            }
        }
    }

    private void throwErrorBizException(String replaceBillNo, String entityName, long billId) {
        DynamicObject bill = QueryServiceHelper.queryOne((String)entityName, (String)"billno", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)});
        String billNo = "";
        if (bill != null) {
            billNo = bill.getString("billno");
        }
        String entity = ResManager.loadKDString((String)"\u6536\u7968\u5355", (String)"ReplaceInvoiceSubmitOp_0", (String)"fi-ap-opplugin", (Object[])new Object[0]);
        if ("ap_finapbill".equals(entityName)) {
            entity = ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355", (String)"ReplaceInvoiceSubmitOp_1", (String)"fi-ap-opplugin", (Object[])new Object[0]);
        } else if ("ap_payapply".equals(entityName)) {
            entity = ResManager.loadKDString((String)"\u4ed8\u6b3e\u7533\u8bf7\u5355", (String)"ReplaceInvoiceSubmitOp_2", (String)"fi-ap-opplugin", (Object[])new Object[0]);
        }
        String errorMessage = String.format(ResManager.loadKDString((String)"\u6362\u7968\u7533\u8bf7%1$s\uff1a\u63d0\u4ea4\u5931\u8d25\u3002%2$s%3$s\u5b58\u5728\u5176\u4ed6\u5728\u9014\u7684\u6362\u7968\u7533\u8bf7\uff0c\u8bf7\u5220\u9664\u6216\u5ba1\u6838\u540e\u91cd\u8bd5\u3002", (String)"ReplaceInvoiceSubmitOp_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), replaceBillNo, entity, billNo);
        throw new KDBizException(errorMessage);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("asstacttype");
        fieldKeys.add("asstact");
        fieldKeys.add("billno");
        fieldKeys.add("o_isprepayinv");
        fieldKeys.add("o_invbillno");
        fieldKeys.add("o_serialno");
        fieldKeys.add("o_apbillno");
        fieldKeys.add("o_usedamt");
        fieldKeys.add("o_apbillid");
        fieldKeys.add("o_applybillno");
        fieldKeys.add("o_applybillid");
        fieldKeys.add("o_applybillid");
        fieldKeys.add("o_invbillno");
        fieldKeys.add("o_invid");
        fieldKeys.add("n_isprepayinv");
        fieldKeys.add("n_invid");
        fieldKeys.add("n_invbillno");
        fieldKeys.add("n_serialno");
        fieldKeys.add("n_blueinvid");
        fieldKeys.add("n_blueinvno");
        fieldKeys.add("n_apbillno");
        fieldKeys.add("n_usedamt");
        fieldKeys.add("n_apbillid");
        fieldKeys.add("n_applybillno");
        fieldKeys.add("n_applybillid");
        fieldKeys.add("oldinventry.pid");
        fieldKeys.add("newinventry.pid");
        fieldKeys.add("newinventry.seq");
        fieldKeys.add("oldinventry.seq");
        fieldKeys.add("n_srctype");
    }
}

