/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.ap.validator.TransferPayValidator;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.ServiceNameEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.helper.ArApTransferHelper;
import kd.fi.arapcommon.model.FinApBillModel;
import kd.fi.arapcommon.validator.DecimalScopeValidator;

public class TransferPayConfimOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new TransferPayValidator());
        e.addValidator((AbstractValidator)new DecimalScopeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject transferInfo = e.getDataEntities()[0];
        List<AssignBillPushParam> paramList = this.dynamicObjectCovertParam(transferInfo);
        ArApServiceAPIFactory.getPushBillService((String)ServiceNameEnum.FINAPTRANSFER.getValue()).assignBillEntryPush("ap_finapbill", "detailentry", paramList);
    }

    private List<AssignBillPushParam> dynamicObjectCovertParam(DynamicObject transferInfo) {
        FinApBillModel finApBillModel = new FinApBillModel();
        ArrayList<AssignBillPushParam> paramList = new ArrayList<AssignBillPushParam>(2);
        String transferType = transferInfo.getString("methodtype");
        Map extendFieldMap = ArApTransferHelper.getTransferExtendFields((String)"transferpaybill");
        Set headExtendFields = (Set)extendFieldMap.get("head");
        Set materialExtendFields = (Set)extendFieldMap.get("detailentry");
        Set planExtendFields = (Set)extendFieldMap.get("planentity");
        DynamicObjectCollection entry = transferInfo.getDynamicObjectCollection("entry");
        for (DynamicObject transRow : entry) {
            BigDecimal transAmount = transRow.getBigDecimal("transamount");
            BigDecimal transTax = transRow.getBigDecimal("transtax");
            if (BigDecimal.ZERO.compareTo(transAmount) == 0 && BigDecimal.ZERO.compareTo(transTax) == 0) continue;
            AssignBillPushParam pushParam = new AssignBillPushParam(transRow.getLong("finbillid"), transRow.getLong("finentryid"));
            pushParam.setTransferType("true".equals(transferType) ? "summary" : "dispersed");
            HashMap<String, Object> tarFieldValueMap = new HashMap<String, Object>(16);
            tarFieldValueMap.put(finApBillModel.HEAD_PAYEEBANKNUM, transferInfo.getString("payeebanknum"));
            tarFieldValueMap.put(finApBillModel.HEAD_BEBANK, transferInfo.getDynamicObject("bebank"));
            tarFieldValueMap.put(finApBillModel.HEAD_ASSTACTTYPE, transferInfo.getString("asstacttype"));
            tarFieldValueMap.put(finApBillModel.HEAD_ASSTACT, transferInfo.getDynamicObject("asstact"));
            tarFieldValueMap.put(finApBillModel.HEAD_REMARK, transferInfo.getString("remark"));
            tarFieldValueMap.put(finApBillModel.HEAD_EXCHANGERATE, transferInfo.getBigDecimal("head_exchangerate"));
            tarFieldValueMap.put(finApBillModel.E_TAXRATEID, transRow.getDynamicObject("taxrateid"));
            tarFieldValueMap.put(finApBillModel.E_QUANTITY, transRow.getBigDecimal("transqty"));
            tarFieldValueMap.put(finApBillModel.E_AMOUNT, transAmount);
            tarFieldValueMap.put(finApBillModel.E_TAX, transTax);
            tarFieldValueMap.put(finApBillModel.HEAD_PAYCOND, transferInfo.getDynamicObject("paycond"));
            tarFieldValueMap.put(finApBillModel.HEAD_SETTLEMENTTYPE, transferInfo.getDynamicObject("settlementtype"));
            tarFieldValueMap.put(finApBillModel.HEAD_PURORG, transferInfo.getDynamicObject("purorg"));
            tarFieldValueMap.put(finApBillModel.HEAD_PURCHASER, transferInfo.getDynamicObject("purchaser"));
            tarFieldValueMap.put(finApBillModel.HEAD_PURDEPT, transferInfo.getDynamicObject("purdept"));
            tarFieldValueMap.put(finApBillModel.HEAD_BIZDATE, transferInfo.getDate("transdate"));
            tarFieldValueMap.put(finApBillModel.HEAD_DUEDATE, transferInfo.getDate("duedate"));
            for (String headExtendField : headExtendFields) {
                tarFieldValueMap.put(headExtendField, transferInfo.get(headExtendField));
            }
            for (String materialExtendField : materialExtendFields) {
                tarFieldValueMap.put(materialExtendField, transRow.get(materialExtendField));
            }
            pushParam.setTarFieldValueMap(tarFieldValueMap);
            paramList.add(pushParam);
        }
        AssignBillPushParam pushParam = (AssignBillPushParam)paramList.get(0);
        DynamicObjectCollection planEntry = transferInfo.getDynamicObjectCollection("planentry");
        ArrayList planEntryParams = new ArrayList(planEntry.size());
        for (DynamicObject planRow : planEntry) {
            HashMap<String, Object> tarPlanFieldValueMap = new HashMap<String, Object>(16);
            tarPlanFieldValueMap.put("p_billno", planRow.get("p_billno"));
            tarPlanFieldValueMap.put("p_billid", planRow.get("p_billid"));
            tarPlanFieldValueMap.put("p_entryid", planRow.get("p_entryid"));
            tarPlanFieldValueMap.put("p_transpricetaxtotal", planRow.get("p_transpricetaxtotal"));
            tarPlanFieldValueMap.put("p_splitdimensionid", planRow.get("p_splitdimensionid"));
            tarPlanFieldValueMap.put("p_payrate", planRow.get("p_payrate"));
            for (String fieldName : planExtendFields) {
                tarPlanFieldValueMap.put(fieldName, planRow.get(fieldName));
            }
            planEntryParams.add(tarPlanFieldValueMap);
        }
        pushParam.setTarInvEntrys(planEntryParams);
        return paramList;
    }
}

