/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.opplugin.tolerance;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ap.business.tolerance.FormulaUtil;

public class ToleranceStrategySaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            DynamicObject Strategy = data.getDataEntity();
            DynamicObjectCollection strategyDetails = Strategy.getDynamicObjectCollection("strategyentry");
            for (int i = 0; i < strategyDetails.size(); ++i) {
                DynamicObject strategyDetail = (DynamicObject)strategyDetails.get(i);
                String controlParty = strategyDetail.getDynamicObject("e_controlparty").getString("id");
                String controlPartyName = strategyDetail.getDynamicObject("e_controlparty").getString("name");
                String oppositeParty = strategyDetail.getDynamicObject("e_oppositeparty").getString("id");
                String oppositePartyName = strategyDetail.getDynamicObject("e_oppositeparty").getString("name");
                String controlObjectDesc = strategyDetail.getString("e_controlobjectdesc");
                String oppositeObjectDesc = strategyDetail.getString("e_oppositeobjectdesc");
                if (!this.fieldIllegalCheck(controlParty, controlPartyName, controlObjectDesc, data, i)) {
                    return;
                }
                if (!this.fieldIllegalCheck(oppositeParty, oppositePartyName, oppositeObjectDesc, data, i)) {
                    return;
                }
                String source = strategyDetail.getString("e_source");
                this.partyIllegalCheck(controlParty, controlObjectDesc, oppositeParty, oppositeObjectDesc, source, data, i);
            }
        }
    }

    private void partyIllegalCheck(String controlParty, String controlObjectDesc, String oppositeParty, String oppositeObjectDesc, String source, ExtendedDataEntity data, int i) {
        if (!FormulaUtil.isSame((String)controlParty, (String)controlObjectDesc, (String)oppositeParty, (String)oppositeObjectDesc).booleanValue()) {
            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u5bb9\u5dee\u7b56\u7565\u7b2c%s\u884c\uff1a\u7ba1\u63a7\u5bf9\u8c61\u548c\u5bf9\u6bd4\u5bf9\u8c61\u9700\u540c\u65f6\u4e3a\u8868\u5934\u6216\u8868\u4f53\u3002", (String)"ToleranceStrategySaveValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), i + 1));
        }
        if (controlParty.equals(oppositeParty)) {
            if (!"SELF".equals(source.replace(",", ""))) {
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u5bb9\u5dee\u7b56\u7565\u7b2c%s\u884c\uff1a\u7ba1\u63a7\u65b9\u548c\u5bf9\u6bd4\u65b9\u4e00\u81f4\uff0c\u201c\u5173\u7cfb\u6765\u6e90\u201d\u9700\u8981\u8bbe\u7f6e\u4e3a\u672c\u5355\u3002", (String)"ToleranceStrategySaveValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), i + 1));
            }
        } else if (source.contains("SELF")) {
            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u5bb9\u5dee\u7b56\u7565\u7b2c%s\u884c\uff1a\u7ba1\u63a7\u65b9\u548c\u5bf9\u6bd4\u65b9\u4e0d\u4e00\u81f4\uff0c\u5173\u7cfb\u6765\u6e90\u4e0d\u80fd\u5305\u542b\u672c\u5355\u3002", (String)"ToleranceStrategySaveValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]), i + 1));
        }
    }

    private boolean fieldIllegalCheck(String party, String partyName, String objectdesc, ExtendedDataEntity data, int i) {
        String expression = FormulaUtil.getExpression((String)objectdesc);
        List fields = FormulaUtil.getFields((String)expression);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)party);
        Map allFields = dataEntityType.getAllFields();
        for (String field : fields) {
            if (allFields.get(field) == null) {
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u5bb9\u5dee\u7b56\u7565\u7b2c%1$s\u884c\uff1a%2$s\u4e0d\u5b58\u5728%3$s\u5c5e\u6027\u3002", (String)"ToleranceStrategySaveValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]), i + 1, partyName, field));
                return false;
            }
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(field);
            Class propertyType = iDataEntityProperty.getPropertyType();
            if (propertyType.isInstance(BigDecimal.ZERO)) continue;
            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u5bb9\u5dee\u7b56\u7565\u7b2c%1$s\u884c\uff1a%2$s\u6240\u9009\u62e9\u7684%3$s\u4e0d\u662f\u6570\u503c\u7c7b\u578b\u3002", (String)"ToleranceStrategySaveValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), i + 1, partyName, field));
            return false;
        }
        return true;
    }
}

