/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.form.FormServiceHelper;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ApBusBillImportValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        HashMap<Long, InitHelper> initMap = new HashMap<Long, InitHelper>();
        HashMap measureUnitIds = new HashMap();
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.FALSE);
        Map settlementTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_settlementtype", (String)"id,number,enable", (QFilter[])filter.toArray());
        DynamicObject defaultSettlement = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        for (ExtendedDataEntity data : datas) {
            String message;
            DynamicObject bill = data.getDataEntity();
            long orgPk = (Long)bill.getDynamicObject("org").getPkValue();
            String billSrctype = bill.getString("billsrctype");
            DynamicObject bizType = bill.getDynamicObject("biztype");
            if (ObjectUtils.isEmpty((Object)bill.getDynamicObject("settlementtype"))) {
                if (ObjectUtils.isEmpty((Object)defaultSettlement)) {
                    bill.set("settlementtype", null);
                } else {
                    bill.set("settlementtype", (Object)defaultSettlement);
                }
            } else {
                DynamicObject settlementType = bill.getDynamicObject("settlementtype");
                Long id = settlementType.getLong("id");
                if (settlementTypeMap.containsKey(id)) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c\u7ed3\u7b97\u65b9\u5f0f\u201d\u72b6\u6001\u4e3a\u7981\u7528\u3002", (String)"ApBusBillImportValidator_10", (String)"fi-ap-opplugin", (Object[])new Object[0]), new Object[0]));
                }
            }
            if (!BillSrcTypeEnum.IMPORT.getValue().equals(billSrctype)) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            FormServiceHelper.checkMeasureUnitRange((DynamicObjectCollection)entries, (String)"e_material", measureUnitIds);
            for (int i = 0; i < entries.size(); ++i) {
                Long materialId;
                Set usableUnitIds;
                DynamicObject row = (DynamicObject)entries.get(i);
                DynamicObject material = row.getDynamicObject("e_material");
                DynamicObject measureUnit = row.getDynamicObject("e_measureunit");
                if (material != null && measureUnit != null && !(usableUnitIds = (Set)measureUnitIds.get(materialId = Long.valueOf(material.getLong("id")))).contains(measureUnit.getLong("id"))) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u8ba1\u4ef7\u5355\u4f4d\u4e0d\u5728\u7269\u6599\u53ef\u7528\u7684\u8ba1\u91cf\u5355\u4f4d\u8303\u56f4\u5185\u3002", (String)"ApBusBillImportValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), i + 1));
                }
                if (material == null) continue;
                String configproperty = material.getString("configproperties");
                DynamicObject configuredcode = row.getDynamicObject("configuredcode");
                if ("2".equals(configproperty)) {
                    if (EmptyUtils.isNotEmpty((Object)configuredcode)) {
                        if (!material.getString("number").equals(configuredcode.getString("material.number"))) {
                            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u3010\u660e\u7ec6\u3011\u7b2c%s\u884c\uff0c\u5bfc\u5165\u7684\u3010\u914d\u7f6e\u53f7\u3011\u4e0e\u7269\u6599\u4e0d\u5339\u914d\u3002", (String)"ApBusBillImportValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]), i + 1));
                        }
                    } else {
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u3010\u660e\u7ec6\u3011\u7b2c%s\u884c\u3010\u914d\u7f6e\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApBusBillImportValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]), i + 1));
                    }
                } else if (EmptyUtils.isNotEmpty((Object)configuredcode)) {
                    row.set("configuredcode", null);
                }
                if (!EmptyUtils.isNotEmpty((Object)bizType)) continue;
                if (("604".equals(bizType.getString("number")) || "6041".equals(bizType.getString("number"))) && !material.getBoolean("enableproduct")) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u4e1a\u52a1\u7c7b\u578b\u4e3a\u5de5\u5e8f\u59d4\u5916\u6216\u5de5\u5e8f\u59d4\u5916\u9000\u8d27\u65f6\uff0c\u5bfc\u5165\u7684\u7269\u6599\u5fc5\u987b\u4e3a\u3010\u53ef\u751f\u4ea7\u3011\u7269\u6599\u3002", (String)"ApBusBillImportValidator_8", (String)"fi-ap-opplugin", (Object[])new Object[0]), i + 1));
                }
                if (!"115".equals(bizType.getString("number")) && !"1151".equals(bizType.getString("number")) || material.getBoolean("enableoutsource")) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u4e1a\u52a1\u7c7b\u578b\u4e3a\u59d4\u5916\u91c7\u8d2d\u6216\u59d4\u5916\u91c7\u8d2d\u9000\u8d27\u65f6\uff0c\u5bfc\u5165\u7684\u7269\u6599\u5fc5\u987b\u4e3a\u3010\u53ef\u59d4\u5916\u3011\u7269\u6599\u3002", (String)"ApBusBillImportValidator_9", (String)"fi-ap-opplugin", (Object[])new Object[0]), i + 1));
            }
            InitHelper init = null;
            if (!initMap.containsKey(orgPk)) {
                init = new InitHelper(orgPk, "ap_init");
                if (!ObjectUtils.isEmpty((Object)init.getInitId())) {
                    initMap.put(orgPk, init);
                }
            } else {
                init = (InitHelper)initMap.get(orgPk);
            }
            if (StringUtils.isEmpty((String)(message = this.dataCheck(bill, init)))) continue;
            this.addErrorMessage(data, message);
        }
    }

    private String dataCheck(DynamicObject bill, InitHelper init) {
        String message = null;
        try {
            Date bizDate = bill.getDate("bizdate");
            if (bill.getBoolean("isperiod")) {
                if (init.isFinishInit()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\u4e0d\u5141\u8bb8\u5bfc\u5165\u671f\u521d\u5355\u636e\u3002", (String)"ApBusBillImportValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                }
                if (DateUtils.compareTo((Date)bizDate, (Date)init.getStartDate()) >= 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u542f\u7528\u65e5\u671f\uff08%s\uff09\u3002", (String)"ApBusBillImportValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[]{init.getStartDate()}));
                }
            } else {
                Date startDate = init.getStartDate();
                if (!ObjectUtils.isEmpty((Object)startDate) && DateUtils.compareTo((Date)bizDate, (Date)startDate) < 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65e5\u671f\uff08%s\uff09\u3002", (String)"ApBusBillImportValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[]{startDate}));
                }
            }
        }
        catch (KDBizException e) {
            message = e.getMessage();
        }
        return message;
    }
}

