/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;

public class ApPayPropertyValidator
extends AbstractExecControlValidator {
    public void validate() {
        HashMap<Long, Boolean> orgMap = new HashMap<Long, Boolean>(64);
        BillModel billModel = BillModelFactory.getModel((String)this.entityKey);
        ArrayList<ExtendedDataEntity> directPmAccept = new ArrayList<ExtendedDataEntity>(64);
        ArrayList<ExtendedDataEntity> indirectPmAccept = new ArrayList<ExtendedDataEntity>(64);
        for (ExtendedDataEntity dataEntity2 : this.dataEntities) {
            DynamicObject entity = dataEntity2.getDataEntity();
            long l = entity.getLong(billModel.HEAD_ORG + ".id");
            Boolean enable = (Boolean)orgMap.get(l);
            if (enable == null) {
                enable = SystemParameterHelper.getAPBooleanParam((long)l, (String)"ap_025");
                orgMap.put(l, enable);
            }
            if (Boolean.TRUE.equals(enable)) continue;
            if ("pm_puracceptbill".equals(entity.getString(billModel.HEAD_SOURCEBILLTYPE))) {
                directPmAccept.add(dataEntity2);
                continue;
            }
            if (ObjectUtils.isEmpty((Object)entity.getString(billModel.HEAD_SOURCEBILLTYPE))) continue;
            indirectPmAccept.add(dataEntity2);
        }
        Set<Object> pmAcceptBillIds = new HashSet(64);
        if (!directPmAccept.isEmpty()) {
            pmAcceptBillIds = directPmAccept.stream().map(dataEntity -> dataEntity.getDataEntity().getLong(billModel.HEAD_SOURCEBILLID)).collect(Collectors.toSet());
        }
        Map botpRelationMap = new HashMap(64);
        if (!indirectPmAccept.isEmpty()) {
            HashSet<Long> billIdSet = new HashSet<Long>(8);
            HashSet<Long> billEntryIdSet = new HashSet<Long>(8);
            for (ExtendedDataEntity extendedDataEntity : indirectPmAccept) {
                DynamicObject entity = extendedDataEntity.getDataEntity();
                billIdSet.add(entity.getLong("id"));
                DynamicObjectCollection entryColl = entity.getDynamicObjectCollection(billModel.ENTRY);
                for (DynamicObject entry : entryColl) {
                    billEntryIdSet.add(entry.getLong("id"));
                }
            }
            botpRelationMap = BOTPHelper.loadNearUpBillIds((String)this.entityKey, (String)billModel.ENTRY, (Long[])billIdSet.toArray(new Long[0]), (Long[])billEntryIdSet.toArray(new Long[0]), (String)"pm_puracceptbill");
            if (!ObjectUtils.isEmpty(botpRelationMap)) {
                for (Map.Entry entry : botpRelationMap.entrySet()) {
                    pmAcceptBillIds.addAll((Collection)entry.getValue());
                }
            }
        }
        if (pmAcceptBillIds.isEmpty()) {
            return;
        }
        Object[] pmAcceptBills = BusinessDataServiceHelper.load((String)"pm_puracceptbill", (String)"id,billentry.id,billentry.linetype", (QFilter[])new QFilter[]{new QFilter("id", "in", pmAcceptBillIds)});
        if (ObjectUtils.isEmpty((Object[])pmAcceptBills)) {
            return;
        }
        HashMap<Long, String> pmAcceptLineTypeMap = new HashMap<Long, String>(8);
        for (Object pmAcceptBill : pmAcceptBills) {
            DynamicObjectCollection billEntry = pmAcceptBill.getDynamicObjectCollection("billentry");
            if (billEntry.size() <= 0) continue;
            pmAcceptLineTypeMap.put(pmAcceptBill.getLong("id"), ((DynamicObject)billEntry.get(0)).getString("linetype.controlcriterion"));
        }
        for (ExtendedDataEntity extendedDataEntity : directPmAccept) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            boolean isBaseAmt = entity.getBoolean(billModel.HEAD_PAYPROPERTY + ".isbasedonamt");
            String lineType = (String)pmAcceptLineTypeMap.get(entity.getLong(billModel.HEAD_SOURCEBILLID));
            if (isBaseAmt && "1".equals(lineType) || !isBaseAmt && "0".equals(lineType)) continue;
            String v = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u4e0e\u4e0a\u6e38\u5355\u636e\u884c\u7c7b\u578b\u4e2d\u7684\u63a7\u5236\u57fa\u51c6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u6210\u4e00\u81f4\u540e\u518d\u63d0\u4ea4\u3002\u672c\u5355\u636e\u7684\u63a7\u5236\u57fa\u51c6\u7531\u201c\u6b3e\u9879\u6027\u8d28\u201d\u7684\u201c\u662f\u5426\u91d1\u989d\u57fa\u51c6\u201d\u6807\u8bc6\u51b3\u5b9a\u3002", (String)"ApPayPropertyValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), entity.getString(billModel.HEAD_BILLNO));
            this.addMessage(extendedDataEntity, v);
        }
        block6: for (ExtendedDataEntity extendedDataEntity : indirectPmAccept) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            boolean isBaseAmt = entity.getBoolean(billModel.HEAD_PAYPROPERTY + ".isbasedonamt");
            List pmAcceptIds = (List)botpRelationMap.get(entity.getLong("id"));
            if (ObjectUtils.isEmpty((Object)pmAcceptIds)) continue;
            for (Long pmAcceptId : pmAcceptIds) {
                String lineType = (String)pmAcceptLineTypeMap.get(pmAcceptId);
                if (isBaseAmt && "1".equals(lineType) || !isBaseAmt && "0".equals(lineType)) continue;
                String v = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u4e0e\u4e0a\u6e38\u5355\u636e\u884c\u7c7b\u578b\u4e2d\u7684\u63a7\u5236\u57fa\u51c6\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u6210\u4e00\u81f4\u540e\u518d\u63d0\u4ea4\u3002\u672c\u5355\u636e\u7684\u63a7\u5236\u57fa\u51c6\u7531\u201c\u6b3e\u9879\u6027\u8d28\u201d\u7684\u201c\u662f\u5426\u91d1\u989d\u57fa\u51c6\u201d\u6807\u8bc6\u51b3\u5b9a\u3002", (String)"ApPayPropertyValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), entity.getString(billModel.HEAD_BILLNO));
                this.addMessage(extendedDataEntity, v);
                continue block6;
            }
        }
    }

    public Set<String> preparePropertys() {
        HashSet<String> selector = new HashSet<String>(64);
        selector.add("billno");
        selector.add("payproperty");
        selector.add("sourcebillid");
        selector.add("sourcebilltype");
        return selector;
    }
}

