/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.mservice.ToleranceMatchService;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;
import kd.fi.arapcommon.vo.CoreBillInfo;
import org.apache.commons.lang.StringUtils;

public class ApplyBillPaymentSecuritySubmitCtrlService
implements IExecCtrlService<Object> {
    private static final Log logger = LogFactory.getLog(ApplyBillPaymentSecuritySubmitCtrlService.class);

    public <T> T execute(Object ... param) {
        if (param == null || param.length == 0) {
            return null;
        }
        DynamicObject[] bills = (DynamicObject[])param;
        Map<String, CoreBillInfo> coreBillInfo = this.queryCoreBill(bills);
        if (coreBillInfo.size() == 0) {
            return null;
        }
        logger.info(coreBillInfo.toString());
        Map<Long, Long> supplierMasterIds = this.getSupplierMasterId(coreBillInfo);
        Map<Long, Integer> precisions = this.getPrecision(coreBillInfo);
        List<CoreBillInfo> cacheData = this.readFormCacheAndWriteCurBillToCache(bills);
        this.loadNeedCtrlFinBillInfos(coreBillInfo, cacheData);
        Set<String> prePayOverToleranceIds = this.processTolerance(coreBillInfo, supplierMasterIds, precisions, true);
        Set<String> sumAmtOverToleranceIds = this.processTolerance(coreBillInfo, supplierMasterIds, precisions, false);
        logger.info(String.valueOf(sumAmtOverToleranceIds.size()));
        this.doValidate(bills, coreBillInfo, prePayOverToleranceIds, sumAmtOverToleranceIds);
        return null;
    }

    private Map<Long, Integer> getPrecision(Map<String, CoreBillInfo> coreBillInfo) {
        HashSet<Long> currencyIds = new HashSet<Long>(16);
        for (Map.Entry<String, CoreBillInfo> entrySet : coreBillInfo.entrySet()) {
            currencyIds.add(entrySet.getValue().getCurrencyId());
        }
        HashMap<Long, Integer> precisions = new HashMap<Long, Integer>(16);
        DynamicObjectCollection currencys = QueryServiceHelper.query((String)"bd_currency", (String)"id,amtprecision", (QFilter[])new QFilter[]{new QFilter("id", "in", currencyIds)});
        for (DynamicObject currency : currencys) {
            precisions.put(currency.getLong("id"), currency.getInt("amtprecision"));
        }
        return precisions;
    }

    private Map<Long, Long> getSupplierMasterId(Map<String, CoreBillInfo> coreBillInfo) {
        HashSet<Long> supplierIds = new HashSet<Long>(16);
        for (Map.Entry<String, CoreBillInfo> entrySet : coreBillInfo.entrySet()) {
            supplierIds.add(entrySet.getValue().getSupplierId());
        }
        HashMap<Long, Long> supplierMasterIds = new HashMap<Long, Long>(16);
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
        for (DynamicObject supplier : suppliers) {
            supplierMasterIds.put(supplier.getLong("id"), supplier.getLong("masterid"));
        }
        return supplierMasterIds;
    }

    private Set<String> processTolerance(Map<String, CoreBillInfo> coreBillInfo, Map<Long, Long> supplierMasterIds, Map<Long, Integer> precisions, boolean isPrePay) {
        HashSet<String> overToleranceId;
        block24: {
            Map result;
            Object results;
            ToleranceMatchService service;
            ArrayList pmomParams;
            ArrayList scpoParams;
            ArrayList conmParams;
            ArrayList purOrderParams;
            block23: {
                List results2;
                overToleranceId = new HashSet<String>(16);
                purOrderParams = new ArrayList(16);
                conmParams = new ArrayList(16);
                scpoParams = new ArrayList(16);
                pmomParams = new ArrayList(16);
                service = new ToleranceMatchService();
                if (!isPrePay) break block23;
                for (Map.Entry<String, CoreBillInfo> entry : coreBillInfo.entrySet()) {
                    CoreBillInfo info = entry.getValue();
                    if (!info.isAllowOverPay() || info.getSumPrePayAmt().compareTo(info.getPreparePayAmt()) == 0) continue;
                    String coreBillType = info.getCoreBillType();
                    HashMap<String, Object> param = new HashMap<String, Object>(16);
                    param.put("pk", entry.getKey());
                    param.put("bd_supplier", supplierMasterIds.get(info.getSupplierId()));
                    param.put("controlvalue", info.getSumPrePayAmt());
                    param.put("contrastvalue", info.getPreparePayAmt());
                    param.put("bd_currency", info.getCurrencyId());
                    param.put("precision", precisions.get(info.getCurrencyId()));
                    param.put("bos_org", info.getOrgId());
                    if ("pm_purorderbill".equals(coreBillType)) {
                        purOrderParams.add(param);
                        continue;
                    }
                    if ("conm_purcontract".equals(coreBillType)) {
                        conmParams.add(param);
                        continue;
                    }
                    if ("sctm_scpo".equals(coreBillType)) {
                        scpoParams.add(param);
                        continue;
                    }
                    if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                    pmomParams.add(param);
                }
                if (purOrderParams.size() > 0) {
                    List results22 = service.getResultByToleranceType("ap_payapply", "pm_purorderbill", "e_approvedseleamt", "payamount", purOrderParams);
                    for (Map result2 : results22) {
                        overToleranceId.add((String)result2.get("pk"));
                    }
                }
                if (conmParams.size() > 0) {
                    results2 = service.getResultByToleranceType("ap_payapply", "conm_purcontract", "e_approvedseleamt", "payamount", conmParams);
                    for (Map result2 : results2) {
                        overToleranceId.add((String)result2.get("pk"));
                    }
                }
                if (scpoParams.size() > 0) {
                    results2 = service.getResultByToleranceType("ap_payapply", "sctm_scpo", "e_approvedseleamt", "payamount", scpoParams);
                    for (Map result2 : results2) {
                        overToleranceId.add((String)result2.get("pk"));
                    }
                }
                if (pmomParams.size() <= 0) break block24;
                results2 = service.getResultByToleranceType("ap_payapply", "pm_om_purorderbill", "e_approvedseleamt", "payamount", pmomParams);
                for (Map result2 : results2) {
                    overToleranceId.add((String)result2.get("pk"));
                }
                break block24;
            }
            for (Map.Entry<String, CoreBillInfo> entry : coreBillInfo.entrySet()) {
                CoreBillInfo info = entry.getValue();
                if (info.getSumAmt().compareTo(info.getCoreBillAmt()) == 0) continue;
                String coreBillType = info.getCoreBillType();
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("pk", entry.getKey());
                param.put("bd_supplier", supplierMasterIds.get(info.getSupplierId()));
                param.put("controlvalue", info.getSumAmt());
                param.put("contrastvalue", info.getCoreBillAmt());
                param.put("bd_currency", info.getCurrencyId());
                param.put("bos_org", info.getOrgId());
                param.put("precision", precisions.get(info.getCurrencyId()));
                if ("pm_purorderbill".equals(coreBillType)) {
                    purOrderParams.add(param);
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    conmParams.add(param);
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    scpoParams.add(param);
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                pmomParams.add(param);
            }
            if (purOrderParams.size() > 0) {
                results = service.getResultByToleranceType("ap_payapply", "pm_purorderbill", "e_approvedseleamt", "totalallamount", purOrderParams);
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    result = (Map)iterator.next();
                    overToleranceId.add((String)result.get("pk"));
                }
            }
            if (conmParams.size() > 0) {
                results = service.getResultByToleranceType("ap_payapply", "conm_purcontract", "e_approvedseleamt", "totalallamount", conmParams);
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    result = (Map)iterator.next();
                    overToleranceId.add((String)result.get("pk"));
                }
            }
            if (scpoParams.size() > 0) {
                results = service.getResultByToleranceType("ap_payapply", "sctm_scpo", "e_approvedseleamt", "totalallamount", scpoParams);
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    result = (Map)iterator.next();
                    overToleranceId.add((String)result.get("pk"));
                }
            }
            if (pmomParams.size() > 0) {
                results = service.getResultByToleranceType("ap_payapply", "pm_om_purorderbill", "e_approvedseleamt", "totalallamount", pmomParams);
                Iterator iterator = results.iterator();
                while (iterator.hasNext()) {
                    result = (Map)iterator.next();
                    overToleranceId.add((String)result.get("pk"));
                }
            }
        }
        return overToleranceId;
    }

    private void doValidate(DynamicObject[] bills, Map<String, CoreBillInfo> coreBillInfos, Set<String> prePayOverToleranceIds, Set<String> sumAmtOverToleranceIds) {
        HashSet<String> messages = new HashSet<String>(16);
        for (DynamicObject applyBill : bills) {
            String billNo = applyBill.getString("billno");
            Long orgId = applyBill.getLong("settleorg.id");
            Long currencyId = applyBill.getLong("settlecurrency.id");
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String msg;
                Long coreBillId = row.getLong("e_corebillid");
                if (coreBillId == 0L) continue;
                Long asstactId = row.getLong("e_asstact.id");
                String key = coreBillId + "_" + orgId + "_" + asstactId + "_" + currencyId;
                CoreBillInfo coreBillInfo = coreBillInfos.get(key);
                if (coreBillInfo == null) continue;
                String coreBillNo = row.getString("e_corebillno");
                String coreBillType = row.getString("e_corebilltype");
                String coreBillName = null;
                if ("pm_purorderbill".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"ApplyBillPaymentSecuritySubmitCtrlService_0", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("conm_purcontract".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c", (String)"ApplyBillPaymentSecuritySubmitCtrlService_1", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("sctm_scpo".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355", (String)"ApplyBillPaymentSecuritySubmitCtrlService_2", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("pm_om_purorderbill".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u7b80\u5355\u59d4\u5916\u8ba2\u5355", (String)"ApplyBillPaymentSecuritySubmitCtrlService_3", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                }
                boolean isAllowOverPay = coreBillInfo.isAllowOverPay();
                if (isAllowOverPay) {
                    if (prePayOverToleranceIds.contains(key)) {
                        msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309%2$s\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001\u6838\u51c6\u91d1\u989d\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u4e0e%2$s\u9884\u4ed8\u91d1\u989d\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApplyBillPaymentSecuritySubmitCtrlService_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, coreBillName);
                        messages.add(msg);
                    }
                    if (!sumAmtOverToleranceIds.contains(key)) continue;
                    msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309%2$s\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001\u6838\u51c6\u91d1\u989d\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u4e0e%2$s\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApplyBillPaymentSecuritySubmitCtrlService_5", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, coreBillName);
                    messages.add(msg);
                    continue;
                }
                if (coreBillInfo.getSumPrePayAmt().compareTo(coreBillInfo.getPreparePayAmt()) > 0) {
                    msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309%2$s\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001\u6838\u51c6\u91d1\u989d\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85%2$s\u9884\u4ed8\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApplyBillPaymentSecuritySubmitCtrlService_6", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, coreBillName);
                    messages.add(msg);
                }
                if (coreBillInfo.getSumAmt().compareTo(coreBillInfo.getCoreBillAmt()) <= 0) continue;
                msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u6309%2$s\u67e5\u8be2\u7684\u9884\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001\u6838\u51c6\u91d1\u989d\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\uff0c\u8d85\u8fc7%2$s\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApplyBillPaymentSecuritySubmitCtrlService_7", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, coreBillName);
                messages.add(msg);
            }
        }
        if (messages.size() > 0) {
            throw new KDBizException(StringUtils.join(messages, (String)"\n"));
        }
    }

    private void loadNeedCtrlFinBillInfos(Map<String, CoreBillInfo> coreBillInfoMap, List<CoreBillInfo> cacheData) {
        HashSet<Long> coreBillIds = new HashSet<Long>(16);
        for (Map.Entry<String, CoreBillInfo> entry : coreBillInfoMap.entrySet()) {
            CoreBillInfo info = entry.getValue();
            coreBillIds.add(info.getCoreBillId());
        }
        HashSet<Long> billIds = new HashSet<Long>(16);
        for (CoreBillInfo cacheInfo : cacheData) {
            billIds.add(cacheInfo.getBillId());
            Long coreBillId = cacheInfo.getCoreBillId();
            Long orgId = cacheInfo.getOrgId();
            Long asstactId = cacheInfo.getSupplierId();
            Long cacheCurrencyId = cacheInfo.getCurrencyId();
            String key = coreBillId + "_" + orgId + "_" + asstactId + "_" + cacheCurrencyId;
            CoreBillInfo coreBillInfo = coreBillInfoMap.get(key);
            if (coreBillInfo == null) continue;
            coreBillInfo.setSumPrePayAmt(coreBillInfo.getSumPrePayAmt().add(cacheInfo.getPreparePayAmt()));
            coreBillInfo.setSumAmt(coreBillInfo.getSumAmt().add(cacheInfo.getCoreBillAmt()));
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"ap_payapply", (String)"id,sourcebilltype,billstatus,settlecurrency,settleorg,entry.e_paymenttype.biztype,entry.e_asstact,entry.e_corebillid,entry.e_approvedseleamt,entry.e_paidamt,entry.id", (QFilter[])new QFilter[]{new QFilter("entry.e_corebillid", "in", coreBillIds), new QFilter("billstatus", "!=", (Object)"A")});
        for (DynamicObject bill : dynamicObjectCollection) {
            Long billId = bill.getLong("id");
            if (billIds.contains(billId)) continue;
            Long coreBillId = bill.getLong("entry.e_corebillid");
            Long orgId = bill.getLong("settleorg");
            Long asstactId = bill.getLong("entry.e_asstact");
            Long currencyId = bill.getLong("settlecurrency");
            String key = coreBillId + "_" + orgId + "_" + asstactId + "_" + currencyId;
            CoreBillInfo coreBillInfo = coreBillInfoMap.get(key);
            if (coreBillInfo == null) continue;
            String billStatus = bill.getString("billstatus");
            BigDecimal approvedAmt = "D".equals(billStatus) ? bill.getBigDecimal("entry.e_paidamt") : bill.getBigDecimal("entry.e_approvedseleamt");
            String sourceBillType = bill.getString("sourcebilltype");
            String payType = bill.getString("entry.e_paymenttype.biztype");
            if (!"pm_purorderbill".equals(sourceBillType) && !"conm_purcontract".equals(sourceBillType) && !"sctm_scpo".equals(sourceBillType) && !"ap_finapbill".equals(sourceBillType)) continue;
            coreBillInfo.setSumAmt(coreBillInfo.getSumAmt().add(approvedAmt));
            if (!"202".equals(payType)) continue;
            coreBillInfo.setSumPrePayAmt(coreBillInfo.getSumPrePayAmt().add(approvedAmt));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoreBillInfo> readFormCacheAndWriteCurBillToCache(DynamicObject[] bills) {
        List existsCache = new ArrayList(16);
        final String cacheKey = "applycache";
        final String lockKey = cacheKey + RequestContext.get().getAccountId() + "_lock";
        final IAppCache iAppCache = AppCache.get((String)"paysecurity");
        final HashSet<Long> billIds = new HashSet<Long>(16);
        ArrayList<CoreBillInfo> currentBills = new ArrayList<CoreBillInfo>(16);
        for (DynamicObject applyBill : bills) {
            Long billId = applyBill.getLong("id");
            billIds.add(billId);
            String sourceBillType = applyBill.getString("sourcebilltype");
            if (!"pm_purorderbill".equals(sourceBillType) && !"conm_purcontract".equals(sourceBillType) && !"sctm_scpo".equals(sourceBillType) && !"ap_finapbill".equals(sourceBillType) && !"pm_om_purorderbill".equals(sourceBillType)) continue;
            DynamicObjectCollection entry = applyBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                this.setCoreBillInfo(currentBills, applyBill, row);
            }
        }
        try (DLock lock = DLock.create((String)lockKey);){
            lock.lock();
            try {
                String value = (String)iAppCache.get(cacheKey, String.class);
                if (value != null) {
                    existsCache = SerializationUtils.fromJsonStringToList((String)value, CoreBillInfo.class);
                }
                if (existsCache != null) {
                    currentBills.addAll(existsCache);
                }
                iAppCache.put(cacheKey, (Object)SerializationUtils.toJsonString(currentBills));
            }
            finally {
                lock.unlock();
            }
        }
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onEnded(boolean rollbacked) {
                ApplyBillPaymentSecuritySubmitCtrlService.this.removeCache(iAppCache, billIds, cacheKey, lockKey);
            }
        });
        return currentBills;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCache(IAppCache iAppCache, Set<Long> billIds, String cacheKey, String lockKey) {
        try (DLock lock = DLock.create((String)lockKey);){
            lock.lock();
            try {
                String value = (String)iAppCache.get(cacheKey, String.class);
                if (value != null) {
                    List cache = SerializationUtils.fromJsonStringToList((String)value, CoreBillInfo.class);
                    Iterator iterator = cache.iterator();
                    while (iterator.hasNext()) {
                        CoreBillInfo next = (CoreBillInfo)iterator.next();
                        Long billId = next.getBillId();
                        if (!billIds.contains(billId)) continue;
                        iterator.remove();
                    }
                    iAppCache.put(cacheKey, (Object)SerializationUtils.toJsonString((Object)cache));
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void setCoreBillInfo(List<CoreBillInfo> currentBills, DynamicObject applyBill, DynamicObject entry) {
        Long billId = applyBill.getLong("id");
        Long orgId = applyBill.getLong("settleorg.id");
        Long currencyId = applyBill.getLong("settlecurrency.id");
        Long coreBillId = entry.getLong("e_corebillid");
        if (coreBillId == 0L) {
            return;
        }
        String payType = entry.getString("e_paymenttype.biztype");
        String asstactType = entry.getString("e_asstacttype");
        if ("bd_supplier".equals(asstactType)) {
            Long asstactId = entry.getLong("e_asstact.id");
            CoreBillInfo info = new CoreBillInfo();
            info.setCoreBillId(coreBillId);
            info.setBillId(billId);
            info.setCurrencyId(currencyId);
            info.setOrgId(orgId);
            info.setSupplierId(asstactId);
            info.setCoreBillAmt(entry.getBigDecimal("e_approvedseleamt"));
            if ("202".equals(payType)) {
                info.setPreparePayAmt(entry.getBigDecimal("e_approvedseleamt"));
            }
            currentBills.add(info);
        }
    }

    private Map<String, CoreBillInfo> queryCoreBill(DynamicObject[] bills) {
        List orderInfo;
        HashMap<String, CoreBillInfo> coreBillInfoMap = new HashMap<String, CoreBillInfo>(16);
        HashMap coreOrderBillInfo = new HashMap(16);
        HashMap coreConBillInfo = new HashMap(16);
        HashMap coreOmBillInfo = new HashMap(16);
        HashMap corePmOmBillInfo = new HashMap(16);
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                Long coreBillId = row.getLong("e_corebillid");
                if (coreBillId == 0L) continue;
                String coreBillType = row.getString("e_corebilltype");
                if ("pm_purorderbill".equals(coreBillType)) {
                    coreOrderBillInfo.put(coreBillId, new HashSet(2));
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    coreConBillInfo.put(coreBillId, new HashSet(2));
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    coreOmBillInfo.put(coreBillId, new HashSet(2));
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                corePmOmBillInfo.put(coreBillId, new HashSet(2));
            }
        }
        if (coreOrderBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreOrderBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "pm_purorderbill");
        }
        if (coreConBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"PurConmService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreConBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "conm_purcontract");
        }
        if (coreOmBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sctm", (String)"ScPoService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreOmBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "sctm_scpo");
        }
        if (corePmOmBillInfo.size() > 0) {
            orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"OmPurOrderbillService", (String)"getOmPurOrderbillInfo", (Object[])new Object[]{corePmOmBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "pm_om_purorderbill");
        }
        return coreBillInfoMap;
    }

    private void setCoreBillInfoMap(Map<String, CoreBillInfo> coreBillInfoMap, List<Map<String, Object>> params, String coreBillType) {
        for (Map<String, Object> map : params) {
            boolean isAllowOverPay = (Boolean)map.get("isallowoverpay");
            Long id = (Long)map.get("billid");
            Long asstactId = (Long)map.get("invoicesupplier");
            Long currencyId = (Long)map.get("settlecurrency");
            BigDecimal preparePayAmt = (BigDecimal)map.get("sumprepayamount");
            List entrys = (List)map.get("entryinfo");
            for (Map entry : entrys) {
                Long orgId = (Long)entry.get("settleorg");
                String key = id + "_" + orgId + "_" + asstactId + "_" + currencyId;
                CoreBillInfo info = coreBillInfoMap.get(key);
                if (info == null) {
                    info = new CoreBillInfo();
                    info.setCoreBillId(id);
                    info.setAllowOverPay(isAllowOverPay);
                    info.setOrgId(orgId);
                    info.setCoreBillType(coreBillType);
                    info.setSupplierId(asstactId);
                    info.setCoreBillAmt((BigDecimal)entry.get("amountandtax"));
                    info.setCurrencyId(currencyId);
                    info.setPreparePayAmt(preparePayAmt);
                    coreBillInfoMap.put(key, info);
                    continue;
                }
                info.setCoreBillAmt(info.getCoreBillAmt().add((BigDecimal)entry.get("amountandtax")));
            }
        }
    }
}

