/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.StringUtils;

public class ApplyBillToPurBillValidatorByRelation
extends AbstractExecControlValidator {
    public Set<String> preparePropertys() {
        HashSet<String> lst = new HashSet<String>(16);
        lst.add("entry.e_paidamt");
        lst.add("billstatus");
        lst.add("aprseleamount");
        lst.add("entry.e_asstact");
        lst.add("entry.e_approvedseleamt");
        lst.add("entry.e_corebillno");
        return lst;
    }

    public void validate() {
        HashSet<Long> payBillIds = new HashSet<Long>(16);
        HashMap<Long, BigDecimal> payAsstactAmt = new HashMap<Long, BigDecimal>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                String coreBillNo = row.getString("e_corebillno");
                if (StringUtils.isEmpty((String)coreBillNo)) continue;
                Long asstactId = row.getLong("e_asstact.id");
                BigDecimal asstSumAmt = (BigDecimal)payAsstactAmt.get(asstactId);
                if (asstSumAmt == null) {
                    payAsstactAmt.put(asstactId, row.getBigDecimal("e_approvedseleamt"));
                    continue;
                }
                payAsstactAmt.put(asstactId, asstSumAmt.add(row.getBigDecimal("e_approvedseleamt")));
            }
            payBillIds.add(bill.getLong("id"));
        }
        Map payBillIdToOrderIds = BOTPHelper.findSourceBills((String)"ap_payapply", (Long[])payBillIds.toArray(new Long[0]));
        Set orderBillIds = (Set)payBillIdToOrderIds.get("pm_purorderbill");
        if (orderBillIds == null || orderBillIds.size() == 0) {
            return;
        }
        HashMap<Long, BigDecimal> purSupplierAmt = new HashMap<Long, BigDecimal>(16);
        DynamicObjectCollection orderBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"totalallamount,invoicesupplier", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)orderBillIds)});
        for (DynamicObject orderBill : orderBills) {
            Long supplierId = orderBill.getLong("invoicesupplier");
            BigDecimal supplierSumAmt = (BigDecimal)purSupplierAmt.get(supplierId);
            if (supplierSumAmt == null) {
                purSupplierAmt.put(supplierId, orderBill.getBigDecimal("totalallamount"));
                continue;
            }
            purSupplierAmt.put(supplierId, supplierSumAmt.add(orderBill.getBigDecimal("totalallamount")));
        }
        Map allDownBillIdsMap = BOTPHelper.findTargetBills((String)"pm_purorderbill", (Long[])orderBillIds.toArray(new Long[0]));
        if (allDownBillIdsMap.size() == 0) {
            return;
        }
        Set downAllPayBillIds = (Set)allDownBillIdsMap.get("ap_payapply");
        if (downAllPayBillIds == null || downAllPayBillIds.size() == 0) {
            return;
        }
        DynamicObjectCollection payBills = QueryServiceHelper.query((String)"ap_payapply", (String)"id,billstatus,entry.e_approvedseleamt,entry.e_paidamt,entry.e_asstact,entry.e_corebillno", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)downAllPayBillIds)});
        for (DynamicObject payBill : payBills) {
            String coreBillNo;
            if (payBillIds.contains(payBill.getLong("id")) || StringUtils.isEmpty((String)(coreBillNo = payBill.getString("entry.e_corebillno")))) continue;
            BigDecimal payAmt = "D".equals(payBill.getString("billstatus")) ? payBill.getBigDecimal("entry.e_paidamt") : payBill.getBigDecimal("entry.e_approvedseleamt");
            Long asstactId = payBill.getLong("entry.e_asstact");
            BigDecimal asstSumAmt = (BigDecimal)payAsstactAmt.get(asstactId);
            if (asstSumAmt == null) {
                payAsstactAmt.put(asstactId, payAmt);
                continue;
            }
            payAsstactAmt.put(asstactId, asstSumAmt.add(payAmt));
        }
        for (Map.Entry entrySet : purSupplierAmt.entrySet()) {
            Long supplierId = (Long)entrySet.getKey();
            BigDecimal purAmt = (BigDecimal)entrySet.getValue();
            BigDecimal paySumAmt = (BigDecimal)payAsstactAmt.get(supplierId);
            if (paySumAmt == null || purAmt.compareTo(paySumAmt) >= 0) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6309\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u4ed8\u6b3e\u7533\u8bf7\u5355\u7d2f\u8ba1\u672a\u5173\u95ed\u6001\u6838\u51c6\u91d1\u989d\u4e0e\u5173\u95ed\u6001\u5df2\u4ed8\u91d1\u989d\u4e4b\u548c\u8d85\u8fc7\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6\u884c\u76f8\u540c\u7ed3\u7b97\u7ec4\u7ec7\u4ef7\u7a0e\u5408\u8ba1\u6c47\u603b\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ApplyBillToPurBillValidatorByRelation_0", (String)"fi-ar-mservice", (Object[])new Object[0]));
        }
    }
}

