/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;

public class ApplyChangeCasValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet tarEntryIds = new HashSet(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject applyPayBill = dataEntity.getDataEntity();
            DynamicObjectCollection entryColls = applyPayBill.getDynamicObjectCollection("entry");
            Set entryIds = entryColls.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
            tarEntryIds.addAll(entryIds);
        }
        Map sourceRowIdsMap = BOTPHelper.loadSourceRowIdsMap((String)"ap_payapplychange", (String)"entry", (Long[])tarEntryIds.toArray(new Long[0]), (String)"ap_payapply");
        HashSet applyEntryIds = new HashSet(10);
        if (sourceRowIdsMap != null) {
            for (Map.Entry entry : sourceRowIdsMap.entrySet()) {
                applyEntryIds.addAll((Collection)entry.getValue());
            }
        }
        DynamicObjectCollection applyBills = QueryServiceHelper.query((String)"ap_payapply", (String)"entry.id,entry.e_paidamt,entry.lockedamt", (QFilter[])new QFilter[]{new QFilter("entry.id", "in", applyEntryIds)});
        HashSet<Long> applyAmtSet = new HashSet<Long>(10);
        for (DynamicObject applyBill : applyBills) {
            BigDecimal lockAmt = applyBill.getBigDecimal("entry.lockedamt");
            BigDecimal payAmt = applyBill.getBigDecimal("entry.e_paidamt");
            Long applyEntryId = applyBill.getLong("entry.id");
            if (lockAmt.compareTo(BigDecimal.ZERO) == 0 && payAmt.compareTo(BigDecimal.ZERO) == 0) continue;
            applyAmtSet.add(applyEntryId);
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isAmtWarn = false;
            DynamicObject PayUpdateBill = dataEntity.getDataEntity();
            DynamicObjectCollection entryColls = PayUpdateBill.getDynamicObjectCollection("entry");
            block4: for (DynamicObject entry : entryColls) {
                if (isAmtWarn) break;
                Long entryId = entry.getLong("id");
                if (sourceRowIdsMap == null || sourceRowIdsMap.size() <= 0) continue;
                Set appEntrySet = (Set)sourceRowIdsMap.get(entryId);
                for (Long applyEntryId : appEntrySet) {
                    if (!applyAmtSet.contains(applyEntryId)) continue;
                    isAmtWarn = true;
                    continue block4;
                }
            }
            if (!isAmtWarn) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5373\u5c06\u53d8\u66f4\u7684\u660e\u7ec6\u884c\u4e0b\u6e38\u5b58\u5728\u5728\u9014\u6216\u5df2\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"ApplyChangeCasValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }
}

