/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.BOTPHelper;

@Deprecated
public class ApplyPayUnClosePayValidator
extends AbstractValidator {
    private Map<Long, Integer> settleParam = new HashMap<Long, Integer>(8);

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        Tuple<List<BFRow>, DynamicObject[]> tuple = this.prepareSrcData(datas);
        List bfRows = (List)tuple.item1;
        DynamicObject[] finBills = (DynamicObject[])tuple.item2;
        Map<Object, BigDecimal> entryUnLockMap = Stream.of(finBills).map(v -> v.getDynamicObjectCollection("detailentry")).flatMap(Collection::stream).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v.getBigDecimal("unlockamt")));
        Map<Object, BigDecimal> planUnLockMap = Stream.of(finBills).map(v -> v.getDynamicObjectCollection("planentity")).flatMap(Collection::stream).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v.getBigDecimal("unplanlockamt")));
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            if (!bill.getString("billstatus").equals("D")) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u53ea\u6709\u5173\u95ed\u72b6\u6001\u7684\u4ed8\u6b3e\u7533\u8bf7\u5141\u8bb8\u53cd\u5173\u95ed\u3002", (String)"ApplyPayUnClosePayValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"ap_finapbill".equals(bill.getString("sourcebilltype")) || !this.judgeSourceBill(bill, bfRows, entryUnLockMap, planUnLockMap)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0a\u6e38\u989d\u5ea6\u4e0d\u591f\uff0c\u4e0d\u5141\u8bb8\u53cd\u5173\u95ed\u4ed8\u6b3e\u7533\u8bf7\u3002", (String)"ApplyPayUnClosePayValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean judgeSourceBill(DynamicObject info, List<BFRow> bfRows, Map<Object, BigDecimal> entryUnLockMap, Map<Object, BigDecimal> planUnLockMap) {
        Long orgPk = info.getLong("settleorg.id");
        Integer param = this.settleParam.get(orgPk);
        if (param == null) {
            param = ArApHelper.getApSettleParam((Object)orgPk);
            this.settleParam.put(orgPk, param);
        }
        List curBfRows = bfRows.stream().filter(v -> v.getId().getBillId().compareTo(info.getLong("id")) == 0).collect(Collectors.toList());
        DynamicObjectCollection entrys = info.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entrys) {
            BigDecimal lockamt = entry.getBigDecimal("e_approvedamt").subtract(entry.getBigDecimal("e_paidamt"));
            if (lockamt.compareTo(BigDecimal.ZERO) == 0) continue;
            List entryRows = curBfRows.stream().filter(v -> v.getId().getEntryId().longValue() == entry.getLong("id")).collect(Collectors.toList());
            BigDecimal unlockamt = BigDecimal.ZERO;
            for (BFRow entryRow : entryRows) {
                Long entryId = entryRow.getSId().getEntryId();
                if (1 == param) {
                    unlockamt = unlockamt.add(entryUnLockMap.getOrDefault(entryId, BigDecimal.ZERO));
                    continue;
                }
                unlockamt = unlockamt.add(planUnLockMap.getOrDefault(entryId, BigDecimal.ZERO));
            }
            if (unlockamt.compareTo(lockamt) >= 0) continue;
            return true;
        }
        return false;
    }

    private Tuple<List<BFRow>, DynamicObject[]> prepareSrcData(ExtendedDataEntity[] datas) {
        List<Long> entryPks = Stream.of(datas).map(ExtendedDataEntity::getDataEntity).map(v -> v.getDynamicObjectCollection("entry")).flatMap(Collection::stream).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        List bfRows = BOTPHelper.loadSourceRowIds((String)"ap_payapply", (String)"entry", (Long[])entryPks.toArray(new Long[0]));
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)"ap_finapbill", (String)"ap_finapbill");
        Set srcFinBillIds = bfRows.stream().filter(v -> v.getSId().getMainTableId().compareTo(tableDefine.getTableId()) == 0).map(v -> v.getSId().getBillId()).collect(Collectors.toSet());
        QFilter qf = new QFilter("id", "in", srcFinBillIds);
        DynamicObject[] finBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"detailentry.unlockamt,planentity.unplanlockamt", (QFilter[])new QFilter[]{qf});
        return Tuple.create((Object)bfRows, (Object)finBills);
    }
}

