/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ap.business.invoice.InvoiceAssignService;
import kd.fi.ap.piaozone.ReplaceInvoiceHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.enums.ApInvoiceServiceEnum;
import kd.fi.arapcommon.factory.ArApServiceAPIFactory;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.JsonUtils;

public class AssginInvoiceValidator
extends AbstractValidator {
    public void validate() {
        Map<Long, DynamicObject> invoiceMap = this.getInvoiceMap();
        InvoiceAssignService assignService = (InvoiceAssignService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.ASSGININVOICE.getValue());
        HashSet<Long> orgIds = new HashSet<Long>(4);
        ArrayList<Long> billIds = new ArrayList<Long>(32);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject finApBill = dataEntity.getDataEntity();
            orgIds.add(finApBill.getLong("org.id"));
            billIds.add(finApBill.getLong("id"));
            String message = assignService.validateFin(new DynamicObject[]{finApBill});
            if (!ObjectUtils.isEmpty((Object)message)) {
                this.addMessage(dataEntity, message);
                continue;
            }
            if (!this.isAutoAssign()) continue;
            BigDecimal invSumAmount = BigDecimal.ZERO;
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            for (DynamicObject invRow : invEntry) {
                DynamicObject invoice = invoiceMap.get(invRow.getLong("invid"));
                if (invoice == null) continue;
                invSumAmount = invSumAmount.add(invoice.getBigDecimal("unrelatedamt"));
            }
            if (finApBill.getBigDecimal("uninvoicedamt").signum() == invSumAmount.signum()) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5e94\u4ed8\u91d1\u989d\u4e0e\u53d1\u7968\u4ef7\u7a0e\u5408\u8ba1\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"AssginInvoiceValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
        Map configByOrg = KingdeeInvoiceCloudConfig.getErConfigByOrg(orgIds);
        Map onTheWayBillIdsMap = ReplaceInvoiceHelper.returnOnTheWayBillIds((String)"ap_finapbill", orgIds, billIds);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject finApBill = dataEntity.getDataEntity();
            Long orgId = finApBill.getLong("org.id");
            String asstactName = finApBill.getString("asstact.name");
            DynamicObject config = (DynamicObject)configByOrg.get(orgId);
            HashSet<String> warningBillnos = new HashSet<String>(8);
            if (config != null && "0".equals(config.getString("identicalpartyinvcom"))) {
                for (Map.Entry<Long, DynamicObject> inv : invoiceMap.entrySet()) {
                    DynamicObject bill = inv.getValue();
                    String invAsstactName = bill.getString("asstactname");
                    if (asstactName.equals(invAsstactName)) continue;
                    warningBillnos.add(bill.getString("billno"));
                }
            }
            if (warningBillnos.size() > 0) {
                String billnos = StringUtils.join((Object[])warningBillnos.toArray(), (String)",");
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u5f80\u6765\u6237\u4e0e\u6536\u7968\u5355: %s\u9500\u65b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u6307\u5b9a\u3002", (String)"AssginInvoiceValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[]{billnos}));
            }
            if (!onTheWayBillIdsMap.containsKey(finApBill.getLong("id"))) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684\u6362\u7968\u8bb0\u5f55\uff0c\u8bf7\u901a\u8fc7\u8054\u67e5-\u67e5\u770b\u6362\u7968\u8bb0\u5f55\u5220\u9664\u6216\u5ba1\u6838\u6362\u7968\u8bb0\u5f55\u540e\u91cd\u8bd5\u3002", (String)"AssginInvoiceValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
        if (!this.isAutoAssign()) {
            ExtendedDataEntity dataEntity = this.getDataEntities()[0];
            BigDecimal invSumAmount = BigDecimal.ZERO;
            for (DynamicObject invoice : invoiceMap.values()) {
                invSumAmount = invSumAmount.add(invoice.getBigDecimal("unrelatedamt"));
            }
            if (dataEntity.getDataEntity().getBigDecimal("uninvoicedamt").signum() != invSumAmount.signum()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u672a\u5f00\u7968\u5e94\u4ed8\u91d1\u989d\u4e0e\u6240\u9009\u6536\u7968\u5355\u672a\u5173\u8054\u91d1\u989d\u7684\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u6307\u5b9a\u3002", (String)"AssginInvoiceValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
        }
        this.validateInvoice(invoiceMap);
    }

    private void validateInvoice(Map<Long, DynamicObject> invoiceMap) {
        boolean isFinMatched = false;
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            if (!dataEntity.getDataEntity().getBoolean("isinvoicematch")) continue;
            isFinMatched = true;
        }
        for (DynamicObject invoice : invoiceMap.values()) {
            InvoiceAssignService assignService;
            String message;
            if (invoice.getBoolean("ismatched") && !isFinMatched) {
                this.addErrorMessage(this.getDataEntities()[0], ResManager.loadKDString((String)"\u6536\u7968\u5355:%s\u5df2\u5b58\u5728\u5339\u914d\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u6307\u5b9a\u5e94\u4ed8\u64cd\u4f5c\u3002", (String)"AssginInvoiceValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[]{invoice.getString("billno")}));
            }
            if (this.isAutoAssign() || ObjectUtils.isEmpty((Object)(message = (assignService = (InvoiceAssignService)ArApServiceAPIFactory.getService((String)ApInvoiceServiceEnum.ASSGININVOICE.getValue())).validateInvoice(new DynamicObject[]{invoice})))) continue;
            this.addMessage(this.getDataEntities()[0], message);
        }
    }

    private Map<Long, DynamicObject> getInvoiceMap() {
        List<Long> invoiceIds = this.getInvoiceIds();
        String selectors = "billno,unrelatedamt,ismatched,billstatus,invoicestatus,org,asstacttype,receivablessupp,currency,asstactname";
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"ap_invoice", (String)selectors, (QFilter[])new QFilter[]{new QFilter("id", "in", invoiceIds)});
        return Arrays.stream(invoices).collect(Collectors.toMap(inv -> inv.getLong("id"), Function.identity()));
    }

    private List<Long> getInvoiceIds() {
        if (this.isAutoAssign()) {
            ArrayList<Long> invoiceIds = new ArrayList<Long>(16);
            for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                DynamicObject finApBill = dataEntity.getDataEntity();
                DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
                for (DynamicObject invRow : invEntry) {
                    if (BigDecimal.ZERO.compareTo(invRow.getBigDecimal("i_usedamt")) != 0) continue;
                    invoiceIds.add(invRow.getLong("invid"));
                }
            }
            return invoiceIds;
        }
        return (List)JsonUtils.jsonToObj((String)this.getOption().getVariableValue("invPks"), List.class);
    }

    private boolean isAutoAssign() {
        String invPksJson = this.getOption().getVariableValue("invPks", " ");
        return EmptyUtils.isEmpty((Object)invPksJson);
    }
}

