/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class BusApBillSumbitPurinBillValidator
extends AbstractValidator {
    private final Map<Long, Boolean> calParam = new HashMap<Long, Boolean>(2);

    public void validate() {
        Map<Long, DynamicObject> purEntrys = this.getSourPurBus();
        if (purEntrys.size() > 0) {
            this.validateData(purEntrys);
        }
    }

    private Map<Long, DynamicObject> getSourPurBus() {
        HashMap<Long, DynamicObject> purBillEntrys = new HashMap<Long, DynamicObject>(2);
        ArrayList<Long> purBillIds = new ArrayList<Long>(2);
        ArrayList<Long> purEntryIds = new ArrayList<Long>(2);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject busBill = data.getDataEntity();
            String sourceBillType = busBill.getString("sourcebilltype");
            if (!"im_purinbill".equals(sourceBillType)) continue;
            boolean isadjust = busBill.getBoolean("isadjust");
            boolean isReval = busBill.getBoolean("isrevaluation");
            boolean hadReval = busBill.getBoolean("hadrevaluation");
            boolean writeoffbusiness = busBill.getBoolean("writeoffbusiness");
            if (isadjust || isReval || hadReval || writeoffbusiness) continue;
            DynamicObjectCollection entrys = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entrys) {
                Long purBillId = row.getLong("e_srcbillid");
                Long purEntryId = row.getLong("e_srcentryid");
                if (purEntryId == null || purEntryId == 0L) continue;
                purEntryIds.add(purEntryId);
                purBillIds.add(purBillId);
            }
        }
        if (purEntryIds.size() > 0) {
            DynamicObjectCollection purBills = QueryServiceHelper.query((String)"im_purinbill", (String)"billentry.id,billentry.linetype,billentry.unit.id,billentry.price", (QFilter[])new QFilter[]{new QFilter("id", "in", purBillIds), new QFilter("billentry.id", "in", purEntryIds)});
            for (DynamicObject purBill : purBills) {
                purBillEntrys.put(purBill.getLong("billentry.id"), purBill);
            }
        }
        return purBillEntrys;
    }

    private void validateData(Map<Long, DynamicObject> purEntrys) {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject busBill = data.getDataEntity();
            String billNo = busBill.getString("billno");
            boolean isadjust = busBill.getBoolean("isadjust");
            boolean isReval = busBill.getBoolean("isrevaluation");
            boolean hadReval = busBill.getBoolean("hadrevaluation");
            boolean writeoffbusiness = busBill.getBoolean("writeoffbusiness");
            if (isadjust || isReval || hadReval || writeoffbusiness) continue;
            Long orgId = busBill.getLong("org.id");
            Boolean param = this.calParam.get(orgId);
            if (param == null) {
                param = this.getCalParam(orgId);
                this.calParam.put(orgId, param);
            }
            if (!param.booleanValue()) continue;
            DynamicObjectCollection busEntrys = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject busEntry : busEntrys) {
                DynamicObject purEntry;
                Long purEntryId = busEntry.getLong("e_srcentryid");
                if (purEntryId == null || purEntryId == 0L || (purEntry = purEntrys.get(purEntryId)) == null) continue;
                DynamicObject busLineType = busEntry.getDynamicObject("linetype");
                Long purLinTypeId = purEntry.getLong("billentry.linetype");
                if (busLineType == null || purLinTypeId == 0L || !purLinTypeId.equals(busLineType.getLong("id"))) continue;
                Long busEntryUnit = busEntry.getLong("e_measureunit.id");
                BigDecimal busEntryprice = busEntry.getBigDecimal("e_unitprice");
                Long purEntryUnit = purEntry.getLong("billentry.unit.id");
                BigDecimal purEntryprice = purEntry.getBigDecimal("billentry.price");
                if (busEntryUnit.equals(purEntryUnit) && busEntryprice.compareTo(purEntryprice) == 0) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u8ba1\u91cf\u5355\u4f4d\u3001\u5355\u4ef7\u5fc5\u987b\u4e0e\u4e0a\u6e38\u91c7\u8d2d\u5165\u5e93\u5355\u4e00\u81f4\uff0c\u82e5\u9700\u4fee\u6539\u8bf7\u5173\u95ed\u5b58\u8d27\u6838\u7b97\u7cfb\u7edf\u53c2\u6570\u201d\u542f\u7528\u5e94\u4ed8\u6682\u4f30\u201c\u540e\u518d\u63d0\u4ea4\u3002", (String)"BusApBillSumbitPurinBillValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo));
            }
        }
    }

    private Boolean getCalParam(Long orgId) {
        AppParam appParam = new AppParam("/KIUHEXROK3D", orgId);
        appParam.setViewType("10");
        Object value = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)"ap_estimation");
        if (value == null) {
            return Boolean.FALSE;
        }
        return (Boolean)value;
    }
}

