/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;

public class BusApBillUnAuditPushValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<Long> billIds = new ArrayList<Long>(dataEntities.length);
        HashSet<Long> entryIdSet = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity data : dataEntities) {
            DynamicObject busApBill = data.getDataEntity();
            billIds.add(busApBill.getLong("id"));
            DynamicObjectCollection entryColl = busApBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entryColl) {
                entryIdSet.add(entry.getLong("id"));
            }
        }
        Map apIdArBillMap = BOTPHelper.loadNearTarBillIds((String)"ap_busbill", (String)"entry", (Long[])billIds.toArray(new Long[0]), (Long[])entryIdSet.toArray(new Long[0]), (String)"ar_busbill");
        if (ObjectUtils.isEmpty((Object)apIdArBillMap)) {
            return;
        }
        Set arIdSet = apIdArBillMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", arIdSet);
        filter.and(new QFilter("billtype.number", "=", (Object)"ar_busbill_other_BT_S"));
        filter.and(new QFilter("billstatus", "!=", (Object)"A"));
        DynamicObjectCollection tarBillColl = QueryServiceHelper.query((String)"ar_busbill", (String)"id,sourcebillid", (QFilter[])new QFilter[]{filter});
        if (ObjectUtils.isEmpty((Object)tarBillColl)) {
            return;
        }
        Set existArIdSet = tarBillColl.stream().map(tarBill -> tarBill.getLong("sourcebillid")).collect(Collectors.toSet());
        for (ExtendedDataEntity data : dataEntities) {
            DynamicObject detailEntry;
            DynamicObject busApBill = data.getDataEntity();
            long id = busApBill.getLong("id");
            DynamicObjectCollection entryColl = busApBill.getDynamicObjectCollection("entry");
            boolean isPrePaid = false;
            Iterator iterator = entryColl.iterator();
            while (iterator.hasNext() && !(isPrePaid = (detailEntry = (DynamicObject)iterator.next()).getBoolean("e_prepaid"))) {
            }
            if (!isPrePaid || !existArIdSet.contains(id)) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"BusApBillUnAuditPushValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }
}

