/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.excecontrol.IExecCtrlService;

public class BusPurAmtCheckService
implements IExecCtrlService<Object> {
    public <T> T execute(Object ... param) {
        if (param == null || param.length == 0) {
            return null;
        }
        DynamicObject[] bills = (DynamicObject[])param;
        return (T)this.doValidator(bills);
    }

    private List<String> doValidator(DynamicObject[] bills) {
        boolean writeoffbusiness;
        boolean hadReval;
        boolean isReval;
        boolean isadjust;
        ArrayList<String> errMessage = new ArrayList<String>(16);
        HashMap<Long, DynamicObject> purBillEntrys = new HashMap<Long, DynamicObject>(2);
        ArrayList<Long> purBillIds = new ArrayList<Long>(2);
        ArrayList<Long> purEntryIds = new ArrayList<Long>(2);
        for (DynamicObject busBill : bills) {
            String sourceBillType = busBill.getString("sourcebilltype");
            if (!"im_purinbill".equals(sourceBillType)) continue;
            isadjust = busBill.getBoolean("isadjust");
            isReval = busBill.getBoolean("isrevaluation");
            hadReval = busBill.getBoolean("hadrevaluation");
            writeoffbusiness = busBill.getBoolean("writeoffbusiness");
            if (isadjust || isReval || hadReval || writeoffbusiness) continue;
            DynamicObjectCollection entrys = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entrys) {
                Long purBillId = row.getLong("e_srcbillid");
                Long purEntryId = row.getLong("e_srcentryid");
                if (purEntryId == null || purEntryId == 0L) continue;
                purEntryIds.add(purEntryId);
                purBillIds.add(purBillId);
            }
        }
        if (purEntryIds.size() > 0) {
            DynamicObjectCollection purBills = QueryServiceHelper.query((String)"im_purinbill", (String)"billentry.id,billentry.linetype,billentry.unit.id,billentry.price,billentry.baseqty,billentry.intercostamt,billentry.amountandtax,billentry.taxamount,billentry.amount", (QFilter[])new QFilter[]{new QFilter("id", "in", purBillIds), new QFilter("billentry.id", "in", purEntryIds)});
            for (DynamicObject purBill : purBills) {
                purBillEntrys.put(purBill.getLong("billentry.id"), purBill);
            }
        }
        for (DynamicObject busBill : bills) {
            String billNo = busBill.getString("billno");
            isadjust = busBill.getBoolean("isadjust");
            isReval = busBill.getBoolean("isrevaluation");
            hadReval = busBill.getBoolean("hadrevaluation");
            writeoffbusiness = busBill.getBoolean("writeoffbusiness");
            if (isadjust || isReval || hadReval || writeoffbusiness) continue;
            DynamicObjectCollection busEntrys = busBill.getDynamicObjectCollection("entry");
            for (DynamicObject busEntry : busEntrys) {
                DynamicObject purEntry;
                Long purEntryId = busEntry.getLong("e_srcentryid");
                if (purEntryId == null || purEntryId == 0L || (purEntry = (DynamicObject)purBillEntrys.get(purEntryId)) == null) continue;
                DynamicObject busLineType = busEntry.getDynamicObject("linetype");
                Long purLinTypeId = purEntry.getLong("billentry.linetype");
                if (busLineType == null || purLinTypeId == 0L || !purLinTypeId.equals(busLineType.getLong("id"))) continue;
                BigDecimal busBaseQty = busEntry.getBigDecimal("e_baseunitqty");
                BigDecimal busAmount = busEntry.getBigDecimal("e_amount");
                BigDecimal busTax = busEntry.getBigDecimal("e_tax");
                BigDecimal busPricetaxtotal = busEntry.getBigDecimal("e_pricetaxtotal");
                BigDecimal busIntercostAmt = busEntry.getBigDecimal("intercostamt");
                BigDecimal purBaseQty = purEntry.getBigDecimal("billentry.baseqty");
                BigDecimal purAmount = purEntry.getBigDecimal("billentry.amount");
                BigDecimal purTax = purEntry.getBigDecimal("billentry.taxamount");
                BigDecimal purPricetaxtotal = purEntry.getBigDecimal("billentry.amountandtax");
                BigDecimal purIntercostAmt = purEntry.getBigDecimal("billentry.intercostamt");
                if (busBaseQty.compareTo(purBaseQty) == 0 && busAmount.compareTo(purAmount) == 0 && busTax.compareTo(purTax) == 0 && busPricetaxtotal.compareTo(purPricetaxtotal) == 0 && busIntercostAmt.compareTo(purIntercostAmt) == 0) continue;
                errMessage.add(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\u7b2c%2$s\u884c\uff1a\u57fa\u672c\u6570\u91cf\u3001\u91d1\u989d\u3001\u7a0e\u989d\u3001\u5e94\u4ed8\u91d1\u989d\u3001\u8ba1\u6210\u672c\u91d1\u989d\u5fc5\u987b\u4e0e\u4e0a\u6e38\u91c7\u8d2d\u5165\u5e93\u5355\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusPurAmtCheckService_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, busEntry.getInt("seq")));
            }
        }
        return errMessage;
    }
}

