/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.CloseAccountHelper;

public class CloseAccountValidator
extends AbstractValidator {
    private Date closeDate;

    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            DynamicObject closeAccountsInfo = data.getDataEntity();
            DynamicObject org = closeAccountsInfo.getDynamicObject("org");
            boolean isFinishInit = closeAccountsInfo.getBoolean("isfinishinit");
            if (!isFinishInit) {
                String message = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u8fdb\u884c\u5173\u8d26\u64cd\u4f5c\u3002", (String)"CloseAccountValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[]{org.getString("name")});
                this.addErrorMessage(data, message);
                continue;
            }
            Date currentDate = closeAccountsInfo.getDate("currentdate");
            if (this.closeDate.before(currentDate)) {
                String message = ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5173\u8d26\u65e5\u671f\u4e0d\u53ef\u5c0f\u4e8e\u8be5\u7ec4\u7ec7\u5f53\u524d\u65e5\u671f\u3002", (String)"CloseAccountValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[]{org.getString("name")});
                this.addErrorMessage(data, message);
                continue;
            }
            List allValidateInfos = CloseAccountHelper.getAllValidateInfos((boolean)false, (long)((Long)org.getPkValue()), (Date)this.closeDate, (Date)currentDate);
            if (allValidateInfos.isEmpty()) continue;
            CloseAccountHelper.bindFailedInfoToEntityEntry((DynamicObject)closeAccountsInfo, (List)allValidateInfos);
            SaveServiceHelper.save((IDataEntityType)closeAccountsInfo.getDataEntityType(), (Object[])new DynamicObject[]{closeAccountsInfo});
            String message = ResManager.loadKDString((String)"\u5173\u8d26\u65e5\u671f\u4e4b\u524d\uff0c\u7ec4\u7ec7\u201c%s\u201d\u5b58\u5728\u672a\u5ba1\u6279\u7684\u5355\u636e\u6216\u5df2\u5ba1\u6279\u4f46\u73b0\u8d2d\u672a\u7ed3\u7b97\u7684\u5355\u636e\uff0c\u65e0\u6cd5\u5173\u8d26\u3002", (String)"CloseAccountValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[]{closeAccountsInfo.getDynamicObject("org").getString("name")});
            this.addErrorMessage(data, message);
        }
    }

    public Date getCloseDate() {
        return this.closeDate;
    }

    public void setCloseDate(Date closeDate) {
        this.closeDate = closeDate;
    }
}

