/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.mservice.ToleranceMatchService;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.helper.ToleranceHepler;

public class CoreBillPriceToleranceValidator
extends AbstractExecControlValidator {
    private boolean noBusOrderPriceTol;
    private boolean noBusConPriceTol;
    private boolean noBusScpoPriceTol;
    private boolean noBusPmomPriceTol;
    private boolean noFinOrderPriceTol;
    private boolean noFinConPriceTol;
    private boolean noFinScpoPriceTol;
    private boolean noFinPmomPriceTol;

    public void validate() {
        BigDecimal coreBillPrice;
        String coreBillType;
        String entityName = this.dataEntities[0].getDataEntity().getDynamicObjectType().getName();
        this.initToleranceScheme(entityName);
        String billName = this.dataEntities[0].getDataEntity().getDataEntityType().getDisplayName().getLocaleValue();
        String entryName = "ap_busbill".equals(entityName) ? "entry" : "detailentry";
        String materialField = "ap_busbill".equals(entityName) ? "e_material.id" : "material.id";
        String coreBillTypeField = "ap_busbill".equals(entityName) ? "e_corebilltype" : "corebilltype";
        String priceField = "ap_busbill".equals(entityName) ? "e_unitprice" : "price";
        HashSet<Long> purOrderEntryIds = new HashSet<Long>(16);
        HashSet<Long> conmEntryIds = new HashSet<Long>(16);
        HashSet<Long> scpoEntryIds = new HashSet<Long>(16);
        HashSet<Long> pmomEntryIds = new HashSet<Long>(16);
        HashSet<Long> supplierIds = new HashSet<Long>(16);
        HashSet<Long> customerIds = new HashSet<Long>(16);
        HashSet<Long> materialIds = new HashSet<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!this.isNeedValidate(entityName, bill)) continue;
            String asstactType = bill.getString("asstacttype");
            if ("bd_supplier".equals(asstactType)) {
                supplierIds.add(bill.getLong("asstact.id"));
            } else {
                customerIds.add(bill.getLong("asstact.id"));
            }
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryName);
            for (DynamicObject row : entry) {
                Long coreBillEntryId = row.getLong("corebillentryid");
                if (coreBillEntryId == 0L) continue;
                materialIds.add(row.getLong(materialField));
                String coreBillType2 = row.getString(coreBillTypeField);
                if ("pm_purorderbill".equals(coreBillType2)) {
                    purOrderEntryIds.add(coreBillEntryId);
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType2)) {
                    conmEntryIds.add(coreBillEntryId);
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType2)) {
                    scpoEntryIds.add(coreBillEntryId);
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType2)) continue;
                pmomEntryIds.add(coreBillEntryId);
            }
        }
        HashMap<Long, Long> supplierMasterIds = new HashMap<Long, Long>(16);
        if (supplierIds.size() > 0) {
            DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierIds)});
            for (Object supplier : suppliers) {
                supplierMasterIds.put(supplier.getLong("id"), supplier.getLong("masterid"));
            }
        }
        HashMap<Long, Long> customerMasterIds = new HashMap<Long, Long>(16);
        if (customerIds.size() > 0) {
            DynamicObjectCollection customers = QueryServiceHelper.query((String)"bd_customer", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", customerIds)});
            for (DynamicObject customer : customers) {
                customerMasterIds.put(customer.getLong("id"), customer.getLong("masterid"));
            }
        }
        HashMap<Object, ArrayList<Long>> materialIdToMaterialgroup = new HashMap<Object, ArrayList<Long>>(16);
        HashMap<Long, Long> materialMasterIds = new HashMap<Long, Long>(16);
        DynamicObjectCollection materials = QueryServiceHelper.query((String)"bd_material", (String)"id,masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIds)});
        for (Object material : materials) {
            materialMasterIds.put(material.getLong("id"), material.getLong("masterid"));
        }
        DynamicObjectCollection materialGroups = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])new QFilter[]{new QFilter("material", "in", materialIds)});
        for (DynamicObject group : materialGroups) {
            Long materialId = group.getLong("material");
            ArrayList<Long> materialGroupIds = (ArrayList<Long>)materialIdToMaterialgroup.get(materialId);
            if (materialGroupIds == null) {
                materialGroupIds = new ArrayList<Long>(16);
                materialGroupIds.add(group.getLong("group"));
                materialIdToMaterialgroup.put(materialId, materialGroupIds);
                continue;
            }
            materialGroupIds.add(group.getLong("group"));
        }
        HashMap<Long, BigDecimal> coreBillEntryPriceMap = new HashMap<Long, BigDecimal>(16);
        if (purOrderEntryIds.size() > 0) {
            DynamicObjectCollection purBills = QueryServiceHelper.query((String)"pm_purorderbill", (String)"billentry.id,billentry.price", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", purOrderEntryIds)});
            for (DynamicObject purBill : purBills) {
                coreBillEntryPriceMap.put(purBill.getLong("billentry.id"), purBill.getBigDecimal("billentry.price"));
            }
        }
        if (conmEntryIds.size() > 0) {
            DynamicObjectCollection conmBills = QueryServiceHelper.query((String)"conm_purcontract", (String)"billentry.id,billentry.price", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", conmEntryIds)});
            for (DynamicObject conmBill : conmBills) {
                coreBillEntryPriceMap.put(conmBill.getLong("billentry.id"), conmBill.getBigDecimal("billentry.price"));
            }
        }
        if (scpoEntryIds.size() > 0) {
            DynamicObjectCollection scpoBills = QueryServiceHelper.query((String)"sctm_scpo", (String)"billentry.id,billentry.price", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", scpoEntryIds)});
            for (DynamicObject scpoBill : scpoBills) {
                coreBillEntryPriceMap.put(scpoBill.getLong("billentry.id"), scpoBill.getBigDecimal("billentry.price"));
            }
        }
        if (pmomEntryIds.size() > 0) {
            DynamicObjectCollection pmomBills = QueryServiceHelper.query((String)"pm_om_purorderbill", (String)"billentry.id,billentry.price", (QFilter[])new QFilter[]{new QFilter("billentry.id", "in", pmomEntryIds)});
            for (DynamicObject pmomBill : pmomBills) {
                coreBillEntryPriceMap.put(pmomBill.getLong("billentry.id"), pmomBill.getBigDecimal("billentry.price"));
            }
        }
        ArrayList purToleranceParams = new ArrayList(16);
        ArrayList conmToleranceParams = new ArrayList(16);
        ArrayList scpoToleranceParams = new ArrayList(16);
        ArrayList pmomToleranceParams = new ArrayList(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            Long billId = bill.getLong("id");
            if (!this.isNeedValidate(entityName, bill)) continue;
            int precision = bill.getInt("currency.priceprecision");
            Long orgId = bill.getLong("org.id");
            String asstactType = bill.getString("asstacttype");
            Long asstactId = bill.getLong("asstact.id");
            Long currencyId = bill.getLong("currency.id");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryName);
            for (DynamicObject row : entry) {
                BigDecimal billPrice;
                Long coreBillEntryId = row.getLong("corebillentryid");
                coreBillType = row.getString(coreBillTypeField);
                Long materialId = row.getLong(materialField);
                if (coreBillEntryId == 0L || (coreBillPrice = (BigDecimal)coreBillEntryPriceMap.get(coreBillEntryId)) == null || (billPrice = row.getBigDecimal(priceField)).compareTo(coreBillPrice) == 0) continue;
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                param.put("bos_org", orgId);
                if ("bd_supplier".equals(asstactType)) {
                    param.put("bd_supplier", supplierMasterIds.get(asstactId));
                    param.put("bd_customer", null);
                } else {
                    param.put("bd_customer", customerMasterIds.get(asstactId));
                    param.put("bd_supplier", null);
                }
                param.put("bd_material", materialMasterIds.get(materialId));
                param.put("bd_materialgroup", materialIdToMaterialgroup.get(materialId));
                param.put("bd_currency", currencyId);
                param.put("controlvalue", billPrice);
                param.put("contrastvalue", coreBillPrice);
                param.put("precision", precision);
                String pk = billId + "_" + row.getInt("seq");
                param.put("pk", pk);
                if ("pm_purorderbill".equals(coreBillType)) {
                    purToleranceParams.add(param);
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    conmToleranceParams.add(param);
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    scpoToleranceParams.add(param);
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                pmomToleranceParams.add(param);
            }
        }
        HashSet<String> overPriceToleranceIds = new HashSet<String>(16);
        ToleranceMatchService service = new ToleranceMatchService();
        if (purToleranceParams.size() > 0) {
            List result = service.getResultByToleranceType(entityName, "pm_purorderbill", priceField, "price", purToleranceParams);
            for (Map map : result) {
                overPriceToleranceIds.add((String)map.get("pk"));
            }
        }
        if (conmToleranceParams.size() > 0) {
            List result = service.getResultByToleranceType(entityName, "conm_purcontract", priceField, "price", conmToleranceParams);
            for (Map map : result) {
                overPriceToleranceIds.add((String)map.get("pk"));
            }
        }
        if (scpoToleranceParams.size() > 0) {
            List result = service.getResultByToleranceType(entityName, "sctm_scpo", priceField, "price", scpoToleranceParams);
            for (Map map : result) {
                overPriceToleranceIds.add((String)map.get("pk"));
            }
        }
        if (pmomToleranceParams.size() > 0) {
            List result = service.getResultByToleranceType(entityName, "pm_om_purorderbill", priceField, "price", pmomToleranceParams);
            for (Map map : result) {
                overPriceToleranceIds.add((String)map.get("pk"));
            }
        }
        HashMap<String, String> coreBillNameMap = new HashMap<String, String>(8);
        coreBillNameMap.put("pm_purorderbill", ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"CoreBillPriceToleranceValidator_03", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        coreBillNameMap.put("conm_purcontract", ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c", (String)"CoreBillPriceToleranceValidator_04", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        coreBillNameMap.put("sctm_scpo", ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355", (String)"CoreBillPriceToleranceValidator_05", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        coreBillNameMap.put("pm_om_purorderbill", ResManager.loadKDString((String)"\u7b80\u5355\u59d4\u5916\u8ba2\u5355", (String)"CoreBillPriceToleranceValidator_06", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            Long billId = bill.getLong("id");
            if (!this.isNeedValidate(entityName, bill)) continue;
            String billNo = bill.getString("billno");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(entryName);
            for (DynamicObject row : entry) {
                BigDecimal controlPrice;
                Long coreBillEntryId = row.getLong("corebillentryid");
                if (coreBillEntryId == 0L) continue;
                String pk = billId + "_" + row.getInt("seq");
                coreBillType = row.getString(coreBillTypeField);
                if ("pm_purorderbill".equals(coreBillType)) {
                    if ("ap_busbill".equals(entityName)) {
                        if (this.noBusOrderPriceTol) {
                            controlPrice = row.getBigDecimal(priceField);
                            coreBillPrice = (BigDecimal)coreBillEntryPriceMap.get(coreBillEntryId);
                            if (coreBillPrice == null || controlPrice.compareTo(coreBillPrice) == 0) continue;
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                            continue;
                        }
                        if (!overPriceToleranceIds.contains(pk)) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                        continue;
                    }
                    if (this.noFinOrderPriceTol) {
                        controlPrice = row.getBigDecimal(priceField);
                        coreBillPrice = (BigDecimal)coreBillEntryPriceMap.get(coreBillEntryId);
                        if (coreBillPrice == null || controlPrice.compareTo(coreBillPrice) == 0) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                        continue;
                    }
                    if (!overPriceToleranceIds.contains(pk)) continue;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    if ("ap_busbill".equals(entityName)) {
                        if (this.noBusConPriceTol) {
                            controlPrice = row.getBigDecimal(priceField);
                            coreBillPrice = (BigDecimal)coreBillEntryPriceMap.get(coreBillEntryId);
                            if (coreBillPrice == null || controlPrice.compareTo(coreBillPrice) == 0) continue;
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                            continue;
                        }
                        if (!overPriceToleranceIds.contains(pk)) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                        continue;
                    }
                    if (this.noFinConPriceTol) {
                        controlPrice = row.getBigDecimal(priceField);
                        coreBillPrice = (BigDecimal)coreBillEntryPriceMap.get(coreBillEntryId);
                        if (coreBillPrice == null || controlPrice.compareTo(coreBillPrice) == 0) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                        continue;
                    }
                    if (!overPriceToleranceIds.contains(pk)) continue;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    if ("ap_busbill".equals(entityName)) {
                        if (this.noBusScpoPriceTol) {
                            controlPrice = row.getBigDecimal(priceField);
                            coreBillPrice = (BigDecimal)coreBillEntryPriceMap.get(coreBillEntryId);
                            if (coreBillPrice == null || controlPrice.compareTo(coreBillPrice) == 0) continue;
                            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                            continue;
                        }
                        if (!overPriceToleranceIds.contains(pk)) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                        continue;
                    }
                    if (this.noFinScpoPriceTol) {
                        controlPrice = row.getBigDecimal(priceField);
                        coreBillPrice = (BigDecimal)coreBillEntryPriceMap.get(coreBillEntryId);
                        if (coreBillPrice == null || controlPrice.compareTo(coreBillPrice) == 0) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                        continue;
                    }
                    if (!overPriceToleranceIds.contains(pk)) continue;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                if ("ap_busbill".equals(entityName)) {
                    if (this.noBusPmomPriceTol) {
                        controlPrice = row.getBigDecimal(priceField);
                        coreBillPrice = (BigDecimal)coreBillEntryPriceMap.get(coreBillEntryId);
                        if (coreBillPrice == null || controlPrice.compareTo(coreBillPrice) == 0) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                        continue;
                    }
                    if (!overPriceToleranceIds.contains(pk)) continue;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
                    continue;
                }
                if (this.noFinPmomPriceTol) {
                    controlPrice = row.getBigDecimal(priceField);
                    coreBillPrice = (BigDecimal)coreBillEntryPriceMap.get(coreBillEntryId);
                    if (coreBillPrice == null || controlPrice.compareTo(coreBillPrice) == 0) continue;
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u5355\u4ef7\u4e0e%3$s\u5bf9\u5e94\u5206\u5f55\u5355\u4ef7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType)));
                    continue;
                }
                if (!overPriceToleranceIds.contains(pk)) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u5355\u4ef7\u4e0e%4$s\u5355\u4ef7\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CoreBillPriceToleranceValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillNameMap.get(coreBillType), billName));
            }
        }
    }

    private boolean isNeedValidate(String entityName, DynamicObject bill) {
        if ("ap_busbill".equals(entityName)) {
            boolean isadjust = bill.getBoolean("isadjust");
            boolean isReval = bill.getBoolean("isrevaluation");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entry");
            if (ObjectUtils.isEmpty((Object)entrys)) {
                return false;
            }
            String expenceBillIds = ((DynamicObject)entrys.get(0)).getString("e_expensebillids_tag");
            boolean isExpenceBill = expenceBillIds != null && !"".equals(expenceBillIds);
            return !isadjust && !isReval && !isExpenceBill;
        }
        boolean isWriteOff = bill.getBoolean("iswrittenoff");
        boolean isPremBill = bill.getBoolean("ispremium");
        boolean isTanspay = bill.getBoolean("istanspay");
        String billType = bill.getString("billtypeid.number");
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("detailentry");
        if (ObjectUtils.isEmpty((Object)entrys)) {
            return false;
        }
        String expenceBillIds = ((DynamicObject)entrys.get(0)).getString("e_expensebillids_tag");
        boolean isExpenceBill = expenceBillIds != null && !"".equals(expenceBillIds);
        return !isWriteOff && !isPremBill && !isTanspay && !"ApFin_borr_BT_S".equals(billType) && !isExpenceBill;
    }

    private void initToleranceScheme(String entityName) {
        if ("ap_busbill".equals(entityName)) {
            this.noBusOrderPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_busbill", (String)"pm_purorderbill", (String)"e_unitprice", (String)"price");
            this.noBusConPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_busbill", (String)"conm_purcontract", (String)"e_unitprice", (String)"price");
            this.noBusScpoPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_busbill", (String)"sctm_scpo", (String)"e_unitprice", (String)"price");
            this.noBusPmomPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_busbill", (String)"pm_om_purorderbill", (String)"e_unitprice", (String)"price");
        } else {
            this.noFinOrderPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_finapbill", (String)"pm_purorderbill", (String)"price", (String)"price");
            this.noFinConPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_finapbill", (String)"conm_purcontract", (String)"price", (String)"price");
            this.noFinScpoPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_finapbill", (String)"sctm_scpo", (String)"price", (String)"price");
            this.noFinPmomPriceTol = !ToleranceHepler.haveToleranceScheme((String)"ap_finapbill", (String)"pm_om_purorderbill", (String)"price", (String)"price");
        }
    }

    public Set<String> preparePropertys() {
        return new HashSet<String>(16);
    }
}

