/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinApAdjustValidator
extends AbstractValidator {
    public void validate() {
        String sourceBillType;
        DynamicObject billtye;
        DynamicObject finApBill;
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashMap<Long, DynamicObject> srcApBillMap = new HashMap<Long, DynamicObject>(8);
        HashSet<Long> srcApBillIds = new HashSet<Long>(8);
        for (ExtendedDataEntity data : datas) {
            finApBill = data.getDataEntity();
            billtye = finApBill.getDynamicObject("billtypeid");
            sourceBillType = finApBill.getString("sourcebilltype");
            boolean iswrittenoff = finApBill.getBoolean("iswrittenoff");
            if (iswrittenoff || !"ApFin_borr_BT_S".equals(billtye.getString("number")) || !"ap_finapbill".equals(sourceBillType)) continue;
            srcApBillIds.add(finApBill.getLong("sourcebillid"));
        }
        if (!srcApBillIds.isEmpty()) {
            DynamicObject[] srcApBills;
            DynamicObject[] dynamicObjectArray = srcApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,payproperty", (QFilter[])new QFilter[]{new QFilter("id", "in", srcApBillIds)});
            int n = dynamicObjectArray.length;
            for (int data = 0; data < n; ++data) {
                DynamicObject srcApBill = dynamicObjectArray[data];
                srcApBillMap.put(srcApBill.getLong("id"), srcApBill);
            }
        }
        for (ExtendedDataEntity data : datas) {
            boolean payProperty;
            finApBill = data.getDataEntity();
            billtye = finApBill.getDynamicObject("billtypeid");
            sourceBillType = finApBill.getString("sourcebilltype");
            String adjustType = finApBill.getString("adjusttype");
            boolean iswrittenoff = finApBill.getBoolean("iswrittenoff");
            if (!iswrittenoff && "ApFin_borr_BT_S".equals(billtye.getString("number"))) {
                this.adjustTypeAmtVal(data);
            }
            if (iswrittenoff || !"ApFin_borr_BT_S".equals(billtye.getString("number")) || !"ap_finapbill".equals(sourceBillType)) continue;
            DynamicObject srcApBiLL = (DynamicObject)srcApBillMap.get(finApBill.getLong("sourcebillid"));
            DynamicObject srcPayProperty = srcApBiLL.getDynamicObject("payproperty");
            if (EmptyUtils.isEmpty((Object)srcPayProperty)) {
                Boolean isBasedonamt;
                DynamicObject payProperty2 = finApBill.getDynamicObject("payproperty");
                if (!EmptyUtils.isNotEmpty((Object)payProperty2) || !(isBasedonamt = Boolean.valueOf(payProperty2.getBoolean("isbasedonamt"))).booleanValue()) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e0a\u6e38\u201c\u6b3e\u9879\u6027\u8d28\u201d\u4e3a\u7a7a\uff0c\u8c03\u6574\u5355\u201c\u6b3e\u9879\u6027\u8d28\u201d\u9700\u8981\u8bbe\u7f6e\u4e3a\u201c\u6570\u91cf\u57fa\u51c6\u201d\u3002", (String)"FinApAdjustValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            boolean srcPayPro = srcPayProperty.getBoolean("isbasedonamt");
            if (srcPayPro == (payProperty = finApBill.getBoolean("payproperty.isbasedonamt"))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8c03\u6574\u5355\u201c\u6b3e\u9879\u6027\u8d28\u201d\u7684\u201c\u662f\u5426\u6570\u91cf\u57fa\u51c6\u201d\u53c2\u6570\u5fc5\u987b\u4e0e\u4e0a\u6e38\u4e00\u81f4\u3002", (String)"FinApAdjustValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }

    public void adjustTypeAmtVal(ExtendedDataEntity data) {
        DynamicObject finApBill = data.getDataEntity();
        String adjustType = finApBill.getString("adjusttype");
        BigDecimal priceTaxTotal = finApBill.getBigDecimal("pricetaxtotal");
        DynamicObjectCollection entryColls = finApBill.getDynamicObjectCollection("detailentry");
        if (entryColls != null && entryColls.size() > 0) {
            for (int i = 0; i < entryColls.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryColls.get(i);
                BigDecimal e_tax = entry.getBigDecimal("e_tax");
                BigDecimal e_amount = entry.getBigDecimal("e_amount");
                if ("buckle".equals(adjustType)) {
                    if (e_tax.compareTo(BigDecimal.ZERO) <= 0 && e_amount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u201c\u8c03\u6574\u7c7b\u578b\u201d\u4e3a\u6263\u7f5a\u6b3e\uff0c\u8bf7\u5c06\u201c\u91d1\u989d\u201d\u548c\u201c\u7a0e\u989d\u201d\u4fee\u6539\u4e3a\u8d1f\u6570\u3002", (String)"FinApAdjustValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[]{i + 1}));
                    continue;
                }
                if ("rebate".equals(adjustType)) {
                    if (e_tax.compareTo(BigDecimal.ZERO) <= 0 && e_amount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff0c\u8c03\u6574\u7c7b\u578b\u4e3a\u201c\u8fd4\u5229\u6298\u6263\u201d\uff0c\u8bf7\u4fee\u6539\u91d1\u989d\u3001\u7a0e\u989d\u4e3a\u8d1f\u6570\u3002", (String)"FinApAdjustValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[]{i + 1}));
                    continue;
                }
                if (!"overdue".equals(adjustType) || e_tax.compareTo(BigDecimal.ZERO) >= 0 && e_amount.compareTo(BigDecimal.ZERO) >= 0) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u201c\u8c03\u6574\u7c7b\u578b\u201d\u4e3a\u903e\u671f\u5229\u606f\uff0c\u8bf7\u5c06\u201c\u91d1\u989d\u201d\u548c\u201c\u7a0e\u989d\u201d\u4fee\u6539\u4e3a\u8d1f\u6570\u3002", (String)"FinApAdjustValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[]{i + 1}));
            }
        }
        if ("buckle".equals(adjustType)) {
            if (priceTaxTotal.compareTo(BigDecimal.ZERO) >= 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u578b\u4e3a\u201c\u6263\u7f5a\u6b3e\u201d\uff0c\u8bf7\u4fee\u6539\u5e94\u4ed8\u91d1\u989d\u4e3a\u8d1f\u6570\u3002", (String)"FinApAdjustValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
        } else if ("rebate".equals(adjustType)) {
            if (priceTaxTotal.compareTo(BigDecimal.ZERO) >= 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u8c03\u6574\u7c7b\u578b\u201d\u4e3a\u8fd4\u5229\u6298\u6263\uff0c\u8bf7\u5c06\u201c\u5e94\u4ed8\u91d1\u989d\u201d\u4fee\u6539\u4e3a\u8d1f\u6570\u3002", (String)"FinApAdjustValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
        } else if ("overdue".equals(adjustType) && priceTaxTotal.compareTo(BigDecimal.ZERO) <= 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u8c03\u6574\u7c7b\u578b\u4e3a\u201c\u903e\u671f\u5229\u606f\u201d\uff0c\u8bf7\u4fee\u6539\u5e94\u4ed8\u91d1\u989d\u4e3a\u6b63\u6570\u3002", (String)"FinApAdjustValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }
}

