/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.piaozone.InvoiceHelper;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class FinApBillInvDiffAdjustValidator
extends AbstractValidator {
    public void validate() {
        List<Long> orgIds = Arrays.stream(this.dataEntities).map(data -> data.getDataEntity().getLong("org.id")).distinct().collect(Collectors.toList());
        Map appParameters = SystemParameterHelper.batchGetAppParameters((Boolean)Boolean.FALSE, orgIds, (String[])new String[]{"ap_024", "ap_022", "ap022_condition"});
        Map invoiceMap = InvoiceHelper.getInvoiceMap((ExtendedDataEntity[])this.dataEntities);
        Map<Long, Set<Long>> invoiceToFinMap = this.getInvoiceAssignOthers(orgIds, invoiceMap.keySet());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String invNosStr;
            DynamicObject finApBill = dataEntity.getDataEntity();
            long orgId = finApBill.getLong("org.id");
            Map parameterMap = (Map)appParameters.get(orgId);
            if (ObjectUtils.isEmpty((Object)parameterMap)) continue;
            if (!"B".equals(finApBill.getString("billstatus"))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u63d0\u4ea4\u6001\u8d22\u52a1\u5e94\u4ed8\u5355\u624d\u80fd\u8fdb\u884c\u624b\u5de5\u8c03\u5dee\u3002", (String)"FinApBillInvDiffAdjustValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection invEntry = finApBill.getDynamicObjectCollection("inventry");
            BigDecimal settleAmount = finApBill.getBigDecimal("settleamount");
            if (invEntry.isEmpty()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u672a\u5173\u8054\u53d1\u7968\uff0c\u65e0\u6cd5\u8c03\u5dee\u3002", (String)"FinApBillInvDiffAdjustValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (settleAmount.signum() != 0) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5e94\u4ed8\u5355\u5df2\u7ed3\u7b97\uff0c\u65e0\u6cd5\u8c03\u5dee\u3002", (String)"FinApBillInvDiffAdjustValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            BigDecimal billAmount = finApBill.getBigDecimal("amount");
            BigDecimal billTax = finApBill.getBigDecimal("tax");
            BigDecimal billPriceTaxAmt = finApBill.getBigDecimal("pricetaxtotal");
            BigDecimal totalInvAmount = BigDecimal.ZERO;
            BigDecimal totalInvTax = BigDecimal.ZERO;
            BigDecimal totalInvPriceTaxAmt = BigDecimal.ZERO;
            HashMap<Long, String> invoiceBillNoMap = new HashMap<Long, String>();
            for (DynamicObject invRow : invEntry) {
                DynamicObject invoice = (DynamicObject)invoiceMap.get(invRow.getLong("invid"));
                if (invoice == null || "2".equals(invoice.getString("invoicestatus"))) continue;
                totalInvAmount = totalInvAmount.add(invRow.getBigDecimal("i_amount"));
                totalInvTax = totalInvTax.add(invRow.getBigDecimal("i_tax"));
                totalInvPriceTaxAmt = totalInvPriceTaxAmt.add(invRow.getBigDecimal("i_pricetaxtotal"));
                invoiceBillNoMap.put(invRow.getLong("invid"), invRow.getString("i_billno"));
            }
            BigDecimal diffRang = ArApHelper.getBigDecimal(parameterMap.get("ap022_condition"));
            if (((Boolean)parameterMap.get("ap_022")).booleanValue() && (totalInvAmount.subtract(billAmount).abs().compareTo(diffRang) > 0 || totalInvTax.subtract(billTax).abs().compareTo(diffRang) > 0 || totalInvPriceTaxAmt.subtract(billPriceTaxAmt).abs().compareTo(diffRang) > 0)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5e94\u4ed8\u4e0e\u53d1\u7968\u7684\u91d1\u989d\u3001\u7a0e\u989d\u3001\u4ef7\u7a0e\u5408\u8ba1\u5dee\u989d\u8d85\u8fc7\u4e86\u5bb9\u5dee\u8303\u56f4\uff0c\u5982\u9700\u7ee7\u7eed\u8c03\u5dee\uff0c\u524d\u5f80\u201c\u7cfb\u7edf\u53c2\u6570>\u5e94\u4ed8\u201d\u8bbe\u7f6e\u201c\u5fae\u8c03\u5bb9\u5dee\u8303\u56f4\u201d\u3002", (String)"FinApBillInvDiffAdjustValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (totalInvAmount.compareTo(billAmount) == 0 && totalInvTax.compareTo(billTax) == 0 && totalInvPriceTaxAmt.compareTo(billPriceTaxAmt) == 0) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5e94\u4ed8\u4e0e\u53d1\u7968\u7684\u91d1\u989d\u3001\u7a0e\u989d\u3001\u4ef7\u7a0e\u5408\u8ba1\u4e00\u81f4\uff0c\u65e0\u9700\u8c03\u5dee\u3002", (String)"FinApBillInvDiffAdjustValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            String errorMessage = InvoiceHelper.validatorInvoiceExist(invoiceBillNoMap, (DynamicObject[])invoiceMap.values().toArray(new DynamicObject[0]));
            if (!ObjectUtils.isEmpty((Object)errorMessage)) {
                this.addFatalErrorMessage(dataEntity, errorMessage);
            }
            ArrayList<String> invBillNos = new ArrayList<String>(4);
            for (DynamicObject invRow : invEntry) {
                Set<Long> finApBillIds = invoiceToFinMap.get(invRow.getLong("invid"));
                if (ObjectUtils.isEmpty(finApBillIds) || finApBillIds.size() <= 1) continue;
                invBillNos.add(invRow.getString("i_billno"));
            }
            if (invBillNos.isEmpty()) continue;
            if (invBillNos.size() <= 3) {
                invNosStr = String.join((CharSequence)" ,", invBillNos);
            } else {
                List tempInvNos = invBillNos.subList(0, 3);
                invNosStr = String.join((CharSequence)" ,", tempInvNos) + "......";
            }
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6536\u7968\u5355%1$s\u540c\u65f6\u88ab\u591a\u5f20\u5e94\u4ed8\u5355\u5360\u7528\uff0c\u5e94\u4ed8\u65e0\u6cd5\u6309\u53d1\u7968\u81ea\u52a8\u8c03\u6574\u3002", (String)"FinApBillInvDiffAdjustValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]), invNosStr));
        }
    }

    private Map<Long, Set<Long>> getInvoiceAssignOthers(List<Long> orgIds, Set<Long> invoiceIds) {
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and("inventry.invid", "in", invoiceIds);
        DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"getInvoiceAssignOthers", (String)"ap_finapbill", (String)"id,inventry.invid", (QFilter[])new QFilter[]{filter}, (String)"");
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(64);
        for (Row row : queryDataSet) {
            Long invId = row.getLong("inventry.invid");
            Set finApBillIds = result.getOrDefault(invId, new HashSet(64));
            finApBillIds.add(row.getLong("id"));
            result.put(invId, finApBillIds);
        }
        return result;
    }
}

