/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.util.DateUtils;

public class FinApBillSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashMap<Long, Boolean> paramMap = new HashMap<Long, Boolean>(8);
        List srcFinIds = Stream.of(this.dataEntities).filter(dataEntity -> "ar_finarbill".equals(dataEntity.getDataEntity().getString("sourcebilltype"))).map(dataEntity -> dataEntity.getDataEntity().getLong("sourcebillid")).collect(Collectors.toList());
        if (!srcFinIds.isEmpty()) {
            QFilter qf = new QFilter("id", "in", srcFinIds);
            DynamicObjectCollection finArBills = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,payproperty.isbasedonamt", (QFilter[])new QFilter[]{qf});
            for (DynamicObject finArBill : finArBills) {
                paramMap.put(finArBill.getLong("id"), finArBill.getBoolean("payproperty.isbasedonamt"));
            }
        }
        for (ExtendedDataEntity data : datas) {
            DynamicObject finApBill = data.getDataEntity();
            DynamicObject billType = finApBill.getDynamicObject("billtypeid");
            if (billType == null) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"FinApBillSubmitValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            BigDecimal pricetaxtotal = finApBill.getBigDecimal("pricetaxtotal");
            BigDecimal premiumamt = finApBill.getBigDecimal("premiumamt");
            if (premiumamt.multiply(pricetaxtotal).compareTo(BigDecimal.ZERO) < 0 || pricetaxtotal.compareTo(BigDecimal.ZERO) == 0 && premiumamt.compareTo(BigDecimal.ZERO) != 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u91d1\u989d\u65b9\u5411\u4e0e\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinApBillSubmitValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            } else if (pricetaxtotal.abs().compareTo(premiumamt.abs()) < 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u91d1\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinApBillSubmitValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            Date duedate = finApBill.getDate("duedate");
            if (duedate != null) {
                duedate = DateUtils.getDataFormat((Date)duedate, (boolean)false);
                DynamicObjectCollection planEntry = finApBill.getDynamicObjectCollection("planentity");
                for (DynamicObject planRow : planEntry) {
                    Date planDuedate = planRow.getDate("planduedate");
                    if (planDuedate == null || DateUtils.compareTo((Date)planDuedate, (Date)duedate) <= 0) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5230\u671f\u65e5\u4e0d\u80fd\u5927\u4e8e\u8868\u5934\u5230\u671f\u65e5\u3002", (String)"FinApBillSubmitValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
            this.checkInvoiceAmt(data);
            this.premiumValidator(data);
            this.checkCoordinationPayProperty(data, paramMap);
        }
    }

    private void checkInvoiceAmt(ExtendedDataEntity data) {
        DynamicObject bill = data.getDataEntity();
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("detailentry");
        for (DynamicObject entry : entries) {
            BigDecimal unInvoicedAmt;
            BigDecimal priceTaxTotal = entry.getBigDecimal("e_pricetaxtotal");
            BigDecimal invoicedAmt = entry.getBigDecimal("e_invoicedamt");
            if (invoicedAmt.add(unInvoicedAmt = entry.getBigDecimal("e_uninvoicedamt")).compareTo(priceTaxTotal) == 0) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u4f53\u7b2c%s\u884c\u672a\u5f00\u7968\u91d1\u989d+\u5df2\u5f00\u7968\u91d1\u989d\u9700\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"FinApBillSubmitValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[]{entry.getString("seq")}));
        }
    }

    private void premiumValidator(ExtendedDataEntity data) {
        DynamicObject finApBill = data.getDataEntity();
        DynamicObjectCollection detailEntry = finApBill.getDynamicObjectCollection("detailentry");
        DynamicObjectCollection planEntity = finApBill.getDynamicObjectCollection("planentity");
        if (detailEntry.size() <= 1 && planEntity.size() <= 1 || BigDecimal.ZERO.compareTo(finApBill.getBigDecimal("premiumamt")) == 0) {
            return;
        }
        long noZeroCount = 0L;
        long count = 0L;
        for (DynamicObject detail : detailEntry) {
            if (BigDecimal.ZERO.compareTo(detail.getBigDecimal("e_pricetaxtotal")) == 0) continue;
            if (BigDecimal.ZERO.compareTo(detail.getBigDecimal("e_pricetaxtotal")) < 0) {
                ++count;
            }
            ++noZeroCount;
        }
        if (count > 0L && count < noZeroCount) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u6b63\u8d1f\u5206\u5f55\u884c\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u5141\u8bb8\u5f55\u5165\u8d28\u4fdd\u91d1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApBillSubmitValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            return;
        }
        noZeroCount = 0L;
        count = 0L;
        for (DynamicObject plan : planEntity) {
            if (BigDecimal.ZERO.compareTo(plan.getBigDecimal("planpricetax")) == 0) continue;
            if (BigDecimal.ZERO.compareTo(plan.getBigDecimal("planpricetax")) < 0) {
                ++count;
            }
            ++noZeroCount;
        }
        if (count > 0L && count < noZeroCount) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5b58\u5728\u6b63\u8d1f\u5206\u5f55\u884c\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u4e0d\u5141\u8bb8\u5f55\u5165\u8d28\u4fdd\u91d1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApBillSubmitValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkCoordinationPayProperty(ExtendedDataEntity data, Map<Long, Boolean> paramMap) {
        DynamicObject finApBill = data.getDataEntity();
        if ("ar_finarbill".equals(finApBill.getString("sourcebilltype"))) {
            Boolean srcIsBasedonAmt = paramMap.get(finApBill.getLong("sourcebillid"));
            if (srcIsBasedonAmt == null) {
                return;
            }
            if (finApBill.getBoolean("payproperty.isbasedonamt") != srcIsBasedonAmt.booleanValue()) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6b3e\u9879\u6027\u8d28\u201c\u662f\u5426\u91d1\u989d\u57fa\u51c6\u201d\u4e0e\u6e90\u5355\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinApBillSubmitValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

