/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FinApBillUnAuditSrcBusRevalValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<Long> directSrcBusIds = new ArrayList<Long>(2);
        ArrayList<Long> sameSrcFinIds = new ArrayList<Long>(2);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String srcType = bill.getString("sourcebilltype");
            if (srcType == null) continue;
            if ("ap_busbill".equals(srcType)) {
                directSrcBusIds.add(bill.getLong("sourcebillid"));
                continue;
            }
            sameSrcFinIds.add(bill.getLong("id"));
        }
        if (directSrcBusIds.size() > 0) {
            DynamicObjectCollection hadRevalBusBill = QueryServiceHelper.query((String)"ap_busbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", directSrcBusIds), new QFilter("hadrevaluation", "=", (Object)Boolean.TRUE)});
            List hadRevalBusIds = hadRevalBusBill.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                DynamicObject bill = dataEntity.getDataEntity();
                String billNo = bill.getString("billno");
                Long sourcebillId = bill.getLong("sourcebillid");
                if (!hadRevalBusIds.contains(sourcebillId)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u5bf9\u5e94\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u5df2\u91cd\u4f30\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinApBillUnAuditSrcBusRevalValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[]{billNo}));
            }
        }
        if (sameSrcFinIds.size() > 0) {
            ArrayList hadSrcRevalBusIds = new ArrayList(2);
            DynamicObjectCollection sameWoffBills = QueryServiceHelper.query((String)"ap_busbill", (String)"id,srcfinbillid,sourcebillid", (QFilter[])new QFilter[]{new QFilter("srcfinbillid", "in", sameSrcFinIds)});
            HashMap<Long, Long> sameSrcFinToBusIdMap = new HashMap<Long, Long>(2);
            ArrayList<Long> srcBusIds = new ArrayList<Long>(sameSrcFinIds.size());
            for (DynamicObject woffBill : sameWoffBills) {
                Long srcBusId = Long.valueOf(woffBill.getString("sourcebillid"));
                sameSrcFinToBusIdMap.put(woffBill.getLong("srcfinbillid"), srcBusId);
                srcBusIds.add(srcBusId);
            }
            if (srcBusIds.size() > 0) {
                DynamicObjectCollection hadRevalSameSrcBills = QueryServiceHelper.query((String)"ap_busbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBusIds), new QFilter("hadrevaluation", "=", (Object)Boolean.TRUE)});
                if (hadRevalSameSrcBills == null || hadRevalSameSrcBills.size() == 0) {
                    return;
                }
                List hadRevalBillIds = hadRevalSameSrcBills.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
                for (Map.Entry entrySet : sameSrcFinToBusIdMap.entrySet()) {
                    if (!hadRevalBillIds.contains(entrySet.getValue())) continue;
                    hadSrcRevalBusIds.add(entrySet.getKey());
                }
            }
            if (hadSrcRevalBusIds.size() > 0) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    String billNo = bill.getString("billno");
                    if (!hadSrcRevalBusIds.contains(bill.getLong("id"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u5bf9\u5e94\u7684\u6682\u4f30\u5e94\u4ed8\u5355\u5df2\u91cd\u4f30\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinApBillUnAuditSrcBusRevalValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[]{billNo}));
                }
            }
        }
    }
}

