/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.validator.validatorService.ApValidatorService;
import kd.fi.arapcommon.enums.APSettleStatusEnum;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.BOTPNewHelper;
import kd.fi.arapcommon.helper.SettleRecordValidateHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;

public class FinApBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        boolean redAllSettleRecord = CommonSettleServiceHelper.isRedAllSettleRecord();
        ArrayList<Long> allFinApBillId = new ArrayList<Long>(64);
        ArrayList<Long> srcTypeNotNullBillIds = new ArrayList<Long>(64);
        ArrayList<Long> maybePremiumIds = new ArrayList<Long>(64);
        ArrayList<Long> redSettleRecordBillIds = new ArrayList<Long>(64);
        HashSet<Long> orgIds = new HashSet<Long>(8);
        HashMap<Long, Long> srcId4WriteOffIdMap = new HashMap<Long, Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject finApBill = dataEntity.getDataEntity();
            long billId = finApBill.getLong("id");
            orgIds.add(finApBill.getLong("org.id"));
            allFinApBillId.add(billId);
            long sourceBillId = finApBill.getLong("sourcebillid");
            if (!ObjectUtils.isEmpty((Object)finApBill.getString("sourcebilltype"))) {
                srcTypeNotNullBillIds.add(billId);
            }
            if (finApBill.getBoolean("iswrittenoff") && sourceBillId != 0L && !this.getOption().getVariables().containsKey("fiap_unaduit_mode")) {
                maybePremiumIds.add(sourceBillId);
            }
            if (!(!redAllSettleRecord || finApBill.getBoolean("iswrittenoff") || finApBill.getBoolean("istanspay") || finApBill.getBoolean("ispremium") || "unsettle".equals(finApBill.getString("settlestatus")))) {
                redSettleRecordBillIds.add(billId);
            }
            if (!finApBill.getBoolean("iswrittenoff")) continue;
            srcId4WriteOffIdMap.put(finApBill.getLong("sourcebillid"), finApBill.getLong("id"));
        }
        Map validateRecordMessageMap = SettleRecordValidateHelper.validate4Bill(allFinApBillId, orgIds, (String)"ap", (String)"unaudit");
        Set<Long> busHasVoucher4FinBillIds = this.validateBusHasVoucher(srcTypeNotNullBillIds);
        Set<Long> srcPremiumBillIds = this.validateSrcIsPremium(maybePremiumIds);
        Set<Long> hasSettleRecordBillIds = this.validateRecSettleRecord(redSettleRecordBillIds, orgIds);
        Set<Long> busHasDown4FinIds = this.validateRedBusHasDownBill(srcTypeNotNullBillIds);
        Set<Long> verifyRecordHasVoucher4FinBillIds = this.validateVerifyRecordIsVoucher(allFinApBillId);
        Set<Long> noUnAuditSrcBillIds = this.validateWriteOffHasAdjust(srcId4WriteOffIdMap);
        ApValidatorService vService = new ApValidatorService();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String errorMessageOther;
            DynamicObject finApBill = dataEntity.getDataEntity();
            long billId = finApBill.getLong("id");
            long sourceBillId = finApBill.getLong("sourcebillid");
            String validateRecordMessage = (String)validateRecordMessageMap.get(billId);
            if (!ObjectUtils.isEmpty((Object)validateRecordMessage)) {
                if (!APSettleStatusEnum.UNSETTLE.getValue().equals(finApBill.getString("settlestatus"))) {
                    this.addErrorMessage(dataEntity, validateRecordMessage);
                    continue;
                }
                if (finApBill.getBoolean("istanspay") || finApBill.getBoolean("ispremium")) {
                    if (validateRecordMessage.contains(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1", (String)"FinApBillUnAuditValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]))) {
                        if (finApBill.getBoolean("istanspay")) {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u5e94\u4ed8\u8f6c\u4ed8\u201d\u7ed3\u7b97\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"FinApBillUnAuditValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u8f6c\u51fa\u8d28\u4fdd\u91d1\u201d\u7684\u7ed3\u7b97\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"FinApBillUnAuditValidator_10", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    this.addErrorMessage(dataEntity, validateRecordMessage);
                    continue;
                }
            }
            if (!"".equals(errorMessageOther = vService.closeAccountValidate(dataEntity, "ap_finapbill", "bookdate"))) {
                this.addErrorMessage(dataEntity, errorMessageOther);
            }
            if (busHasVoucher4FinBillIds.contains(billId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0a\u6e38\u6682\u4f30\u5e94\u4ed8\u5355\u7684\u51b2\u56de\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u64cd\u4f5c\u3002", (String)"FinApBillUnAuditValidator_4", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            if (finApBill.getBoolean("iswrittenoff") && finApBill.getBoolean("istanspay")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u8f6c\u4ed8\u4e1a\u52a1\u7684\u51b2\u9500\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinApBillUnAuditValidator_11", (String)"fi-ap-opplugin", (Object[])new Object[]{finApBill.getString("billno")}));
            }
            if (srcPremiumBillIds.contains(sourceBillId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d28\u4fdd\u91d1\u7684\u51b2\u9500\u5355\u636e\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinApBillUnAuditValidator_6", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            if (hasSettleRecordBillIds.contains(billId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\u9700\u8981\u88ab\u7ea2\u51b2\uff0c\u8bf7\u5230\u7ed3\u7b97\u8bb0\u5f55\u5217\u8868\u6267\u884c\u53cd\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\uff01", (String)"SettleRecordValidateHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            if (busHasDown4FinIds.contains(billId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0b\u6e38\u51b2\u56de\u5355\u5df2\u5b58\u5728\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"FinApBillUnAuditValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            if (verifyRecordHasVoucher4FinBillIds.contains(billId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u5e94\u7684\u6838\u9500\u8bb0\u5f55\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u6cd5\u53cd\u5ba1\u6838\u3002", (String)"FinApBillUnAuditValidator_9", (String)"fi-ap-opplugin", (Object[])new Object[0]));
            }
            if (!noUnAuditSrcBillIds.contains(sourceBillId)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u51b2\u9500\u5355\u5c06\u5bfc\u81f4\u5e94\u4ed8\u4e0e\u53d1\u7968\u4ea7\u751f\u5dee\u5f02\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FinApBillUnAuditValidator_12", (String)"fi-ap-opplugin", (Object[])new Object[0]));
        }
    }

    private Set<Long> validateBusHasVoucher(List<Long> billIds) {
        if (billIds.isEmpty()) {
            return new HashSet<Long>(2);
        }
        HashSet<Long> errorBillIds = new HashSet<Long>(16);
        QFilter filter = new QFilter("srcfinbillid", "in", billIds);
        filter.and(new QFilter("isvoucher", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection writeOffBills = QueryServiceHelper.query((String)"ap_busbill", (String)"id,isvoucher,srcfinbillid", (QFilter[])new QFilter[]{filter});
        for (DynamicObject writeOffBill : writeOffBills) {
            errorBillIds.add(writeOffBill.getLong("srcfinbillid"));
        }
        return errorBillIds;
    }

    private Set<Long> validateSrcIsPremium(List<Long> billIds) {
        if (billIds.isEmpty()) {
            return new HashSet<Long>(2);
        }
        HashSet<Long> errorBillIds = new HashSet<Long>(16);
        QFilter filter = new QFilter("id", "in", billIds);
        filter.and(new QFilter("ispremium", "=", (Object)Boolean.TRUE));
        DynamicObjectCollection premiumBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id", (QFilter[])new QFilter[]{filter});
        for (DynamicObject bill : premiumBills) {
            errorBillIds.add(bill.getLong("id"));
        }
        return errorBillIds;
    }

    private Set<Long> validateRecSettleRecord(List<Long> billIds, Set<Long> orgIds) {
        if (billIds.isEmpty()) {
            return new HashSet<Long>(2);
        }
        HashSet<Long> errorBillIds = new HashSet<Long>(16);
        DynamicObjectCollection asMainRecords = QueryServiceHelper.query((String)"ap_settlerecord", (String)"mainbillid", (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", billIds)});
        for (DynamicObject asMainRecord : asMainRecords) {
            errorBillIds.add(asMainRecord.getLong("mainbillid"));
        }
        billIds.removeAll(errorBillIds);
        if (!billIds.isEmpty()) {
            DynamicObjectCollection asAssRecords = QueryServiceHelper.query((String)"ap_settlerecord", (String)"entry.billid", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", billIds), new QFilter("org", "in", orgIds)});
            for (DynamicObject asAssRecord : asAssRecords) {
                errorBillIds.add(asAssRecord.getLong("entry.billid"));
            }
        }
        return errorBillIds;
    }

    private Set<Long> validateRedBusHasDownBill(List<Long> billIds) {
        if (billIds.isEmpty()) {
            return new HashSet<Long>(2);
        }
        HashSet<Long> errorBillIds = new HashSet<Long>(16);
        DynamicObjectCollection busBills = QueryServiceHelper.query((String)"ap_busbill", (String)"id,srcfinbillid,entry.id", (QFilter[])new QFilter[]{new QFilter("srcfinbillid", "in", billIds)});
        if (busBills.isEmpty()) {
            return new HashSet<Long>(2);
        }
        HashMap<Long, Long> busId4FinIdMap = new HashMap<Long, Long>(32);
        ArrayList<Long> busEntryIds = new ArrayList<Long>(32);
        for (DynamicObject busBill : busBills) {
            busId4FinIdMap.put(busBill.getLong("id"), busBill.getLong("srcfinbillid"));
            busEntryIds.add(busBill.getLong("entry.id"));
        }
        Map allTargetBillIdsMap = BOTPNewHelper.loadAllTargetBillIds((String)"ap_busbill", (String)"entry", (Long[])busId4FinIdMap.keySet().toArray(new Long[0]), (Long[])busEntryIds.toArray(new Long[0]));
        ArrayList allBusBillIds = new ArrayList(64);
        for (Map.Entry entrySet : allTargetBillIdsMap.entrySet()) {
            Map targetBillIdsMap = (Map)entrySet.getValue();
            List busBillIds = (List)targetBillIdsMap.get("ap_busbill");
            if (ObjectUtils.isEmpty((Object)busBillIds)) continue;
            allBusBillIds.addAll(busBillIds);
        }
        HashSet<Long> hasExistBusBillIds = new HashSet<Long>(32);
        if (!allBusBillIds.isEmpty()) {
            DynamicObjectCollection hasExistBusBills = QueryServiceHelper.query((String)"ap_busbill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", allBusBillIds)});
            for (DynamicObject busBill : hasExistBusBills) {
                hasExistBusBillIds.add(busBill.getLong("id"));
            }
        }
        block3: for (Map.Entry entrySet : allTargetBillIdsMap.entrySet()) {
            Long finApBillId = (Long)busId4FinIdMap.get(entrySet.getKey());
            if (finApBillId == null) continue;
            Map targetBillIdsMap = (Map)entrySet.getValue();
            List busBillIds = (List)targetBillIdsMap.get("ap_busbill");
            if (ObjectUtils.isEmpty((Object)busBillIds)) {
                if (targetBillIdsMap.size() <= 0) continue;
                errorBillIds.add(finApBillId);
                continue;
            }
            for (Long billId : busBillIds) {
                if (!hasExistBusBillIds.contains(billId)) continue;
                errorBillIds.add(finApBillId);
                continue block3;
            }
        }
        return errorBillIds;
    }

    private Set<Long> validateVerifyRecordIsVoucher(List<Long> billIds) {
        if (billIds.isEmpty()) {
            return new HashSet<Long>(2);
        }
        HashSet<Long> errorBillIds = new HashSet<Long>(16);
        ArrayList<Long> billPks = new ArrayList<Long>(billIds);
        QFilter mainFilter = new QFilter("billid", "in", billPks);
        QFilter isVoucherFilter = new QFilter("isvoucher", "=", (Object)Boolean.TRUE);
        mainFilter.and(isVoucherFilter);
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)"ap_finapbill", (Object[])billPks.toArray(), (boolean)false);
        DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)"FinApBillUnAuditValidator", (String)"ap_verifyrecord", (String)"billid", (QFilter[])new QFilter[]{mainFilter}, null);
        for (Row asMainRecord : mainDataSet) {
            errorBillIds.add(asMainRecord.getLong("billid"));
        }
        billPks.removeAll(errorBillIds);
        if (!billIds.isEmpty()) {
            QFilter asstFilter = new QFilter("entry.e_billid", "in", billPks);
            asstFilter.and(isVoucherFilter);
            asstFilter.and(commonFilter);
            DataSet asstDataSet = QueryServiceHelper.queryDataSet((String)"FinApBillUnAuditValidator", (String)"ap_verifyrecord", (String)"entry.e_billid", (QFilter[])new QFilter[]{asstFilter}, null);
            for (Row asAssRecord : asstDataSet) {
                errorBillIds.add(asAssRecord.getLong("entry.e_billid"));
            }
        }
        return errorBillIds;
    }

    private Set<Long> validateWriteOffHasAdjust(Map<Long, Long> srcId4WriteOffIdMap) {
        QFilter filter = new QFilter("id", "in", srcId4WriteOffIdMap.keySet());
        filter.and(new QFilter("billsrctype", "=", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue()));
        DataSet finApDataSet = QueryServiceHelper.queryDataSet((String)"query_src_finap", (String)"ap_finapbill", (String)"sourcebillid,id", (QFilter[])new QFilter[]{filter}, (String)"");
        if (!finApDataSet.hasNext()) {
            return new HashSet<Long>(2);
        }
        HashMap<Long, Long> finAp4WriteOffSrcIdMap = new HashMap<Long, Long>(8);
        for (Row row : finApDataSet) {
            finAp4WriteOffSrcIdMap.put(row.getLong("sourcebillid"), row.getLong("id"));
        }
        QFilter filter1 = new QFilter("sourcebillid", "in", finAp4WriteOffSrcIdMap.keySet());
        filter1.and(new QFilter("billsrctype", "=", (Object)BillSrcTypeEnum.COORDINATEADJUST.getValue()));
        filter1.and(new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE));
        DataSet finApAdjustDataSet = QueryServiceHelper.queryDataSet((String)"query_other_adjustap", (String)"ap_finapbill", (String)"sourcebillid", (QFilter[])new QFilter[]{filter1}, (String)"");
        if (!finApAdjustDataSet.hasNext()) {
            return new HashSet<Long>(2);
        }
        ArrayList<Long> hasAdjustFinApIds = new ArrayList<Long>(8);
        for (Row row : finApAdjustDataSet) {
            hasAdjustFinApIds.add(row.getLong("sourcebillid"));
        }
        HashSet<Long> noAuditSrcBillIds = new HashSet<Long>(8);
        for (Long hasAdjustFinApId : hasAdjustFinApIds) {
            noAuditSrcBillIds.add((Long)finAp4WriteOffSrcIdMap.get(hasAdjustFinApId));
        }
        return noAuditSrcBillIds;
    }
}

