/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.mservice.ToleranceMatchService;
import kd.fi.arapcommon.helper.ToleranceHepler;

public class FinApTaxToleranceValidator
extends AbstractValidator {
    public void validate() {
        if (!ToleranceHepler.haveToleranceScheme((String)"ap_finapbill", (String)"ap_finapbill", (String)"e_tax", (String)"e_tax")) {
            return;
        }
        ArrayList toleranceParams = new ArrayList(16);
        HashMap<Long, DynamicObject> materialGroupMap = new HashMap<Long, DynamicObject>(8);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean isWriteOff = bill.getBoolean("iswrittenoff");
            boolean isPremBill = bill.getBoolean("ispremium");
            boolean isTanspay = bill.getBoolean("istanspay");
            String billType = bill.getString("billtypeid.number");
            if (isWriteOff || isPremBill || isTanspay || "ApFin_borr_BT_S".equals(billType)) continue;
            DynamicObject currency = bill.getDynamicObject("currency");
            String asstactType = bill.getString("asstacttype");
            Long asstactId = bill.getLong("asstact.id");
            int precision = currency.getInt("amtprecision");
            Long currencyId = currency.getLong("id");
            Long orgId = bill.getLong("org.id");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            List materialIds = entry.stream().map(v -> v.getLong("material.id")).collect(Collectors.toList());
            HashMap<Long, ArrayList<Long>> materialIdToMaterialgroup = new HashMap<Long, ArrayList<Long>>(16);
            ArrayList<DynamicObject> materialGroups = new ArrayList<DynamicObject>(8);
            for (Long materialId : materialIds) {
                DynamicObject group = (DynamicObject)materialGroupMap.get(materialId);
                if (group == null && (group = QueryServiceHelper.queryOne((String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])new QFilter[]{new QFilter("material", "=", (Object)materialId)})) != null) {
                    materialGroupMap.put(materialId, group);
                }
                if (group == null) continue;
                materialGroups.add(group);
            }
            for (DynamicObject group : materialGroups) {
                Long materialId = group.getLong("material");
                ArrayList<Long> materialGroupIds = (ArrayList<Long>)materialIdToMaterialgroup.get(materialId);
                if (materialGroupIds == null) {
                    materialGroupIds = new ArrayList<Long>(16);
                    materialGroupIds.add(group.getLong("group"));
                    materialIdToMaterialgroup.put(materialId, materialGroupIds);
                    continue;
                }
                materialGroupIds.add(group.getLong("group"));
            }
            for (DynamicObject row : entry) {
                BigDecimal realTax;
                BigDecimal amount = row.getBigDecimal("e_amount");
                BigDecimal taxRate = row.getBigDecimal("taxrate");
                BigDecimal tax = row.getBigDecimal("e_tax");
                if (tax.compareTo(realTax = amount.multiply(taxRate).divide(new BigDecimal("100"), precision, RoundingMode.HALF_UP)) == 0) continue;
                Long materialId = row.getLong("material.id");
                HashMap<String, Object> toleranceMap = new HashMap<String, Object>(8);
                toleranceMap.put("e_tax", tax);
                toleranceMap.put("controlvalue", tax);
                toleranceMap.put("contrastvalue", realTax);
                toleranceMap.put("bd_currency", currencyId);
                toleranceMap.put("bd_material", materialId);
                toleranceMap.put("precision", precision);
                List materialGroup = (List)materialIdToMaterialgroup.get(materialId);
                toleranceMap.put("bd_materialgroup", materialGroup);
                if ("bd_supplier".equals(asstactType)) {
                    toleranceMap.put("bd_supplier", asstactId);
                    toleranceMap.put("bd_customer", null);
                } else {
                    toleranceMap.put("bd_customer", asstactId);
                    toleranceMap.put("bd_supplier", null);
                }
                toleranceMap.put("bos_org", orgId);
                toleranceMap.put("pk", row.getLong("id"));
                toleranceParams.add(toleranceMap);
            }
        }
        ToleranceMatchService service = new ToleranceMatchService();
        List result = service.getResultByToleranceType("ap_finapbill", "ap_finapbill", "e_tax", "e_tax", toleranceParams);
        ArrayList<Long> overTaxentryIds = new ArrayList<Long>(16);
        for (Map resultMap : result) {
            overTaxentryIds.add((Long)resultMap.get("pk"));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String billNo = bill.getString("billno");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                Long entryId = row.getLong("id");
                if (!overTaxentryIds.contains(entryId)) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u7a0e\u989d\u4e0e\u7cfb\u7edf\u81ea\u52a8\u8ba1\u7b97\u7684\u7a0e\u989d\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u5173\u6ce8\u662f\u5426\u5b58\u5728\u7a0e\u52a1\u98ce\u9669\u3002", (String)"FinApTaxToleranceValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq")));
            }
        }
    }
}

