/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ap.validator;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ap.validator.validatorService.PaymentSecurityToleranceValidatorService;
import kd.fi.arapcommon.excecontrol.AbstractExecControlValidator;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.CoreBillInfo;

public class FinPaymentSecurityAuditValidator
extends AbstractExecControlValidator {
    private static final Log logger = LogFactory.getLog(FinPaymentSecurityAuditValidator.class);
    private boolean isValidataQty;
    private boolean isValidataAmt;
    private String operateKey;
    private Date minDate = null;

    public Set<String> preparePropertys() {
        HashSet<String> lst = new HashSet<String>(16);
        lst.add("billno");
        lst.add("org");
        lst.add("iswrittenoff");
        lst.add("ispremium");
        lst.add("istanspay");
        lst.add("asstact");
        lst.add("payproperty");
        lst.add("currency");
        lst.add("detailentry.corebillid");
        lst.add("detailentry.corebillentryid");
        lst.add("detailentry.corebilltype");
        lst.add("detailentry.seq");
        lst.add("detailentry.e_pricetaxtotal");
        lst.add("detailentry.e_baseunitqty");
        lst.add("biztype");
        lst.add("detailentry.material");
        lst.add("detailentry.e_baseunit");
        lst.add("detailentry.e_expensebillids_tag");
        return lst;
    }

    public void validate() {
        this.initValidataLevel();
        if (!this.isValidataQty && !this.isValidataAmt) {
            logger.info("execcontrol is disable");
            return;
        }
        this.operateKey = this.getOperateKey();
        DynamicObject finApBill = this.dataEntities[0].getDataEntity();
        if (!finApBill.getBoolean("iswrittenoff") && "save".equals(this.operateKey)) {
            return;
        }
        Map<String, CoreBillInfo> coreBillInfoMap = this.queryCoreBill();
        Map<String, CoreBillInfo> coreBillInfoGroupByOrg = this.getCtrlBillInfo(coreBillInfoMap);
        Map<String, List<String>> toleranceResult = PaymentSecurityToleranceValidatorService.getQtyTolearnceResult(coreBillInfoGroupByOrg, this.isValidataQty, this.isValidataAmt, "ap_finapbill");
        this.doValidate(coreBillInfoGroupByOrg, toleranceResult);
    }

    private void doValidate(Map<String, CoreBillInfo> coreBillInfoGroupByOrg, Map<String, List<String>> toleranceResult) {
        List<String> qtyToleranceRs = toleranceResult.get("qty");
        List<String> amtToleranceRs = toleranceResult.get("amt");
        if (coreBillInfoGroupByOrg.size() == 0) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String billNo = bill.getString("billno");
            String bizTypeNum = bill.getString("biztype.number");
            String sourceBillType = bill.getString("sourcebilltype");
            if (bill.getBoolean("ispremium") || bill.getBoolean("istanspay") || "114-1".equals(bizTypeNum)) continue;
            Long orgId = bill.getLong("org.id");
            Long supplierId = bill.getLong("asstact.id");
            boolean isAmtBase = bill.getBoolean("payproperty.isbasedonamt");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                String msg;
                String key;
                CoreBillInfo info;
                Long coreBillId = row.getLong("corebillid");
                Long coreBillEntryId = row.getLong("corebillentryid");
                if (coreBillId == 0L || coreBillEntryId == 0L) continue;
                String coreBillType = row.getString("corebilltype");
                String coreBillName = null;
                if ("pm_purorderbill".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"FinPaymentSecurityAuditValidator_0", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("conm_purcontract".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u91c7\u8d2d\u5408\u540c", (String)"FinPaymentSecurityAuditValidator_1", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("sctm_scpo".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355", (String)"FinPaymentSecurityAuditValidator_2", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                } else if ("pm_om_purorderbill".equals(coreBillType)) {
                    coreBillName = ResManager.loadKDString((String)"\u7b80\u5355\u59d4\u5916\u8ba2\u5355", (String)"FinPaymentSecurityAuditValidator_3", (String)"fi-ap-opplugin", (Object[])new Object[0]);
                }
                if ((info = coreBillInfoGroupByOrg.get(key = coreBillId + "_" + coreBillEntryId + "_" + orgId + "_" + supplierId)) == null || info.isAllowOverPay()) continue;
                if (this.isValidataAmt && amtToleranceRs != null && amtToleranceRs.contains(key)) {
                    msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u7269\u6599\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309%3$s\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u7d2f\u8ba1\u5e94\u4ed8\u91d1\u989d\u4e0e%3$s\u4ef7\u7a0e\u5408\u8ba1\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"FinPaymentSecurityAuditValidator_5", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"), coreBillName);
                    this.addMessage(dataEntity, msg);
                }
                if (!this.isValidataQty || !sourceBillType.equals(coreBillType) || isAmtBase) continue;
                if ("pm_purorderbill".equals(coreBillType)) {
                    if (qtyToleranceRs == null || !qtyToleranceRs.contains(key)) continue;
                    msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u76f4\u63a5\u4e0a\u6e38\u662f\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u57fa\u672c\u6570\u91cf\u4e4b\u548c\u4e0e\u91c7\u8d2d\u8ba2\u5355\u6536\u8d27\u4e0a\u9650\u57fa\u672c\u6570\u91cf\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6570\u91cf\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"FinPaymentSecurityAuditValidator_7", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"));
                    this.addMessage(dataEntity, msg);
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    if (qtyToleranceRs == null || !qtyToleranceRs.contains(key)) continue;
                    msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u76f4\u63a5\u4e0a\u6e38\u662f\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u57fa\u672c\u6570\u91cf\u4e4b\u548c\u4e0e\u91c7\u8d2d\u5408\u540c\u57fa\u672c\u6570\u91cf\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6570\u91cf\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"FinPaymentSecurityAuditValidator_9", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"));
                    this.addMessage(dataEntity, msg);
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    if (qtyToleranceRs == null || !qtyToleranceRs.contains(key)) continue;
                    msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u76f4\u63a5\u4e0a\u6e38\u662f\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u57fa\u672c\u6570\u91cf\u4e4b\u548c\u4e0e\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u6536\u8d27\u4e0a\u9650\u57fa\u672c\u6570\u91cf\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6570\u91cf\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"FinPaymentSecurityAuditValidator_11", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"));
                    this.addMessage(dataEntity, msg);
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType) || qtyToleranceRs == null || !qtyToleranceRs.contains(key)) continue;
                msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\uff0c\u6309\u76f4\u63a5\u4e0a\u6e38\u662f\u7b80\u5355\u59d4\u5916\u8ba2\u5355\u67e5\u8be2\u7684\u8d22\u52a1\u5e94\u4ed8\u5355\u57fa\u672c\u6570\u91cf\u4e4b\u548c\u4e0e\u7b80\u5355\u59d4\u5916\u8ba2\u5355\u6536\u8d27\u4e0a\u9650\u57fa\u672c\u6570\u91cf\u7684\u5dee\u5f02\u8d85\u8fc7\u5bb9\u5dee\u8303\u56f4\uff0c\u8bf7\u4fee\u6539\u5355\u636e\u6570\u91cf\u6216\u4fee\u6539\u5bb9\u5dee\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"FinPaymentSecurityAuditValidator_13", (String)"fi-ap-opplugin", (Object[])new Object[0]), billNo, row.getInt("seq"));
                this.addMessage(dataEntity, msg);
            }
        }
    }

    private Map<String, CoreBillInfo> getCtrlBillInfo(Map<String, CoreBillInfo> coreBillInfo) {
        boolean isExpenseBill;
        String expenseBillIds;
        HashMap<String, CoreBillInfo> coreBillInfoGroupByOrg = new HashMap<String, CoreBillInfo>(16);
        if (coreBillInfo.size() == 0) {
            return coreBillInfoGroupByOrg;
        }
        HashSet<Long> coreBillIds = new HashSet<Long>(16);
        HashSet<Long> curBillIds = new HashSet<Long>(16);
        HashSet<Long> orgIds = new HashSet<Long>(16);
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            expenseBillIds = ((DynamicObject)bill.getDynamicObjectCollection("detailentry").get(0)).getString("e_expensebillids_tag");
            boolean bl = isExpenseBill = expenseBillIds != null && !"".equals(expenseBillIds);
            if (bill.getBoolean("ispremium") || bill.getBoolean("istanspay") || isExpenseBill) continue;
            curBillIds.add(bill.getLong("id"));
            Long currencyId = bill.getLong("currency.id");
            int amtPrecision = bill.getInt("currency.amtprecision");
            Long orgId = bill.getLong("org.id");
            orgIds.add(orgId);
            Long supplierId = bill.getLong("asstact.id");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : entry) {
                Long coreCurrencyId;
                String coreKey;
                CoreBillInfo info;
                Long coreBillId = row.getLong("corebillid");
                Long coreBillEntryId = row.getLong("corebillentryid");
                if (coreBillId == 0L || coreBillEntryId == 0L || (info = coreBillInfo.get(coreKey = coreBillId + "_" + coreBillEntryId)) == null || !(coreCurrencyId = info.getCurrencyId()).equals(currencyId)) continue;
                coreBillIds.add(coreBillId);
                int qtyPrecision = row.getInt("e_baseunit.precision");
                Long materialId = row.getLong("material.id");
                String ctrlCoreKey = coreBillId + "_" + coreBillEntryId + "_" + orgId + "_" + supplierId;
                CoreBillInfo ctrlInfo = (CoreBillInfo)coreBillInfoGroupByOrg.get(ctrlCoreKey);
                if (ctrlInfo == null) {
                    ctrlInfo = new CoreBillInfo();
                    ctrlInfo.setCoreBillId(coreBillId);
                    ctrlInfo.setSupplierId(supplierId);
                    ctrlInfo.setOrgId(orgId);
                    ctrlInfo.setCoreBillType(info.getCoreBillType());
                    ctrlInfo.setMaterialId(materialId);
                    ctrlInfo.setCurrencyId(coreCurrencyId);
                    ctrlInfo.setAllowOverPay(info.isAllowOverPay());
                    ctrlInfo.setCoreBillEntryId(coreBillEntryId);
                    ctrlInfo.setCoreBillAmt(info.getCoreBillAmt());
                    ctrlInfo.setCoreBaseQtyUp(info.getCoreBaseQtyUp());
                    ctrlInfo.setQtyPrecision(qtyPrecision);
                    ctrlInfo.setAmtPrecision(amtPrecision);
                    if ("delete".equals(this.operateKey)) {
                        ctrlInfo.setSumAmt(BigDecimal.ZERO);
                        ctrlInfo.setSumBaseQty(BigDecimal.ZERO);
                    } else {
                        ctrlInfo.setSumAmt(row.getBigDecimal("e_pricetaxtotal"));
                        ctrlInfo.setSumBaseQty(row.getBigDecimal("e_baseunitqty"));
                    }
                    coreBillInfoGroupByOrg.put(ctrlCoreKey, ctrlInfo);
                    continue;
                }
                if ("delete".equals(this.operateKey)) continue;
                ctrlInfo.setSumBaseQty(ctrlInfo.getSumBaseQty().add(row.getBigDecimal("e_baseunitqty")));
                ctrlInfo.setSumAmt(ctrlInfo.getSumAmt().add(row.getBigDecimal("e_pricetaxtotal")));
            }
        }
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and(new QFilter("detailentry.corebillid", "in", coreBillIds));
        filter.and(new QFilter("billstatus", "!=", (Object)"A"));
        filter.and(new QFilter("ispremium", "=", (Object)Boolean.FALSE));
        filter.and(new QFilter("istanspay", "=", (Object)Boolean.FALSE));
        if (this.minDate != null) {
            this.minDate = DateUtils.getDataFormat((Date)this.minDate, (boolean)true);
            filter.and(new QFilter("bizdate", ">=", (Object)this.minDate));
        }
        DynamicObjectCollection historyBills = QueryServiceHelper.query((String)"ap_finapbill", (String)"id,org,asstact,currency,detailentry.corebillid corebillid,detailentry.corebillentryseq corebillseq,detailentry.e_baseunitqty baseqty,detailentry.e_pricetaxtotal amt,detailentry.corebillentryid corebillentryid,detailentry.e_expensebillids_tag", (QFilter[])new QFilter[]{filter});
        for (DynamicObject bill : historyBills) {
            Long historyCurrencyId;
            Long infoCurrencyId;
            Long billId = bill.getLong("id");
            if (curBillIds.contains(billId)) continue;
            expenseBillIds = bill.getString("detailentry.e_expensebillids_tag");
            boolean bl = isExpenseBill = expenseBillIds != null && !"".equals(expenseBillIds);
            if (isExpenseBill) continue;
            Long orgId = bill.getLong("org");
            Long asstactId = bill.getLong("asstact");
            Long corebillId = bill.getLong("corebillid");
            Long coreBillEntryId = bill.getLong("corebillentryid");
            String key = corebillId + "_" + coreBillEntryId + "_" + orgId + "_" + asstactId;
            CoreBillInfo info = (CoreBillInfo)coreBillInfoGroupByOrg.get(key);
            if (info == null || !(infoCurrencyId = info.getCurrencyId()).equals(historyCurrencyId = Long.valueOf(bill.getLong("currency")))) continue;
            info.setSumAmt(info.getSumAmt().add(bill.getBigDecimal("amt")));
            info.setSumBaseQty(info.getSumBaseQty().add(bill.getBigDecimal("baseqty")));
        }
        return coreBillInfoGroupByOrg;
    }

    private Map<String, CoreBillInfo> queryCoreBill() {
        HashMap<Long, HashSet<Long>> coreOrderBillInfo = new HashMap<Long, HashSet<Long>>(16);
        HashMap<Long, HashSet<Long>> coreConBillInfo = new HashMap<Long, HashSet<Long>>(16);
        HashMap<Long, HashSet<Long>> coreOmBillInfo = new HashMap<Long, HashSet<Long>>(16);
        HashMap<Long, HashSet<Long>> corePmOmBillInfo = new HashMap<Long, HashSet<Long>>(16);
        for (ExtendedDataEntity data : this.dataEntities) {
            boolean isExpenseBill;
            DynamicObject bill = data.getDataEntity();
            boolean isPremium = bill.getBoolean("ispremium");
            boolean isTanspay = bill.getBoolean("istanspay");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("detailentry");
            if (entry.size() == 0) continue;
            String expenseBillIds = ((DynamicObject)entry.get(0)).getString("e_expensebillids_tag");
            boolean bl = isExpenseBill = expenseBillIds != null && !"".equals(expenseBillIds);
            if (isPremium || isTanspay || isExpenseBill) continue;
            for (DynamicObject row : entry) {
                BigDecimal qty = row.getBigDecimal("e_baseunitqty");
                if ("delete".equals(this.operateKey) && qty.compareTo(BigDecimal.ZERO) > 0) continue;
                Long coreBillId = row.getLong("corebillid");
                Long coreBillEntryId = row.getLong("corebillentryid");
                if (coreBillId == 0L || coreBillEntryId == 0L) continue;
                String coreBillType = row.getString("corebilltype");
                if ("pm_purorderbill".equals(coreBillType)) {
                    HashSet<Long> coreOrderBillEntryIds = (HashSet<Long>)coreOrderBillInfo.get(coreBillId);
                    if (coreOrderBillEntryIds == null) {
                        coreOrderBillEntryIds = new HashSet<Long>(16);
                        coreOrderBillEntryIds.add(coreBillEntryId);
                        coreOrderBillInfo.put(coreBillId, coreOrderBillEntryIds);
                        continue;
                    }
                    coreOrderBillEntryIds.add(coreBillEntryId);
                    continue;
                }
                if ("conm_purcontract".equals(coreBillType)) {
                    HashSet<Long> coreConBillEntryIds = (HashSet<Long>)coreConBillInfo.get(coreBillId);
                    if (coreConBillEntryIds == null) {
                        coreConBillEntryIds = new HashSet<Long>(16);
                        coreConBillEntryIds.add(coreBillEntryId);
                        coreConBillInfo.put(coreBillId, coreConBillEntryIds);
                        continue;
                    }
                    coreConBillEntryIds.add(coreBillEntryId);
                    continue;
                }
                if ("sctm_scpo".equals(coreBillType)) {
                    HashSet<Long> coreOmBillEntryIds = (HashSet<Long>)coreOmBillInfo.get(coreBillId);
                    if (coreOmBillEntryIds == null) {
                        coreOmBillEntryIds = new HashSet<Long>(16);
                        coreOmBillEntryIds.add(coreBillEntryId);
                        coreOmBillInfo.put(coreBillId, coreOmBillEntryIds);
                        continue;
                    }
                    coreOmBillEntryIds.add(coreBillEntryId);
                    continue;
                }
                if (!"pm_om_purorderbill".equals(coreBillType)) continue;
                HashSet<Long> corePmOmBillEntryIds = (HashSet<Long>)corePmOmBillInfo.get(coreBillId);
                if (corePmOmBillEntryIds == null) {
                    corePmOmBillEntryIds = new HashSet<Long>(16);
                    corePmOmBillEntryIds.add(coreBillEntryId);
                    corePmOmBillInfo.put(coreBillId, corePmOmBillEntryIds);
                    continue;
                }
                corePmOmBillEntryIds.add(coreBillEntryId);
            }
        }
        HashMap<String, CoreBillInfo> coreBillInfoMap = new HashMap<String, CoreBillInfo>(16);
        if (coreOrderBillInfo.size() > 0) {
            logger.info(((Object)coreOrderBillInfo).toString());
            List orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"PurOrderService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreOrderBillInfo});
            logger.info(orderInfo.toString());
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "pm_purorderbill");
        }
        if (coreConBillInfo.size() > 0) {
            List orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"conm", (String)"PurConmService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreConBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "conm_purcontract");
        }
        if (coreOmBillInfo.size() > 0) {
            List orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"sctm", (String)"ScPoService", (String)"queryOverPayParamAndAmount", (Object[])new Object[]{coreOmBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "sctm_scpo");
        }
        if (corePmOmBillInfo.size() > 0) {
            List orderInfo = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"pm", (String)"OmPurOrderbillService", (String)"getOmPurOrderbillInfo", (Object[])new Object[]{corePmOmBillInfo});
            this.setCoreBillInfoMap(coreBillInfoMap, orderInfo, "pm_om_purorderbill");
            this.minDate = null;
        }
        return coreBillInfoMap;
    }

    private void setCoreBillInfoMap(Map<String, CoreBillInfo> coreBillInfoMap, List<Map<String, Object>> params, String coreBillType) {
        for (Map<String, Object> map : params) {
            boolean isAllowOverPay = (Boolean)map.get("isallowoverpay");
            Long id = (Long)map.get("billid");
            Long supplierId = (Long)map.get("invoicesupplier");
            Long currencyId = (Long)map.get("settlecurrency");
            Date coreCreateTime = (Date)map.get("createtime");
            if (coreCreateTime != null) {
                this.minDate = this.minDate == null ? coreCreateTime : (this.minDate.before(coreCreateTime) ? this.minDate : coreCreateTime);
            }
            List entrys = (List)map.get("entryinfo");
            for (Map entry : entrys) {
                CoreBillInfo info = new CoreBillInfo();
                Long entryId = (Long)entry.get("entryid");
                info.setCoreBillId(id);
                info.setCoreBillType(coreBillType);
                info.setCoreBillEntryId(entryId);
                info.setAllowOverPay(isAllowOverPay);
                info.setOrgId((Long)entry.get("settleorg"));
                info.setSupplierId(supplierId);
                info.setCurrencyId(currencyId);
                info.setCoreBillAmt((BigDecimal)entry.get("amountandtax"));
                Object baseQty = entry.get("receivebaseqtyup");
                if (baseQty == null) {
                    baseQty = entry.get("baseqty");
                }
                info.setCoreBaseQtyUp((BigDecimal)baseQty);
                String key = id + "_" + entryId;
                coreBillInfoMap.put(key, info);
            }
        }
    }

    private void initValidataLevel() {
        DynamicObjectCollection execcontrols = QueryServiceHelper.query((String)"arap_execcontrol", (String)"number,enable", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)new String[]{"SZJK-PRE-0087", "SZJK-PRE-0088"})});
        for (DynamicObject ctrl : execcontrols) {
            String number = ctrl.getString("number");
            if ("SZJK-PRE-0087".equals(number)) {
                if (!ctrl.getBoolean("enable")) continue;
                this.isValidataAmt = true;
                continue;
            }
            if (!"SZJK-PRE-0088".equals(number) || !ctrl.getBoolean("enable")) continue;
            this.isValidataQty = true;
        }
    }
}

